/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.io.OutputStream;
import java.util.Map;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolDocument;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.P3;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomSetCollectionReader {
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public boolean isBinary;
    public AtomSetCollection atomSetCollection;
    protected BufferedReader reader;
    protected JmolDocument doc;
    protected String readerName;
    public Map<String, Object> htParams;
    public JmolList<P3[]> trajectorySteps;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    protected long ptLine;
    public int[] latticeCells;
    public boolean doProcessLines;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    public boolean continuing = true;
    public Viewer viewer;
    protected boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    public boolean applySymmetryToBonds;
    protected boolean doCheckUnitCell;
    protected boolean getHeader;
    protected boolean isSequential;
    protected int templateAtomCount;
    public int modelNumber;
    protected int vibrationNumber;
    public int desiredVibrationNumber = Integer.MIN_VALUE;
    protected BS bsModels;
    protected boolean havePartialChargeFilter;
    public String calculationType = "?";
    protected String spaceGroup;
    protected boolean ignoreFileUnitCell;
    protected boolean ignoreFileSpaceGroupName;
    protected float[] notionalUnitCell;
    protected int desiredModelNumber = Integer.MIN_VALUE;
    protected SymmetryInterface symmetry;
    protected OutputStream os;
    protected boolean iHaveFractionalCoordinates;
    protected boolean doPackUnitCell;
    protected String strSupercell;
    protected P3 ptSupercell;
    protected boolean mustFinalizeModelSet;
    protected boolean forcePacked;
    private SB loadNote = new SB();
    private boolean doConvertToFractional;
    private boolean fileCoordinatesAreFractional;
    private boolean merging;
    private float symmetryRange;
    private int[] firstLastStep;
    private int lastModelNumber = Integer.MAX_VALUE;
    private int desiredSpaceGroupIndex = -1;
    protected P3 fileScaling;
    protected P3 fileOffset;
    private P3 fileOffsetFractional;
    private P3 unitCellOffset;
    private boolean unitCellOffsetFractional;
    protected String filePath;
    protected String fileName;
    protected int stateScriptVersionInt = Integer.MAX_VALUE;
    public boolean haveModel;
    private String previousSpaceGroup;
    private float[] previousUnitCell;
    private int nMatrixElements = 0;
    protected Matrix3f matUnitCellOrientation;
    protected BS bsFilter;
    protected String filter;
    private boolean haveAtomFilter;
    private boolean filterAltLoc;
    private boolean filterGroup3;
    private boolean filterChain;
    private boolean filterAtomName;
    private boolean filterAtomType;
    private String filterAtomTypeStr;
    private String filterAtomNameTerminator = ";";
    private boolean filterElement;
    protected boolean filterHetero;
    private boolean filterEveryNth;
    private int filterN;
    private int nFiltered;
    private boolean doSetOrientation;
    protected boolean doCentralize;
    protected boolean addVibrations;
    protected boolean useAltNames;
    public boolean doReadMolecularOrbitals;
    protected boolean reverseModels;
    private String nameRequired;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    private String filter1;
    private String filter2;
    private Matrix3f matrixRotate;
    private String previousScript;
    private String siteScript;

    protected void setup(String string, Map<String, Object> map, Object object) {
        this.setupASCR(string, map, object);
    }

    protected void setupASCR(String string, Map<String, Object> map, Object object) {
        if (string == null) {
            return;
        }
        this.htParams = map;
        this.filePath = string.replace('\\', '/');
        int n = this.filePath.lastIndexOf(47);
        this.fileName = this.filePath.substring(n + 1);
        if (object instanceof BufferedReader) {
            this.reader = (BufferedReader)object;
        } else if (object instanceof JmolDocument) {
            this.doc = (JmolDocument)object;
        }
    }

    Object readData() throws Exception {
        this.initialize();
        this.atomSetCollection = new AtomSetCollection(this.readerName, this, null, null);
        try {
            this.initializeReader();
            if (this.doc == null) {
                if (this.line == null && this.continuing) {
                    this.readLine();
                }
                while (this.line != null && this.continuing) {
                    if (!this.checkLine()) continue;
                    this.readLine();
                }
            } else {
                this.processBinaryDocument(this.doc);
            }
            this.finalizeReader();
        }
        catch (Throwable throwable) {
            Logger.info("Reader error: " + throwable);
            if (!this.viewer.isJS) {
                throwable.printStackTrace();
            }
            this.setError(throwable);
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.doc != null) {
            this.doc.close();
        }
        return this.finish();
    }

    private void fixBaseIndices() {
        try {
            int n = (Integer)this.htParams.get("baseAtomIndex");
            int n2 = (Integer)this.htParams.get("baseModelIndex");
            this.htParams.put("baseAtomIndex", n += this.atomSetCollection.getAtomCount());
            this.htParams.put("baseModelIndex", n2 += this.atomSetCollection.getAtomSetCount());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object readDataObject(Object object) throws Exception {
        this.initialize();
        this.atomSetCollection = new AtomSetCollection(this.readerName, this, null, null);
        this.initializeReader();
        this.processDOM(object);
        return this.finish();
    }

    protected void processDOM(Object object) {
    }

    protected void processBinaryDocument(JmolDocument jmolDocument) throws Exception {
    }

    protected void initializeReader() throws Exception {
    }

    protected boolean checkLine() throws Exception {
        return true;
    }

    public boolean checkLastModel() {
        if (this.isLastModel(this.modelNumber) && this.doProcessLines) {
            this.continuing = false;
            return false;
        }
        this.doProcessLines = false;
        return true;
    }

    public boolean isLastModel(int n) {
        return this.desiredModelNumber > 0 || n >= this.lastModelNumber;
    }

    protected String appendLoadNote(String string) {
        this.loadNote.append(string).append("\n");
        Logger.info(string);
        return string;
    }

    protected void initializeTrajectoryFile() {
        this.atomSetCollection.addAtom(new Atom());
        this.trajectorySteps = (JmolList)this.htParams.get("trajectorySteps");
        if (this.trajectorySteps == null) {
            this.trajectorySteps = new JmolList();
            this.htParams.put("trajectorySteps", this.trajectorySteps);
        }
    }

    protected void finalizeReader() throws Exception {
        this.finalizeReaderASCR();
    }

    protected void finalizeReaderASCR() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.setLoadNote();
        this.atomSetCollection.finalizeStructures();
        if (this.doCentralize) {
            this.atomSetCollection.centralize();
        }
    }

    protected void setLoadNote() {
        if (this.loadNote.length() > 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("modelLoadNote", this.loadNote.toString());
        }
    }

    public void setIsPDB() {
        this.atomSetCollection.setGlobalBoolean(4);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        if (this.htParams.get("pdbNoHydrogens") != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("pdbNoHydrogens", this.htParams.get("pdbNoHydrogens"));
        }
    }

    protected void setPdb() {
    }

    private Object finish() {
        String string;
        String string2;
        String string3 = (String)this.htParams.get("loadState");
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("loadState", string3 == null ? "" : string3);
        string3 = (String)this.htParams.get("smilesString");
        if (string3 != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("smilesString", string3);
        }
        if (!this.htParams.containsKey("templateAtomCount")) {
            this.htParams.put("templateAtomCount", this.atomSetCollection.getAtomCount());
        }
        if (this.htParams.containsKey("bsFilter")) {
            this.htParams.put("filteredAtomCount", BSUtil.cardinalityOf((BS)this.htParams.get("bsFilter")));
        }
        if (!this.calculationType.equals("?")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("calculationType", this.calculationType);
        }
        if ((string2 = (string = this.atomSetCollection.getFileTypeName())).indexOf("(") >= 0) {
            string2 = string2.substring(0, string2.indexOf("("));
        }
        int n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("fileName", this.filePath, n);
            this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("fileType", string2, n);
        }
        this.atomSetCollection.freeze(this.reverseModels);
        if (this.atomSetCollection.errorMessage != null) {
            return this.atomSetCollection.errorMessage + "\nfor file " + this.filePath + "\ntype " + string;
        }
        if ((this.atomSetCollection.bsAtoms == null ? this.atomSetCollection.getAtomCount() : this.atomSetCollection.bsAtoms.cardinality()) == 0 && string2.indexOf("DataOnly") < 0 && this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("dataOnly") == null) {
            return "No atoms found\nfor file " + this.filePath + "\ntype " + string;
        }
        this.fixBaseIndices();
        return this.atomSetCollection;
    }

    private void setError(Throwable throwable) {
        String string = throwable.getMessage();
        this.atomSetCollection.errorMessage = this.line == null ? "Error reading file at end of file \n" + string : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + string;
        if (!this.viewer.isJS) {
            throwable.printStackTrace();
        }
    }

    private void initialize() {
        Object object;
        Object object2 = this.htParams.get("supercell");
        if (object2 instanceof String) {
            this.strSupercell = (String)object2;
        } else {
            this.ptSupercell = (P3)object2;
        }
        this.initializeSymmetry();
        this.viewer = (Viewer)this.htParams.remove("viewer");
        if (this.htParams.containsKey("stateScriptVersionInt")) {
            this.stateScriptVersionInt = (Integer)this.htParams.get("stateScriptVersionInt");
        }
        this.merging = this.htParams.containsKey("merging");
        this.getHeader = this.htParams.containsKey("getHeader");
        this.isSequential = this.htParams.containsKey("isSequential");
        this.readerName = (String)this.htParams.get("readerName");
        if (this.htParams.containsKey("OutputStream")) {
            this.os = (OutputStream)this.htParams.get("OutputStream");
        }
        if (this.htParams.containsKey("vibrationNumber")) {
            this.desiredVibrationNumber = (Integer)this.htParams.get("vibrationNumber");
        } else if (this.htParams.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)this.htParams.get("modelNumber");
        }
        this.applySymmetryToBonds = this.htParams.containsKey("applySymmetryToBonds");
        this.bsFilter = (BS)this.htParams.get("bsFilter");
        this.setFilter(null);
        int n = this.htParams.containsKey("ptFile") ? (Integer)this.htParams.get("ptFile") : -1;
        this.isTrajectory = this.htParams.containsKey("isTrajectory");
        if (n > 0 && this.htParams.containsKey("firstLastSteps")) {
            object = ((JmolList)this.htParams.get("firstLastSteps")).get(n - 1);
            if (object instanceof BS) {
                this.bsModels = (BS)object;
            } else {
                this.firstLastStep = (int[])object;
            }
        } else if (this.htParams.containsKey("firstLastStep")) {
            this.firstLastStep = (int[])this.htParams.get("firstLastStep");
        } else if (this.htParams.containsKey("bsModels")) {
            this.bsModels = (BS)this.htParams.get("bsModels");
        }
        if (this.htParams.containsKey("templateAtomCount")) {
            this.templateAtomCount = (Integer)this.htParams.get("templateAtomCount");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = BSUtil.newAndSetBit(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = this.bsModels.length();
        }
        this.symmetryRange = this.htParams.containsKey("symmetryRange") ? ((Float)this.htParams.get("symmetryRange")).floatValue() : 0.0f;
        this.initializeSymmetryOptions();
        if (this.htParams.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)this.htParams.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.spaceGroup = (String)this.htParams.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (this.htParams.containsKey("unitCellOffset")) {
            this.fileScaling = P3.new3(1.0f, 1.0f, 1.0f);
            this.fileOffset = (P3)this.htParams.get("unitCellOffset");
            this.fileOffsetFractional = P3.newP(this.fileOffset);
            this.unitCellOffsetFractional = this.htParams.containsKey("unitCellOffsetFractional");
        }
        if (this.htParams.containsKey("unitcell")) {
            object = (float[])this.htParams.get("unitcell");
            if (this.merging) {
                this.setFractionalCoordinates(true);
            }
            if (((E)object).length == 9) {
                this.addPrimitiveLatticeVector(0, (float[])object, 0);
                this.addPrimitiveLatticeVector(1, (float[])object, 3);
                this.addPrimitiveLatticeVector(2, (float[])object, 6);
            } else {
                this.setUnitCell((float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
            }
            this.ignoreFileUnitCell = this.iHaveUnitCell;
            if (this.merging && !this.iHaveUnitCell) {
                this.setFractionalCoordinates(false);
            }
        }
    }

    protected void initializeSymmetryOptions() {
        this.latticeCells = new int[3];
        P3 p3 = (P3)this.htParams.get("lattice");
        if (this.forcePacked && p3 == null) {
            p3 = P3.new3(1.0f, 1.0f, 1.0f);
        }
        if (p3 != null) {
            this.latticeCells[0] = (int)p3.x;
            this.latticeCells[1] = (int)p3.y;
            this.latticeCells[2] = (int)p3.z;
            this.doCentroidUnitCell = this.htParams.containsKey("centroid");
            if (this.doCentroidUnitCell && (this.latticeCells[2] == -1 || this.latticeCells[2] == 0)) {
                this.latticeCells[2] = 1;
            }
            boolean bl = this.forcePacked || this.htParams.containsKey("packed");
            this.centroidPacked = this.doCentroidUnitCell && bl;
            this.doPackUnitCell = !this.doCentroidUnitCell && (bl || this.latticeCells[2] < 0);
        }
        boolean bl = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells[0] = 0;
            this.latticeCells[1] = 0;
            this.latticeCells[2] = 0;
        }
    }

    public boolean doGetModel(int n, String string) {
        boolean bl;
        if (string != null && this.nameRequired != null && this.nameRequired.length() > 0 && string.toUpperCase().indexOf(this.nameRequired) < 0) {
            return false;
        }
        boolean bl2 = this.bsModels == null ? this.desiredModelNumber < 1 || n == this.desiredModelNumber : (n > this.lastModelNumber ? false : (bl = n > 0 && this.bsModels.get(n - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (n - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0)));
        if (bl && this.desiredModelNumber == 0) {
            this.atomSetCollection.discardPreviousAtoms();
        }
        this.haveModel |= bl;
        if (bl) {
            this.doProcessLines = true;
        }
        return bl;
    }

    protected void initializeSymmetry() {
        this.previousSpaceGroup = this.spaceGroup;
        this.previousUnitCell = this.notionalUnitCell;
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.notionalUnitCell = new float[25];
            int n = 25;
            while (--n >= 0) {
                this.notionalUnitCell[n] = Float.NaN;
            }
            if (this.ptSupercell != null) {
                this.notionalUnitCell[22] = Math.max(1, (int)this.ptSupercell.x);
                this.notionalUnitCell[23] = Math.max(1, (int)this.ptSupercell.y);
                this.notionalUnitCell[24] = Math.max(1, (int)this.ptSupercell.z);
            }
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.spaceGroup = "unspecified!";
        }
        this.doCheckUnitCell = false;
    }

    protected void newAtomSet(String string) {
        if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setCollectionName("<collection of " + (this.atomSetCollection.getCurrentAtomSetIndex() + 1) + " models>");
        } else {
            this.atomSetCollection.setCollectionName(string);
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("name", string, Math.max(0, this.atomSetCollection.getCurrentAtomSetIndex()));
    }

    protected int cloneLastAtomSet(int n, P3[] p3Array) throws Exception {
        int n2 = this.atomSetCollection.getLastAtomSetAtomCount();
        this.atomSetCollection.cloneLastAtomSetFromPoints(n, p3Array);
        if (this.atomSetCollection.haveUnitCell) {
            this.iHaveUnitCell = true;
            this.doCheckUnitCell = true;
            this.spaceGroup = this.previousSpaceGroup;
            this.notionalUnitCell = this.previousUnitCell;
        }
        return n2;
    }

    public void setSpaceGroupName(String string) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        this.spaceGroup = string.trim();
        Logger.info("Setting space group name to " + this.spaceGroup);
    }

    public int setSymmetryOperator(String string) {
        if (this.ignoreFileSymmetryOperators) {
            return -1;
        }
        this.setLatticeCells(false);
        int n = this.atomSetCollection.addSpaceGroupOperation(string);
        if (n < 0) {
            Logger.warn("Skipping symmetry operation " + string);
        }
        this.iHaveSymmetryOperators = true;
        return n;
    }

    private void initializeCartesianToFractional() {
        int n;
        for (n = 0; n < 16; ++n) {
            if (Float.isNaN(this.notionalUnitCell[6 + n])) continue;
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.notionalUnitCell[6 + n] = n % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearUnitCell() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < 22; ++i) {
            this.notionalUnitCell[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int n, float f) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0 && f == 1.0f || n == 3 && f == 0.0f) {
            return;
        }
        if (!Float.isNaN(f) && n >= 6 && Float.isNaN(this.notionalUnitCell[6])) {
            this.initializeCartesianToFractional();
        }
        this.notionalUnitCell[n] = f;
        if (Logger.debugging) {
            Logger.debug("setunitcellitem " + n + " " + f);
        }
        if (n < 6 || Float.isNaN(f)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.checkUnitCell(22);
        }
    }

    public void setUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.clearUnitCell();
        this.notionalUnitCell[0] = f;
        this.notionalUnitCell[1] = f2;
        this.notionalUnitCell[2] = f3;
        if (f4 != 0.0f) {
            this.notionalUnitCell[3] = f4;
        }
        if (f5 != 0.0f) {
            this.notionalUnitCell[4] = f5;
        }
        if (f6 != 0.0f) {
            this.notionalUnitCell[5] = f6;
        }
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addPrimitiveLatticeVector(int n, float[] fArray, int n2) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0) {
            for (int i = 0; i < 6; ++i) {
                this.notionalUnitCell[i] = 0.0f;
            }
        }
        n = 6 + n * 3;
        this.notionalUnitCell[n++] = fArray[n2++];
        this.notionalUnitCell[n++] = fArray[n2++];
        this.notionalUnitCell[n] = fArray[n2];
        if (Float.isNaN(this.notionalUnitCell[0])) {
            for (n = 0; n < 6; ++n) {
                this.notionalUnitCell[n] = -1.0f;
            }
        }
        this.iHaveUnitCell = this.checkUnitCell(15);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.notionalUnitCell[i])) continue;
            return false;
        }
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (this.doApplySymmetry) {
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        this.checkUnitCellOffset();
        return true;
    }

    private void checkUnitCellOffset() {
        if (this.symmetry == null || this.fileOffsetFractional == null) {
            return;
        }
        this.fileOffset.setT(this.fileOffsetFractional);
        if (this.unitCellOffsetFractional != this.fileCoordinatesAreFractional) {
            if (this.unitCellOffsetFractional) {
                this.symmetry.toCartesian(this.fileOffset, false);
            } else {
                this.symmetry.toFractional(this.fileOffset, false);
            }
        }
    }

    protected SymmetryInterface getSymmetry() {
        this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean bl) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = bl;
        this.checkUnitCellOffset();
    }

    protected void setFilterAtomTypeStr(String string) {
        this.filterAtomTypeStr = string;
        this.filterAtomNameTerminator = "\u0000";
    }

    protected void setFilter(String string) {
        if (string == null) {
            string = (String)this.htParams.get("filter");
        } else {
            this.bsFilter = null;
        }
        if (string != null) {
            string = string.toUpperCase();
        }
        this.filter = string;
        this.doSetOrientation = !this.checkFilterKey("NOORIENT");
        this.doCentralize = !this.checkFilterKey("NOCENTER") && this.checkFilterKey("CENTER");
        this.addVibrations = !this.checkFilterKey("NOVIB");
        this.doReadMolecularOrbitals = !this.checkFilterKey("NOMO");
        this.useAltNames = this.checkFilterKey("ALTNAME");
        this.reverseModels = this.checkFilterKey("REVERSEMODELS");
        if (this.checkFilterKey("NAME=")) {
            this.nameRequired = this.filter.substring(this.filter.indexOf("NAME=") + 5);
            if (this.nameRequired.startsWith("'")) {
                this.nameRequired = TextFormat.splitChars(this.nameRequired, "'")[1];
            } else if (this.nameRequired.startsWith("\"")) {
                this.nameRequired = TextFormat.splitChars(this.nameRequired, "\"")[1];
            }
            string = this.filter = TextFormat.simpleReplace(this.filter, this.nameRequired, "");
            string = this.filter = TextFormat.simpleReplace(this.filter, "NAME=", "");
        }
        if (this.filter == null) {
            return;
        }
        this.filterAtomName = this.checkFilterKey("*.") || this.checkFilterKey("!.");
        this.filterElement = this.checkFilterKey("_");
        this.filterHetero = this.checkFilterKey("HETATM");
        this.filterGroup3 = this.checkFilterKey("[");
        this.filterChain = this.checkFilterKey(":");
        this.filterAltLoc = this.checkFilterKey("%");
        this.filterEveryNth = this.checkFilterKey("/=");
        if (this.filterEveryNth) {
            this.filterN = this.parseIntStr(this.filter.substring(this.filter.indexOf("/=") + 2));
        } else {
            this.filterAtomType = this.checkFilterKey("=");
        }
        if (this.filterN == Integer.MIN_VALUE) {
            this.filterEveryNth = false;
        }
        boolean bl = this.haveAtomFilter = this.filterAtomName || this.filterAtomType || this.filterElement || this.filterGroup3 || this.filterChain || this.filterAltLoc || this.filterHetero || this.filterEveryNth || this.checkFilterKey("/=");
        if (this.bsFilter == null) {
            this.bsFilter = new BS();
            this.htParams.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            Logger.info("filtering with " + this.filter);
            if (this.haveAtomFilter) {
                this.filter1 = this.filter;
                int n = this.filter.indexOf("|");
                if (n >= 0) {
                    this.filter1 = this.filter.substring(0, n).trim() + ";";
                    this.filter2 = ";" + this.filter.substring(n).trim();
                }
            }
        }
    }

    protected String getFilter(String string) {
        int n = this.filter == null ? -1 : this.filter.indexOf(string);
        return n < 0 ? null : this.filter.substring(n + string.length(), this.filter.indexOf(";", n));
    }

    protected boolean checkFilterKey(String string) {
        return this.filter != null && this.filter.indexOf(string) >= 0;
    }

    protected boolean filterAtom(Atom atom, int n) {
        if (!this.haveAtomFilter) {
            return true;
        }
        boolean bl = this.checkFilter(atom, this.filter1);
        if (this.filter2 != null) {
            bl |= this.checkFilter(atom, this.filter2);
        }
        if (bl && this.filterEveryNth) {
            bl = this.nFiltered++ % this.filterN == 0;
        }
        this.bsFilter.setBitTo(n >= 0 ? n : this.atomSetCollection.getAtomCount(), bl);
        return bl;
    }

    private boolean checkFilter(Atom atom, String string) {
        return !(this.filterGroup3 && atom.group3 != null && this.filterReject(string, "[", atom.group3.toUpperCase() + "]") || this.filterAtomName && !this.allowAtomName(atom.atomName, string) || this.filterAtomTypeStr != null && atom.atomName != null && atom.atomName.toUpperCase().indexOf("\u0000" + this.filterAtomTypeStr) < 0 || this.filterElement && atom.elementSymbol != null && this.filterReject(string, "_", atom.elementSymbol.toUpperCase() + ";") || this.filterChain && atom.chainID != 0 && this.filterReject(string, ":", "" + this.viewer.getChainIDStr(atom.chainID)) || this.filterAltLoc && atom.alternateLocationID != '\u0000' && this.filterReject(string, "%", "" + atom.alternateLocationID) || this.filterHetero && this.filterReject(string, "HETATM", atom.isHetero ? "HETATM" : "ATOM"));
    }

    protected boolean rejectAtomName(String string) {
        return this.filterAtomName && !this.allowAtomName(string, this.filter);
    }

    private boolean allowAtomName(String string, String string2) {
        return string == null || !this.filterReject(string2, ".", string.toUpperCase() + this.filterAtomNameTerminator);
    }

    protected boolean filterReject(String string, String string2, String string3) {
        return string.indexOf(string2) >= 0 && (string.indexOf("!" + string2) >= 0 ? string.indexOf(string2 + string3) >= 0 : string.indexOf(string2 + string3) < 0);
    }

    protected void set2D() {
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("is2D", Boolean.TRUE);
        if (!this.checkFilterKey("NOMIN")) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("doMinimize", Boolean.TRUE);
        }
    }

    public boolean doGetVibration(int n) {
        return this.addVibrations && (this.desiredVibrationNumber <= 0 || n == this.desiredVibrationNumber);
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.matrixRotate != null || !this.doSetOrientation) {
            return;
        }
        this.matrixRotate = new Matrix3f();
        V3 v3 = new V3();
        v3.set(f, f2, f3);
        v3.normalize();
        this.matrixRotate.setColumnV(0, v3);
        v3.set(f4, f5, f6);
        v3.normalize();
        this.matrixRotate.setColumnV(1, v3);
        v3.set(f7, f8, f9);
        v3.normalize();
        this.matrixRotate.setColumnV(2, v3);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationMatrix", Matrix3f.newM(this.matrixRotate));
        Quaternion quaternion = Quaternion.newM(this.matrixRotate);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("defaultOrientationQuaternion", quaternion);
        Logger.info("defaultOrientationMatrix = " + this.matrixRotate);
    }

    public void setAtomCoordXYZ(Atom atom, float f, float f2, float f3) {
        atom.set(f, f2, f3);
        this.setAtomCoord(atom);
    }

    public void setAtomCoord(Atom atom) {
        if (this.fileScaling != null) {
            atom.x = atom.x * this.fileScaling.x + this.fileOffset.x;
            atom.y = atom.y * this.fileScaling.y + this.fileOffset.y;
            atom.z = atom.z * this.fileScaling.z + this.fileOffset.z;
        }
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.symmetry != null) {
            if (!this.symmetry.haveUnitCell()) {
                this.symmetry.setUnitCell(this.notionalUnitCell);
            }
            this.symmetry.toFractional(atom, false);
            this.iHaveFractionalCoordinates = true;
        }
        this.doCheckUnitCell = true;
    }

    protected void addSites(Map<String, Map<String, Object>> map) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbSites", map);
        String string = "";
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            Map<String, Object> map2 = entry.getValue();
            int n = string2.length();
            while (--n >= 0) {
                char c = string2.charAt(n);
                if (Character.isLetterOrDigit(c) || c == '\'') continue;
                string2 = string2.substring(0, n) + "_" + string2.substring(n + 1);
            }
            String string3 = (String)map2.get("groups");
            if (string3.length() == 0) continue;
            this.addSiteScript("@site_" + string2 + " " + string3);
            this.addSiteScript("site_" + string2 + " = \"" + string3 + "\".split(\",\")");
            string = string + (string == "" ? "" : ",") + "site_" + string2;
        }
        this.addSiteScript("site_list = \"" + string + "\".split(\",\")");
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.applySymTrajASCR();
    }

    public SymmetryInterface applySymTrajASCR() throws Exception {
        if (this.forcePacked) {
            this.initializeSymmetryOptions();
        }
        SymmetryInterface symmetryInterface = null;
        if (this.iHaveUnitCell && this.doCheckUnitCell) {
            this.atomSetCollection.setCoordinatesAreFractional(this.iHaveFractionalCoordinates);
            this.atomSetCollection.setNotionalUnitCell(this.notionalUnitCell, this.matUnitCellOrientation, this.unitCellOffset);
            symmetryInterface = this.atomSetCollection.symmetry;
            this.atomSetCollection.setAtomSetSpaceGroupName(this.spaceGroup);
            this.atomSetCollection.setSymmetryRange(this.symmetryRange);
            if (this.doConvertToFractional || this.fileCoordinatesAreFractional) {
                this.setLatticeCells(false);
                if (this.ignoreFileSpaceGroupName || !this.iHaveSymmetryOperators) {
                    if (!this.merging || this.symmetry == null) {
                        this.getSymmetry();
                    }
                    if (this.symmetry.createSpaceGroup(this.desiredSpaceGroupIndex, this.spaceGroup.indexOf("!") >= 0 ? "P1" : this.spaceGroup, this.notionalUnitCell)) {
                        this.atomSetCollection.applySymmetry(this.symmetry);
                        this.atomSetCollection.setAtomSetSpaceGroupName(this.symmetry.getSpaceGroupName());
                    }
                } else {
                    this.atomSetCollection.applySymmetry(null);
                }
            }
            if (this.iHaveFractionalCoordinates && this.merging && this.symmetry != null) {
                this.atomSetCollection.toCartesian(this.symmetry);
                this.atomSetCollection.setCoordinatesAreFractional(false);
                this.addVibrations = false;
            }
        }
        if (this.isTrajectory) {
            this.atomSetCollection.setTrajectory();
        }
        this.initializeSymmetry();
        return symmetryInterface;
    }

    public void finalizeMOData(Map<String, Object> map) {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", map);
        if (map == null) {
            return;
        }
        JmolList jmolList = (JmolList)map.get("mos");
        if (jmolList != null) {
            Logger.info(jmolList.size() + " molecular orbitals read in model " + this.atomSetCollection.getAtomSetCount());
        }
    }

    public static String getElementSymbol(int n) {
        return JmolAdapter.getElementSymbol(n);
    }

    protected void fillDataBlockFixed(String[][] stringArray, int n, int n2, int n3) throws Exception {
        if (n2 == 0) {
            this.fillDataBlock(stringArray, n3);
            return;
        }
        int n4 = stringArray.length;
        for (int i = 0; i < n4; ++i) {
            this.discardLinesUntilNonBlank();
            int n5 = (this.line.length() - n + 1) / n2;
            stringArray[i] = new String[n5];
            int n6 = 0;
            int n7 = n;
            while (n6 < n5) {
                stringArray[i][n6] = this.line.substring(n7, Math.min(this.line.length(), n7 + n2));
                ++n6;
                n7 += n2;
            }
        }
    }

    protected void fillDataBlock(String[][] stringArray, int n) throws Exception {
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = AtomSetCollectionReader.getTokensStr(this.discardLinesUntilNonBlank());
            if (stringArray[i].length >= n) continue;
            --i;
        }
    }

    protected float[] fillFloatArray(String string, int n, float[] fArray) throws Exception {
        String[] stringArray = new String[]{};
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            while (stringArray != null && n2 >= stringArray.length) {
                if (string == null) {
                    string = this.readLine();
                }
                if (n == 0) {
                    stringArray = AtomSetCollectionReader.getTokensStr(string);
                } else {
                    stringArray = new String[string.length() / n];
                    for (int j = 0; j < stringArray.length; ++j) {
                        stringArray[j] = string.substring(j * n, (j + 1) * n);
                    }
                }
                string = null;
                n2 = 0;
            }
            if (stringArray == null) break;
            fArray[i] = this.parseFloatStr(stringArray[n2++]);
        }
        return fArray;
    }

    protected void fillFrequencyData(int n, int n2, int n3, boolean[] blArray, boolean bl, int n4, int n5, int[] nArray, int n6) throws Exception {
        boolean bl2;
        boolean bl3 = bl2 = n3 != n2;
        if (nArray != null) {
            n2 = nArray.length;
        }
        int n7 = bl ? n2 : n2 * 3;
        int n8 = blArray.length;
        String[][] stringArray = new String[n7][];
        this.fillDataBlockFixed(stringArray, n4, n5, n6);
        int n9 = 0;
        int n10 = 0;
        while (n9 < n7) {
            String[] stringArray2 = stringArray[n9];
            String[] stringArray3 = bl ? null : stringArray[++n9];
            String[] stringArray4 = bl ? null : stringArray[++n9];
            int n11 = stringArray2.length - (bl ? n8 * 3 : n8) - 1;
            int n12 = 0;
            for (int i = 0; i < n8; ++i) {
                int n13;
                String string;
                if ((string = stringArray2[++n11]).charAt(0) == ')') {
                    string = string.substring(1);
                }
                float f = this.parseFloatStr(string);
                float f2 = this.parseFloatStr(bl ? stringArray2[++n11] : stringArray3[n11]);
                float f3 = this.parseFloatStr(bl ? stringArray2[++n11] : stringArray4[n11]);
                if (blArray[i]) continue;
                int n14 = n13 = nArray == null ? n10 : nArray[n10];
                if (n13 < 0) continue;
                if (Logger.debugging) {
                    Logger.debug("atom " + n13 + " vib" + n12 + ": " + f + " " + f2 + " " + f3);
                }
                this.atomSetCollection.addVibrationVectorWithSymmetry(n + n3 * n12++ + n13, f, f2, f3, bl2);
            }
            ++n9;
            ++n10;
        }
    }

    protected String readLines(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.readLine();
        }
        return this.line;
    }

    protected String discardLinesUntilStartsWith(String string) throws Exception {
        while (this.readLine() != null && !this.line.startsWith(string)) {
        }
        return this.line;
    }

    protected String discardLinesUntilContains(String string) throws Exception {
        while (this.readLine() != null && this.line.indexOf(string) < 0) {
        }
        return this.line;
    }

    protected String discardLinesUntilContains2(String string, String string2) throws Exception {
        while (this.readLine() != null && this.line.indexOf(string) < 0 && this.line.indexOf(string2) < 0) {
        }
        return this.line;
    }

    protected void discardLinesUntilBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() != 0) {
        }
    }

    protected String discardLinesUntilNonBlank() throws Exception {
        while (this.readLine() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String string) {
        this.line = string;
        this.checkCurrentLineForScript();
    }

    public void checkCurrentLineForScript() {
        int n;
        Object object;
        if (this.line.indexOf("Jmol") >= 0) {
            if (this.line.indexOf("Jmol PDB-encoded data") >= 0) {
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolData", this.line);
                if (!this.line.endsWith("#noautobond")) {
                    this.line = this.line + "#noautobond";
                }
            }
            if (this.line.indexOf("Jmol data min") >= 0) {
                Logger.info(this.line);
                float[] fArray = new float[15];
                this.parseStringInfestedFloatArray(this.line.substring(10).replace('=', ' ').replace('{', ' ').replace('}', ' '), fArray);
                object = P3.new3(fArray[0], fArray[1], fArray[2]);
                P3 p3 = P3.new3(fArray[3], fArray[4], fArray[5]);
                this.fileScaling = P3.new3(fArray[6], fArray[7], fArray[8]);
                this.fileOffset = P3.new3(fArray[9], fArray[10], fArray[11]);
                P3 p32 = P3.new3(fArray[12], fArray[13], fArray[14]);
                if (p32.x <= 0.0f) {
                    p32.x = 100.0f;
                }
                if (p32.y <= 0.0f) {
                    p32.y = 100.0f;
                }
                if (p32.z <= 0.0f) {
                    p32.z = 100.0f;
                }
                if (this.fileScaling.y == 0.0f) {
                    this.fileScaling.y = 1.0f;
                }
                if (this.fileScaling.z == 0.0f) {
                    this.fileScaling.z = 1.0f;
                }
                this.setFractionalCoordinates(true);
                this.latticeCells = new int[3];
                this.setLatticeCells(true);
                this.setUnitCell(p32.x * 2.0f / (p3.x - ((P3)object).x), p32.y * 2.0f / (p3.y - ((P3)object).y), p32.z * 2.0f / (p3.z == ((P3)object).z ? 1.0f : p3.z - ((P3)object).z), 90.0f, 90.0f, 90.0f);
                this.unitCellOffset = P3.newP(p32);
                this.unitCellOffset.scale(-1.0f);
                this.symmetry.toFractional(this.unitCellOffset, false);
                this.unitCellOffset.scaleAdd2(-1.0f, (Tuple3f)object, this.unitCellOffset);
                this.symmetry.setOffsetPt(this.unitCellOffset);
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolDataScaling", new P3[]{object, p3, p32});
            }
        }
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.atomSetCollection.setNoAutoBond();
        }
        if ((n = this.line.indexOf("jmolscript:")) >= 0) {
            object = this.line.substring(n + 11, this.line.length());
            if (((String)object).indexOf("#") >= 0) {
                object = ((String)object).substring(0, ((String)object).indexOf("#"));
            }
            this.addJmolScript((String)object);
            this.line = this.line.substring(0, n).trim();
        }
    }

    private void setLatticeCells(boolean bl) {
        if (bl) {
            this.atomSetCollection.setLatticeCells(this.latticeCells, true, false, false, false, null, null);
        } else {
            this.atomSetCollection.setLatticeCells(this.latticeCells, this.applySymmetryToBonds, this.doPackUnitCell, this.doCentroidUnitCell, this.centroidPacked, this.strSupercell, this.ptSupercell);
        }
    }

    protected void addJmolScript(String string) {
        Logger.info("#jmolScript: " + string);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + string;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("jmolscript", this.previousScript);
    }

    protected void addSiteScript(String string) {
        if (this.siteScript == null) {
            this.siteScript = "";
        } else if (!this.siteScript.endsWith(";")) {
            this.siteScript = this.siteScript + ";";
        }
        this.siteScript = this.siteScript + string;
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("sitescript", this.siteScript);
    }

    public String readLine() throws Exception {
        return this.RL();
    }

    public String RL() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        if (this.os != null && this.line != null) {
            byte[] byArray = this.line.getBytes();
            this.os.write(byArray, 0, byArray.length);
            this.os.write(10);
        }
        ++this.ptLine;
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }

    protected static final String[] getStrings(String string, int n, int n2) {
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            stringArray[n3] = string.substring(n4, n4 + n2);
            ++n3;
            n4 += n2;
        }
        return stringArray;
    }

    protected String[] getTokens() {
        return Parser.getTokens(this.line);
    }

    protected void parseStringInfestedFloatArray(String string, float[] fArray) {
        Parser.parseStringInfestedFloatArray(string, null, fArray);
    }

    protected static float[] getTokensFloat(String string, float[] fArray, int n) {
        if (fArray == null) {
            fArray = new float[n];
        }
        Parser.parseFloatArrayDataN(AtomSetCollectionReader.getTokensStr(string), fArray, n);
        return fArray;
    }

    public static String[] getTokensStr(String string) {
        return Parser.getTokens(string);
    }

    protected static String[] getTokensAt(String string, int n) {
        return Parser.getTokensAt(string, n);
    }

    protected float parseFloat() {
        return Parser.parseFloatNext(this.line, this.next);
    }

    public float parseFloatStr(String string) {
        this.next[0] = 0;
        return Parser.parseFloatNext(string, this.next);
    }

    protected float parseFloatRange(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseFloatRange(string, n2, this.next);
    }

    protected int parseInt() {
        return Parser.parseIntNext(this.line, this.next);
    }

    public int parseIntStr(String string) {
        this.next[0] = 0;
        return Parser.parseIntNext(string, this.next);
    }

    protected int parseIntAt(String string, int n) {
        this.next[0] = n;
        return Parser.parseIntNext(string, this.next);
    }

    protected int parseIntRange(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseIntRange(string, n2, this.next);
    }

    protected String parseToken() {
        return Parser.parseTokenNext(this.line, this.next);
    }

    protected String parseTokenStr(String string) {
        this.next[0] = 0;
        return Parser.parseTokenNext(string, this.next);
    }

    protected String parseTokenNext(String string) {
        return Parser.parseTokenNext(string, this.next);
    }

    protected String parseTokenRange(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseTokenRange(string, n2, this.next);
    }

    protected static String parseTrimmedAt(String string, int n) {
        return Parser.parseTrimmedAt(string, n);
    }

    protected static String parseTrimmedRange(String string, int n, int n2) {
        return Parser.parseTrimmedRange(string, n, n2);
    }

    protected static JmolList<Integer> getFortranFormatLengths(String string) {
        JmolList<Integer> jmolList = new JmolList<Integer>();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        boolean bl2 = true;
        string = string + ",";
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '.': {
                    bl = false;
                    continue block5;
                }
                case ',': {
                    int n4;
                    for (n4 = 0; n4 < n2; ++n4) {
                        jmolList.addLast(n * n3);
                    }
                    bl = false;
                    bl2 = true;
                    n2 = 0;
                    continue block5;
                }
                case 'X': {
                    n = n2;
                    n2 = 1;
                    n3 = -1;
                    continue block5;
                }
                default: {
                    int n4 = Character.isDigit(c);
                    if (n4 != 0) {
                        if (bl) {
                            n = n * 10 + c - 48;
                            continue block5;
                        }
                        if (!bl2) continue block5;
                        n2 = n2 * 10 + c - 48;
                        continue block5;
                    }
                    if (Character.isLetter(c)) {
                        n = 0;
                        bl = true;
                        bl2 = false;
                        n3 = 1;
                        continue block5;
                    }
                    bl = false;
                }
            }
        }
        return jmolList;
    }

    protected V3[] read3Vectors(boolean bl) throws Exception {
        V3[] v3Array = new V3[3];
        float[] fArray = new float[3];
        for (int i = 0; i < 3; ++i) {
            if (i > 0 || Float.isNaN(this.parseFloatStr(this.line))) {
                this.readLine();
                if (i == 0 && this.line != null) {
                    i = -1;
                    continue;
                }
            }
            this.fillFloatArray(this.line, 0, fArray);
            v3Array[i] = new V3();
            v3Array[i].setA(fArray);
            if (!bl) continue;
            v3Array[i].scale(0.5291772f);
        }
        return v3Array;
    }

    protected void setElementAndIsotope(Atom atom, String string) {
        int n = this.parseIntStr(string);
        if (n == Integer.MIN_VALUE) {
            atom.elementSymbol = string;
        } else {
            atom.elementNumber = (short)((string = string.substring(("" + n).length())).length() == 0 ? n : (n << 7) + JmolAdapter.getElementNumber(string));
        }
    }

    public void finalizeModelSet() {
    }

    public void setChainID(Atom atom, char c) {
        atom.chainID = this.viewer.getChainID("" + c);
    }
}

