/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jmol.api.JmolSceneGenerator;
import org.jmol.constant.EnumAxesMode;
import org.jmol.constant.EnumCallback;
import org.jmol.constant.EnumStructure;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.script.SV;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.J2SIgnoreImport;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.P3;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@J2SIgnoreImport(value={Runtime.class})
public class StateManager {
    public static final int OBJ_BACKGROUND = 0;
    public static final int OBJ_AXIS1 = 1;
    public static final int OBJ_AXIS2 = 2;
    public static final int OBJ_AXIS3 = 3;
    public static final int OBJ_BOUNDBOX = 4;
    public static final int OBJ_UNITCELL = 5;
    public static final int OBJ_FRANK = 6;
    public static final int OBJ_MAX = 8;
    private static final String objectNameList = "background axis1      axis2      axis3      boundbox   unitcell   frank      ";
    Viewer viewer;
    Map<String, Object> saved = new Hashtable<String, Object>();
    String lastOrientation = "";
    String lastConnections = "";
    String lastScene = "";
    String lastSelected = "";
    String lastState = "";
    String lastShape = "";
    String lastCoordinates = "";
    protected static final String unreportedProperties = (";ambientpercent;animationfps;antialiasdisplay;antialiasimages;antialiastranslucent;appendnew;axescolor;axesposition;axesmolecular;axesorientationrasmol;axesunitcell;axeswindow;axis1color;axis2color;axis3color;backgroundcolor;backgroundmodel;bondsymmetryatoms;boundboxcolor;cameradepth;debug;debugscript;defaultlatttice;defaults;defaultdropscript;diffusepercent;;exportdrivers;exportscale;_filecaching;_filecache;fontcaching;fontscaling;forcefield;language;legacyautobonding;legacyhaddition;loglevel;logfile;loggestures;logcommands;measurestylechime;loadformat;loadligandformat;smilesurlformat;pubchemformat;nihresolverformat;edsurlformat;edsurlcutoff;multiprocessor;navigationmode;;pathforallfiles;perspectivedepth;phongexponent;perspectivemodel;platformspeed;preservestate;refreshing;repaintwaitms;rotationradius;showaxes;showaxis1;showaxis2;showaxis3;showboundbox;showfrank;showtiming;showunitcell;slabenabled;slab;slabrange;depth;zshade;zshadepower;specular;specularexponent;specularpercent;celshading;specularpower;stateversion;statusreporting;stereo;stereostate;vibrationperiod;unitcellcolor;visualrange;windowcentered;zerobasedxyzrasmol;zoomenabled;mousedragfactor;mousewheelfactor;scriptqueue;scriptreportinglevel;syncscript;syncmouse;syncstereo;;defaultdirectory;currentlocalpath;defaultdirectorylocal;ambient;bonds;colorrasmol;diffuse;frank;hetero;hidenotselected;hoverlabel;hydrogen;languagetranslation;measurementunits;navigationdepth;navigationslab;picking;pickingstyle;propertycolorschemeoverload;radius;rgbblue;rgbgreen;rgbred;scaleangstromsperinch;selectionhalos;showscript;showselections;solvent;strandcount;spinx;spiny;spinz;spinfps;navx;navy;navz;navfps;" + EnumCallback.getNameList() + ";undo;bondpicking;modelkitmode;allowgestures;allowkeystrokes;allowmultitouch;allowmodelkit" + ";").toLowerCase();

    public static String getVariableList(Map<String, SV> map, int n, boolean bl, boolean bl2) {
        SB sB = new SB();
        int n2 = 0;
        Object[] objectArray = new String[map.size()];
        for (Map.Entry<String, SV> entry : map.entrySet()) {
            String string = entry.getKey();
            SV sV = entry.getValue();
            if (!bl && string.startsWith("site_") || bl2 && string.charAt(0) != '@') continue;
            objectArray[n2++] = string + (string.charAt(0) == '@' ? " " + sV.asString() : " = " + StateManager.varClip(string, sV.escape(), n));
        }
        Arrays.sort(objectArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            if (objectArray[i] == null) continue;
            sB.append("  ").append((String)objectArray[i]).append(";\n");
        }
        if (n2 == 0 && !bl2) {
            sB.append("# --no global user variables defined--;\n");
        }
        return sB.toString();
    }

    public static int getObjectIdFromName(String string) {
        if (string == null) {
            return -1;
        }
        int n = objectNameList.indexOf(string.toLowerCase());
        return n < 0 ? n : n / 11;
    }

    static String getObjectNameFromId(int n) {
        if (n < 0 || n >= 8) {
            return null;
        }
        return objectNameList.substring(n * 11, n * 11 + 11).trim();
    }

    StateManager(Viewer viewer) {
        this.viewer = viewer;
    }

    GlobalSettings getGlobalSettings(GlobalSettings globalSettings, boolean bl) {
        this.saved.clear();
        return new GlobalSettings(globalSettings, bl);
    }

    void clear(GlobalSettings globalSettings) {
        this.viewer.setShowAxes(false);
        this.viewer.setShowBbcage(false);
        this.viewer.setShowUnitCell(false);
        globalSettings.clear();
    }

    void setCrystallographicDefaults() {
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setShowAxes(true);
        this.viewer.setShowUnitCell(true);
        this.viewer.setBooleanProperty("perspectiveDepth", false);
    }

    private void setCommonDefaults() {
        this.viewer.setBooleanProperty("perspectiveDepth", true);
        this.viewer.setFloatProperty("bondTolerance", 0.45f);
        this.viewer.setFloatProperty("minBondDistance", 0.4f);
        this.viewer.setBooleanProperty("translucent", true);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("ColorScheme", "Jmol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", false);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", false);
        this.viewer.setIntProperty("percentVdwAtom", 23);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 150);
        this.viewer.setDefaultVdw("auto");
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "RasMol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", true);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.viewer.setIntProperty("percentVdwAtom", 0);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 1);
        this.viewer.setDefaultVdw("Rasmol");
    }

    public void setPyMOLDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("measurementUnits", "ANGSTROMS");
        this.viewer.setBooleanProperty("zoomHeight", true);
    }

    private static Object getNoCase(Map<String, Object> map, String string) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(string)) continue;
            return entry.getValue();
        }
        return null;
    }

    String listSavedStates() {
        String string = "";
        for (String string2 : this.saved.keySet()) {
            string = string + "\n" + string2;
        }
        return string;
    }

    private void deleteSavedType(String string) {
        Iterator<String> iterator = this.saved.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (!string2.startsWith(string)) continue;
            iterator.remove();
        }
    }

    void deleteSaved(String string) {
        this.saved.remove(string);
    }

    void saveSelection(String string, BS bS) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Selected_");
            return;
        }
        string = this.lastSelected = "Selected_" + string;
        this.saved.put(string, BSUtil.copy(bS));
    }

    boolean restoreSelection(String string) {
        String string2 = string.length() > 0 ? "Selected_" + string : this.lastSelected;
        BS bS = (BS)StateManager.getNoCase(this.saved, string2);
        if (bS == null) {
            this.viewer.select(new BS(), false, 0, false);
            return false;
        }
        this.viewer.select(bS, false, 0, false);
        return true;
    }

    void saveState(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("State_");
            return;
        }
        string = this.lastState = "State_" + string;
        this.saved.put(string, this.viewer.getStateInfo());
    }

    String getSavedState(String string) {
        String string2 = string.length() > 0 ? "State_" + string : this.lastState;
        String string3 = (String)StateManager.getNoCase(this.saved, string2);
        return string3 == null ? "" : string3;
    }

    void saveStructure(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Shape_");
            return;
        }
        string = this.lastShape = "Shape_" + string;
        this.saved.put(string, this.viewer.getStructureState());
    }

    String getSavedStructure(String string) {
        String string2 = string.length() > 0 ? "Shape_" + string : this.lastShape;
        String string3 = (String)StateManager.getNoCase(this.saved, string2);
        return string3 == null ? "" : string3;
    }

    void saveCoordinates(String string, BS bS) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Coordinates_");
            return;
        }
        string = this.lastCoordinates = "Coordinates_" + string;
        this.saved.put(string, this.viewer.getCoordinateState(bS));
    }

    String getSavedCoordinates(String string) {
        String string2 = string.length() > 0 ? "Coordinates_" + string : this.lastCoordinates;
        String string3 = (String)StateManager.getNoCase(this.saved, string2);
        return string3 == null ? "" : string3;
    }

    Orientation getOrientation() {
        return new Orientation(false, null);
    }

    String getSavedOrientationText(String string) {
        if (string != null) {
            Orientation orientation = this.getOrientationFor(string);
            return orientation == null ? "" : orientation.getMoveToText(true);
        }
        SB sB = new SB();
        for (Map.Entry<String, Object> entry : this.saved.entrySet()) {
            String string2 = entry.getKey();
            if (!string2.startsWith("Orientation_")) continue;
            sB.append(((Orientation)entry.getValue()).getMoveToText(true));
        }
        return sB.toString();
    }

    public void saveScene(String string, Map<String, Object> map) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Scene_");
            return;
        }
        Scene scene = new Scene(map);
        scene.saveName = this.lastScene = "Scene_" + string;
        this.saved.put(scene.saveName, scene);
    }

    public boolean restoreScene(String string, float f) {
        Scene scene = this.getSceneFor(string);
        return scene != null && scene.restore(f);
    }

    private Scene getSceneFor(String string) {
        String string2 = string.length() > 0 ? "Scene_" + string : this.lastScene;
        return (Scene)StateManager.getNoCase(this.saved, string2);
    }

    void saveOrientation(String string, float[] fArray) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Orientation_");
            return;
        }
        Orientation orientation = new Orientation(string.equalsIgnoreCase("default"), fArray);
        orientation.saveName = this.lastOrientation = "Orientation_" + string;
        this.saved.put(orientation.saveName, orientation);
    }

    boolean restoreOrientation(String string, float f, boolean bl) {
        Orientation orientation = this.getOrientationFor(string);
        return orientation != null && orientation.restore(f, bl);
    }

    private Orientation getOrientationFor(String string) {
        String string2 = string.length() > 0 ? "Orientation_" + string : this.lastOrientation;
        return (Orientation)StateManager.getNoCase(this.saved, string2);
    }

    void saveBonds(String string) {
        if (string.equalsIgnoreCase("DELETE")) {
            this.deleteSavedType("Bonds_");
            return;
        }
        Connections connections = new Connections();
        connections.saveName = this.lastConnections = "Bonds_" + string;
        this.saved.put(connections.saveName, connections);
    }

    boolean restoreBonds(String string) {
        String string2 = string.length() > 0 ? "Bonds_" + string : this.lastConnections;
        Connections connections = (Connections)StateManager.getNoCase(this.saved, string2);
        return connections != null && connections.restore();
    }

    static boolean doReportProperty(String string) {
        return string.charAt(0) != '_' && unreportedProperties.indexOf(";" + string + ";") < 0;
    }

    protected static int getJmolVersionInt() {
        String string = JC.version;
        int n = -1;
        try {
            int n2 = string.indexOf(".");
            if (n2 < 0) {
                n = 100000 * Integer.parseInt(string);
                return n;
            }
            n = 100000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf(".")) < 0) {
                return n += 1000 * Integer.parseInt(string);
            }
            n += 1000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf("_")) >= 0) {
                string = string.substring(0, n2);
            }
            if ((n2 = string.indexOf(" ")) >= 0) {
                string = string.substring(0, n2);
            }
            n += Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static String varClip(String string, String string2, int n) {
        if (n > 0 && string2.length() > n) {
            string2 = string2.substring(0, n) + " #...more (" + string2.length() + " bytes -- use SHOW " + string + " or MESSAGE @" + string + " to view)";
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GlobalSettings {
        Map<String, Object> htNonbooleanParameterValues;
        Map<String, Boolean> htBooleanParameterFlags;
        Map<String, Boolean> htPropertyFlagsRemoved;
        Map<String, SV> htUserVariables = new Hashtable<String, SV>();
        Map<String, String> databases;
        int ambientPercent = 45;
        int diffusePercent = 84;
        boolean specular = true;
        int specularExponent = 6;
        int phongExponent = 64;
        int specularPercent = 22;
        int specularPower = 40;
        int zDepth = 0;
        int zShadePower = 3;
        int zSlab = 50;
        boolean slabByMolecule = false;
        boolean slabByAtom = false;
        boolean allowEmbeddedScripts = true;
        boolean appendNew = true;
        String appletProxy = "";
        boolean applySymmetryToBonds = false;
        String atomTypes = "";
        boolean autoBond = true;
        boolean axesOrientationRasmol = false;
        short bondRadiusMilliAngstroms = (short)150;
        float bondTolerance = 0.45f;
        String defaultDirectory = "";
        boolean defaultStructureDSSP = true;
        final P3 ptDefaultLattice = new P3();
        String defaultLoadScript = "";
        String defaultLoadFilter = "";
        String defaultDropScript = "zap; load SYNC \"%FILE\";if (%ALLOWCARTOONS && _loadScript == '' && defaultLoadScript == '' && _filetype == 'Pdb') {if ({(protein or nucleic)&*/1.1} && {*/1.1}[1].groupindex != {*/1.1}[0].groupindex){select protein or nucleic;cartoons only;}if ({visible}){color structure}else{wireframe -0.1};if (!{visible}){spacefill 23%};select *}";
        boolean forceAutoBond = false;
        boolean fractionalRelative = false;
        char inlineNewlineChar = (char)124;
        String loadFormat;
        String loadLigandFormat;
        String nmrUrlFormat;
        String nmrPredictFormat;
        String smilesUrlFormat;
        String nihResolverFormat;
        String pubChemFormat;
        String edsUrlFormat = "http://eds.bmc.uu.se/eds/dfs/%LC13/%LCFILE/%LCFILE.omap";
        String edsUrlCutoff = "load('http://eds.bmc.uu.se/eds/dfs/%LC13/%LCFILE/%LCFILE.sfdat').lines.find('MAP_SIGMA').split(' ')[2]";
        String edsUrlOptions = "within 2.0 {*}";
        float minBondDistance = 0.4f;
        int minPixelSelRadius = 6;
        boolean pdbAddHydrogens = false;
        boolean pdbGetHeader = false;
        boolean pdbSequential = false;
        int percentVdwAtom = 23;
        int smallMoleculeMaxAtoms = 40000;
        boolean smartAromatic = true;
        boolean zeroBasedXyzRasmol = false;
        boolean legacyAutoBonding = false;
        boolean legacyHAddition = false;
        boolean allowRotateSelected = false;
        boolean allowMoveAtoms = false;
        boolean defaultPerspectiveDepth = true;
        float visualRange = 5.0f;
        boolean solventOn = false;
        String defaultAngleLabel = "%VALUE %UNITS";
        String defaultDistanceLabel = "%VALUE %UNITS";
        String defaultTorsionLabel = "%VALUE %UNITS";
        boolean justifyMeasurements = false;
        boolean measureAllModels = false;
        int minimizationSteps = 100;
        boolean minimizationRefresh = true;
        boolean minimizationSilent = false;
        float minimizationCriterion = 0.001f;
        boolean antialiasDisplay = false;
        boolean antialiasImages = true;
        boolean imageState = true;
        boolean antialiasTranslucent = true;
        boolean displayCellParameters = true;
        boolean dotsSelectedOnly = false;
        boolean dotSurface = true;
        int dotDensity = 3;
        int dotScale = 1;
        int meshScale = 1;
        boolean dynamicMeasurements = false;
        boolean greyscaleRendering = false;
        boolean isosurfaceKey = false;
        boolean isosurfacePropertySmoothing = true;
        int isosurfacePropertySmoothingPower = 7;
        int platformSpeed = 10;
        public int repaintWaitMs = 1000;
        boolean showHiddenSelectionHalos = false;
        boolean showKeyStrokes = true;
        boolean showMeasurements = true;
        public boolean showTiming = false;
        boolean zoomLarge = true;
        boolean zoomHeight = false;
        String backgroundImageFileName;
        boolean partialDots = false;
        boolean bondModeOr = false;
        boolean hbondsBackbone = false;
        float hbondsAngleMinimum = 90.0f;
        float hbondsDistanceMaximum = 3.25f;
        boolean hbondsRasmol = true;
        boolean hbondsSolid = false;
        byte modeMultipleBond = (byte)2;
        boolean showHydrogens = true;
        boolean showMultipleBonds = true;
        boolean ssbondsBackbone = false;
        float multipleBondSpacing = -1.0f;
        float multipleBondRadiusFactor = 0.0f;
        boolean cartoonBaseEdges = false;
        boolean cartoonRockets = false;
        boolean cartoonFancy = false;
        boolean cartoonLadders = false;
        boolean chainCaseSensitive = false;
        int hermiteLevel = 0;
        boolean highResolutionFlag = false;
        public boolean rangeSelected = false;
        boolean rasmolHydrogenSetting = true;
        boolean rasmolHeteroSetting = true;
        int ribbonAspectRatio = 16;
        boolean ribbonBorder = false;
        boolean rocketBarrels = false;
        float sheetSmoothing = 1.0f;
        boolean traceAlpha = true;
        boolean translucent = true;
        boolean twistedSheets = false;
        boolean allowGestures = false;
        boolean allowModelkit = true;
        boolean allowMultiTouch = true;
        boolean allowKeyStrokes = false;
        int animationFps = 10;
        boolean atomPicking = true;
        boolean autoFps = false;
        EnumAxesMode axesMode = EnumAxesMode.BOUNDBOX;
        float axesScale = 2.0f;
        float starScale = 0.05f;
        boolean bondPicking = false;
        float defaultCameraDepth = 3.0f;
        boolean celShading = false;
        String dataSeparator = "~~~";
        boolean debugScript = false;
        float defaultDrawArrowScale = 0.5f;
        String defaultLabelXYZ = "%a";
        String defaultLabelPDB = "%m%r";
        float defaultTranslucent = 0.5f;
        int delayMaximumMs = 0;
        float dipoleScale = 1.0f;
        float drawFontSize = 14.0f;
        boolean disablePopupMenu = false;
        boolean dragSelected = false;
        boolean drawHover = false;
        boolean drawPicking = false;
        boolean dsspCalcHydrogen = true;
        String energyUnits = "kJ";
        float exportScale = 1.0f;
        String helpPath = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
        boolean fontScaling = false;
        boolean fontCaching = true;
        String forceField = "MMFF";
        int helixStep = 1;
        boolean hideNameInPopup = false;
        int hoverDelayMs = 500;
        float loadAtomDataTolerance = 0.01f;
        public boolean logCommands = false;
        public boolean logGestures = false;
        String measureDistanceUnits = "nanometers";
        boolean measurementLabels = true;
        boolean messageStyleChime = false;
        boolean monitorEnergy = false;
        boolean multiProcessor = true;
        int pickingSpinRate = 10;
        String pickLabel = "";
        float pointGroupDistanceTolerance = 0.2f;
        float pointGroupLinearTolerance = 8.0f;
        public boolean preserveState = true;
        String propertyColorScheme = "roygb";
        String quaternionFrame = "p";
        boolean saveProteinStructureState = true;
        float solventProbeRadius = 1.2f;
        int scriptDelay = 0;
        boolean selectAllModels = true;
        boolean statusReporting = true;
        int strandCountForStrands = 5;
        int strandCountForMeshRibbon = 7;
        int strutSpacing = 6;
        float strutLengthMaximum = 7.0f;
        float strutDefaultRadius = 0.3f;
        boolean strutsMultiple = false;
        boolean useArcBall = false;
        boolean useMinimizationThread = true;
        boolean useNumberLocalization = true;
        public boolean useScriptQueue = true;
        public boolean waitForMoveTo = true;
        float vectorScale = 1.0f;
        boolean vectorSymmetry = false;
        float vibrationPeriod = 1.0f;
        float vibrationScale = 1.0f;
        boolean wireframeRotation = false;
        boolean hideNavigationPoint = false;
        boolean navigationMode = false;
        boolean navigationPeriodic = false;
        float navigationSpeed = 5.0f;
        boolean showNavigationPointAlways = false;
        String stereoState = null;
        boolean modelKitMode = false;
        int[] objColors = new int[8];
        boolean[] objStateOn = new boolean[8];
        int[] objMad = new int[8];
        boolean ellipsoidAxes = false;
        boolean ellipsoidDots = false;
        boolean ellipsoidArcs = false;
        boolean ellipsoidArrows = false;
        boolean ellipsoidFill = false;
        boolean ellipsoidBall = true;
        int ellipsoidDotCount = 200;
        float ellipsoidAxisDiameter = 0.02f;
        boolean testFlag1 = false;
        boolean testFlag2 = false;
        boolean testFlag3 = false;
        boolean testFlag4 = false;
        Map<EnumStructure, float[]> structureList = new Hashtable<EnumStructure, float[]>();
        boolean haveSetStructureList;
        private String[] userDatabases;

        GlobalSettings(GlobalSettings globalSettings, boolean bl) {
            this.structureList.put(EnumStructure.TURN, new float[]{30.0f, 90.0f, -15.0f, 95.0f});
            this.structureList.put(EnumStructure.SHEET, new float[]{-180.0f, -10.0f, 70.0f, 180.0f, -180.0f, -45.0f, -180.0f, -130.0f, 140.0f, 180.0f, 90.0f, 180.0f});
            this.structureList.put(EnumStructure.HELIX, new float[]{-160.0f, 0.0f, -100.0f, 45.0f});
            this.registerAllValues(globalSettings, bl);
        }

        void clear() {
            Iterator<String> iterator = this.htUserVariables.keySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (string.charAt(0) != '@' && !string.startsWith("site_")) continue;
                iterator.remove();
            }
            this.setPicked(-1);
            this.setI("_atomhovered", -1);
            this.setS("_pickinfo", "");
            this.setB("selectionhalos", false);
            this.setB("hidenotselected", false);
            this.measurementLabels = true;
            this.setB("measurementlabels", true);
            this.drawHover = false;
            this.setB("drawHover", false);
            StateManager.this.saveScene("DELETE", null);
        }

        void registerAllValues(GlobalSettings globalSettings, boolean bl) {
            this.htNonbooleanParameterValues = new Hashtable<String, Object>();
            this.htBooleanParameterFlags = new Hashtable<String, Boolean>();
            this.htPropertyFlagsRemoved = new Hashtable<String, Boolean>();
            if (globalSettings != null) {
                if (!bl) {
                    this.htUserVariables = globalSettings.htUserVariables;
                }
                this.debugScript = globalSettings.debugScript;
                this.disablePopupMenu = globalSettings.disablePopupMenu;
                this.messageStyleChime = globalSettings.messageStyleChime;
                this.defaultDirectory = globalSettings.defaultDirectory;
                this.allowGestures = globalSettings.allowGestures;
                this.allowModelkit = globalSettings.allowModelkit;
                this.allowMultiTouch = globalSettings.allowMultiTouch;
                this.allowKeyStrokes = globalSettings.allowKeyStrokes;
                this.legacyAutoBonding = globalSettings.legacyAutoBonding;
                this.legacyHAddition = globalSettings.legacyHAddition;
                this.platformSpeed = globalSettings.platformSpeed;
                this.useScriptQueue = globalSettings.useScriptQueue;
                this.useArcBall = globalSettings.useArcBall;
                this.databases = globalSettings.databases;
                this.showTiming = globalSettings.showTiming;
                this.wireframeRotation = globalSettings.wireframeRotation;
            }
            if (this.databases == null) {
                this.databases = new Hashtable<String, String>();
                this.getDataBaseList(JC.databases);
                this.getDataBaseList(this.userDatabases);
            }
            this.loadFormat = this.databases.get("pdb");
            this.loadLigandFormat = this.databases.get("ligand");
            this.nmrUrlFormat = this.databases.get("nmr");
            this.nmrPredictFormat = this.databases.get("nmrdb");
            this.smilesUrlFormat = this.databases.get("nci") + "/file?format=sdf&get3d=True";
            this.nihResolverFormat = this.databases.get("nci");
            this.pubChemFormat = this.databases.get("pubchem");
            for (EnumCallback enumCallback : EnumCallback.values()) {
                this.resetValue(enumCallback.name() + "Callback", globalSettings);
            }
            this.setI("historyLevel", 0);
            this.setI("depth", 0);
            this.setF("gestureSwipeFactor", 1.0f);
            this.setB("hideNotSelected", false);
            this.setS("hoverLabel", "");
            this.setB("isKiosk", StateManager.this.viewer.isKiosk());
            this.setS("logFile", StateManager.this.viewer.getLogFileName());
            this.setI("logLevel", Logger.getLogLevel());
            this.setF("mouseWheelFactor", 1.15f);
            this.setF("mouseDragFactor", 1.0f);
            this.setI("navFps", 10);
            this.setI("navigationDepth", 0);
            this.setI("navigationSlab", 0);
            this.setI("navX", 0);
            this.setI("navY", 0);
            this.setI("navZ", 0);
            this.setS("pathForAllFiles", "");
            this.setI("perspectiveModel", 11);
            this.setS("picking", "identify");
            this.setS("pickingStyle", "toggle");
            this.setB("refreshing", true);
            this.setI("rotationRadius", 0);
            this.setI("scaleAngstromsPerInch", 0);
            this.setI("scriptReportingLevel", 0);
            this.setB("selectionHalos", false);
            this.setB("showaxes", false);
            this.setB("showboundbox", false);
            this.setB("showfrank", false);
            this.setB("showUnitcell", false);
            this.setI("slab", 100);
            this.setB("slabEnabled", false);
            this.setF("slabrange", 0.0f);
            this.setI("spinX", 0);
            this.setI("spinY", 30);
            this.setI("spinZ", 0);
            this.setI("spinFps", 30);
            this.setI("stereoDegrees", -5);
            this.setI("stateversion", 0);
            this.setB("syncScript", StateManager.this.viewer.getStatusManager().syncingScripts);
            this.setB("syncMouse", StateManager.this.viewer.getStatusManager().syncingMouse);
            this.setB("syncStereo", StateManager.this.viewer.getStatusManager().stereoSync);
            this.setB("windowCentered", true);
            this.setB("zoomEnabled", true);
            this.setI("zDepth", 0);
            this.setB("zShade", false);
            this.setI("zSlab", 50);
            this.setI("_version", StateManager.getJmolVersionInt());
            this.setB("axesWindow", true);
            this.setB("axesMolecular", false);
            this.setB("axesPosition", false);
            this.setB("axesUnitcell", false);
            this.setI("backgroundModel", 0);
            this.setB("colorRasmol", false);
            this.setS("currentLocalPath", "");
            this.setS("defaultLattice", "{0 0 0}");
            this.setS("defaultColorScheme", "Jmol");
            this.setS("defaultDirectoryLocal", "");
            this.setS("defaults", "Jmol");
            this.setS("defaultVDW", "Jmol");
            this.setS("exportDrivers", "Idtf;Maya;Povray;Vrml;X3d;Tachyon;Obj");
            this.setI("propertyAtomNumberColumnCount", 0);
            this.setI("propertyAtomNumberField", 0);
            this.setI("propertyDataColumnCount", 0);
            this.setI("propertyDataField", 0);
            this.setB("undo", true);
            this.setB("allowEmbeddedScripts", this.allowEmbeddedScripts);
            this.setB("allowGestures", this.allowGestures);
            this.setB("allowKeyStrokes", this.allowKeyStrokes);
            this.setB("allowModelkit", this.allowModelkit);
            this.setB("allowMultiTouch", this.allowMultiTouch);
            this.setB("allowRotateSelected", this.allowRotateSelected);
            this.setB("allowMoveAtoms", this.allowMoveAtoms);
            this.setI("ambientPercent", this.ambientPercent);
            this.setI("animationFps", this.animationFps);
            this.setB("antialiasImages", this.antialiasImages);
            this.setB("antialiasDisplay", this.antialiasDisplay);
            this.setB("antialiasTranslucent", this.antialiasTranslucent);
            this.setB("appendNew", this.appendNew);
            this.setS("appletProxy", this.appletProxy);
            this.setB("applySymmetryToBonds", this.applySymmetryToBonds);
            this.setB("atomPicking", this.atomPicking);
            this.setS("atomTypes", this.atomTypes);
            this.setB("autoBond", this.autoBond);
            this.setB("autoFps", this.autoFps);
            this.setI("axesMode", this.axesMode.getCode());
            this.setF("axesScale", this.axesScale);
            this.setB("axesOrientationRasmol", this.axesOrientationRasmol);
            this.setB("bondModeOr", this.bondModeOr);
            this.setB("bondPicking", this.bondPicking);
            this.setI("bondRadiusMilliAngstroms", this.bondRadiusMilliAngstroms);
            this.setF("bondTolerance", this.bondTolerance);
            this.setF("cameraDepth", this.defaultCameraDepth);
            this.setB("cartoonBaseEdges", this.cartoonBaseEdges);
            this.setB("cartoonFancy", this.cartoonFancy);
            this.setB("cartoonLadders", this.cartoonLadders);
            this.setB("cartoonRockets", this.cartoonRockets);
            this.setB("chainCaseSensitive", this.chainCaseSensitive);
            this.setB("celShading", this.celShading);
            this.setS("dataSeparator", this.dataSeparator);
            this.setB("debugScript", this.debugScript);
            this.setS("defaultAngleLabel", this.defaultAngleLabel);
            this.setF("defaultDrawArrowScale", this.defaultDrawArrowScale);
            this.setS("defaultDirectory", this.defaultDirectory);
            this.setS("defaultDistanceLabel", this.defaultDistanceLabel);
            this.setS("defaultDropScript", this.defaultDropScript);
            this.setS("defaultLabelPDB", this.defaultLabelPDB);
            this.setS("defaultLabelXYZ", this.defaultLabelXYZ);
            this.setS("defaultLoadFilter", this.defaultLoadFilter);
            this.setS("defaultLoadScript", this.defaultLoadScript);
            this.setB("defaultStructureDSSP", this.defaultStructureDSSP);
            this.setS("defaultTorsionLabel", this.defaultTorsionLabel);
            this.setF("defaultTranslucent", this.defaultTranslucent);
            this.setI("delayMaximumMs", this.delayMaximumMs);
            this.setI("diffusePercent", this.diffusePercent);
            this.setF("dipoleScale", this.dipoleScale);
            this.setB("disablePopupMenu", this.disablePopupMenu);
            this.setB("displayCellParameters", this.displayCellParameters);
            this.setI("dotDensity", this.dotDensity);
            this.setI("dotScale", this.dotScale);
            this.setB("dotsSelectedOnly", this.dotsSelectedOnly);
            this.setB("dotSurface", this.dotSurface);
            this.setB("dragSelected", this.dragSelected);
            this.setB("drawHover", this.drawHover);
            this.setF("drawFontSize", this.drawFontSize);
            this.setB("drawPicking", this.drawPicking);
            this.setB("dsspCalculateHydrogenAlways", this.dsspCalcHydrogen);
            this.setB("dynamicMeasurements", this.dynamicMeasurements);
            this.setS("edsUrlFormat", this.edsUrlFormat);
            this.setS("edsUrlCutoff", this.edsUrlCutoff);
            this.setB("ellipsoidArcs", this.ellipsoidArcs);
            this.setB("ellipsoidArrows", this.ellipsoidArrows);
            this.setB("ellipsoidAxes", this.ellipsoidAxes);
            this.setF("ellipsoidAxisDiameter", this.ellipsoidAxisDiameter);
            this.setB("ellipsoidBall", this.ellipsoidBall);
            this.setI("ellipsoidDotCount", this.ellipsoidDotCount);
            this.setB("ellipsoidDots", this.ellipsoidDots);
            this.setB("ellipsoidFill", this.ellipsoidFill);
            this.setS("energyUnits", this.energyUnits);
            this.setF("exportScale", this.exportScale);
            this.setB("fontScaling", this.fontScaling);
            this.setB("fontCaching", this.fontCaching);
            this.setB("forceAutoBond", this.forceAutoBond);
            this.setS("forceField", this.forceField);
            this.setB("fractionalRelative", this.fractionalRelative);
            this.setB("greyscaleRendering", this.greyscaleRendering);
            this.setF("hbondsAngleMinimum", this.hbondsAngleMinimum);
            this.setF("hbondsDistanceMaximum", this.hbondsDistanceMaximum);
            this.setB("hbondsBackbone", this.hbondsBackbone);
            this.setB("hbondsRasmol", this.hbondsRasmol);
            this.setB("hbondsSolid", this.hbondsSolid);
            this.setI("helixStep", this.helixStep);
            this.setS("helpPath", this.helpPath);
            this.setI("hermiteLevel", this.hermiteLevel);
            this.setB("hideNameInPopup", this.hideNameInPopup);
            this.setB("hideNavigationPoint", this.hideNavigationPoint);
            this.setB("highResolution", this.highResolutionFlag);
            this.setF("hoverDelay", (float)this.hoverDelayMs / 1000.0f);
            this.setB("imageState", this.imageState);
            this.setB("isosurfaceKey", this.isosurfaceKey);
            this.setB("isosurfacePropertySmoothing", this.isosurfacePropertySmoothing);
            this.setI("isosurfacePropertySmoothingPower", this.isosurfacePropertySmoothingPower);
            this.setB("justifyMeasurements", this.justifyMeasurements);
            this.setB("legacyAutoBonding", this.legacyAutoBonding);
            this.setB("legacyHAddition", this.legacyHAddition);
            this.setF("loadAtomDataTolerance", this.loadAtomDataTolerance);
            this.setS("loadFormat", this.loadFormat);
            this.setS("loadLigandFormat", this.loadLigandFormat);
            this.setB("logCommands", this.logCommands);
            this.setB("logGestures", this.logGestures);
            this.setB("measureAllModels", this.measureAllModels);
            this.setB("measurementLabels", this.measurementLabels);
            this.setS("measurementUnits", this.measureDistanceUnits);
            this.setI("meshScale", this.meshScale);
            this.setB("messageStyleChime", this.messageStyleChime);
            this.setF("minBondDistance", this.minBondDistance);
            this.setI("minPixelSelRadius", this.minPixelSelRadius);
            this.setI("minimizationSteps", this.minimizationSteps);
            this.setB("minimizationRefresh", this.minimizationRefresh);
            this.setB("minimizationSilent", this.minimizationSilent);
            this.setF("minimizationCriterion", this.minimizationCriterion);
            this.setB("modelKitMode", this.modelKitMode);
            this.setB("monitorEnergy", this.monitorEnergy);
            this.setF("multipleBondRadiusFactor", this.multipleBondRadiusFactor);
            this.setF("multipleBondSpacing", this.multipleBondSpacing);
            this.setB("multiProcessor", this.multiProcessor && Viewer.nProcessors > 1);
            this.setB("navigationMode", this.navigationMode);
            this.setB("navigationPeriodic", this.navigationPeriodic);
            this.setF("navigationSpeed", this.navigationSpeed);
            this.setS("nmrPredictFormat", this.nmrPredictFormat);
            this.setS("nmrUrlFormat", this.nmrUrlFormat);
            this.setB("partialDots", this.partialDots);
            this.setB("pdbAddHydrogens", this.pdbAddHydrogens);
            this.setB("pdbGetHeader", this.pdbGetHeader);
            this.setB("pdbSequential", this.pdbSequential);
            this.setB("perspectiveDepth", this.defaultPerspectiveDepth);
            this.setI("percentVdwAtom", this.percentVdwAtom);
            this.setI("phongExponent", this.phongExponent);
            this.setI("pickingSpinRate", this.pickingSpinRate);
            this.setS("pickLabel", this.pickLabel);
            this.setI("platformSpeed", this.platformSpeed);
            this.setF("pointGroupLinearTolerance", this.pointGroupLinearTolerance);
            this.setF("pointGroupDistanceTolerance", this.pointGroupDistanceTolerance);
            this.setB("preserveState", this.preserveState);
            this.setS("propertyColorScheme", this.propertyColorScheme);
            this.setS("quaternionFrame", this.quaternionFrame);
            this.setB("rangeSelected", this.rangeSelected);
            this.setI("repaintWaitMs", this.repaintWaitMs);
            this.setI("ribbonAspectRatio", this.ribbonAspectRatio);
            this.setB("ribbonBorder", this.ribbonBorder);
            this.setB("rocketBarrels", this.rocketBarrels);
            this.setB("saveProteinStructureState", this.saveProteinStructureState);
            this.setB("scriptqueue", this.useScriptQueue);
            this.setB("selectAllModels", this.selectAllModels);
            this.setB("selectHetero", this.rasmolHeteroSetting);
            this.setB("selectHydrogen", this.rasmolHydrogenSetting);
            this.setF("sheetSmoothing", this.sheetSmoothing);
            this.setB("showHiddenSelectionHalos", this.showHiddenSelectionHalos);
            this.setB("showHydrogens", this.showHydrogens);
            this.setB("showKeyStrokes", this.showKeyStrokes);
            this.setB("showMeasurements", this.showMeasurements);
            this.setB("showMultipleBonds", this.showMultipleBonds);
            this.setB("showNavigationPointAlways", this.showNavigationPointAlways);
            this.setI("showScript", this.scriptDelay);
            this.setB("showtiming", this.showTiming);
            this.setB("slabByMolecule", this.slabByMolecule);
            this.setB("slabByAtom", this.slabByAtom);
            this.setB("smartAromatic", this.smartAromatic);
            this.setI("smallMoleculeMaxAtoms", this.smallMoleculeMaxAtoms);
            this.setS("smilesUrlFormat", this.smilesUrlFormat);
            this.setS("nihResolverFormat", this.nihResolverFormat);
            this.setS("pubChemFormat", this.pubChemFormat);
            this.setB("solventProbe", this.solventOn);
            this.setF("solventProbeRadius", this.solventProbeRadius);
            this.setB("specular", this.specular);
            this.setI("specularExponent", this.specularExponent);
            this.setI("specularPercent", this.specularPercent);
            this.setI("specularPower", this.specularPower);
            this.setB("ssbondsBackbone", this.ssbondsBackbone);
            this.setF("starScale", this.starScale);
            this.setB("statusReporting", this.statusReporting);
            this.setI("strandCount", this.strandCountForStrands);
            this.setI("strandCountForStrands", this.strandCountForStrands);
            this.setI("strandCountForMeshRibbon", this.strandCountForMeshRibbon);
            this.setF("strutDefaultRadius", this.strutDefaultRadius);
            this.setF("strutLengthMaximum", this.strutLengthMaximum);
            this.setI("strutSpacing", this.strutSpacing);
            this.setB("strutsMultiple", this.strutsMultiple);
            this.setB("testFlag1", this.testFlag1);
            this.setB("testFlag2", this.testFlag2);
            this.setB("testFlag3", this.testFlag3);
            this.setB("testFlag4", this.testFlag4);
            this.setB("traceAlpha", this.traceAlpha);
            this.setB("translucent", this.translucent);
            this.setB("twistedSheets", this.twistedSheets);
            this.setB("useArcBall", this.useArcBall);
            this.setB("useMinimizationThread", this.useMinimizationThread);
            this.setB("useNumberLocalization", this.useNumberLocalization);
            this.setF("vectorScale", this.vectorScale);
            this.setB("vectorSymmetry", this.vectorSymmetry);
            this.setF("vibrationPeriod", this.vibrationPeriod);
            this.setF("vibrationScale", this.vibrationScale);
            this.setF("visualRange", this.visualRange);
            this.setB("waitForMoveTo", this.waitForMoveTo);
            this.setB("wireframeRotation", this.wireframeRotation);
            this.setI("zDepth", this.zDepth);
            this.setB("zeroBasedXyzRasmol", this.zeroBasedXyzRasmol);
            this.setB("zoomHeight", this.zoomHeight);
            this.setB("zoomLarge", this.zoomLarge);
            this.setI("zShadePower", this.zShadePower);
            this.setI("zSlab", this.zSlab);
        }

        void setDefaultLattice(P3 p3) {
            this.ptDefaultLattice.setT(p3);
        }

        P3 getDefaultLattice() {
            return this.ptDefaultLattice;
        }

        void setUnits(String string) {
            String string2 = this.measureDistanceUnits;
            String string3 = this.energyUnits;
            if (string.equalsIgnoreCase("angstroms")) {
                this.measureDistanceUnits = "angstroms";
            } else if (string.equalsIgnoreCase("nanometers") || string.equalsIgnoreCase("nm")) {
                this.measureDistanceUnits = "nanometers";
            } else if (string.equalsIgnoreCase("picometers") || string.equalsIgnoreCase("pm")) {
                this.measureDistanceUnits = "picometers";
            } else if (string.equalsIgnoreCase("bohr") || string.equalsIgnoreCase("au")) {
                this.measureDistanceUnits = "au";
            } else if (string.equalsIgnoreCase("vanderwaals") || string.equalsIgnoreCase("vdw")) {
                this.measureDistanceUnits = "vdw";
            } else if (string.toLowerCase().endsWith("hz") || string.toLowerCase().endsWith("khz")) {
                this.measureDistanceUnits = string.toLowerCase();
            } else if (string.equalsIgnoreCase("kj")) {
                this.energyUnits = "kJ";
            } else if (string.equalsIgnoreCase("kcal")) {
                this.energyUnits = "kcal";
            }
            if (!string2.equalsIgnoreCase(this.measureDistanceUnits)) {
                this.setS("measurementUnits", this.measureDistanceUnits);
            } else if (!string3.equalsIgnoreCase(this.energyUnits)) {
                this.setS("energyUnits", this.energyUnits);
            }
        }

        boolean isJmolVariable(String string) {
            return string.charAt(0) == '_' || this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase()) || this.htBooleanParameterFlags.containsKey(string) || unreportedProperties.indexOf(";" + string + ";") >= 0;
        }

        private void resetValue(String string, GlobalSettings globalSettings) {
            this.setS(string, globalSettings == null ? "" : (String)globalSettings.getParameter(string));
        }

        public void setB(String string, boolean bl) {
            if (this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htBooleanParameterFlags.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        }

        void setI(String string, int n) {
            if (this.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htNonbooleanParameterValues.put(string, n);
        }

        public void setF(String string, float f) {
            if (Float.isNaN(f)) {
                return;
            }
            if (this.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htNonbooleanParameterValues.put(string, Float.valueOf(f));
        }

        void setS(String string, String string2) {
            string = string.toLowerCase();
            if (string2 == null || this.htBooleanParameterFlags.containsKey(string)) {
                return;
            }
            this.htNonbooleanParameterValues.put(string, string2);
        }

        void removeParam(String string) {
            if (this.htBooleanParameterFlags.containsKey(string = string.toLowerCase())) {
                this.htBooleanParameterFlags.remove(string);
                if (!this.htPropertyFlagsRemoved.containsKey(string)) {
                    this.htPropertyFlagsRemoved.put(string, Boolean.FALSE);
                }
                return;
            }
            if (this.htNonbooleanParameterValues.containsKey(string)) {
                this.htNonbooleanParameterValues.remove(string);
            }
        }

        SV setUserVariable(String string, SV sV) {
            if (sV == null) {
                return null;
            }
            string = string.toLowerCase();
            this.htUserVariables.put(string, sV.setName(string).setGlobal());
            return sV;
        }

        void unsetUserVariable(String string) {
            if (string.equals("all") || string.equals("variables")) {
                this.htUserVariables.clear();
                Logger.info("all user-defined variables deleted");
            } else if (this.htUserVariables.containsKey(string)) {
                Logger.info("variable " + string + " deleted");
                this.htUserVariables.remove(string);
            }
        }

        void removeUserVariable(String string) {
            this.htUserVariables.remove(string);
        }

        SV getUserVariable(String string) {
            if (string == null) {
                return null;
            }
            string = string.toLowerCase();
            return this.htUserVariables.get(string);
        }

        String getParameterEscaped(String string, int n) {
            if (this.htNonbooleanParameterValues.containsKey(string = string.toLowerCase())) {
                Object object = this.htNonbooleanParameterValues.get(string);
                return StateManager.varClip(string, Escape.e(object), n);
            }
            if (this.htBooleanParameterFlags.containsKey(string)) {
                return this.htBooleanParameterFlags.get(string).toString();
            }
            if (this.htUserVariables.containsKey(string)) {
                return this.htUserVariables.get(string).escape();
            }
            if (this.htPropertyFlagsRemoved.containsKey(string)) {
                return "false";
            }
            return "<not defined>";
        }

        Object getParameter(String string) {
            Object object = this.getParam(string, false);
            return object == null ? "" : object;
        }

        SV getOrSetNewVariable(String string, boolean bl) {
            Object object;
            if (string == null || string.length() == 0) {
                string = "x";
            }
            return (object = this.getParam(string, true)) == null && bl && string.charAt(0) != '_' ? this.setUserVariable(string, SV.newVariable(4, "")) : SV.getVariable(object);
        }

        Object getParam(String string, boolean bl) {
            if ((string = string.toLowerCase()).equals("_memory")) {
                float f = 0.0f;
                float f2 = 0.0f;
                Object object = Runtime.getRuntime();
                f = (float)((Runtime)object).totalMemory() / 1000000.0f;
                f2 = (float)((Runtime)object).freeMemory() / 1000000.0f;
                object = TextFormat.formatDecimal(f - f2, 1) + "/" + TextFormat.formatDecimal(f, 1);
                this.htNonbooleanParameterValues.put("_memory", object);
            }
            if (this.htNonbooleanParameterValues.containsKey(string)) {
                return this.htNonbooleanParameterValues.get(string);
            }
            if (this.htBooleanParameterFlags.containsKey(string)) {
                return this.htBooleanParameterFlags.get(string);
            }
            if (this.htPropertyFlagsRemoved.containsKey(string)) {
                return Boolean.FALSE;
            }
            if (this.htUserVariables.containsKey(string)) {
                SV sV = this.htUserVariables.get(string);
                return bl ? sV : SV.oValue(sV);
            }
            return null;
        }

        String getVariableList() {
            return StateManager.getVariableList(this.htUserVariables, 0, true, false);
        }

        public void setStructureList(float[] fArray, EnumStructure enumStructure) {
            this.haveSetStructureList = true;
            this.structureList.put(enumStructure, fArray);
        }

        public Map<EnumStructure, float[]> getStructureList() {
            return this.structureList;
        }

        void setPicked(int n) {
            SV sV = null;
            if (n >= 0) {
                this.setI("_atompicked", n);
                sV = (SV)this.getParam("picked", true);
            }
            if (sV == null || sV.tok != 10) {
                sV = SV.newVariable(10, new BS());
                this.setUserVariable("picked", sV);
            }
            if (n >= 0) {
                SV.getBitSet(sV, false).set(n);
            }
        }

        public String resolveDataBase(String string, String string2) {
            String string3 = this.databases.get(string.toLowerCase());
            if (string3 == null) {
                return null;
            }
            if (string2.indexOf("/") < 0) {
                if (string.equals("pubchem")) {
                    string2 = "name/" + string2;
                } else if (string.equals("nci")) {
                    string2 = string2 + "/file?format=sdf&get3d=True";
                }
            }
            return string3.indexOf("%FILE") < 0 ? string3 + string2 : TextFormat.formatStringS(string3, "FILE", string2);
        }

        private void getDataBaseList(String[] stringArray) {
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; i += 2) {
                this.databases.put(stringArray[i].toLowerCase(), stringArray[i + 1]);
            }
        }
    }

    static class Connection {
        int atomIndex1;
        int atomIndex2;
        short mad;
        short colix;
        int order;
        float energy;
        int shapeVisibilityFlags;

        Connection(int n, int n2, short s, short s2, int n3, float f, int n4) {
            this.atomIndex1 = n;
            this.atomIndex2 = n2;
            this.mad = s;
            this.colix = s2;
            this.order = n3;
            this.energy = f;
            this.shapeVisibilityFlags = n4;
        }
    }

    class Connections {
        String saveName;
        int bondCount;
        Connection[] connections;

        Connections() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            this.bondCount = modelSet.bondCount;
            this.connections = new Connection[this.bondCount + 1];
            Bond[] bondArray = modelSet.bonds;
            int n = this.bondCount;
            while (--n >= 0) {
                Bond bond = bondArray[n];
                this.connections[n] = new Connection(bond.getAtomIndex1(), bond.getAtomIndex2(), bond.mad, bond.colix, bond.order, bond.getEnergy(), bond.getShapeVisibilityFlags());
            }
        }

        boolean restore() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return false;
            }
            modelSet.deleteAllBonds();
            int n = this.bondCount;
            while (--n >= 0) {
                Connection connection = this.connections[n];
                int n2 = modelSet.getAtomCount();
                if (connection.atomIndex1 >= n2 || connection.atomIndex2 >= n2) continue;
                Bond bond = modelSet.bondAtoms(modelSet.atoms[connection.atomIndex1], modelSet.atoms[connection.atomIndex2], connection.order, connection.mad, null, connection.energy, false, true);
                bond.setColix(connection.colix);
                bond.setShapeVisibilityFlags(connection.shapeVisibilityFlags);
            }
            n = this.bondCount;
            while (--n >= 0) {
                modelSet.getBondAt(n).setIndex(n);
            }
            StateManager.this.viewer.setShapeProperty(1, "reportAll", null);
            return true;
        }
    }

    public class Orientation {
        String saveName;
        Matrix3f rotationMatrix = new Matrix3f();
        float xTrans;
        float yTrans;
        float zoom;
        float rotationRadius;
        P3 center = new P3();
        P3 navCenter = new P3();
        float xNav = Float.NaN;
        float yNav = Float.NaN;
        float navDepth = Float.NaN;
        float cameraDepth = Float.NaN;
        float cameraX = Float.NaN;
        float cameraY = Float.NaN;
        boolean windowCenteredFlag;
        boolean navigationMode;
        String moveToText;
        private float[] pymolView;

        Orientation(boolean bl, float[] fArray) {
            if (fArray != null) {
                this.pymolView = fArray;
                this.moveToText = "moveTo -1.0 PyMOL " + Escape.eAF(fArray);
                return;
            }
            StateManager.this.viewer.finalizeTransformParameters();
            if (bl) {
                Matrix3f matrix3f = (Matrix3f)StateManager.this.viewer.getModelSetAuxiliaryInfoValue("defaultOrientationMatrix");
                if (matrix3f == null) {
                    this.rotationMatrix.setIdentity();
                } else {
                    this.rotationMatrix.setM(matrix3f);
                }
            } else {
                StateManager.this.viewer.getRotation(this.rotationMatrix);
            }
            this.xTrans = StateManager.this.viewer.getTranslationXPercent();
            this.yTrans = StateManager.this.viewer.getTranslationYPercent();
            this.zoom = StateManager.this.viewer.getZoomSetting();
            this.center.setT(StateManager.this.viewer.getRotationCenter());
            this.windowCenteredFlag = StateManager.this.viewer.isWindowCentered();
            this.rotationRadius = StateManager.this.viewer.getFloat(0x2200002C);
            this.navigationMode = StateManager.this.viewer.getBoolean(603979887);
            this.moveToText = StateManager.this.viewer.getMoveToText(-1.0f);
            if (this.navigationMode) {
                this.xNav = StateManager.this.viewer.getNavigationOffsetPercent('X');
                this.yNav = StateManager.this.viewer.getNavigationOffsetPercent('Y');
                this.navDepth = StateManager.this.viewer.getNavigationDepthPercent();
                this.navCenter = P3.newP(StateManager.this.viewer.getNavigationCenter());
            }
            if (StateManager.this.viewer.getCamera().z != 0.0f) {
                this.cameraDepth = StateManager.this.viewer.getCameraDepth();
                this.cameraX = StateManager.this.viewer.getCamera().x;
                this.cameraY = StateManager.this.viewer.getCamera().y;
            }
        }

        public String getMoveToText(boolean bl) {
            return bl ? "   " + this.moveToText + "\n  save orientation " + Escape.eS(this.saveName.substring(12)) + ";\n" : this.moveToText;
        }

        public boolean restore(float f, boolean bl) {
            if (bl) {
                StateManager.this.viewer.setBooleanProperty("windowCentered", this.windowCenteredFlag);
                StateManager.this.viewer.setBooleanProperty("navigationMode", this.navigationMode);
                if (this.pymolView == null) {
                    StateManager.this.viewer.moveTo(StateManager.this.viewer.eval, f, this.center, null, Float.NaN, this.rotationMatrix, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth, this.cameraDepth, this.cameraX, this.cameraY);
                } else {
                    StateManager.this.viewer.movePyMOL(StateManager.this.viewer.eval, f, this.pymolView);
                }
            } else {
                StateManager.this.viewer.setRotationMatrix(this.rotationMatrix);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Scene {
        String saveName;
        private Map<String, Object> scene;

        public Scene(Map<String, Object> map) {
            this.scene = map;
        }

        public boolean restore(float f) {
            float[] fArray;
            JmolSceneGenerator jmolSceneGenerator = (JmolSceneGenerator)this.scene.get("generator");
            if (jmolSceneGenerator != null) {
                jmolSceneGenerator.generateScene(this.scene);
            }
            return (fArray = (float[])this.scene.get("pymolView")) != null && StateManager.this.viewer.movePyMOL(StateManager.this.viewer.eval, f, fArray);
        }
    }
}

