/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import org.jmol.api.JmolJSpecView;
import org.jmol.modelset.Atom;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

public class JSpecView
implements JmolJSpecView {
    private Viewer viewer;

    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    public void atomPicked(int n) {
        if (n < 0) {
            return;
        }
        String string = this.getPeakAtomRecord(n);
        if (string != null) {
            this.sendJSpecView(string + " src=\"JmolAtomSelect\"");
        }
    }

    private String getPeakAtomRecord(int n) {
        Atom[] atomArray = this.viewer.modelSet.atoms;
        short s = atomArray[n].modelIndex;
        String string = null;
        switch (atomArray[n].getElementNumber()) {
            case 1: {
                string = "1HNMR";
                break;
            }
            case 6: {
                string = "13CNMR";
                break;
            }
            default: {
                return null;
            }
        }
        JmolList jmolList = (JmolList)this.viewer.getModelAuxiliaryInfoValue(s, "jdxAtomSelect_" + string);
        if (jmolList == null) {
            return null;
        }
        this.viewer.modelSet.htPeaks = new Hashtable();
        Hashtable hashtable = this.viewer.modelSet.htPeaks;
        for (int i = 0; i < jmolList.size(); ++i) {
            String string2 = (String)jmolList.get(i);
            System.out.println("Jmol JSpecView.java peak=" + string2);
            BS bS = (BS)hashtable.get(string2);
            System.out.println("Jmol JSpecView.java bspeak=" + bS);
            if (bS == null) {
                bS = new BS();
                hashtable.put(string2, bS);
                String string3 = Parser.getQuotedAttribute(string2, "atoms");
                String string4 = Parser.getQuotedAttribute(string2, "select");
                System.out.println("Jmol JSpecView.java satoms select " + string3 + " " + string4);
                String string5 = "";
                if (string3 != null) {
                    string5 = string5 + "visible & (atomno=" + TextFormat.simpleReplace(string3, ",", " or atomno=") + ")";
                } else if (string4 != null) {
                    string5 = string5 + "visible & (" + string4 + ")";
                }
                System.out.println("Jmol JSpecView.java script : " + string5);
                bS.or(this.viewer.getAtomBitSet(string5));
            }
            System.out.println("Jmol JSpecView bsPeak now : " + bS + " " + n);
            if (!bS.get(n)) continue;
            return string2;
        }
        return null;
    }

    private void sendJSpecView(String string) {
        String string2 = Parser.getQuotedAttribute(string, "title");
        if (string2 != null) {
            this.viewer.scriptEcho(Logger.debugging ? string : string2);
        }
        string = this.viewer.fullName + "JSpecView: " + string;
        Logger.info("Jmol>JSV " + string);
        this.viewer.statusManager.syncSend(string, ">", 0);
    }

    public void setModel(int n) {
        int n2;
        int n3 = n2 = "sync on".equals(this.viewer.modelSet.getModelSetAuxiliaryInfoValue("jmolscript")) ? 1 : this.viewer.statusManager.getSyncMode();
        if (n2 != 1) {
            return;
        }
        String string = (String)this.viewer.getModelAuxiliaryInfoValue(n, "jdxModelSelect");
        if (string != null) {
            this.sendJSpecView(string);
        }
    }

    public int getBaseModelIndex(int n) {
        String string = (String)this.viewer.getModelAuxiliaryInfoValue(n, "jdxBaseModel");
        if (string != null) {
            int n2 = this.viewer.getModelCount();
            while (--n2 >= 0) {
                if (!string.equals(this.viewer.getModelAuxiliaryInfoValue(n2, "jdxModelID"))) continue;
                return n2;
            }
        }
        return n;
    }
}

