/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.constant.EnumPalette;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Object2d;
import org.jmol.modelset.Text;
import org.jmol.shape.AtomShape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.JmolFont;
import org.jmol.util.JmolList;

public class Labels
extends AtomShape {
    public String[] strings;
    public String[] formats;
    public short[] bgcolixes;
    public byte[] fids;
    public int[] offsets;
    private Map<Integer, Text> atomLabels = new Hashtable<Integer, Text>();
    private Text text;
    private Map<Integer, float[]> labelBoxes;
    public BS bsFontSet;
    public BS bsBgColixSet;
    public int defaultOffset;
    public int defaultAlignment;
    public int defaultZPos;
    public byte defaultFontId;
    public short defaultColix;
    public short defaultBgcolix;
    public byte defaultPaletteID;
    public int defaultPointer;
    public static int zeroOffset = 1028;
    public byte zeroFontId;
    private boolean defaultsOnlyForNone = true;
    private boolean setDefaults = false;
    private static final LabelToken[][] nullToken = new LabelToken[][]{null};
    private boolean isScaled;
    private float scalePixelsPerMicron;
    public static final int POINTER_FLAGS = 3;
    public static final int ALIGN_FLAGS = 12;
    public static final int ZPOS_FLAGS = 48;
    public static final int GROUP_FLAG = 16;
    public static final int FRONT_FLAG = 32;
    public static final int SCALE_FLAG = 64;
    public static final int EXACT_OFFSET_FLAG = 128;
    public static final int FLAGS = 255;
    public static final int FLAG_OFFSET = 8;
    private int pickedAtom = -1;
    private int pickedOffset = 0;
    private int pickedX;
    private int pickedY;

    public void initShape() {
        super.initShape();
        this.defaultFontId = this.zeroFontId = this.gdata.getFont3DFSS((String)"SansSerif", (String)"Plain", (float)13.0f).fid;
        this.defaultColix = 0;
        this.defaultBgcolix = 0;
        this.defaultOffset = zeroOffset;
        this.defaultZPos = 0;
        this.translucentAllowed = false;
    }

    public void setProperty(String string, Object object, BS bS) {
        this.isActive = true;
        if ("setDefaults" == string) {
            this.setDefaults = (Boolean)object;
            return;
        }
        if ("color" == string) {
            byte by = EnumPalette.pidOf(object);
            short s = C.getColixO(object);
            if (!this.setDefaults) {
                int n = bS.nextSetBit(0);
                while (n >= 0 && n < this.atomCount) {
                    this.setLabelColix(n, s, by);
                    n = bS.nextSetBit(n + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultColix = s;
                this.defaultPaletteID = by;
            }
            return;
        }
        if ("scalereference" == string) {
            if (this.strings == null) {
                return;
            }
            float f = ((Float)object).floatValue();
            float f2 = f == 0.0f ? 0.0f : 10000.0f / f;
            int n = bS.nextSetBit(0);
            while (n >= 0 && n < this.atomCount) {
                if (this.strings.length > n) {
                    this.text = this.getLabel(n);
                    if (this.text == null) {
                        this.text = Text.newLabel(this.gdata, null, this.strings[n], (short)0, (short)0, 0, f2, null);
                        this.putLabel(n, this.text);
                    } else {
                        this.text.setScalePixelsPerMicron(f2);
                    }
                }
                n = bS.nextSetBit(n + 1);
            }
            return;
        }
        if ("label" == string) {
            LabelToken[][] labelTokenArray;
            this.setScaling();
            String string2 = (String)object;
            if (string2 == null || string2.length() == 0) {
                labelTokenArray = nullToken;
            } else {
                LabelToken[][] labelTokenArrayArray = new LabelToken[1][];
                labelTokenArray = labelTokenArrayArray;
                labelTokenArrayArray[0] = null;
            }
            LabelToken[][] labelTokenArray2 = labelTokenArray;
            int n = bS.nextSetBit(0);
            while (n >= 0 && n < this.atomCount) {
                this.setLabel(labelTokenArray2, string2, n);
                n = bS.nextSetBit(n + 1);
            }
            return;
        }
        if ("labels" == string) {
            this.setScaling();
            JmolList jmolList = (JmolList)object;
            int n = bS.nextSetBit(0);
            int n2 = 0;
            while (n >= 0 && n < this.atomCount) {
                LabelToken[][] labelTokenArray;
                String string3;
                if ((string3 = (String)jmolList.get(n2++)) == null || string3.length() == 0) {
                    labelTokenArray = nullToken;
                } else {
                    LabelToken[][] labelTokenArrayArray = new LabelToken[1][];
                    labelTokenArray = labelTokenArrayArray;
                    labelTokenArrayArray[0] = null;
                }
                LabelToken[][] labelTokenArray3 = labelTokenArray;
                this.setLabel(labelTokenArray3, string3, n);
                n = bS.nextSetBit(n + 1);
            }
            return;
        }
        if ("clearBoxes" == string) {
            this.labelBoxes = null;
            return;
        }
        if ("translucency" == string || "bgtranslucency" == string) {
            return;
        }
        if ("bgcolor" == string) {
            this.isActive = true;
            if (this.bsBgColixSet == null) {
                this.bsBgColixSet = new BS();
            }
            short s = C.getColixO(object);
            if (!this.setDefaults) {
                int n = bS.nextSetBit(0);
                while (n >= 0 && n < this.atomCount) {
                    this.setBgcolix(n, s);
                    n = bS.nextSetBit(n + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultBgcolix = s;
            }
            return;
        }
        if (this.bsFontSet == null) {
            this.bsFontSet = new BS();
        }
        if ("textLabels" == string) {
            this.setScaling();
            Map map = (Map)object;
            int n = bS.nextSetBit(0);
            while (n >= 0 && n < this.atomCount) {
                this.setTextLabel(n, (Text)map.get(n));
                n = bS.nextSetBit(n + 1);
            }
            return;
        }
        if ("fontsize" == string) {
            int n = (Integer)object;
            if (n < 0) {
                this.fids = null;
                return;
            }
            byte by = this.gdata.getFontFid(n);
            if (!this.setDefaults) {
                int n3 = bS.nextSetBit(0);
                while (n3 >= 0 && n3 < this.atomCount) {
                    this.setFont(n3, by);
                    n3 = bS.nextSetBit(n3 + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultFontId = by;
            }
            return;
        }
        if ("font" == string) {
            byte by = ((JmolFont)object).fid;
            if (!this.setDefaults) {
                int n = bS.nextSetBit(0);
                while (n >= 0 && n < this.atomCount) {
                    this.setFont(n, by);
                    n = bS.nextSetBit(n + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultFontId = by;
            }
            return;
        }
        if ("offset" == string || "offsetexact" == string) {
            boolean bl;
            if (!(object instanceof Integer)) {
                if (!this.setDefaults) {
                    int n = bS.nextSetBit(0);
                    while (n >= 0 && n < this.atomCount) {
                        this.setPymolOffset(n, (float[])object);
                        n = bS.nextSetBit(n + 1);
                    }
                }
                return;
            }
            int n = (Integer)object;
            boolean bl2 = bl = string == "offsetexact";
            if (n == 0) {
                n = Short.MAX_VALUE;
            } else if (n == zeroOffset) {
                n = 0;
            }
            if (!this.setDefaults) {
                int n4 = bS.nextSetBit(0);
                while (n4 >= 0 && n4 < this.atomCount) {
                    this.setOffsets(n4, n, bl);
                    n4 = bS.nextSetBit(n4 + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultOffset = n;
            }
            return;
        }
        if ("align" == string) {
            String string4 = (String)object;
            int n = 1;
            if (string4.equalsIgnoreCase("right")) {
                n = 3;
            } else if (string4.equalsIgnoreCase("center")) {
                n = 2;
            }
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0 && n5 < this.atomCount) {
                this.setAlignment(n5, n);
                n5 = bS.nextSetBit(n5 + 1);
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultAlignment = n;
            }
            return;
        }
        if ("pointer" == string) {
            int n = (Integer)object;
            if (!this.setDefaults) {
                int n6 = bS.nextSetBit(0);
                while (n6 >= 0 && n6 < this.atomCount) {
                    this.setPointer(n6, n);
                    n6 = bS.nextSetBit(n6 + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultPointer = n;
            }
            return;
        }
        if ("front" == string) {
            boolean bl = (Boolean)object;
            if (!this.setDefaults) {
                int n = bS.nextSetBit(0);
                while (n >= 0 && n < this.atomCount) {
                    this.setFront(n, bl);
                    n = bS.nextSetBit(n + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultZPos = bl ? 32 : 0;
            }
            return;
        }
        if ("group" == string) {
            boolean bl = (Boolean)object;
            if (!this.setDefaults) {
                int n = bS.nextSetBit(0);
                while (n >= 0 && n < this.atomCount) {
                    this.setGroup(n, bl);
                    n = bS.nextSetBit(n + 1);
                }
            }
            if (this.setDefaults || !this.defaultsOnlyForNone) {
                this.defaultZPos = bl ? 16 : 0;
            }
            return;
        }
        if ("display" == string || "toggleLabel" == string) {
            int n;
            int n7 = "toggleLabel" == string ? 0 : (n = (Boolean)object != false ? 1 : -1);
            if (this.mads == null) {
                this.mads = new short[this.atomCount];
            }
            String string5 = null;
            LabelToken[] labelTokenArray = null;
            String string6 = null;
            LabelToken[] labelTokenArray4 = null;
            int n8 = bS.nextSetBit(0);
            while (n8 >= 0 && n8 < this.atomCount) {
                Atom atom = this.atoms[n8];
                if (this.formats == null || n8 >= this.formats.length) {
                    this.formats = ArrayUtil.ensureLengthS(this.formats, n8 + 1);
                }
                if (this.strings != null && this.strings.length > n8 && this.strings[n8] != null) {
                    this.mads[n8] = (short)(n == 0 && this.mads[n8] < 0 || n == 1 ? 1 : -1);
                } else {
                    LabelToken[] labelTokenArray5;
                    String string7;
                    if (this.bsSizeSet == null) {
                        this.bsSizeSet = new BS();
                    }
                    this.strings = ArrayUtil.ensureLengthS(this.strings, n8 + 1);
                    if (atom.getGroup3(false).equals("UNK")) {
                        if (string6 == null) {
                            string6 = this.viewer.getStandardLabelFormat(1);
                            labelTokenArray4 = LabelToken.compile(this.viewer, string6, '\u0000', null);
                        }
                        string7 = string6;
                        labelTokenArray5 = labelTokenArray4;
                    } else {
                        if (string5 == null) {
                            string5 = this.viewer.getStandardLabelFormat(2);
                            labelTokenArray = LabelToken.compile(this.viewer, string5, '\u0000', null);
                        }
                        string7 = string5;
                        labelTokenArray5 = labelTokenArray;
                    }
                    this.strings[n8] = LabelToken.formatLabelAtomArray(this.viewer, atom, labelTokenArray5, '\u0000', null);
                    this.formats[n8] = string7;
                    this.bsSizeSet.set(n8);
                    if (!(this.bsBgColixSet != null && this.bsBgColixSet.get(n8) || this.defaultBgcolix == 0)) {
                        this.setBgcolix(n8, this.defaultBgcolix);
                    }
                    this.mads[n8] = (short)(n >= 0 ? 1 : -1);
                }
                atom.setShapeVisibility(this.myVisibilityFlag, this.strings != null && n8 < this.strings.length && this.strings[n8] != null && this.mads[n8] >= 0);
                n8 = bS.nextSetBit(n8 + 1);
            }
            return;
        }
        if (string.startsWith("label:")) {
            this.setScaling();
            this.setLabel(new LabelToken[1][], string.substring(6), (Integer)object);
            return;
        }
        if (string == "deleteModelAtoms") {
            this.labelBoxes = null;
            int n = ((int[])((Object[])object)[2])[1];
            int n9 = ((int[])((Object[])object)[2])[2];
            this.fids = (byte[])ArrayUtil.deleteElements(this.fids, n, n9);
            this.bgcolixes = (short[])ArrayUtil.deleteElements(this.bgcolixes, n, n9);
            this.offsets = (int[])ArrayUtil.deleteElements(this.offsets, n, n9);
            this.formats = (String[])ArrayUtil.deleteElements(this.formats, n, n9);
            this.strings = (String[])ArrayUtil.deleteElements(this.strings, n, n9);
            BSUtil.deleteBits(this.bsFontSet, bS);
            BSUtil.deleteBits(this.bsBgColixSet, bS);
        }
        this.setPropAS(string, object, bS);
    }

    private void setPymolOffset(int n, float[] fArray) {
        Text text = this.getLabel(n);
        if (text == null) {
            byte by;
            byte by2 = by = this.bsFontSet != null && this.bsFontSet.get(n) ? this.fids[n] : (byte)-1;
            if (by < 0) {
                by = this.defaultFontId;
                this.setFont(n, by);
            }
            JmolFont jmolFont = JmolFont.getFont3D(by);
            short s = this.getColix2(n, this.atoms[n], false);
            text = Text.newLabel(this.gdata, jmolFont, this.strings[n], s, this.getColix2(n, this.atoms[n], true), 0, this.scalePixelsPerMicron, fArray);
            this.setTextLabel(n, text);
        } else {
            text.pymolOffset = fArray;
        }
    }

    private void setScaling() {
        this.isActive = true;
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BS();
        }
        this.isScaled = this.viewer.getBoolean(603979845);
        this.scalePixelsPerMicron = this.isScaled ? this.viewer.getScalePixelsPerAngstrom(false) * 10000.0f : 0.0f;
    }

    private void setTextLabel(int n, Text text) {
        if (text == null) {
            return;
        }
        String string = text.getText();
        Atom atom = this.atoms[n];
        this.addString(atom, n, string, string);
        atom.setShapeVisibility(this.myVisibilityFlag, true);
        if (text.colix >= 0) {
            this.setLabelColix(n, text.colix, EnumPalette.UNKNOWN.id);
        }
        this.setFont(n, text.font.fid);
        this.putLabel(n, text);
    }

    private void setLabel(LabelToken[][] labelTokenArray, String string, int n) {
        Atom atom = this.atoms[n];
        LabelToken[] labelTokenArray2 = labelTokenArray[0];
        if (labelTokenArray2 == null) {
            labelTokenArray[0] = LabelToken.compile(this.viewer, string, '\u0000', null);
            labelTokenArray2 = labelTokenArray[0];
        }
        String string2 = labelTokenArray2 == null ? null : LabelToken.formatLabelAtomArray(this.viewer, atom, labelTokenArray2, '\u0000', null);
        this.addString(atom, n, string2, string);
        this.text = this.getLabel(n);
        if (this.isScaled) {
            this.text = Text.newLabel(this.gdata, null, string2, (short)0, (short)0, 0, this.scalePixelsPerMicron, null);
            this.putLabel(n, this.text);
        } else if (this.text != null && string2 != null) {
            this.text.setText(string2);
        }
        if (this.defaultOffset != zeroOffset) {
            this.setOffsets(n, this.defaultOffset, false);
        }
        if (this.defaultAlignment != 1) {
            this.setAlignment(n, this.defaultAlignment);
        }
        if ((this.defaultZPos & 0x20) != 0) {
            this.setFront(n, true);
        } else if ((this.defaultZPos & 0x10) != 0) {
            this.setGroup(n, true);
        }
        if (this.defaultPointer != 0) {
            this.setPointer(n, this.defaultPointer);
        }
        if (this.defaultColix != 0 || this.defaultPaletteID != 0) {
            this.setLabelColix(n, this.defaultColix, this.defaultPaletteID);
        }
        if (this.defaultBgcolix != 0) {
            this.setBgcolix(n, this.defaultBgcolix);
        }
        if (this.defaultFontId != this.zeroFontId) {
            this.setFont(n, this.defaultFontId);
        }
    }

    private void addString(Atom atom, int n, String string, String string2) {
        atom.setShapeVisibility(this.myVisibilityFlag, string != null);
        if (this.strings == null || n >= this.strings.length) {
            this.strings = ArrayUtil.ensureLengthS(this.strings, n + 1);
        }
        if (this.formats == null || n >= this.formats.length) {
            this.formats = ArrayUtil.ensureLengthS(this.formats, n + 1);
        }
        this.strings[n] = string;
        this.formats[n] = string2 != null && string2.indexOf("%{") >= 0 ? string : string2;
        this.bsSizeSet.setBitTo(n, string2 != null);
    }

    public Object getProperty(String string, int n) {
        if (string.equals("offsets")) {
            return this.offsets;
        }
        if (string.equals("label")) {
            return this.strings != null && n < this.strings.length && this.strings[n] != null ? this.strings[n] : "";
        }
        return null;
    }

    public void putLabel(int n, Text text) {
        if (text == null) {
            this.atomLabels.remove(n);
        } else {
            this.atomLabels.put(n, text);
        }
    }

    public Text getLabel(int n) {
        return this.atomLabels.get(n);
    }

    public void putBox(int n, float[] fArray) {
        if (this.labelBoxes == null) {
            this.labelBoxes = new Hashtable<Integer, float[]>();
        }
        this.labelBoxes.put(n, fArray);
    }

    public float[] getBox(int n) {
        if (this.labelBoxes == null) {
            return null;
        }
        return this.labelBoxes.get(n);
    }

    private void setLabelColix(int n, short s, byte by) {
        this.setColixAndPalette(s, by, n);
        if (this.colixes != null && (this.text = this.getLabel(n)) != null) {
            this.text.setColix(this.colixes[n]);
        }
    }

    private void setBgcolix(int n, short s) {
        if (this.bgcolixes == null || n >= this.bgcolixes.length) {
            if (s == 0) {
                return;
            }
            this.bgcolixes = ArrayUtil.ensureLengthShort(this.bgcolixes, n + 1);
        }
        this.bgcolixes[n] = s;
        this.bsBgColixSet.setBitTo(n, s != 0);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setBgColix(s);
        }
    }

    private void setOffsets(int n, int n2, boolean bl) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLengthI(this.offsets, n + 1);
        }
        this.offsets[n] = this.offsets[n] & 0xFF | n2 << 8;
        if (bl) {
            int n3 = n;
            this.offsets[n3] = this.offsets[n3] | 0x80;
        }
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setOffset(n2);
        }
    }

    private void setAlignment(int n, int n2) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 1) {
                return;
            }
            this.offsets = ArrayUtil.ensureLengthI(this.offsets, n + 1);
        }
        this.offsets[n] = this.offsets[n] & 0xFFFFFFF3 | n2 << 2;
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setAlignment(n2);
        }
    }

    public static int getAlignment(int n) {
        return (n & 0xC) >> 2;
    }

    private void setPointer(int n, int n2) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (n2 == 0) {
                return;
            }
            this.offsets = ArrayUtil.ensureLengthI(this.offsets, n + 1);
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFFC) + n2;
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setPointer(n2);
        }
    }

    private void setFront(int n, boolean bl) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (!bl) {
                return;
            }
            this.offsets = ArrayUtil.ensureLengthI(this.offsets, n + 1);
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFCF) + (bl ? 32 : 0);
    }

    private void setGroup(int n, boolean bl) {
        if (this.offsets == null || n >= this.offsets.length) {
            if (!bl) {
                return;
            }
            this.offsets = ArrayUtil.ensureLengthI(this.offsets, n + 1);
        }
        this.offsets[n] = (this.offsets[n] & 0xFFFFFFCF) + (bl ? 16 : 0);
    }

    private void setFont(int n, byte by) {
        if (this.fids == null || n >= this.fids.length) {
            if (by == this.zeroFontId) {
                return;
            }
            this.fids = ArrayUtil.ensureLengthByte(this.fids, n + 1);
        }
        this.fids[n] = by;
        this.bsFontSet.set(n);
        this.text = this.getLabel(n);
        if (this.text != null) {
            this.text.setFontFromFid(by);
        }
    }

    public void setModelClickability() {
        if (this.strings == null) {
            return;
        }
        int n = this.strings.length;
        while (--n >= 0) {
            String string = this.strings[n];
            if (string == null || this.modelSet.atoms.length <= n || this.modelSet.isAtomHidden(n)) continue;
            this.modelSet.atoms[n].setClickable(this.myVisibilityFlag);
        }
    }

    public String getShapeState() {
        if (!this.isActive || this.bsSizeSet == null) {
            return "";
        }
        return this.viewer.getShapeState(this);
    }

    public synchronized boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS) {
        if (this.viewer.getPickingMode() != 2 || this.labelBoxes == null) {
            return false;
        }
        if (n == Integer.MIN_VALUE) {
            int n6 = this.findNearestLabel(n3, n4);
            if (n6 >= 0) {
                this.pickedAtom = n6;
                this.pickedX = n3;
                this.pickedY = n4;
                this.pickedOffset = (this.offsets == null || this.pickedAtom >= this.offsets.length ? 0 : this.offsets[this.pickedAtom]) >> 8;
                return true;
            }
            return false;
        }
        if (n == Integer.MAX_VALUE) {
            this.pickedAtom = -1;
            return false;
        }
        if (this.pickedAtom < 0) {
            return false;
        }
        this.move2D(this.pickedAtom, n3, n4);
        return true;
    }

    private int findNearestLabel(int n, int n2) {
        if (this.labelBoxes == null) {
            return -1;
        }
        float f = Float.MAX_VALUE;
        int n3 = -1;
        float f2 = Float.MAX_VALUE;
        for (Map.Entry<Integer, float[]> entry : this.labelBoxes.entrySet()) {
            if (!this.atoms[entry.getKey()].isVisible(this.myVisibilityFlag)) continue;
            float[] fArray = entry.getValue();
            float f3 = (float)n - fArray[0];
            float f4 = (float)n2 - fArray[1];
            if (f3 <= 0.0f || f4 <= 0.0f || f3 >= fArray[2] || f4 >= fArray[3] || fArray[4] > f2) continue;
            f2 = fArray[4];
            float f5 = Math.min(Math.abs(f3 - fArray[2] / 2.0f), Math.abs(f4 - fArray[3] / 2.0f));
            if (!(f5 <= f)) continue;
            f = f5;
            n3 = entry.getKey();
        }
        return n3;
    }

    private void move2D(int n, int n2, int n3) {
        int n4 = Object2d.getXOffset(this.pickedOffset);
        int n5 = -Object2d.getYOffset(this.pickedOffset);
        int n6 = Object2d.getOffset(n4 += n2 - this.pickedX, n5 += this.pickedY - n3);
        if (n6 == 0) {
            n6 = Short.MAX_VALUE;
        } else if (n6 == zeroOffset) {
            n6 = 0;
        }
        this.setOffsets(n, n6, true);
    }

    public short getColix2(int n, Atom atom, boolean bl) {
        short s;
        if (bl) {
            s = this.bgcolixes == null || n >= this.bgcolixes.length ? (short)0 : this.bgcolixes[n];
        } else {
            s = this.colixes == null || n >= this.colixes.length ? (short)0 : this.colixes[n];
            if (C.isColixTranslucent(s = C.getColixInherited(s, atom.getColix()))) {
                s = C.getColixTranslucent3(s, false, 0.0f);
            }
        }
        return s;
    }
}

