/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.Text;
import org.jmol.util.JmolFont;
import org.jmol.viewer.Viewer;

class TextRenderer {
    TextRenderer() {
    }

    static void render(Text text, Viewer viewer, JmolRendererInterface jmolRendererInterface, float f, float f2, boolean bl, float[] fArray, float[] fArray2) {
        if (text == null || text.image == null && text.lines == null) {
            return;
        }
        boolean bl2 = jmolRendererInterface.setColix(text.colix);
        if (!(bl2 || text.image != null || text.bgcolix != 0 && jmolRendererInterface.setColix(text.bgcolix))) {
            return;
        }
        text.setPosition(viewer, jmolRendererInterface.getRenderWidth(), jmolRendererInterface.getRenderHeight(), f, f2, bl, fArray);
        if (text.image == null && text.bgcolix != 0) {
            if (bl2) {
                jmolRendererInterface.setColix(text.bgcolix);
            }
            TextRenderer.showBox(jmolRendererInterface, text.colix, (int)text.boxX, (int)text.boxY + text.boxYoff2 * 2, text.z + 2, text.zSlab, (int)text.boxWidth, (int)text.boxHeight, text.fontScale, text.isLabelOrHover);
            if (!bl2) {
                return;
            }
        }
        if (text.image == null) {
            for (int i = 0; i < text.lines.length; ++i) {
                text.setXYA(fArray2, i);
                jmolRendererInterface.drawString(text.lines[i], text.font, (int)fArray2[0], (int)fArray2[1], text.z, text.zSlab, text.bgcolix);
            }
        } else {
            jmolRendererInterface.drawImage(text.image, (int)text.boxX, (int)text.boxY, text.z, text.zSlab, text.bgcolix, (int)text.boxWidth, (int)text.boxHeight);
        }
        TextRenderer.drawPointer(text, jmolRendererInterface);
    }

    static void drawPointer(Text text, JmolRendererInterface jmolRendererInterface) {
        if ((text.pointer & 1) == 0 || !jmolRendererInterface.setColix((text.pointer & 2) != 0 && text.bgcolix != 0 ? text.bgcolix : text.colix)) {
            return;
        }
        float f = text.boxWidth;
        float f2 = text.boxHeight;
        float f3 = Float.NaN;
        float f4 = text.boxX + (text.boxX > (float)text.atomX + f ? 0.0f : (text.boxX + f < (float)text.atomX - f ? f : (f3 = f / 2.0f)));
        boolean bl = !Float.isNaN(f3);
        float f5 = text.boxY + (bl && text.boxY > (float)text.atomY ? 0.0f : (bl && text.boxY + f2 < (float)text.atomY ? f2 : f2 / 2.0f));
        jmolRendererInterface.drawLineXYZ(text.atomX, text.atomY, text.atomZ, (int)f4, (int)f5, text.zSlab);
    }

    static void renderSimpleLabel(JmolRendererInterface jmolRendererInterface, JmolFont jmolFont, String string, short s, short s2, float[] fArray, int n, int n2, int n3, int n4, float f, int n5, boolean bl, short s3, boolean bl2) {
        float f2 = jmolFont.stringWidth(string) + 8;
        float f3 = f + (float)n5 + 8.0f;
        int n6 = (int)fArray[0];
        int n7 = (int)fArray[1];
        Text.setBoxXY(f2, f3, n3, n4, fArray, bl2);
        float f4 = fArray[0];
        float f5 = fArray[1];
        if (s2 != 0 && jmolRendererInterface.setColix(s2)) {
            TextRenderer.showBox(jmolRendererInterface, s, (int)f4, (int)f5, n, n2, (int)f2, (int)f3, 1.0f, true);
        } else {
            jmolRendererInterface.setColix(s);
        }
        jmolRendererInterface.drawString(string, jmolFont, (int)(f4 + 4.0f), (int)(f5 + 4.0f + f), n - 1, n2, s2);
        if (bl) {
            jmolRendererInterface.setColix(s3);
            if (n3 > 0) {
                jmolRendererInterface.drawLineXYZ(n6, n7, n2, (int)f4, (int)(f5 + f3 / 2.0f), n2);
            } else if (n3 < 0) {
                jmolRendererInterface.drawLineXYZ(n6, n7, n2, (int)(f4 + f2), (int)(f5 + f3 / 2.0f), n2);
            }
        }
    }

    private static void showBox(JmolRendererInterface jmolRendererInterface, short s, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
        jmolRendererInterface.fillRect(n, n2, n3, n4, n5, n6);
        jmolRendererInterface.setColix(s);
        if (!bl) {
            return;
        }
        if (f >= 2.0f) {
            jmolRendererInterface.drawRect(n + 3, n2 + 3, n3 - 1, n4, n5 - 6, n6 - 6);
        } else {
            jmolRendererInterface.drawRect(n + 1, n2 + 1, n3 - 1, n4, n5 - 2, n6 - 2);
        }
    }
}

