/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.api.ApiPlatform;

class Platform3D {
    int windowWidth;
    int windowHeight;
    int windowSize;
    int bufferWidth;
    int bufferHeight;
    int bufferSize;
    int bufferSizeT;
    Object bufferedImage;
    int[] pBuffer;
    int[] pBufferT;
    int[] zBuffer;
    int[] zBufferT;
    int widthOffscreen;
    int heightOffscreen;
    Object offscreenImage;
    Object graphicsForTextOrImage;
    static final boolean desireClearingThread = false;
    boolean useClearingThread = false;
    private ClearingThread clearingThread;
    ApiPlatform apiPlatform;
    private static boolean backgroundTransparent = false;

    Platform3D(ApiPlatform apiPlatform) {
        this.initialize(false);
        this.apiPlatform = apiPlatform;
    }

    Object getGraphicsForMetrics() {
        return this.apiPlatform.getGraphics(this.allocateOffscreenImage(1, 1));
    }

    final void initialize(boolean bl) {
        this.useClearingThread = bl;
        if (bl) {
            this.clearingThread = new ClearingThread();
            this.clearingThread.start();
        }
    }

    void allocateTBuffers(boolean bl) {
        this.bufferSizeT = bl ? this.bufferSize : this.windowSize;
        this.zBufferT = new int[this.bufferSizeT];
        this.pBufferT = new int[this.bufferSizeT];
    }

    void allocateBuffers(int n, int n2, boolean bl, boolean bl2) {
        this.windowWidth = n;
        this.windowHeight = n2;
        this.windowSize = n * n2;
        if (bl) {
            n *= 2;
            n2 *= 2;
        }
        this.bufferWidth = n;
        this.bufferHeight = n2;
        this.bufferSize = this.bufferWidth * this.bufferHeight;
        this.zBuffer = new int[this.bufferSize];
        this.pBuffer = new int[this.bufferSize];
        this.bufferedImage = this.apiPlatform.allocateRgbImage(this.windowWidth, this.windowHeight, this.pBuffer, this.windowSize, backgroundTransparent, bl2);
    }

    void releaseBuffers() {
        this.bufferSize = -1;
        this.bufferHeight = -1;
        this.bufferWidth = -1;
        this.windowHeight = -1;
        this.windowWidth = -1;
        if (this.bufferedImage != null) {
            this.apiPlatform.flushImage(this.bufferedImage);
            this.bufferedImage = null;
        }
        this.pBuffer = null;
        this.zBuffer = null;
        this.pBufferT = null;
        this.zBufferT = null;
    }

    boolean hasContent() {
        int n = this.bufferSize;
        while (--n >= 0) {
            if (this.zBuffer[n] == Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    void clearScreenBuffer() {
        int n = this.bufferSize;
        while (--n >= 0) {
            this.zBuffer[n] = Integer.MAX_VALUE;
            this.pBuffer[n] = 0;
        }
    }

    void setBackgroundColor(int n) {
        if (this.pBuffer == null) {
            return;
        }
        int n2 = this.bufferSize;
        while (--n2 >= 0) {
            if (this.pBuffer[n2] != 0) continue;
            this.pBuffer[n2] = n;
        }
    }

    void clearTBuffer() {
        int n = this.bufferSizeT;
        while (--n >= 0) {
            this.zBufferT[n] = Integer.MAX_VALUE;
            this.pBufferT[n] = 0;
        }
    }

    final void clearBuffer() {
        if (this.useClearingThread) {
            this.clearingThread.clearClientBuffer();
        } else {
            this.clearScreenBuffer();
        }
    }

    final void clearScreenBufferThreaded() {
        if (this.useClearingThread) {
            this.clearingThread.releaseBufferForClearing();
        }
    }

    void notifyEndOfRendering() {
        this.apiPlatform.notifyEndOfRendering();
    }

    Object getGraphicsForTextOrImage(int n, int n2) {
        if (n > this.widthOffscreen || n2 > this.heightOffscreen) {
            if (this.offscreenImage != null) {
                this.apiPlatform.disposeGraphics(this.graphicsForTextOrImage);
                this.apiPlatform.flushImage(this.offscreenImage);
            }
            if (n > this.widthOffscreen) {
                this.widthOffscreen = n;
            }
            if (n2 > this.heightOffscreen) {
                this.heightOffscreen = n2;
            }
            this.offscreenImage = this.allocateOffscreenImage(this.widthOffscreen, this.heightOffscreen);
            this.graphicsForTextOrImage = this.apiPlatform.getStaticGraphics(this.offscreenImage, backgroundTransparent);
        }
        return this.graphicsForTextOrImage;
    }

    private Object allocateOffscreenImage(int n, int n2) {
        return this.apiPlatform.newOffScreenImage(n, n2);
    }

    void setBackgroundTransparent(boolean bl) {
        backgroundTransparent = bl;
    }

    class ClearingThread
    extends Thread {
        boolean bufferHasBeenCleared = false;
        boolean clientHasBuffer = false;

        ClearingThread() {
        }

        synchronized void notifyBackgroundChange(int n) {
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void clearClientBuffer() {
            while (!this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.clientHasBuffer = true;
        }

        synchronized void releaseBufferForClearing() {
            this.clientHasBuffer = false;
            this.bufferHasBeenCleared = false;
            this.notify();
        }

        synchronized void waitForClientRelease() {
            while (this.clientHasBuffer || this.bufferHasBeenCleared) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        synchronized void notifyBufferReady() {
            this.bufferHasBeenCleared = true;
            this.notify();
        }

        public void run() {
            while (true) {
                this.waitForClientRelease();
                Platform3D.this.clearScreenBuffer();
                this.notifyBufferReady();
            }
        }
    }
}

