/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jmol.api.JmolViewer;
import org.jmol.util.P3;
import org.jmol.util.TextFormat;

class Display {
    Display() {
    }

    static void getFullScreenDimensions(Object object, int[] nArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        nArray[0] = dimension.width;
        nArray[1] = dimension.height;
    }

    static boolean hasFocus(Object object) {
        return ((Component)object).hasFocus();
    }

    static void requestFocusInWindow(Object object) {
        ((Component)object).requestFocusInWindow();
    }

    static void repaint(Object object) {
        ((Component)object).repaint();
    }

    static void renderScreenImage(JmolViewer jmolViewer, Object object, Object object2) {
        jmolViewer.renderScreenImage(object, ((Dimension)object2).width, ((Dimension)object2).height);
    }

    static void setTransparentCursor(Object object) {
        int[] nArray = new int[1];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(1, 1, nArray, 0, 1));
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        ((Container)object).setCursor(cursor);
    }

    static void setCursor(int n, Object object) {
        Container container = (Container)object;
        switch (n) {
            case 1: {
                n = 12;
                break;
            }
            case 3: {
                n = 13;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            default: {
                container.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        container.setCursor(Cursor.getPredefinedCursor(n));
    }

    public static String prompt(String string, String string2, String[] stringArray, boolean bl) {
        try {
            if (!bl) {
                return JOptionPane.showInputDialog(string, (Object)string2);
            }
            if (string2 != null) {
                stringArray = TextFormat.splitChars(string2, "|");
            }
            int n = JOptionPane.showOptionDialog(null, string, "Jmol prompt", -1, 1, null, stringArray, stringArray[0]);
            return string2 == null ? "" + n : (n == -1 ? "null" : stringArray[n]);
        }
        catch (Throwable throwable) {
            return "null";
        }
    }

    public static void convertPointFromScreen(Object object, P3 p3) {
        Point point = new Point();
        point.x = (int)p3.x;
        point.y = (int)p3.y;
        SwingUtilities.convertPointFromScreen(point, (Component)object);
        p3.set(point.x, point.y, Float.NaN);
    }
}

