/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.P3;
import org.jmol.util.Tensor;
import org.jmol.util.V3;

public class Atom
extends P3
implements Cloneable {
    public int atomSetIndex;
    public int index;
    public BS bsSymmetry;
    public int atomSite;
    public String elementSymbol;
    public short elementNumber = (short)-1;
    public String atomName;
    public int formalCharge = Integer.MIN_VALUE;
    public float partialCharge = Float.NaN;
    public V3 vib;
    public float bfactor = Float.NaN;
    public float foccupancy = 1.0f;
    public float radius = Float.NaN;
    public boolean isHetero;
    public int atomSerial = Integer.MIN_VALUE;
    public int chainID;
    public char alternateLocationID = '\u0000';
    public String group3;
    public int sequenceNumber = Integer.MIN_VALUE;
    public char insertionCode = '\u0000';
    public float[] anisoBorU;
    public JmolList<Tensor> tensors;
    public boolean ignoreSymmetry;
    private static final int[] elementCharMasks = new int[]{1972292, -2147351151, -2146019271, -2130706430, 0x160000, -2147348464, 25, -2147205008, -2147344384, 0, -2147352576, 0x120101, 548936, -2147434213, -2147221504, -2145759221, 0, 1056947, -2147339946, -2147477097, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0x800010, -2147483646, 139264};

    public Tensor addTensor(Tensor tensor, String string, boolean bl) {
        if (tensor == null) {
            return null;
        }
        if (bl || this.tensors == null) {
            this.tensors = new JmolList();
        }
        this.tensors.addLast(tensor);
        if (string != null) {
            tensor.setType(string);
        }
        return tensor;
    }

    public Atom() {
        this.set(Float.NaN, Float.NaN, Float.NaN);
    }

    public Atom getClone() throws CloneNotSupportedException {
        Atom atom = (Atom)this.clone();
        if (this.vib != null) {
            atom.vib = V3.newV(atom.vib);
        }
        if (this.anisoBorU != null) {
            atom.anisoBorU = ArrayUtil.arrayCopyF(this.anisoBorU, -1);
        }
        if (this.tensors != null) {
            atom.tensors = new JmolList();
            int n = this.tensors.size();
            while (--n >= 0) {
                atom.tensors.addLast(Tensor.copyTensor((Tensor)this.tensors.get(n)));
            }
        }
        return atom;
    }

    public String getElementSymbol() {
        if (this.elementSymbol == null && this.atomName != null) {
            int n;
            int n2 = this.atomName.length();
            char c = '\u0000';
            for (n = 0; n < n2 && !Atom.isValidFirstSymbolChar(c = this.atomName.charAt(n)); ++n) {
            }
            switch (n2 - n) {
                case 0: {
                    break;
                }
                default: {
                    char c2 = this.atomName.charAt(n + 1);
                    if (Atom.isValidElementSymbolNoCaseSecondChar2(c, c2)) {
                        this.elementSymbol = "" + c + c2;
                        break;
                    }
                }
                case 1: {
                    if (!Atom.isValidElementSymbol(c)) break;
                    this.elementSymbol = "" + c;
                }
            }
        }
        return this.elementSymbol;
    }

    public static boolean isValidElementSymbol(char c) {
        return c >= 'A' && c <= 'Z' && elementCharMasks[c - 65] < 0;
    }

    public static boolean isValidElementSymbol2(char c, char c2) {
        if (c < 'A' || c > 'Z' || c2 < 'a' || c2 > 'z') {
            return false;
        }
        return (elementCharMasks[c - 65] >> c2 - 97 & 1) != 0;
    }

    public static boolean isValidElementSymbolNoCaseSecondChar2(char c, char c2) {
        if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 + 32);
        }
        if (c < 'A' || c > 'Z' || c2 < 'a' || c2 > 'z') {
            return false;
        }
        return (elementCharMasks[c - 65] >> c2 - 97 & 1) != 0;
    }

    public static boolean isValidFirstSymbolChar(char c) {
        return c >= 'A' && c <= 'Z' && elementCharMasks[c - 65] != 0;
    }

    public static boolean isValidElementSymbolNoCaseSecondChar(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (n == 1) {
            return Atom.isValidElementSymbol(c);
        }
        if (n > 2) {
            return false;
        }
        char c2 = string.charAt(1);
        return Atom.isValidElementSymbolNoCaseSecondChar2(c, c2);
    }

    public void scaleVector(float f) {
        if (this.vib == null || Float.isNaN(this.vib.z)) {
            return;
        }
        this.vib.scale(f);
    }
}

