/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.Serializable;
import org.jmol.util.V3;

public class Location
implements Serializable {
    private static final long serialVersionUID = -3472243250219991476L;
    private float _x;
    private float _y;
    static final Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();

    public Location() {
        this._x = 0.0f;
        this._y = 0.0f;
    }

    public Location(float f, float f2) {
        this._x = f;
        this._y = f2;
    }

    public float getX() {
        return this._x;
    }

    public float getY() {
        return this._y;
    }

    public String toString() {
        return "x = " + this._x + ", y = " + this._y + (this._x < 1.0f && this._x > 0.0f ? "(" + Location.pixelLocation(this).getX() + " " + Location.pixelLocation(this).getY() + ")" : "");
    }

    public float getDistance(Location location) {
        float f = this._x - location._x;
        float f2 = this._y - location._y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public V3 getVector(Location location) {
        return V3.new3((float)(location._x - this._x), (float)(location._y - this._y), (float)0.0f);
    }

    public static Location getCenter(Location location, Location location2) {
        return Location.getCentroid(location, location2, 0.5f);
    }

    public static Location getCentroid(Location location, Location location2, float f) {
        float f2 = 1.0f - f;
        return new Location(location._x * f2 + location2._x * f, location._y * f2 + location2._y * f);
    }

    public static Location pixelLocation(Location location) {
        return location == null ? null : new Location(location.getX() * (float)Location.screenDim.width, location.getY() * (float)Location.screenDim.height);
    }

    public static Location screenLocation(Location location) {
        return location == null ? null : new Location(location.getX() / (float)Location.screenDim.width, location.getY() / (float)Location.screenDim.height);
    }
}

