/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Map;
import org.jmol.adapter.readers.quantum.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.JmolList;

public class GamessUKReader
extends GamessReader {
    private JmolList<String> symmetries;
    private JmolList<Float> occupancies;

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("BASIS OPTIONS") >= 0) {
            this.readBasisInfo();
            return true;
        }
        if (this.line.indexOf("$CONTRL OPTIONS") >= 0) {
            this.readControlInfo();
            return true;
        }
        if (this.line.indexOf("contracted primitive functions") >= 0) {
            this.readGaussianBasis("======================================================", "======");
            return false;
        }
        if (this.line.indexOf("molecular geometry") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.atomNames = new JmolList();
            this.readAtomsInBohrCoordinates();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("FREQUENCY_INFO_WOULD_BE_HERE") >= 0) {
            return true;
        }
        if (this.line.indexOf("SYMMETRY ASSIGNMENT") >= 0) {
            this.readOrbitalSymmetryAndOccupancy();
            return false;
        }
        if (this.line.indexOf("- ALPHA SET -") >= 0) {
            this.alphaBeta = "alpha";
        } else if (this.line.indexOf("- BETA SET -") >= 0) {
            this.alphaBeta = "beta";
        } else if (this.line.indexOf("eigenvectors") >= 0) {
            this.readMolecularOrbitals(3);
            this.setOrbitalSymmetryAndOccupancy();
            return false;
        }
        return this.checkNboLine();
    }

    protected void readAtomsInBohrCoordinates() throws Exception {
        this.discardLinesUntilContains("*****");
        this.discardLinesUntilContains("atom");
        this.discardLinesUntilContains("*****");
        this.atomSetCollection.newAtomSet();
        while (this.readLine() != null && this.line.indexOf("*****") < 0) {
            if (this.line.charAt(14) == ' ') continue;
            String[] stringArray = this.getTokens();
            String string = stringArray[1];
            int n = (int)this.parseFloatStr(stringArray[2]);
            float f = this.parseFloatStr(stringArray[3]);
            float f2 = this.parseFloatStr(stringArray[4]);
            float f3 = this.parseFloatStr(stringArray[5]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string;
            this.setAtomCoordXYZ(atom, f * 0.5291772f, f2 * 0.5291772f, f3 * 0.5291772f);
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol((int)n);
            this.atomNames.addLast((Object)string);
        }
    }

    protected String fixShellTag(String string) {
        return string.substring(1).toUpperCase();
    }

    private void readOrbitalSymmetryAndOccupancy() throws Exception {
        this.readLines(4);
        this.symmetries = new JmolList();
        this.occupancies = new JmolList();
        while (this.readLine() != null && this.line.indexOf("====") < 0) {
            String[] stringArray = GamessUKReader.getTokensStr((String)this.line.substring(20));
            this.symmetries.addLast((Object)(stringArray[0] + " " + stringArray[1]));
            this.occupancies.addLast((Object)Float.valueOf(this.parseFloatStr(stringArray[5])));
        }
    }

    private void setOrbitalSymmetryAndOccupancy() {
        if (this.symmetries.size() < this.orbitals.size()) {
            return;
        }
        int n = this.orbitals.size();
        while (--n >= 0) {
            Map map = (Map)this.orbitals.get(n);
            map.put("symmetry", this.symmetries.get(n));
            map.put("occupancy", this.occupancies.get(n));
        }
    }
}

