/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import org.jmol.io.JmolBinary;
import org.jmol.jvxl.readers.PmeshReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

class MsmsReader
extends PmeshReader {
    private String fileName;

    MsmsReader() {
    }

    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2PFR(surfaceGenerator, bufferedReader);
        this.fileName = (String)((Object[])surfaceGenerator.getReaderData())[0];
        if (this.fileName == null) {
            return;
        }
        this.type = "msms";
        this.onePerLine = true;
        this.fixedCount = 3;
        this.vertexBase = 1;
        this.setHeader();
    }

    protected boolean readVertices() throws Exception {
        this.skipHeader();
        return this.readVerticesPM();
    }

    protected boolean readPolygons() throws Exception {
        this.br.close();
        this.fileName = TextFormat.simpleReplace((String)this.fileName, (String)".vert", (String)".face");
        Logger.info((String)("reading from file " + this.fileName));
        try {
            this.br = JmolBinary.getBufferedReader((BufferedInputStream)this.sg.getAtomDataServer().getBufferedInputStream(this.fileName), null);
        }
        catch (Exception exception) {
            Logger.info((String)("Note: file " + this.fileName + " was not found"));
            this.br = null;
            return true;
        }
        this.sg.addRequiredFile(this.fileName);
        this.skipHeader();
        return this.readPolygonsPM();
    }

    private void skipHeader() throws Exception {
        while (this.readLine() != null && this.line.indexOf("#") >= 0) {
        }
        this.tokens = this.getTokens();
        this.iToken = 0;
    }
}

