/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.SB;

public class OutputStringBuilder {
    public String type;
    SB sb;
    BufferedWriter bw;
    long nBytes;
    private BufferedOutputStream bos;
    private byte[] buf;

    public OutputStringBuilder(BufferedOutputStream bufferedOutputStream, boolean bl) {
        if (bufferedOutputStream != null) {
            if (bl) {
                this.bos = bufferedOutputStream;
            } else {
                this.bw = new BufferedWriter(new OutputStreamWriter(bufferedOutputStream), 8192);
            }
        } else if (bl) {
            this.buf = new byte[8092];
        } else {
            this.sb = new SB();
        }
    }

    public OutputStringBuilder append(String string) {
        try {
            if (this.bw != null) {
                this.bw.write(string);
            } else {
                if (this.bos != null) {
                    byte[] byArray = string.getBytes();
                    this.bos.write(byArray, 0, byArray.length);
                    return this;
                }
                this.sb.append(string);
            }
            this.nBytes += (long)string.length();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.bos == null) {
            if ((long)this.buf.length < this.nBytes + (long)n2) {
                this.buf = ArrayUtil.ensureLengthByte(this.buf, (int)this.nBytes * 2 + n2);
            }
            System.arraycopy(byArray, n, this.buf, (int)this.nBytes, n2);
        } else {
            this.bos.write(byArray, n, n2);
        }
        this.nBytes += (long)byArray.length;
    }

    public long length() {
        return this.nBytes;
    }

    public byte[] getBytes() {
        return this.buf != null ? this.buf : (byte[])(this.sb != null ? this.sb.toBytes(0, -1) : null);
    }

    public String toString() {
        if (this.bw != null) {
            try {
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.bw == null ? this.sb.toString() : this.nBytes + " bytes";
    }
}

