/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import org.jmol.applet.ClassPreloader;
import org.jmol.applet.WrappedApplet;
import org.jmol.applet.WrappedAppletLoader;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class AppletWrapper
extends Applet {
    public WrappedApplet wrappedApplet;
    private String wrappedAppletClassName;
    private String preloadImageName;
    private String preloadTextMessage;
    private String previousClassName;
    private int preloadThreadCount;
    private String[] preloadClassNames;
    private int preloadClassIndex;
    private boolean isSigned;
    private boolean needToCompleteInitialization;
    private boolean preloadImageReadyForDisplay;
    private boolean preloadImagePainted;
    private Color bgcolor;
    private Color textColor;
    private Image preloadImage;
    private MediaTracker mediaTracker;
    private long startTime;
    private int clockX;
    private int clockBaseline;
    private int clockWidth;
    private static int MINIMUM_ELAPSED_SECONDS = 1;
    private static String fontFace = "sansserif";
    private static int fontSizeDivisor = 18;
    private int fontSize;
    private Font font;
    private FontMetrics fontMetrics;
    private int fontAscent;
    private int fontHeight;
    private static final String[] colorNames = new String[]{"aqua", "black", "blue", "fuchsia", "gray", "green", "lime", "maroon", "navy", "olive", "purple", "red", "silver", "teal", "white", "yellow"};
    private static final Color[] colors = new Color[]{Color.cyan, Color.black, Color.blue, Color.magenta, Color.gray, new Color(0, 128, 0), Color.green, new Color(128, 0, 0), new Color(0, 0, 128), new Color(128, 128, 0), new Color(128, 0, 128), Color.red, Color.lightGray, new Color(0, 128, 128), Color.white, Color.yellow};

    public void destroy() {
        try {
            this.wrappedApplet.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wrappedApplet = null;
        super.destroy();
    }

    public AppletWrapper(String string, String string2, int n, String[] stringArray) {
        GT.ignoreApplicationBundle();
        this.wrappedAppletClassName = string;
        this.preloadImageName = string2;
        this.preloadTextMessage = GT._("Loading Jmol applet ...");
        this.preloadThreadCount = n;
        this.preloadClassNames = stringArray;
        this.needToCompleteInitialization = true;
        this.isSigned = false;
        try {
            String string3 = "" + this.getClass().getClassLoader().getResource(string2);
            this.isSigned = string3.indexOf("Signed") >= 0;
        }
        catch (Exception exception) {
            Logger.error("isSigned false: " + exception);
        }
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public String getAppletInfo() {
        return this.wrappedApplet != null ? this.wrappedApplet.getAppletInfo() : null;
    }

    public void init() {
        this.startTime = System.currentTimeMillis();
        new WrappedAppletLoader(this, this.wrappedAppletClassName).start();
        int n = this.preloadThreadCount;
        while (--n >= 0) {
            new ClassPreloader(this).start();
        }
    }

    public void update(Graphics graphics) {
        long l;
        int n;
        if (this.wrappedApplet != null) {
            this.mediaTracker = null;
            this.preloadImage = null;
            this.fontMetrics = null;
            this.wrappedApplet.update(graphics);
            return;
        }
        Dimension dimension = this.getSize();
        if (this.needToCompleteInitialization) {
            this.completeInitialization(graphics, dimension);
        }
        graphics.setColor(this.bgcolor);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(this.textColor);
        int n2 = 0;
        if (!this.preloadImageReadyForDisplay && this.mediaTracker != null) {
            this.preloadImageReadyForDisplay = this.mediaTracker.checkID(0, true);
        }
        if (this.preloadImageReadyForDisplay && (n = this.preloadImage.getHeight(null)) > 0 && 10 + n + this.fontHeight <= dimension.height) {
            graphics.drawImage(this.preloadImage, 10, 10, null);
            this.preloadImagePainted = true;
            n2 = 10 + n;
        }
        if ((l = (System.currentTimeMillis() - this.startTime) / 1000L) >= (long)MINIMUM_ELAPSED_SECONDS) {
            int n3 = n2 + this.fontAscent;
            if (n3 < dimension.height / 2) {
                n3 = dimension.height / 2;
            } else if (n3 >= dimension.height) {
                n3 = dimension.height - 1;
            }
            graphics.setFont(this.font);
            graphics.drawString(this.preloadTextMessage, 10, n3);
            String string = GT._("  {0} seconds", new Object[]{new Long(l)});
            this.clockWidth = this.fontMetrics.stringWidth(string);
            this.clockX = dimension.width - this.clockWidth - 5;
            if (this.clockX < 0) {
                this.clockX = 0;
            }
            this.clockBaseline = dimension.height - 5;
            if (Logger.debugging) {
                Logger.debug(string);
            }
            graphics.drawString(string, this.clockX, this.clockBaseline);
        }
    }

    public void paint(Graphics graphics) {
        if (this.wrappedApplet != null) {
            this.wrappedApplet.paint(graphics);
            return;
        }
        this.update(graphics);
    }

    public boolean handleEvent(Event event) {
        if (this.wrappedApplet != null) {
            return this.wrappedApplet.handleEvent(event);
        }
        return false;
    }

    public synchronized String getNextPreloadClassName() {
        String string;
        if (this.preloadClassNames == null || this.preloadClassIndex == this.preloadClassNames.length) {
            return null;
        }
        if ((string = this.preloadClassNames[this.preloadClassIndex++]).charAt(0) == '.') {
            int n = this.previousClassName.lastIndexOf(46);
            String string2 = this.previousClassName.substring(0, n);
            string = string2 + string;
        }
        this.previousClassName = string;
        return this.previousClassName;
    }

    protected void repaintClock() {
        if (!this.preloadImagePainted || this.clockBaseline == 0) {
            this.repaint();
        } else {
            this.repaint(this.clockX, this.clockBaseline - this.fontAscent, this.clockWidth, this.fontHeight);
        }
    }

    private boolean completeInitialization(Graphics graphics, Dimension dimension) {
        Object object;
        this.needToCompleteInitialization = false;
        try {
            if (Logger.debugging) {
                Logger.debug("loadImage:" + this.preloadImageName);
            }
            object = this.getClass().getClassLoader().getResource(this.preloadImageName);
            Logger.info("urlImage=" + object);
            if (object != null) {
                this.preloadImage = Toolkit.getDefaultToolkit().getImage((URL)object);
                if (Logger.debugging) {
                    Logger.debug("successfully loaded " + this.preloadImageName);
                    Logger.debug("preloadImage=" + this.preloadImage);
                }
                this.mediaTracker = new MediaTracker(this);
                this.mediaTracker.addImage(this.preloadImage, 0);
                this.mediaTracker.checkID(0, true);
            }
        }
        catch (Exception exception) {
            Logger.error("getImage failed: " + exception);
        }
        object = this.getParameter("boxbgcolor");
        if (object == null) {
            object = this.getParameter("bgcolor");
        }
        this.bgcolor = this.getColorFromName((String)object);
        this.textColor = this.getContrastingBlackOrWhite(this.bgcolor);
        this.fontSize = dimension.height / fontSizeDivisor;
        if (this.fontSize < 7) {
            this.fontSize = 7;
        }
        if (this.fontSize > 30) {
            this.fontSize = 30;
        }
        while (true) {
            this.font = new Font(fontFace, 0, this.fontSize);
            this.fontMetrics = graphics.getFontMetrics(this.font);
            if (this.fontMetrics.stringWidth(this.preloadTextMessage) + 10 < dimension.width || this.fontSize < 8) break;
            this.fontSize -= 2;
        }
        this.fontHeight = this.fontMetrics.getHeight();
        this.fontAscent = this.fontMetrics.getAscent();
        return this.isSigned;
    }

    private Color getColorFromName(String string) {
        if (string != null) {
            if (string.length() == 7 && string.charAt(0) == '#') {
                try {
                    int n = Parser.parseIntRadix(string.substring(1, 3), 16);
                    int n2 = Parser.parseIntRadix(string.substring(3, 5), 16);
                    int n3 = Parser.parseIntRadix(string.substring(5, 7), 16);
                    return new Color(n, n2, n3);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                string = string.toLowerCase().intern();
                int n = colorNames.length;
                while (--n >= 0) {
                    if (string != colorNames[n]) continue;
                    return colors[n];
                }
            }
        }
        return Color.black;
    }

    private Color getContrastingBlackOrWhite(Color color) {
        int n = color.getRGB();
        int n2 = ((2989 * (n >> 16) & 0xFF) + (5870 * (n >> 8) & 0xFF) + 1140 * (n & 0xFF) + 500) / 1000;
        return n2 < 128 ? Color.white : Color.black;
    }
}

