/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import org.jmol.util.P3i;

class HallTranslation {
    char translationCode = '\u0000';
    int rotationOrder;
    int rotationShift12ths;
    P3i vectorShift12ths;
    static final String[] latticeTranslationData = new String[]{"\u0000", "unknown", "", "P", "primitive", "", "I", "body-centered", " 1n", "R", "rhombohedral", " 1r 1r", "F", "face-centered", " 1ab 1bc 1ac", "A", "A-centered", " 1bc", "B", "B-centered", " 1ac", "C", "C-centered", " 1ab", "S", "rhombohedral(S)", " 1s 1s", "T", "rhombohedral(T)", " 1t 1t"};
    static final int nLatticeTypes = latticeTranslationData.length / 3 - 1;
    static final HallTranslation[] hallTranslationTerms = new HallTranslation[]{new HallTranslation('a', P3i.new3((int)6, (int)0, (int)0)), new HallTranslation('b', P3i.new3((int)0, (int)6, (int)0)), new HallTranslation('c', P3i.new3((int)0, (int)0, (int)6)), new HallTranslation('n', P3i.new3((int)6, (int)6, (int)6)), new HallTranslation('u', P3i.new3((int)3, (int)0, (int)0)), new HallTranslation('v', P3i.new3((int)0, (int)3, (int)0)), new HallTranslation('w', P3i.new3((int)0, (int)0, (int)3)), new HallTranslation('d', P3i.new3((int)3, (int)3, (int)3)), new HallTranslation('1', P3i.new3((int)2, (int)6, (int)-1)), new HallTranslation('1', P3i.new3((int)3, (int)4, (int)-1)), new HallTranslation('2', P3i.new3((int)3, (int)8, (int)-1)), new HallTranslation('1', P3i.new3((int)4, (int)3, (int)-1)), new HallTranslation('3', P3i.new3((int)4, (int)9, (int)-1)), new HallTranslation('1', P3i.new3((int)6, (int)2, (int)-1)), new HallTranslation('2', P3i.new3((int)6, (int)4, (int)-1)), new HallTranslation('4', P3i.new3((int)6, (int)8, (int)-1)), new HallTranslation('5', P3i.new3((int)6, (int)10, (int)-1)), new HallTranslation('r', P3i.new3((int)4, (int)8, (int)8)), new HallTranslation('s', P3i.new3((int)8, (int)8, (int)4)), new HallTranslation('t', P3i.new3((int)8, (int)4, (int)8))};

    HallTranslation(char c, P3i p3i) {
        this.translationCode = c;
        if (p3i != null) {
            if (p3i.y < 0) {
                int n = p3i.x;
                for (int i = 0; i < hallTranslationTerms.length; ++i) {
                    HallTranslation hallTranslation = hallTranslationTerms[i];
                    if (hallTranslation.translationCode != c || hallTranslation.rotationOrder != 0 && hallTranslation.rotationOrder != n) continue;
                    this.translationCode = c;
                    this.rotationShift12ths = hallTranslation.rotationShift12ths;
                    this.vectorShift12ths = hallTranslation.vectorShift12ths;
                    break;
                }
                return;
            }
            if (p3i.z >= 0) {
                this.vectorShift12ths = p3i;
                return;
            }
            this.rotationOrder = p3i.x;
            this.rotationShift12ths = p3i.y;
        }
        this.vectorShift12ths = new P3i();
    }

    static final String getHallLatticeEquivalent(int n) {
        char c = HallTranslation.getLatticeCode(n);
        boolean bl = n > 0;
        return (bl ? "-" : "") + c + " 1";
    }

    static final int getLatticeIndex(char c) {
        int n = 1;
        int n2 = 3;
        while (n <= nLatticeTypes) {
            if (latticeTranslationData[n2].charAt(0) == c) {
                return n;
            }
            ++n;
            n2 += 3;
        }
        return 0;
    }

    static final char getLatticeCode(int n) {
        if (n < 0) {
            n = -n;
        }
        return n == 0 ? (char)'\u0000' : (n > nLatticeTypes ? HallTranslation.getLatticeCode(HallTranslation.getLatticeIndex((char)n)) : latticeTranslationData[n * 3].charAt(0));
    }

    static final String getLatticeDesignation(int n) {
        String string;
        boolean bl = n > 0;
        String string2 = string = bl ? "-" : "";
        if (n < 0) {
            n = -n;
        }
        if (n == 0 || n > nLatticeTypes) {
            return "";
        }
        return string + HallTranslation.getLatticeCode(n) + ": " + (bl ? "centrosymmetric " : "") + latticeTranslationData[n * 3 + 1];
    }

    static final String getLatticeDesignation2(char c, boolean bl) {
        int n = HallTranslation.getLatticeIndex(c);
        if (!bl) {
            n = -n;
        }
        return HallTranslation.getLatticeDesignation(n);
    }

    static final String getLatticeExtension(char c, boolean bl) {
        int n = 1;
        int n2 = 3;
        while (n <= nLatticeTypes) {
            if (latticeTranslationData[n2].charAt(0) == c) {
                return latticeTranslationData[n2 + 2] + (bl ? " -1" : "");
            }
            ++n;
            n2 += 3;
        }
        return "";
    }
}

