/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.SB;

public class VaspPoscarReader
extends AtomSetCollectionReader {
    private JmolList<String> atomLabels = new JmolList();
    private int atomCount;

    protected void initializeReader() throws Exception {
        this.readJobTitle();
        this.readUnitCellVectors();
        this.readMolecularFormula();
        this.readCoordinates();
        this.continuing = false;
    }

    private void readJobTitle() throws Exception {
        this.atomSetCollection.setAtomSetName(this.readLine().trim());
    }

    private void readUnitCellVectors() throws Exception {
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(true);
        float f = this.parseFloatStr(this.readLine().trim());
        float[] fArray = new float[9];
        this.fillFloatArray(null, 0, fArray);
        if (f != 1.0f) {
            int n = 0;
            while (n < fArray.length) {
                int n2 = n++;
                fArray[n2] = fArray[n2] * f;
            }
        }
        this.addPrimitiveLatticeVector(0, fArray, 0);
        this.addPrimitiveLatticeVector(1, fArray, 3);
        this.addPrimitiveLatticeVector(2, fArray, 6);
    }

    private void readMolecularFormula() throws Exception {
        String[] stringArray = VaspPoscarReader.getTokensStr((String)this.discardLinesUntilNonBlank());
        String[] stringArray2 = VaspPoscarReader.getTokensStr((String)this.readLine());
        SB sB = new SB();
        for (int i = 0; i < stringArray2.length; ++i) {
            int n = Integer.parseInt(stringArray2[i]);
            this.atomCount += n;
            String string = stringArray[i];
            sB.append(" ").append(string).appendI(n);
            int n2 = n;
            while (--n2 >= 0) {
                this.atomLabels.addLast((Object)string);
            }
        }
        String string = sB.toString();
        Logger.info((String)("VaspPoscar reader: " + this.atomCount + " atoms identified for" + string));
        this.appendLoadNote(string);
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetName(string);
    }

    private void readCoordinates() throws Exception {
        if (this.discardLinesUntilNonBlank().toLowerCase().contains("selective")) {
            this.readLine();
        }
        if (this.line.toLowerCase().contains("cartesian")) {
            this.setFractionalCoordinates(false);
        }
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = this.atomSetCollection.addNewAtom();
            String[] stringArray = VaspPoscarReader.getTokensStr((String)this.readLine());
            atom.atomName = (String)this.atomLabels.get(i);
            float f = this.parseFloatStr(stringArray[0]);
            float f2 = this.parseFloatStr(stringArray[1]);
            float f3 = this.parseFloatStr(stringArray[2]);
            this.setAtomCoordXYZ(atom, f, f2, f3);
        }
    }
}

