/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Eigen;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

public class CastepReader
extends AtomSetCollectionReader {
    private static final float RAD_TO_DEG = 57.29578f;
    private String[] tokens;
    private boolean isPhonon;
    private boolean isOutput;
    private boolean isCell;
    private float a;
    private float b;
    private float c;
    private float alpha;
    private float beta;
    private float gamma;
    private V3[] abc = new V3[3];
    private int atomCount;
    private P3[] atomPts;
    private boolean havePhonons = false;
    private String lastQPt;
    private int qpt2;
    private V3 desiredQpt;
    private String desiredQ;
    private String chargeType = "MULL";
    private static final String[] lengthUnitIds = new String[]{"bohr", "m", "cm", "nm", "ang", "a0"};
    private static final float[] lengthUnitFactors = new float[]{0.5291772f, 1.0E10f, 1.0E8f, 10.0f, 1.0f, 0.5291772f};
    private static final double TWOPI = Math.PI * 2;

    public void initializeReader() throws Exception {
        if (this.filter != null) {
            if (this.checkFilterKey("CHARGE=")) {
                this.chargeType = this.filter.substring(this.filter.indexOf("CHARGE=") + 7);
                if (this.chargeType.length() > 4) {
                    this.chargeType = this.chargeType.substring(0, 4);
                }
            }
            this.filter = this.filter.replace('(', '{').replace(')', '}');
            this.filter = TextFormat.simpleReplace((String)this.filter, (String)"  ", (String)" ");
            if (this.filter.indexOf("{") >= 0) {
                this.setDesiredQpt(this.filter.substring(this.filter.indexOf("{")));
            }
            this.filter = TextFormat.simpleReplace((String)this.filter, (String)"-PT", (String)"");
        }
        this.continuing = this.readFileData();
    }

    private void setDesiredQpt(String string) {
        this.desiredQpt = new V3();
        this.desiredQ = "";
        float f = 1.0f;
        float f2 = 1.0f;
        int n = 0;
        int n2 = 0;
        boolean bl = string.indexOf(44) < 0;
        block10: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '{': {
                    n = i + 1;
                    f = 1.0f;
                    f2 = 1.0f;
                    continue block10;
                }
                case '/': {
                    f = this.parseFloatStr(string.substring(n, i));
                    n = i + 1;
                    f2 = 0.0f;
                    continue block10;
                }
                case ' ': 
                case ',': 
                case '}': {
                    if (c == '}') {
                        this.desiredQ = string.substring(0, i + 1);
                    } else if (c == ' ' != bl) continue block10;
                    if (f2 == 0.0f) {
                        f2 = this.parseFloatStr(string.substring(n, i));
                    } else {
                        f = this.parseFloatStr(string.substring(n, i));
                    }
                    f /= f2;
                    switch (n2++) {
                        case 0: {
                            this.desiredQpt.x = f;
                            break;
                        }
                        case 1: {
                            this.desiredQpt.y = f;
                            break;
                        }
                        case 2: {
                            this.desiredQpt.z = f;
                        }
                    }
                    f2 = 1.0f;
                    if (c == '}') {
                        i = string.length();
                    }
                    n = i + 1;
                }
            }
        }
        Logger.info((String)("Looking for q-pt=" + this.desiredQpt));
    }

    private boolean readFileData() throws Exception {
        while (this.tokenizeCastepCell() > 0) {
            if (this.tokens.length < 2 || !this.tokens[0].equalsIgnoreCase("%BLOCK")) continue;
            Logger.info((String)this.line);
            if (this.tokens[1].equalsIgnoreCase("LATTICE_ABC")) {
                this.readLatticeAbc();
                continue;
            }
            if (this.tokens[1].equalsIgnoreCase("LATTICE_CART")) {
                this.readLatticeCart();
                continue;
            }
            if (this.tokens[1].equalsIgnoreCase("POSITIONS_FRAC")) {
                this.setFractionalCoordinates(true);
                this.readPositionsFrac();
                continue;
            }
            if (!this.tokens[1].equalsIgnoreCase("POSITIONS_ABS")) continue;
            this.setFractionalCoordinates(false);
            this.readPositionsAbs();
        }
        if (this.isPhonon || this.isOutput) {
            if (this.isPhonon) {
                this.isTrajectory = this.desiredVibrationNumber <= 0;
                this.atomSetCollection.allowMultiple = false;
            }
            return true;
        }
        return false;
    }

    protected boolean checkLine() throws Exception {
        if (this.isOutput) {
            if (this.line.contains("Real Lattice(A)")) {
                this.readOutputUnitCell();
            } else if (this.line.contains("Fractional coordinates of atoms")) {
                if (this.doGetModel(++this.modelNumber, null)) {
                    this.readOutputAtoms();
                }
            } else if (this.doProcessLines && (this.line.contains("Atomic Populations (Mulliken)") || this.line.contains("Hirshfield Charge (e)"))) {
                this.readOutputCharges();
            } else if (this.doProcessLines && this.line.contains("Born Effective Charges")) {
                this.readOutputBornChargeTensors();
            } else if (this.line.contains("Final energy")) {
                this.readEnergy();
            }
            return true;
        }
        if (this.line.contains("<-- E")) {
            this.readPhononTrajectories();
            return true;
        }
        if (this.line.indexOf("Unit cell vectors") == 1) {
            this.readPhononUnitCell();
            return true;
        }
        if (this.line.indexOf("Fractional Co-ordinates") >= 0) {
            this.readPhononFractionalCoord();
            return true;
        }
        if (this.line.indexOf("q-pt") >= 0) {
            this.readPhononFrequencies();
            return true;
        }
        return true;
    }

    private void readOutputUnitCell() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.setFractionalCoordinates(true);
        this.abc = this.read3Vectors(false);
        this.setLatticeVectors();
    }

    private void readOutputAtoms() throws Exception {
        this.readLines(2);
        while (this.readLine().indexOf("xxx") < 0) {
            Atom atom = new Atom();
            this.tokens = this.getTokens();
            atom.elementSymbol = this.tokens[1];
            atom.atomName = this.tokens[1] + this.tokens[2];
            this.atomSetCollection.addAtomWithMappedName(atom);
            this.setAtomCoordXYZ(atom, this.parseFloatStr(this.tokens[3]), this.parseFloatStr(this.tokens[4]), this.parseFloatStr(this.tokens[5]));
        }
    }

    private void readEnergy() throws Exception {
        this.tokens = this.getTokens();
        Double d = Double.parseDouble(this.tokens[4]);
        this.atomSetCollection.setAtomSetName("Energy = " + d + " eV");
        this.atomSetCollection.setAtomSetEnergy("" + d, d.floatValue());
        this.atomSetCollection.setAtomSetAuxiliaryInfo("Energy", (Object)d);
        this.applySymmetryAndSetTrajectory();
        this.atomSetCollection.newAtomSet();
        this.setLatticeVectors();
    }

    private void readPhononTrajectories() throws Exception {
        this.isTrajectory = this.desiredVibrationNumber <= 0;
        this.doApplySymmetry = true;
        while (this.line != null && this.line.contains("<-- E")) {
            this.atomSetCollection.newAtomSet();
            this.discardLinesUntilContains("<-- h");
            this.setSpaceGroupName("P1");
            this.abc = this.read3Vectors(true);
            this.setLatticeVectors();
            this.setFractionalCoordinates(false);
            this.discardLinesUntilContains("<-- R");
            while (this.line != null && this.line.contains("<-- R")) {
                this.tokens = this.getTokens();
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.elementSymbol = this.tokens[0];
                this.setAtomCoordXYZ(atom, this.parseFloatStr(this.tokens[2]) * 0.5291772f, this.parseFloatStr(this.tokens[3]) * 0.5291772f, this.parseFloatStr(this.tokens[4]) * 0.5291772f);
                this.readLine();
            }
            this.applySymmetryAndSetTrajectory();
            this.discardLinesUntilContains("<-- E");
        }
    }

    protected void finalizeReader() throws Exception {
        if (this.isPhonon || this.isOutput) {
            this.isTrajectory = false;
            super.finalizeReader();
            return;
        }
        this.doApplySymmetry = true;
        this.setLatticeVectors();
        int n = this.atomSetCollection.getAtomCount();
        for (int i = 0; i < n; ++i) {
            this.setAtomCoord(this.atomSetCollection.getAtom(i));
        }
        super.finalizeReader();
    }

    private void setLatticeVectors() {
        if (this.abc[0] == null) {
            this.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
            return;
        }
        float[] fArray = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray[0] = this.abc[i].x;
            fArray[1] = this.abc[i].y;
            fArray[2] = this.abc[i].z;
            this.addPrimitiveLatticeVector(i, fArray, 0);
        }
    }

    private void readLatticeAbc() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit(this.tokens[0]);
        if (this.tokens.length < 3) {
            Logger.warn((String)"error reading a,b,c in %BLOCK LATTICE_ABC in CASTEP .cell file");
            return;
        }
        this.a = this.parseFloatStr(this.tokens[0]) * f;
        this.b = this.parseFloatStr(this.tokens[1]) * f;
        this.c = this.parseFloatStr(this.tokens[2]) * f;
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        if (this.tokens.length >= 3) {
            this.alpha = this.parseFloatStr(this.tokens[0]);
            this.beta = this.parseFloatStr(this.tokens[1]);
            this.gamma = this.parseFloatStr(this.tokens[2]);
        } else {
            Logger.warn((String)"error reading alpha,beta,gamma in %BLOCK LATTICE_ABC in CASTEP .cell file");
        }
    }

    private void readLatticeCart() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit(this.tokens[0]);
        for (int i = 0; i < 3; ++i) {
            if (this.tokens.length < 3) {
                Logger.warn((String)("error reading coordinates of lattice vector " + Integer.toString(i + 1) + " in %BLOCK LATTICE_CART in CASTEP .cell file"));
                return;
            }
            float f2 = this.parseFloatStr(this.tokens[0]) * f;
            float f3 = this.parseFloatStr(this.tokens[1]) * f;
            float f4 = this.parseFloatStr(this.tokens[2]) * f;
            this.abc[i] = V3.new3((float)f2, (float)f3, (float)f4);
            if (this.tokenizeCastepCell() != 0) continue;
            return;
        }
        this.a = this.abc[0].length();
        this.b = this.abc[1].length();
        this.c = this.abc[2].length();
        this.alpha = this.abc[1].angle(this.abc[2]) * 57.29578f;
        this.beta = this.abc[2].angle(this.abc[0]) * 57.29578f;
        this.gamma = this.abc[0].angle(this.abc[1]) * 57.29578f;
    }

    private void readPositionsFrac() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        this.readAtomData(1.0f);
    }

    private void readPositionsAbs() throws Exception {
        if (this.tokenizeCastepCell() == 0) {
            return;
        }
        float f = this.readLengthUnit(this.tokens[0]);
        this.readAtomData(f);
    }

    private float readLengthUnit(String string) throws Exception {
        float f = 1.0f;
        for (int i = 0; i < lengthUnitIds.length; ++i) {
            if (!string.equalsIgnoreCase(lengthUnitIds[i])) continue;
            f = lengthUnitFactors[i];
            this.tokenizeCastepCell();
            break;
        }
        return f;
    }

    private void readAtomData(float f) throws Exception {
        do {
            if (this.tokens.length >= 4) {
                Atom atom = this.atomSetCollection.addNewAtom();
                int n = this.tokens[0].indexOf(":");
                if (n >= 0) {
                    atom.elementSymbol = this.tokens[0].substring(0, n);
                    atom.atomName = this.tokens[0];
                } else {
                    atom.elementSymbol = this.tokens[0];
                }
                atom.set(this.parseFloatStr(this.tokens[1]), this.parseFloatStr(this.tokens[2]), this.parseFloatStr(this.tokens[3]));
                atom.scale(f);
                continue;
            }
            Logger.warn((String)("cannot read line with CASTEP atom data: " + this.line));
        } while (this.tokenizeCastepCell() > 0 && !this.tokens[0].equalsIgnoreCase("%ENDBLOCK"));
    }

    private int tokenizeCastepCell() throws Exception {
        int n;
        while (this.readLine() != null) {
            this.line = this.line.trim();
            if (this.line.length() == 0 || this.line.startsWith("#") || this.line.startsWith("!")) continue;
            if (this.isCell) break;
            if (this.line.startsWith("%")) {
                this.isCell = true;
                break;
            }
            if (this.line.startsWith("BEGIN header")) {
                this.isPhonon = true;
                Logger.info((String)"reading CASTEP .phonon file");
                return -1;
            }
            if (!this.line.contains("CASTEP")) break;
            this.isOutput = true;
            Logger.info((String)"reading CASTEP .castep file");
            return -1;
        }
        if (this.line == null) {
            n = 0;
        } else {
            this.tokens = this.getTokens();
            n = this.tokens.length;
        }
        return n;
    }

    private void readOutputBornChargeTensors() throws Exception {
        if (this.readLine().indexOf("--------") < 0) {
            return;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        while (this.readLine().indexOf(61) < 0) {
            this.getOutputEllipsoid(atomArray[this.readOutputAtomIndex()], this.line.substring(12));
        }
    }

    private int readOutputAtomIndex() {
        this.tokens = CastepReader.getTokensStr((String)this.line);
        return this.atomSetCollection.getAtomIndexFromName(this.tokens[0] + this.tokens[1]);
    }

    private void getOutputEllipsoid(Atom atom, String string) throws Exception {
        float[] fArray = new float[9];
        double[][] dArray = new double[3][3];
        this.fillFloatArray(string, 0, fArray);
        Logger.info((String)("tensor " + atom.atomName + "\t" + Escape.eAF((float[])fArray)));
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = fArray[n++];
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (dArray[0][1] != dArray[1][0]) {
            d3 = (dArray[0][1] - dArray[1][0]) / 2.0;
            double d4 = (dArray[0][1] + dArray[1][0]) / 2.0;
            dArray[1][0] = d4;
            dArray[0][1] = d4;
        }
        if (dArray[1][2] != dArray[2][1]) {
            d = (dArray[1][2] - dArray[2][1]) / 2.0;
            double d5 = (dArray[1][2] + dArray[2][1]) / 2.0;
            dArray[2][1] = d5;
            dArray[1][2] = d5;
        }
        if (dArray[0][2] != dArray[2][0]) {
            d2 = -(dArray[0][2] - dArray[2][0]) / 2.0;
            double d6 = (dArray[0][2] + dArray[2][0]) / 2.0;
            dArray[2][0] = d6;
            dArray[0][2] = d6;
        }
        atom.setEllipsoid(Eigen.getEllipsoidDD((double[][])dArray));
        this.atomSetCollection.addVibrationVector(atom.atomIndex, (float)d, (float)d2, (float)d3);
    }

    private void readOutputCharges() throws Exception {
        int n;
        String[] stringArray;
        if (this.line.toUpperCase().indexOf(this.chargeType) < 0) {
            return;
        }
        Logger.info((String)("reading charges: " + this.line));
        this.readLines(2);
        boolean bl = this.line.indexOf("Spin") >= 0;
        this.readLine();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        String[] stringArray2 = stringArray = bl ? new String[atomArray.length] : null;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = "0";
            }
        }
        while (this.readLine() != null && this.line.indexOf(61) < 0) {
            float f;
            n = this.readOutputAtomIndex();
            atomArray[n].partialCharge = f = this.parseFloatStr(this.tokens[bl ? this.tokens.length - 2 : this.tokens.length - 1]);
            if (!bl) continue;
            stringArray[n] = this.tokens[this.tokens.length - 1];
        }
        if (bl) {
            String string = TextFormat.join((String[])stringArray, (char)'\n', (int)0);
            this.atomSetCollection.setAtomSetAtomProperty("spin", string, -1);
        }
    }

    private void readPhononUnitCell() throws Exception {
        this.abc = this.read3Vectors(this.line.indexOf("bohr") >= 0);
        this.setSpaceGroupName("P1");
        this.setLatticeVectors();
    }

    private void readPhononFractionalCoord() throws Exception {
        Atom[] atomArray;
        this.setFractionalCoordinates(true);
        while (this.readLine() != null && this.line.indexOf("END") < 0) {
            this.tokens = this.getTokens();
            atomArray = this.atomSetCollection.addNewAtom();
            this.setAtomCoordXYZ((Atom)atomArray, this.parseFloatStr(this.tokens[1]), this.parseFloatStr(this.tokens[2]), this.parseFloatStr(this.tokens[3]));
            atomArray.elementSymbol = this.tokens[4];
            atomArray.bfactor = this.parseFloatStr(this.tokens[5]);
        }
        this.atomCount = this.atomSetCollection.getAtomCount();
        this.atomPts = new P3[this.atomCount];
        atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomPts[i] = P3.newP((Tuple3f)atomArray[i]);
        }
    }

    private void readPhononFrequencies() throws Exception {
        this.tokens = this.getTokens();
        V3 v3 = new V3();
        V3 v32 = V3.new3((float)this.parseFloatStr(this.tokens[2]), (float)this.parseFloatStr(this.tokens[3]), (float)this.parseFloatStr(this.tokens[4]));
        String string = this.getFractionalCoord(v32);
        String string2 = "{" + this.tokens[2] + " " + this.tokens[3] + " " + this.tokens[4] + "}";
        string = string == null ? string2 : "{" + string + "}";
        boolean bl = false;
        boolean bl2 = this.tokens[1].equals(this.lastQPt);
        this.qpt2 = bl2 ? this.qpt2 + 1 : 1;
        this.lastQPt = this.tokens[1];
        if (this.filter != null && this.checkFilterKey("Q=")) {
            if (this.desiredQpt != null) {
                v3.sub2((Tuple3f)this.desiredQpt, (Tuple3f)v32);
                if (v3.length() < 0.001f) {
                    string = this.desiredQ;
                }
            }
            boolean bl3 = bl = this.checkFilterKey("Q=" + string + "." + this.qpt2 + ";") || this.checkFilterKey("Q=" + this.lastQPt + "." + this.qpt2 + ";") || !bl2 && this.checkFilterKey("Q=" + string + ";") || !bl2 && this.checkFilterKey("Q=" + this.lastQPt + ";");
            if (!bl) {
                return;
            }
        }
        boolean bl4 = v32.length() == 0.0f;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        if (this.ptSupercell != null && !bl && !bl2) {
            this.atomSetCollection.setSupercellFromPoint(this.ptSupercell);
            f = this.ptSupercell.x;
            f2 = this.ptSupercell.y;
            f3 = this.ptSupercell.z;
            float f4 = (v32.x == 0.0f ? 1.0f : v32.x) * f;
            float f5 = (v32.y == 0.0f ? 1.0f : v32.y) * f2;
            float f6 = (v32.z == 0.0f ? 1.0f : v32.z) * f3;
            if (!(CastepReader.isInt(f4) && CastepReader.isInt(f5) && CastepReader.isInt(f6))) {
                return;
            }
            bl = true;
        }
        if (this.ptSupercell == null || !this.havePhonons) {
            this.appendLoadNote(this.line);
        }
        if (!bl && bl2) {
            return;
        }
        if (!bl && this.ptSupercell == null == !bl4) {
            return;
        }
        if (this.havePhonons) {
            return;
        }
        this.havePhonons = true;
        String string3 = "q=" + this.lastQPt + " " + string;
        this.applySymmetryAndSetTrajectory();
        if (bl4) {
            v32 = null;
        }
        JmolList jmolList = new JmolList();
        while (this.readLine() != null && this.line.indexOf("Phonon") < 0) {
            this.tokens = this.getTokens();
            jmolList.addLast((Object)Float.valueOf(this.parseFloatStr(this.tokens[1])));
        }
        this.readLine();
        int n = jmolList.size();
        float[] fArray = new float[8];
        V3 v33 = new V3();
        this.atomSetCollection.setCollectionName(string3);
        for (int i = 0; i < n; ++i) {
            int n2;
            if (!this.doGetVibration(++this.vibrationNumber)) {
                for (n2 = 0; n2 < this.atomCount; ++n2) {
                    this.readLine();
                }
                continue;
            }
            if (this.desiredVibrationNumber <= 0 && !this.isTrajectory) {
                this.cloneLastAtomSet(this.atomCount, this.atomPts);
                this.applySymmetryAndSetTrajectory();
            }
            this.symmetry = this.atomSetCollection.getSymmetry();
            n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
            float f7 = ((Float)jmolList.get(i)).floatValue();
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            int n3 = this.atomSetCollection.getAtomCount();
            for (int j = 0; j < this.atomCount; ++j) {
                this.fillFloatArray(null, 0, fArray);
                for (int k = n2++; k < n3; ++k) {
                    if (atomArray[k].atomSite != j) continue;
                    v33.sub2((Tuple3f)atomArray[k], (Tuple3f)atomArray[atomArray[k].atomSite]);
                    v33.x *= f;
                    v33.y *= f2;
                    v33.z *= f3;
                    this.setPhononVector(fArray, atomArray[k], v33, v32, v3);
                    this.atomSetCollection.addVibrationVectorWithSymmetry(k, v3.x, v3.y, v3.z, true);
                }
            }
            if (this.isTrajectory) {
                this.atomSetCollection.setTrajectory();
            }
            this.atomSetCollection.setAtomSetFrequency(null, null, "" + f7, null);
            this.atomSetCollection.setAtomSetName(TextFormat.formatDecimal((float)f7, (int)2) + " cm-1 " + string3);
        }
    }

    private String getFractionalCoord(V3 v3) {
        return CastepReader.isInt(v3.x * 12.0f) && CastepReader.isInt(v3.y * 12.0f) && CastepReader.isInt(v3.z * 12.0f) ? this.getSymmetry().fcoord((Tuple3f)v3) : null;
    }

    private static boolean isInt(float f) {
        return Math.abs(f - (float)Math.round(f)) < 0.001f;
    }

    private void setPhononVector(float[] fArray, Atom atom, V3 v3, V3 v32, V3 v33) {
        if (v32 == null) {
            v33.set(fArray[2], fArray[4], fArray[6]);
        } else {
            double d = v32.dot(v3);
            double d2 = Math.cos(Math.PI * 2 * d);
            double d3 = Math.sin(Math.PI * 2 * d);
            v33.x = (float)(d2 * (double)fArray[2] - d3 * (double)fArray[3]);
            v33.y = (float)(d2 * (double)fArray[4] - d3 * (double)fArray[5]);
            v33.z = (float)(d2 * (double)fArray[6] - d3 * (double)fArray[7]);
        }
        v33.scale((float)Math.sqrt(1.0f / atom.bfactor));
    }
}

