/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jmol.adapter.readers.cifpdb.PdbReader;
import org.jmol.adapter.readers.pymol.ModelSettings;
import org.jmol.adapter.readers.pymol.PickleReader;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLAtom;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolDocument;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Text;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.C;
import org.jmol.util.ColorUtil;
import org.jmol.util.Dimension;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolFont;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.Point3fi;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyMOLReader
extends PdbReader {
    private static final int BRANCH_SELECTION = -1;
    private static final int BRANCH_MOLECULE = 1;
    private static final int BRANCH_MAPDATA = 2;
    private static final int BRANCH_MAPMESH = 3;
    private static final int BRANCH_MEASURE = 4;
    private static final int BRANCH_CALLBACK = 5;
    private static final int BRANCH_CGO = 6;
    private static final int BRANCH_SURFACE = 7;
    private static final int BRANCH_GADGET = 8;
    private static final int BRANCH_CALCULATOR = 9;
    private static final int BRANCH_SLICE = 10;
    private static final int BRANCH_ALIGNMENT = 11;
    private static final int BRANCH_GROUP = 12;
    private static final int MIN_RESNO = -1000;
    private static String nucleic = " A C G T U ADE THY CYT GUA URI DA DC DG DT DU ";
    private boolean usePymolRadii = true;
    private boolean allowSurface = true;
    private boolean doResize = false;
    private JmolList<Object> settings;
    private Map<Integer, JmolList<Object>> localSettings;
    private int atomCount0;
    private int atomCount;
    private int strucNo;
    private boolean isHidden;
    private JmolList<Object> pymolAtoms;
    private BS bsBondedPyMOL = new BS();
    private BS bsBondedJmol = new BS();
    private BS bsHidden = new BS();
    private BS bsNucleic = new BS();
    private BS bsNoSurface = new BS();
    private BS bsStructureDefined = new BS();
    private boolean haveTraceOrBackbone;
    private boolean haveNucleicLadder;
    private int[] atomMap;
    private Map<Float, BS> htSpacefill = new Hashtable<Float, BS>();
    private Map<String, int[]> htAtomMap = new Hashtable<String, int[]>();
    private Map<String, BS> ssMapSeq = new Hashtable<String, BS>();
    private Map<String, BS> ssMapAtom = new Hashtable<String, BS>();
    private JmolList<Integer> atomColorList = new JmolList();
    private JmolList<Text> labels = new JmolList();
    private JmolList<ModelSettings> modelSettings = new JmolList();
    private short[] colixes;
    private boolean isStateScript;
    private int width;
    private int height;
    private boolean valence;
    private P3 xyzMin = P3.new3((float)1000000.0f, (float)1000000.0f, (float)1000000.0f);
    private P3 xyzMax = P3.new3((float)-1000000.0f, (float)-1000000.0f, (float)-1000000.0f);
    private int nModels;
    private boolean logging;
    private BS[] reps = new BS[16];
    private float cartoonTranslucency;
    private float sphereTranslucency;
    private float stickTranslucency;
    private boolean cartoonLadderMode;
    private boolean cartoonRockets;
    private boolean solventAsSpheres;
    private int surfaceMode;
    private int surfaceColor;
    private int labelFontId;
    private Map<String, Object> movie;
    private boolean isMovie;
    private Map<String, Object> pymol = new Hashtable<String, Object>();
    private JmolList<BS> lstStates = new JmolList();
    private Map<String, Object> htNames = new Hashtable<String, Object>();
    private JmolList<P3[]> lstTrajectories = new JmolList();
    private int currentFrame = -1;
    private int pymolFrame;
    private boolean allStates;
    private int totalAtomCount;
    private int pymolVersion;
    private String branchName;
    private BS bsModelAtoms = BS.newN((int)1000);
    private int branchID;
    private float nonBondedSize;
    private float sphereScale;
    private JmolList<JmolList<Object>> selections;
    private Hashtable<Integer, JmolList<Object>> uniqueSettings;
    private P3 labelPosition;
    private float labelColor;
    private float labelSize;
    private P3 labelPosition0 = new P3();
    private Hashtable<String, JmolList<Object>> volumeData;
    private JmolList<JmolList<Object>> mapObjects;
    private String branchNameID;
    private Map<String, String> branchIDs = new Hashtable<String, String>();
    private static final int REP_JMOL_MIN = 13;
    private static final int REP_JMOL_TRACE = 13;
    private static final int REP_JMOL_PUTTY = 14;
    private static final int REP_JMOL_STARS = 15;
    private static final int REP_JMOL_MAX = 16;

    protected void initializeReader() throws Exception {
        this.isBinary = true;
        this.isStateScript = this.htParams.containsKey("isStateScript");
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("noAutoBond", (Object)Boolean.TRUE);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbNoHydrogens", (Object)Boolean.TRUE);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPyMOL", (Object)Boolean.TRUE);
        super.initializeReader();
    }

    public void processBinaryDocument(JmolDocument jmolDocument) throws Exception {
        this.doResize = this.checkFilterKey("DORESIZE");
        this.allowSurface = !this.checkFilterKey("NOSURFACE");
        PickleReader pickleReader = new PickleReader(jmolDocument, this.viewer);
        this.logging = false;
        Map<String, Object> map = pickleReader.getMap(this.logging);
        pickleReader = null;
        this.process(map);
    }

    /*
     * WARNING - void declaration
     */
    private void process(Map<String, Object> map) {
        void var5_17;
        int n;
        String string;
        this.pymolVersion = (Integer)map.get("version");
        this.appendLoadNote("PyMOL version: " + this.pymolVersion);
        this.settings = PyMOLReader.getMapList(map, "settings");
        JmolList<Object> jmolList = PyMOLReader.listAt(this.settings, 440);
        if (jmolList != null) {
            Logger.info((String)("PyMOL session file: " + jmolList.get(2)));
        }
        this.setVersionSettings();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("settings", this.settings);
        this.setUniqueSettings(PyMOLReader.getMapList(map, "unique_settings"));
        this.logging = this.viewer.getLogFile().length() > 0;
        JmolList<Object> jmolList2 = PyMOLReader.getMapList(map, "names");
        for (Map.Entry<String, Object> object : map.entrySet()) {
            string = object.getKey();
            Logger.info((String)string);
            if (!string.equals("names")) continue;
            for (int i = 1; i < jmolList2.size(); ++i) {
                Logger.info((String)("  " + PyMOLReader.stringAt(PyMOLReader.listAt(jmolList2, i), 0)));
            }
        }
        if (this.logging) {
            if (this.logging) {
                this.viewer.log("$CLEAR$");
            }
            for (Map.Entry<String, Object> exception : map.entrySet()) {
                string = exception.getKey();
                if ("names".equals(string)) continue;
                this.viewer.log("\n===" + string + "===");
                this.viewer.log(TextFormat.simpleReplace((String)exception.getValue().toString(), (String)"[", (String)"\n["));
            }
            this.viewer.log("\n===names===");
            for (int i = 1; i < jmolList2.size(); ++i) {
                this.viewer.log("");
                JmolList i2 = (JmolList)jmolList2.get(i);
                this.viewer.log(" =" + i2.get(0).toString() + "=");
                try {
                    this.viewer.log(TextFormat.simpleReplace((String)i2.toString(), (String)"[", (String)"\n["));
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
        this.addColors(PyMOLReader.getMapList(map, "colors"));
        this.allStates = this.getBooleanSetting(49);
        this.pymolFrame = (int)this.getFloatSetting(194);
        Iterator<Map.Entry<String, Object>> iterator = PyMOLReader.getMapList(map, "movie");
        if (iterator != null && !this.allStates && (n = PyMOLReader.intAt(iterator, 0)) > 0) {
            this.currentFrame = (int)this.getFloatSetting(194);
            this.isMovie = true;
            this.movie = new Hashtable<String, Object>();
            this.movie.put("states", this.lstStates);
            this.movie.put("frameCount", n);
            this.movie.put("frames", PyMOLReader.listAt(iterator, 4));
            this.movie.put("currentFrame", this.currentFrame);
            this.pymol.put("movie", this.movie);
            this.appendLoadNote("PyMOL movie frameCount = " + n);
        }
        if (!this.isStateScript && this.doResize) {
            void var5_15;
            try {
                this.width = PyMOLReader.intAt(PyMOLReader.getMapList(map, "main"), 0);
                this.height = PyMOLReader.intAt(PyMOLReader.getMapList(map, "main"), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.width > 0 && this.height > 0) {
                String string2 = "PyMOL dimensions width=" + this.width + " height=" + this.height;
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("perferredWidthHeight", (Object)new int[]{this.width, this.height});
                string = this.viewer.resizeInnerPanel(this.width, this.height);
                if (((Dimension)string).width == Integer.MIN_VALUE) {
                    throw new NullPointerException("canceled");
                }
                this.width = ((Dimension)string).width;
                this.height = ((Dimension)string).height;
            } else {
                String string3 = "PyMOL dimensions?";
            }
            this.appendLoadNote((String)var5_15);
        }
        this.totalAtomCount = this.getTotalAtomCount(jmolList2);
        Logger.info((String)("PyMOL total atom count = " + this.totalAtomCount));
        if (this.totalAtomCount == 0) {
            this.atomSetCollection.newAtomSet();
        }
        PyMOLReader.pointAt((JmolList<Object>)((JmolList)PyMOLReader.listAt(this.settings, 471).get(2)), 0, this.labelPosition0);
        this.selections = new JmolList();
        boolean bl = true;
        while (var5_17 < jmolList2.size()) {
            this.processBranch(PyMOLReader.listAt(jmolList2, (int)var5_17));
            ++var5_17;
        }
        this.processSelections();
        this.proecssMeshes();
        if (this.isMovie) {
            this.appendLoadNote("PyMOL trajectories read: " + this.lstTrajectories.size());
            this.atomSetCollection.finalizeTrajectoryAs(this.lstTrajectories, null);
        }
        this.setDefinitions();
        this.setRendering(PyMOLReader.getMapList(map, "view"));
        if (this.atomCount == 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("dataOnly", (Object)Boolean.TRUE);
        }
    }

    private void proecssMeshes() {
        if (this.mapObjects == null) {
            return;
        }
        this.viewer.cachePut(this.filePath + "#jmolSurfaceInfo", this.volumeData);
        int n = this.mapObjects.size();
        while (--n >= 0) {
            Object object;
            String string;
            JmolList<Object> jmolList;
            int n2;
            JmolList jmolList2 = (JmolList)this.mapObjects.get(n);
            String string2 = jmolList2.get(jmolList2.size() - 1).toString();
            boolean bl = string2.endsWith("_e_pot");
            if (bl) {
                n2 = 0x400000C0;
                jmolList = string2.substring(0, string2.length() - 3);
                string = (String)jmolList + "map";
                object = this.branchIDs.get(jmolList + "chg");
                if (object == null) continue;
                jmolList2.addLast(object);
            } else {
                n2 = 1073742018;
                string = PyMOLReader.stringAt(PyMOLReader.listAt(PyMOLReader.listAt((JmolList<Object>)jmolList2, 2), 0), 1);
            }
            jmolList = this.volumeData.get(string);
            if (jmolList == null) continue;
            jmolList2.addLast((Object)string);
            this.appendLoadNote("PyMOL object " + string2 + " references map " + string);
            this.volumeData.put(string2, (JmolList<Object>)jmolList2);
            this.volumeData.put("__pymolSurfaceData__", (JmolList<Object>)jmolList2);
            if (this.isStateScript) continue;
            object = new ModelSettings(n2, null, jmolList2);
            this.modelSettings.addLast(object);
            if (bl) continue;
            ((ModelSettings)object).setSize(this.getFloatSetting(90));
            ((ModelSettings)object).argb = PyMOL.getRGB(PyMOLReader.intAt(PyMOLReader.listAt((JmolList<Object>)jmolList2, 0), 2));
        }
    }

    private void setVersionSettings() {
        if (this.pymolVersion < 100) {
            this.addSetting(550, 2, 0);
            this.addSetting(529, 2, 2);
            this.addSetting(471, 4, new double[]{1.0, 1.0, 0.0});
            if (this.pymolVersion < 99) {
                this.addSetting(448, 2, 0);
                this.addSetting(431, 2, 0);
                this.addSetting(361, 2, 1);
            }
        }
    }

    private void addSetting(int n, int n2, Object object) {
        int n3 = this.settings.size();
        if (n3 <= n) {
            int n4 = n + 1;
            while (--n4 >= n3) {
                this.settings.addLast(null);
            }
        }
        if (n2 == 4) {
            double[] dArray = (double[])object;
            JmolList jmolList = new JmolList();
            object = jmolList;
            for (int i = 0; i < 3; ++i) {
                jmolList.addLast((Object)dArray[i]);
            }
        }
        JmolList jmolList = new JmolList();
        jmolList.addLast((Object)n);
        jmolList.addLast((Object)n2);
        jmolList.addLast(object);
        this.settings.set(n, (Object)jmolList);
    }

    private void setDefinitions() {
        this.modelSettings.addLast((Object)new ModelSettings(1060866, null, this.htNames));
        this.appendLoadNote(this.viewer.getAtomDefs(this.htNames));
    }

    private int getTotalAtomCount(JmolList<Object> jmolList) {
        int n = 0;
        for (int i = 1; i < jmolList.size(); ++i) {
            JmolList<Object> jmolList2 = PyMOLReader.listAt(jmolList, i);
            int n2 = PyMOLReader.getBranchType(jmolList2);
            if (n2 != 1 || !this.checkBranch(jmolList2)) continue;
            JmolList<Object> jmolList3 = PyMOLReader.listAt(jmolList2, 5);
            if (this.isMovie) {
                n += PyMOLReader.getBranchAtoms(jmolList3).size();
                continue;
            }
            JmolList<Object> jmolList4 = PyMOLReader.listAt(jmolList3, 4);
            int n3 = jmolList4.size();
            for (int j = 0; j < n3; ++j) {
                JmolList<Object> jmolList5 = PyMOLReader.listAt(jmolList4, j);
                JmolList<Object> jmolList6 = PyMOLReader.listAt(jmolList5, 3);
                n += jmolList6.size();
            }
        }
        return n;
    }

    private void addColors(JmolList<Object> jmolList) {
        if (jmolList == null || jmolList.size() == 0) {
            return;
        }
        P3 p3 = new P3();
        int n = jmolList.size();
        while (--n >= 0) {
            JmolList<Object> jmolList2 = PyMOLReader.listAt(jmolList, n);
            PyMOL.addColor((Integer)jmolList2.get(1), ColorUtil.colorPtToInt((Tuple3f)PyMOLReader.pointAt(PyMOLReader.listAt(jmolList2, 2), 0, p3)));
        }
    }

    private static int intAt(JmolList<Object> jmolList, int n) {
        return ((Number)jmolList.get(n)).intValue();
    }

    static float floatAt(JmolList<Object> jmolList, int n) {
        return jmolList == null ? 0.0f : ((Number)jmolList.get(n)).floatValue();
    }

    static P3 pointAt(JmolList<Object> jmolList, int n, P3 p3) {
        p3.set(PyMOLReader.floatAt(jmolList, n++), PyMOLReader.floatAt(jmolList, n++), PyMOLReader.floatAt(jmolList, n));
        return p3;
    }

    private static String stringAt(JmolList<Object> jmolList, int n) {
        String string = jmolList.get(n).toString();
        return string.length() == 0 ? " " : string;
    }

    static JmolList<Object> listAt(JmolList<Object> jmolList, int n) {
        if (jmolList == null || n >= jmolList.size()) {
            return null;
        }
        Object object = jmolList.get(n);
        return object instanceof JmolList ? (JmolList)object : null;
    }

    private static JmolList<Object> getMapList(Map<String, Object> map, String string) {
        return (JmolList)map.get(string);
    }

    private boolean getBooleanSetting(int n) {
        return this.getFloatSetting(n) != 0.0f;
    }

    private float getFloatSetting(int n) {
        float f = 0.0f;
        try {
            JmolList<Object> jmolList = null;
            if (this.localSettings != null) {
                jmolList = this.localSettings.get(n);
            }
            if (jmolList == null) {
                jmolList = PyMOLReader.listAt(this.settings, n);
            }
            if (this.settings == null) {
                return 0.0f;
            }
            f = ((Number)jmolList.get(2)).floatValue();
            Logger.info((String)("Pymol setting " + n + " = " + f));
        }
        catch (Exception exception) {
            Logger.info((String)("PyMOL " + this.pymolVersion + " does not have setting " + n));
            switch (n) {
                case 376: {
                    return -1.0f;
                }
                case 453: {
                    return 14.0f;
                }
            }
            Logger.error((String)("PyMOL rendering missing setting " + n));
        }
        return f;
    }

    private void processBranch(JmolList<Object> jmolList) {
        int n = PyMOLReader.getBranchType(jmolList);
        if (!this.checkBranch(jmolList)) {
            return;
        }
        Logger.info((String)("PyMOL model " + (this.nModels + 1) + " Branch " + this.branchName + (this.isHidden ? " (hidden)" : " (visible)")));
        JmolList<Object> jmolList2 = PyMOLReader.listAt(jmolList, 5);
        this.branchNameID = this.branchName + "_" + ++this.branchID;
        this.branchIDs.put(this.branchName, this.branchNameID);
        String string = "" + n;
        switch (n) {
            case -1: {
                this.selections.addLast(jmolList);
                return;
            }
            case 1: {
                this.processBranchModels(jmolList2);
                return;
            }
            case 4: {
                this.processBranchMeasure(jmolList2);
                return;
            }
            case 2: 
            case 3: {
                this.processMap(jmolList2, n == 3);
                return;
            }
            case 8: {
                this.processGadget(jmolList2);
                return;
            }
            case 6: {
                string = "CGO";
                this.processCGO(jmolList2);
                break;
            }
            case 11: {
                string = "ALIGNEMENT";
                break;
            }
            case 9: {
                string = "CALCULATOR";
                break;
            }
            case 5: {
                string = "CALLBACK";
                break;
            }
            case 12: {
                string = "GROUP";
                break;
            }
            case 10: {
                string = "SLICE";
                break;
            }
            case 7: {
                string = "SURFACE";
            }
        }
        Logger.error((String)("Unprocessed branch type " + string));
    }

    private void processCGO(JmolList<Object> jmolList) {
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        int n = PyMOLReader.intAt(PyMOLReader.listAt(jmolList, 0), 2);
        JmolList<Object> jmolList2 = PyMOLReader.listAt(PyMOLReader.listAt(jmolList, 2), 0);
        jmolList2.addLast((Object)this.branchName);
        ModelSettings modelSettings = new ModelSettings(23, null, jmolList2);
        modelSettings.argb = PyMOL.getRGB(n);
        this.modelSettings.addLast((Object)modelSettings);
    }

    private void processGadget(JmolList<Object> jmolList) {
        if (this.branchName.endsWith("_e_pot")) {
            this.processMap(jmolList, true);
        }
    }

    private void processMap(JmolList<Object> jmolList, boolean bl) {
        if (bl) {
            if (this.isHidden) {
                return;
            }
            if (this.mapObjects == null) {
                this.mapObjects = new JmolList();
            }
            this.mapObjects.addLast(jmolList);
        } else {
            if (this.volumeData == null) {
                this.volumeData = new Hashtable();
            }
            this.volumeData.put(this.branchName, jmolList);
        }
        jmolList.addLast((Object)this.branchName);
    }

    private void processSelections() {
        int n = this.selections.size();
        while (--n >= 0) {
            JmolList jmolList = (JmolList)this.selections.get(n);
            this.checkBranch((JmolList<Object>)jmolList);
            this.processBranchSelection(PyMOLReader.listAt((JmolList<Object>)jmolList, 5));
        }
    }

    private void processBranchSelection(JmolList<Object> jmolList) {
        BS bS = new BS();
        int n = jmolList.size();
        while (--n >= 0) {
            JmolList<Object> jmolList2 = PyMOLReader.listAt(jmolList, n);
            String string = PyMOLReader.stringAt(jmolList2, 0);
            this.atomMap = this.htAtomMap.get(string);
            if (this.atomMap == null) continue;
            JmolList<Object> jmolList3 = PyMOLReader.listAt(jmolList2, 1);
            int n2 = jmolList3.size();
            while (--n2 >= 0) {
                int n3 = this.atomMap[PyMOLReader.intAt(jmolList3, n2)];
                if (n3 < 0) continue;
                bS.set(n3);
            }
        }
        if (!bS.isEmpty()) {
            this.addName(this.branchName, bS);
        }
    }

    private boolean checkBranch(JmolList<Object> jmolList) {
        this.branchName = PyMOLReader.stringAt(jmolList, 0);
        this.isHidden = PyMOLReader.intAt(jmolList, 2) != 1;
        return this.branchName.indexOf("_") != 0;
    }

    private void processBranchMeasure(JmolList<Object> jmolList) {
        int n;
        int n2;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Logger.info((String)("PyMOL measure " + this.branchName));
        JmolList<Object> jmolList2 = PyMOLReader.listAt(PyMOLReader.listAt(jmolList, 2), 0);
        int n3 = PyMOLReader.intAt(PyMOLReader.listAt(jmolList, 0), 2);
        int n4 = 1;
        if (jmolList2.get(1) instanceof JmolList) {
            n2 = 2;
        } else {
            n4 = 4;
            if (jmolList2.get(4) instanceof JmolList) {
                n2 = 3;
            } else {
                n4 = 6;
                n2 = n = jmolList2.get(6) instanceof JmolList ? 4 : 0;
            }
        }
        if (n == 0) {
            return;
        }
        JmolList<Object> jmolList3 = PyMOLReader.listAt(jmolList2, n4);
        int n5 = jmolList3.size();
        int n6 = 0;
        float f = this.getFloatSetting(107) / 1000.0f;
        if (f == 0.0f) {
            f = 0.002f;
        }
        while (n6 < n5) {
            JmolList jmolList4 = new JmolList();
            int n7 = 0;
            while (n7 < n) {
                jmolList4.addLast((Object)PyMOLReader.pointAt(jmolList3, n6, (P3)new Point3fi()));
                ++n7;
                n6 += 3;
            }
            BS bS = BSUtil.newAndSetBit((int)0);
            MeasurementData measurementData = new MeasurementData(this.viewer, jmolList4);
            measurementData.note = this.branchName;
            String string = "";
            int n8 = -1;
            switch (n) {
                case 2: {
                    n8 = (int)this.getFloatSetting(530);
                    break;
                }
                case 3: {
                    n8 = (int)this.getFloatSetting(531);
                    break;
                }
                case 4: {
                    n8 = (int)this.getFloatSetting(532);
                }
            }
            string = n8 > 0 ? n + ":%0." + n8 + "VALUE %UNITS" : "";
            measurementData.strFormat = string;
            measurementData.colix = C.getColix((int)PyMOL.getRGB(n3));
            ModelSettings modelSettings = new ModelSettings(6, bS, measurementData);
            modelSettings.setSize(f);
            this.modelSettings.addLast((Object)modelSettings);
        }
    }

    private void processBranchModels(JmolList<Object> jmolList) {
        int n;
        JmolList<Object> jmolList2 = PyMOLReader.listAt(jmolList, 0);
        this.setLocalSettings(PyMOLReader.listAt(jmolList2, 8));
        if (!this.isMovie) {
            this.processCryst(PyMOLReader.listAt(jmolList, 10));
        }
        this.atomCount = this.atomCount0 = this.atomSetCollection.getAtomCount();
        this.atomMap = new int[PyMOLReader.intAt(jmolList, 3)];
        this.htAtomMap.put(this.branchName, this.atomMap);
        JmolList<Object> jmolList3 = PyMOLReader.listAt(jmolList, 4);
        JmolList<Bond> jmolList4 = this.processBonds(PyMOLReader.listAt(jmolList, 6));
        this.pymolAtoms = PyMOLReader.getBranchAtoms(jmolList);
        int n2 = jmolList3.size();
        if (n2 > 1) {
            Logger.info((String)(n2 + " PyMOL states"));
        }
        if (n2 == 1) {
            this.allStates = true;
        }
        BS bS = null;
        BS bS2 = BS.newN((int)(this.atomCount0 + this.pymolAtoms.size()));
        Logger.info((String)("PyMOL molecule " + this.branchName));
        this.addName(this.branchName, bS2);
        for (n = 0; n < 16; ++n) {
            this.reps[n] = BS.newN((int)1000);
        }
        if (this.isMovie) {
            JmolList<Object> jmolList5;
            JmolList<Object> jmolList6;
            int n3;
            if (this.nModels == 0) {
                this.model(++this.nModels);
            }
            n = this.pymolAtoms.size();
            bS = BS.newN((int)n);
            if (this.lstTrajectories.size() == 0) {
                n3 = n2;
                while (--n3 >= 0) {
                    this.lstTrajectories.addLast((Object)new P3[this.totalAtomCount]);
                    this.lstStates.addLast((Object)new BS());
                }
            }
            n3 = n2;
            while (--n3 >= 0) {
                jmolList6 = PyMOLReader.listAt(jmolList3, n3);
                jmolList5 = PyMOLReader.listAt(jmolList6, 3);
                if (jmolList5 == null) {
                    Logger.error((String)"movie error: no idxToAtm");
                    continue;
                }
                int n4 = jmolList5.size();
                while (--n4 >= 0) {
                    bS.set(PyMOLReader.intAt(jmolList5, n4));
                }
            }
            n3 = bS.nextSetBit(0);
            while (n3 >= 0) {
                if (!this.addAtom(this.pymolAtoms, n3, -1, null, null, bS2)) {
                    bS.clear(n3);
                }
                n3 = bS.nextSetBit(n3 + 1);
            }
            for (n3 = 0; n3 < n2; ++n3) {
                jmolList6 = PyMOLReader.listAt(jmolList3, n3);
                jmolList5 = PyMOLReader.listAt(jmolList6, 2);
                JmolList<Object> jmolList7 = PyMOLReader.listAt(jmolList6, 3);
                if (jmolList7 == null) continue;
                P3[] p3Array = (P3[])this.lstTrajectories.get(n3);
                BS bS3 = (BS)this.lstStates.get(n3);
                int n5 = jmolList7.size();
                while (--n5 >= 0) {
                    int n6 = PyMOLReader.intAt(jmolList7, n5);
                    if (!bS.get(n6)) continue;
                    int n7 = this.atomMap[n6];
                    bS3.set(n7);
                    int n8 = n5 * 3;
                    float f = PyMOLReader.floatAt(jmolList5, n8);
                    float f2 = PyMOLReader.floatAt(jmolList5, ++n8);
                    float f3 = PyMOLReader.floatAt(jmolList5, ++n8);
                    p3Array[n7] = P3.new3((float)f, (float)f2, (float)f3);
                    BoxInfo.addPointXYZ((float)f, (float)f2, (float)f3, (P3)this.xyzMin, (P3)this.xyzMax, (float)0.0f);
                }
            }
            this.processStructures();
            this.setBranchShapes();
        } else {
            this.allStates |= n2 > 1;
            n2 = 1;
            this.lstStates.clear();
            for (n = 0; n < n2; ++n) {
                int n9;
                JmolList<Object> jmolList8 = PyMOLReader.listAt(jmolList3, n);
                JmolList<Object> jmolList9 = PyMOLReader.listAt(jmolList8, 2);
                JmolList<Object> jmolList10 = PyMOLReader.listAt(jmolList8, 3);
                JmolList<Object> jmolList11 = PyMOLReader.listAt(jmolList8, 8);
                int n10 = jmolList10.size();
                String string = PyMOLReader.stringAt(jmolList8, 5).trim();
                if (n10 == 0) continue;
                if (string.length() == 0) {
                    this.currentFrame = this.pymolFrame;
                    if (this.lstStates.size() < n2) {
                        for (n9 = this.lstStates.size(); n9 < n2; ++n9) {
                            this.lstStates.addLast((Object)new BS());
                        }
                    }
                    bS = (BS)this.lstStates.get(n);
                } else {
                    bS2 = BS.newN((int)(this.atomCount0 + this.pymolAtoms.size()));
                    this.addName(string, bS2);
                }
                this.model(++this.nModels);
                for (n9 = 0; n9 < n10; ++n9) {
                    this.addAtom(this.pymolAtoms, PyMOLReader.intAt(jmolList10, n9), n9, jmolList9, jmolList11, bS);
                }
                if (bS != null) {
                    bS2.or(bS);
                }
                this.processStructures();
                this.setBranchShapes();
            }
        }
        this.setBonds(jmolList4);
        Logger.info((String)("reading " + (this.atomCount - this.atomCount0) + " atoms"));
        this.dumpBranch();
    }

    private void setBonds(JmolList<Bond> jmolList) {
        int n = jmolList.size();
        for (int i = 0; i < n; ++i) {
            Bond bond = (Bond)jmolList.get(i);
            bond.atomIndex1 = this.atomMap[bond.atomIndex1];
            bond.atomIndex2 = this.atomMap[bond.atomIndex2];
            if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0) continue;
            this.atomSetCollection.addBond(bond);
        }
    }

    private void setLocalSettings(JmolList<Object> jmolList) {
        this.localSettings = new Hashtable<Integer, JmolList<Object>>();
        if (jmolList != null && jmolList.size() != 0) {
            Logger.info((String)jmolList.toString());
            int n = jmolList.size();
            while (--n >= 0) {
                JmolList jmolList2 = (JmolList)jmolList.get(n);
                this.localSettings.put((Integer)jmolList2.get(0), (JmolList<Object>)jmolList2);
            }
        }
        this.nonBondedSize = this.getFloatSetting(65);
        this.sphereScale = this.getFloatSetting(155);
        this.valence = this.getBooleanSetting(64);
        this.cartoonTranslucency = this.getFloatSetting(279);
        this.stickTranslucency = this.getFloatSetting(198);
        this.sphereTranslucency = this.getFloatSetting(172);
        this.cartoonLadderMode = this.getBooleanSetting(448);
        this.cartoonRockets = this.getBooleanSetting(180);
        this.solventAsSpheres = this.getBooleanSetting(203);
        this.surfaceMode = (int)this.getFloatSetting(143);
        this.surfaceColor = (int)this.getFloatSetting(144);
        this.labelPosition = new P3();
        try {
            JmolList<Object> jmolList3 = this.localSettings.get(471);
            PyMOLReader.pointAt((JmolList<Object>)((JmolList)jmolList3.get(2)), 0, this.labelPosition);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.labelPosition.add((Tuple3f)this.labelPosition0);
        this.labelColor = this.getFloatSetting(66);
        this.labelSize = this.getFloatSetting(453);
        this.labelFontId = (int)this.getFloatSetting(328);
    }

    private void setUniqueSettings(JmolList<Object> jmolList) {
        this.uniqueSettings = new Hashtable();
        if (jmolList != null && jmolList.size() != 0) {
            int n = jmolList.size();
            while (--n >= 0) {
                JmolList jmolList2 = (JmolList)jmolList.get(n);
                int n2 = PyMOLReader.intAt((JmolList<Object>)jmolList2, 0);
                JmolList jmolList3 = (JmolList)jmolList2.get(1);
                int n3 = jmolList3.size();
                while (--n3 >= 0) {
                    JmolList jmolList4 = (JmolList)jmolList3.get(n3);
                    int n4 = n2 * 1000 + PyMOLReader.intAt((JmolList<Object>)jmolList4, 0);
                    this.uniqueSettings.put(n4, (JmolList<Object>)jmolList4);
                    Logger.info((String)("PyMOL unique setting " + n2 + " " + jmolList4));
                }
            }
        }
    }

    private float getUniqueFloat(int n, int n2, float f) {
        JmolList<Object> jmolList;
        if (n < 0 || (jmolList = this.uniqueSettings.get(n * 1000 + n2)) == null) {
            return f;
        }
        float f2 = ((Number)jmolList.get(2)).floatValue();
        Logger.info((String)("Pymol unique setting for " + n + ": " + n2 + " = " + f2));
        return f2;
    }

    private P3 getUniquePoint(int n, int n2, P3 p3) {
        JmolList<Object> jmolList;
        if (n < 0 || (jmolList = this.uniqueSettings.get(n * 1000 + n2)) == null) {
            return p3;
        }
        p3 = new P3();
        PyMOLReader.pointAt((JmolList<Object>)((JmolList)jmolList.get(2)), 0, p3);
        Logger.info((String)("Pymol unique setting for " + n + ": " + n2 + " = " + p3));
        return p3;
    }

    private void addName(String string, BS bS) {
        this.htNames.put(PyMOLReader.fixName(string), bS);
    }

    private static String fixName(String string) {
        char[] cArray = string.toLowerCase().toCharArray();
        int n = cArray.length;
        while (--n >= 0) {
            if (Character.isLetterOrDigit(cArray[n])) continue;
            cArray[n] = 95;
        }
        return "__" + String.valueOf(cArray);
    }

    private static int getBranchType(JmolList<Object> jmolList) {
        return PyMOLReader.intAt(jmolList, 4);
    }

    private static JmolList<Object> getBranchAtoms(JmolList<Object> jmolList) {
        return PyMOLReader.listAt(jmolList, 7);
    }

    protected void model(int n) {
        this.bsModelAtoms.clearAll();
        super.model(n);
    }

    private boolean addAtom(JmolList<Object> jmolList, int n, int n2, JmolList<Object> jmolList2, JmolList<Object> jmolList3, BS bS) {
        boolean bl;
        String string;
        this.atomMap[n] = -1;
        JmolList<Object> jmolList4 = PyMOLReader.listAt(jmolList, n);
        int n3 = PyMOLReader.intAt(jmolList4, 0);
        String string2 = PyMOLReader.stringAt(jmolList4, 1);
        String string3 = PyMOLReader.stringAt(jmolList4, 2);
        String string4 = " ";
        String string5 = PyMOLReader.stringAt(jmolList4, 6);
        String string6 = PyMOLReader.stringAt(jmolList4, 5);
        if (string6.length() > 3) {
            string6 = string6.substring(0, 3);
        }
        if (string6.equals(" ")) {
            string6 = "UNK";
        }
        if ((string = PyMOLReader.stringAt(jmolList4, 7)).equals("A")) {
            string = "C";
        }
        boolean bl2 = PyMOLReader.intAt(jmolList4, 19) != 0;
        PyMOLAtom pyMOLAtom = (PyMOLAtom)this.processAtom(new PyMOLAtom(), string5, string3.charAt(0), string6, string2.charAt(0), n3, string4.charAt(0), bl2, string);
        if (!this.filterPDBAtom(pyMOLAtom, this.fileAtomIndex++)) {
            return false;
        }
        boolean bl3 = bl = nucleic.indexOf(string6) >= 0;
        if (bl) {
            this.bsNucleic.set(this.atomCount);
        }
        pyMOLAtom.label = PyMOLReader.stringAt(jmolList4, 9);
        String string7 = PyMOLReader.stringAt(jmolList4, 10);
        if (n3 >= -1000 && (!string7.equals(" ") || string5.equals("CA") || bl)) {
            BS bS2;
            if (this.ssMapAtom.get(string7) == null) {
                this.ssMapAtom.put(string7, new BS());
            }
            if ((bS2 = this.ssMapSeq.get(string7)) == null) {
                bS2 = new BS();
                this.ssMapSeq.put(string7, bS2);
            }
            bS2.set(n3 - -1000);
            string7 = string7 + string2;
            bS2 = this.ssMapSeq.get(string7);
            if (bS2 == null) {
                bS2 = new BS();
                this.ssMapSeq.put(string7, bS2);
            }
            bS2.set(n3 - -1000);
        }
        pyMOLAtom.bfactor = PyMOLReader.floatAt(jmolList4, 14);
        pyMOLAtom.occupancy = (int)(PyMOLReader.floatAt(jmolList4, 15) * 100.0f);
        pyMOLAtom.radius = PyMOLReader.floatAt(jmolList4, 16);
        pyMOLAtom.partialCharge = PyMOLReader.floatAt(jmolList4, 17);
        int n4 = PyMOLReader.intAt(jmolList4, 18);
        pyMOLAtom.bsReps = this.getBsReps(PyMOLReader.listAt(jmolList4, 20));
        boolean bl4 = !pyMOLAtom.bsReps.isEmpty();
        int n5 = PyMOLReader.intAt(jmolList4, 22);
        pyMOLAtom.cartoonType = PyMOLReader.intAt(jmolList4, 23);
        pyMOLAtom.flags = PyMOLReader.intAt(jmolList4, 24);
        boolean bl5 = pyMOLAtom.bonded = PyMOLReader.intAt(jmolList4, 25) != 0;
        if (jmolList4.size() > 40 && PyMOLReader.intAt(jmolList4, 40) == 1) {
            pyMOLAtom.uniqueID = PyMOLReader.intAt(jmolList4, 32);
        }
        boolean bl6 = true;
        switch (this.surfaceMode) {
            case 0: {
                bl6 = (pyMOLAtom.flags & PyMOL.FLAG_NOSURFACE) == 0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                bl6 = !string.equals("H");
                break;
            }
            case 3: {
                bl6 = bl4;
                break;
            }
            case 4: {
                boolean bl7 = bl6 = bl4 && !string.equals("H");
            }
        }
        if (!bl6) {
            this.bsNoSurface.set(this.atomCount);
        }
        float f = this.getUniqueFloat(pyMOLAtom.uniqueID, 172, this.sphereTranslucency);
        int n6 = PyMOLReader.intAt(jmolList4, 21);
        this.atomColorList.addLast((Object)this.getColix(n6, f));
        this.bsHidden.setBitTo(this.atomCount, this.isHidden);
        this.bsModelAtoms.set(this.atomCount);
        if (bS != null) {
            bS.set(this.atomCount);
        }
        int n7 = n2 * 3;
        float f2 = PyMOLReader.floatAt(jmolList2, n7);
        float f3 = PyMOLReader.floatAt(jmolList2, ++n7);
        float f4 = PyMOLReader.floatAt(jmolList2, ++n7);
        BoxInfo.addPointXYZ((float)f2, (float)f3, (float)f4, (P3)this.xyzMin, (P3)this.xyzMax, (float)0.0f);
        this.processAtom2(pyMOLAtom, n5, f2, f3, f4, n4);
        if (jmolList4.size() > 46) {
            float[] fArray = new float[7];
            for (int i = 0; i < 6; ++i) {
                fArray[i] = PyMOLReader.floatAt(jmolList4, i + 41);
            }
            this.atomSetCollection.setAnisoBorU((Atom)pyMOLAtom, fArray, 12);
        }
        this.setAtomReps(n, this.atomCount, n6, jmolList3);
        ++this.atomCount;
        return true;
    }

    private void setAtomReps(int n, int n2, int n3, JmolList<Object> jmolList) {
        int n4;
        PyMOLAtom pyMOLAtom = (PyMOLAtom)this.atomSetCollection.getAtom(n2);
        for (n4 = 0; n4 < 12; ++n4) {
            if (!pyMOLAtom.bsReps.get(n4)) continue;
            this.reps[n4].set(n2);
        }
        if (this.reps[3].get(n2)) {
            if (pyMOLAtom.label.equals(" ")) {
                this.reps[3].clear(n2);
            } else {
                n4 = (int)this.getUniqueFloat(pyMOLAtom.uniqueID, 66, this.labelColor);
                if (n4 < 0) {
                    n4 = n3;
                }
                float[] fArray = new float[7];
                JmolList<Object> jmolList2 = PyMOLReader.listAt(jmolList, n);
                if (jmolList2 == null) {
                    P3 p3 = this.getUniquePoint(pyMOLAtom.uniqueID, 471, null);
                    if (p3 == null) {
                        p3 = this.labelPosition;
                    } else {
                        p3.add((Tuple3f)this.labelPosition);
                    }
                    fArray[0] = 1.0f;
                    fArray[1] = p3.x;
                    fArray[2] = p3.y;
                    fArray[3] = p3.z;
                } else {
                    for (int i = 0; i < 7; ++i) {
                        fArray[i] = PyMOLReader.floatAt(jmolList2, i);
                    }
                }
                this.labels.addLast((Object)this.newTextLabel(pyMOLAtom.label, fArray, this.getColix(n4, 0.0f), (int)this.getUniqueFloat(pyMOLAtom.uniqueID, 328, this.labelFontId), this.getUniqueFloat(pyMOLAtom.uniqueID, 453, this.labelSize)));
            }
        }
        if ((n4 = (int)(this.reps[1].get(n2) ? 1 : 0)) == 0 && !this.solventAsSpheres && this.reps[11].get(n2) && !pyMOLAtom.bonded) {
            this.reps[4].clear(n2);
            this.reps[11].clear(n2);
            this.reps[15].set(n2);
        }
        float f = 0.0f;
        if (n4 != 0) {
            float f2 = this.getUniqueFloat(pyMOLAtom.uniqueID, 155, this.sphereScale);
            f = pyMOLAtom.radius * f2;
        } else if (this.reps[11].get(n2) || this.reps[4].get(n2)) {
            float f3 = this.getUniqueFloat(pyMOLAtom.uniqueID, 65, this.nonBondedSize);
            f = -pyMOLAtom.radius * f3;
        }
        if (!this.usePymolRadii) {
            pyMOLAtom.radius = Float.NaN;
        }
        if (f != 0.0f) {
            this.addSpacefill(n2, f);
        }
        if (this.reps[5].get(n2)) {
            switch (pyMOLAtom.cartoonType) {
                case -1: {
                    this.reps[5].clear(n2);
                    break;
                }
                case 1: {
                    this.reps[13].set(n2);
                    break;
                }
                case 4: {
                    this.reps[13].set(n2);
                    break;
                }
                case 7: {
                    this.reps[5].clear(n2);
                    this.reps[14].set(n2);
                }
            }
        }
    }

    private Text newTextLabel(String string, float[] fArray, short s, int n, float f) {
        String string2;
        String string3;
        float f2 = 1.0f;
        switch (n) {
            default: {
                string3 = "SansSerif";
                break;
            }
            case 0: 
            case 1: {
                string3 = "Monospaced";
                break;
            }
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string3 = "Serif";
            }
        }
        switch (n) {
            default: {
                string2 = "Plain";
                break;
            }
            case 6: 
            case 12: 
            case 16: 
            case 17: {
                string2 = "Italic";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                string2 = "Bold";
                break;
            }
            case 8: 
            case 14: 
            case 18: {
                string2 = "BoldItalic";
            }
        }
        JmolFont jmolFont = this.viewer.getFont3D(string3, string2, f == 0.0f ? 12.0f : f * f2);
        Text text = Text.newLabel((GData)this.viewer.getGraphicsData(), (JmolFont)jmolFont, (String)string, (short)s, (short)0, (int)0, (float)0.0f, (float[])fArray);
        return text;
    }

    private short getColix(int n, float f) {
        return C.getColixTranslucent3((short)C.getColixO((Object)PyMOL.getRGB(n)), (f > 0.0f ? 1 : 0) != 0, (float)f);
    }

    private BS getBsReps(JmolList<Object> jmolList) {
        BS bS = new BS();
        for (int i = 0; i < 12; ++i) {
            if (PyMOLReader.intAt(jmolList, i) != 1) continue;
            bS.set(i);
        }
        return bS;
    }

    private void dumpBranch() {
        Logger.info((String)"----------");
    }

    protected void setAdditionalAtomParameters(Atom atom) {
    }

    private void processStructures() {
        if (this.atomSetCollection.bsStructuredModels == null) {
            this.atomSetCollection.bsStructuredModels = new BS();
        }
        this.atomSetCollection.bsStructuredModels.set(Math.max(this.atomSetCollection.getCurrentAtomSetIndex(), 0));
        this.processSS("H", this.ssMapAtom.get("H"), EnumStructure.HELIX, 0);
        this.processSS("S", this.ssMapAtom.get("S"), EnumStructure.SHEET, 1);
        this.processSS("L", this.ssMapAtom.get("L"), EnumStructure.TURN, 0);
        this.processSS(" ", this.ssMapAtom.get(" "), EnumStructure.NONE, 0);
        this.ssMapSeq = new Hashtable<String, BS>();
    }

    private void processSS(String string, BS bS, EnumStructure enumStructure, int n) {
        if (this.ssMapSeq.get(string) == null) {
            return;
        }
        int n2 = -1;
        int n3 = -1;
        char c = '\u0000';
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        BS bS2 = null;
        int n4 = this.atomCount + 1;
        int n5 = -1;
        char c2 = '\u0000';
        int n6 = -1;
        int n7 = -1;
        for (int i = this.atomCount0; i < n4; ++i) {
            if (i == this.atomCount) {
                c2 = '\u0000';
            } else {
                n5 = atomArray[i].sequenceNumber;
                c2 = atomArray[i].chainID;
                n7 = atomArray[i].atomSetIndex;
            }
            if (c2 != c || n7 != n6) {
                c = c2;
                n6 = n7;
                bS2 = this.ssMapSeq.get(string + c2);
                --i;
                if (n2 < 0) {
                    continue;
                }
            } else {
                if (bS2 != null && n5 >= -1000 && bS2.get(n5 - -1000)) {
                    n3 = i;
                    if (n2 >= 0) continue;
                    n2 = i;
                    continue;
                }
                if (n2 < 0) continue;
            }
            if (enumStructure != EnumStructure.NONE) {
                int n8 = this.bsStructureDefined.nextSetBit(n2);
                if (n8 >= 0 && n8 <= n3) continue;
                this.bsStructureDefined.setBits(n2, n3 + 1);
                Structure structure = new Structure(n6, enumStructure, enumStructure, enumStructure.toString(), ++this.strucNo, n);
                Atom atom = atomArray[n2];
                Atom atom2 = atomArray[n3];
                structure.set(atom.chainID, atom.sequenceNumber, atom.insertionCode, atom2.chainID, atom2.sequenceNumber, atom2.insertionCode, n2, n3);
                this.atomSetCollection.addStructure(structure);
            }
            bS.setBits(n2, n3 + 1);
            n2 = -1;
        }
    }

    private JmolList<Bond> processBonds(JmolList<Object> jmolList) {
        JmolList jmolList2 = new JmolList();
        this.bsBondedPyMOL.clear(this.totalAtomCount);
        int n = (int)this.getFloatSetting(376);
        float f = this.getFloatSetting(21) / 2.0f;
        float f2 = this.getFloatSetting(198);
        int n2 = jmolList.size();
        for (int i = 0; i < n2; ++i) {
            float f3;
            int n3;
            float f4;
            boolean bl;
            int n4;
            JmolList<Object> jmolList3 = PyMOLReader.listAt(jmolList, i);
            int n5 = n4 = this.valence ? PyMOLReader.intAt(jmolList3, 2) : 1;
            if (n4 < 1 || n4 > 3) {
                n4 = 1;
            }
            int n6 = PyMOLReader.intAt(jmolList3, 0);
            int n7 = PyMOLReader.intAt(jmolList3, 1);
            this.bsBondedPyMOL.set(n6);
            this.bsBondedPyMOL.set(n7);
            Bond bond = new Bond(n6, n7, n4);
            jmolList2.addLast((Object)bond);
            boolean bl2 = bl = jmolList3.size() > 6 && PyMOLReader.intAt(jmolList3, 6) != 0;
            if (bl) {
                int n8 = PyMOLReader.intAt(jmolList3, 5);
                f4 = this.getUniqueFloat(n8, 21, f) / 2.0f;
                n3 = (int)this.getUniqueFloat(n8, 376, n);
                f3 = this.getUniqueFloat(n8, 198, f2);
            } else {
                f4 = f;
                n3 = n;
                f3 = f2;
            }
            bond.radius = f4;
            if (n3 < 0) continue;
            bond.colix = C.getColixTranslucent3((short)C.getColix((int)PyMOL.getRGB(n3)), (f3 > 0.0f ? 1 : 0) != 0, (float)f3);
        }
        return jmolList2;
    }

    private void processCryst(JmolList<Object> jmolList) {
        if (jmolList == null || jmolList.size() == 0) {
            return;
        }
        JmolList<Object> jmolList2 = PyMOLReader.listAt(PyMOLReader.listAt(jmolList, 0), 0);
        JmolList<Object> jmolList3 = PyMOLReader.listAt(PyMOLReader.listAt(jmolList, 0), 1);
        this.setUnitCell(PyMOLReader.floatAt(jmolList2, 0), PyMOLReader.floatAt(jmolList2, 1), PyMOLReader.floatAt(jmolList2, 2), PyMOLReader.floatAt(jmolList3, 0), PyMOLReader.floatAt(jmolList3, 1), PyMOLReader.floatAt(jmolList3, 2));
        this.setSpaceGroupName(PyMOLReader.stringAt(jmolList, 1));
    }

    private void setRendering(JmolList<Object> jmolList) {
        if (this.isStateScript) {
            return;
        }
        this.setJmolDefaults();
        SB sB = new SB();
        this.setView(sB, jmolList);
        this.setFrame();
        if (!this.bsHidden.isEmpty()) {
            this.modelSettings.addLast((Object)new ModelSettings(3145770, this.bsHidden, null));
        }
        this.addJmolScript(sB.toString());
    }

    private void setJmolDefaults() {
        this.viewer.setBooleanProperty("navigationMode", false);
        this.viewer.setBooleanProperty("zoomLarge", false);
        this.viewer.setBooleanProperty("ssBondsBackbone", false);
        this.viewer.setStringProperty("measurementUnits", "ANGSTROMS");
    }

    private void setBranchShapes() {
        if (this.isStateScript) {
            return;
        }
        BS bS = BSUtil.newBitSet2((int)this.atomCount0, (int)this.atomCount);
        ModelSettings modelSettings = new ModelSettings(0, bS, null);
        this.colixes = this.setColors(this.colixes, this.atomColorList);
        modelSettings.setSize(0.0f);
        modelSettings.setColors(this.colixes, 0.0f);
        this.modelSettings.addLast((Object)modelSettings);
        modelSettings = new ModelSettings(1, bS, null);
        modelSettings.setSize(0.0f);
        this.modelSettings.addLast((Object)modelSettings);
        this.setSpacefill();
        this.cleanSingletonCartoons(this.reps[5]);
        this.reps[13].and(this.reps[5]);
        this.reps[5].andNot(this.reps[13]);
        for (int i = 0; i < 16; ++i) {
            this.setShape(i);
        }
        this.setSurface();
        this.ssMapAtom = new Hashtable<String, BS>();
    }

    private short[] setColors(short[] sArray, JmolList<Integer> jmolList) {
        sArray = sArray == null ? new short[this.atomCount] : ArrayUtil.ensureLengthShort((short[])sArray, (int)this.atomCount);
        int n = this.atomCount;
        while (--n >= this.atomCount0) {
            sArray[n] = (short)((Integer)jmolList.get(n)).intValue();
        }
        return sArray;
    }

    private void setShape(int n) {
        BS bS = this.reps[n];
        switch (n) {
            case 4: 
            case 11: {
                break;
            }
            case 7: {
                bS.andNot(this.reps[0]);
            }
        }
        if (bS.isEmpty()) {
            return;
        }
        ModelSettings modelSettings = null;
        switch (n) {
            case 15: {
                modelSettings = new ModelSettings(7, bS, null);
                modelSettings.rd = new RadiusData(null, this.getFloatSetting(65) / 2.0f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
                modelSettings.setColors(this.colixes, 0.0f);
                this.modelSettings.addLast((Object)modelSettings);
                break;
            }
            case 11: {
                modelSettings = new ModelSettings(0, bS, null);
                modelSettings.setColors(this.colixes, 0.0f);
                modelSettings.translucency = this.sphereTranslucency;
                this.modelSettings.addLast((Object)modelSettings);
                break;
            }
            case 1: 
            case 4: {
                modelSettings = new ModelSettings(0, bS, null);
                modelSettings.setColors(this.colixes, 0.0f);
                modelSettings.translucency = this.sphereTranslucency;
                this.modelSettings.addLast((Object)modelSettings);
                break;
            }
            case 0: {
                float f = this.getFloatSetting(21) * 2.0f;
                modelSettings = new ModelSettings(1, bS, null);
                modelSettings.setSize(f);
                modelSettings.translucency = this.stickTranslucency;
                this.modelSettings.addLast((Object)modelSettings);
                break;
            }
            case 9: {
                modelSettings = new ModelSettings(16, bS, null);
                float f = this.getFloatSetting(155);
                modelSettings.rd = new RadiusData(null, f, RadiusData.EnumType.FACTOR, EnumVdw.AUTO);
                this.modelSettings.addLast((Object)modelSettings);
                break;
            }
            case 7: {
                float f = this.getFloatSetting(44) / 15.0f;
                modelSettings = new ModelSettings(1, bS, null);
                modelSettings.setSize(f);
                this.modelSettings.addLast((Object)modelSettings);
                break;
            }
            case 5: {
                if (this.cartoonRockets) {
                    this.setCartoon("H", 181, 2.0f);
                } else {
                    this.setCartoon("H", 100, 2.0f);
                }
                this.setCartoon("S", 96, 2.0f);
                this.setCartoon("L", 92, 2.0f);
                this.setCartoon(" ", 92, 2.0f);
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: {
                JmolList jmolList = new JmolList();
                for (int i = 0; i < this.labels.size(); ++i) {
                    jmolList.addLast(this.labels.get(i));
                }
                this.labels.clear();
                modelSettings = new ModelSettings(5, bS, jmolList);
                this.modelSettings.addLast((Object)modelSettings);
                break;
            }
            case 14: {
                this.setPutty(bS);
                break;
            }
            case 13: {
                this.haveTraceOrBackbone = true;
                this.setTrace(bS);
                break;
            }
            case 6: {
                this.haveTraceOrBackbone = true;
                this.setRibbon(bS);
                break;
            }
            case 10: {
                break;
            }
            default: {
                if (n >= 13) break;
                Logger.error((String)("Unprocessed representation type " + n));
            }
        }
    }

    private void addSpacefill(int n, float f) {
        Float f2 = Float.valueOf(f);
        BS bS = this.htSpacefill.get(f2);
        if (bS == null) {
            bS = new BS();
            this.htSpacefill.put(f2, bS);
        }
        bS.set(n);
    }

    private void setSpacefill() {
        int n = this.bsBondedPyMOL.nextSetBit(0);
        while (n >= 0 && n < this.atomMap.length) {
            int n2 = this.atomMap[n];
            if (n2 >= 0) {
                this.bsBondedJmol.set(n2);
            }
            n = this.bsBondedPyMOL.nextSetBit(n + 1);
        }
        for (Map.Entry<Float, BS> entry : this.htSpacefill.entrySet()) {
            float f = entry.getKey().floatValue();
            BS bS = entry.getValue();
            if (f < 0.0f) {
                bS.andNot(this.bsBondedJmol);
                f = -f;
            }
            if (bS.isEmpty()) continue;
            ModelSettings modelSettings = new ModelSettings(0, bS, null);
            modelSettings.rd = new RadiusData(null, f, RadiusData.EnumType.ABSOLUTE, EnumVdw.AUTO);
            this.modelSettings.addLast((Object)modelSettings);
        }
        this.htSpacefill.clear();
    }

    private void setSurface() {
        ModelSettings modelSettings;
        if (!this.allowSurface || this.isStateScript || this.bsModelAtoms.isEmpty()) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        BS bS = this.reps[2];
        BSUtil.andNot((BS)bS, (BS)this.bsNoSurface);
        if (!bS.isEmpty()) {
            modelSettings = new ModelSettings(24, bS, new String[]{this.branchNameID, this.getBooleanSetting(156) ? "FULLYLIT" : "FRONTLIT"});
            modelSettings.setSize(this.getFloatSetting(4));
            modelSettings.translucency = this.getFloatSetting(138);
            if (this.surfaceColor < 0) {
                modelSettings.setColors(this.colixes, 0.0f);
            } else {
                modelSettings.argb = PyMOL.getRGB(this.surfaceColor);
            }
            this.modelSettings.addLast((Object)modelSettings);
        }
        bS = this.reps[8];
        BSUtil.andNot((BS)bS, (BS)this.bsNoSurface);
        if (!bS.isEmpty()) {
            modelSettings = new ModelSettings(24, bS, new String[]{this.branchNameID, null});
            modelSettings.setSize(this.getFloatSetting(4));
            modelSettings.translucency = this.getFloatSetting(138);
            modelSettings.setColors(this.colixes, 0.0f);
            this.modelSettings.addLast((Object)modelSettings);
        }
    }

    private void setTrace(BS bS) {
        ModelSettings modelSettings;
        BS bS2 = BSUtil.copy((BS)this.bsNucleic);
        bS2.and(bS);
        if (!bS2.isEmpty() && this.cartoonLadderMode) {
            this.haveNucleicLadder = true;
            modelSettings = new ModelSettings(11, bS2, null);
            modelSettings.setColors(this.colixes, this.cartoonTranslucency);
            modelSettings.setSize(this.getFloatSetting(103) * 2.0f);
            this.modelSettings.addLast((Object)modelSettings);
            bS.andNot(bS2);
            if (bS.isEmpty()) {
                return;
            }
        }
        modelSettings = new ModelSettings(10, bS, null);
        modelSettings.setColors(this.colixes, this.cartoonTranslucency);
        modelSettings.setSize(this.getFloatSetting(103) * 2.0f);
        this.modelSettings.addLast((Object)modelSettings);
    }

    private void setPutty(BS bS) {
        float[] fArray = new float[]{this.getFloatSetting(378), this.getFloatSetting(377), this.getFloatSetting(382), this.getFloatSetting(379), this.getFloatSetting(380), this.getFloatSetting(381), this.getFloatSetting(581)};
        ModelSettings modelSettings = new ModelSettings(13, bS, fArray);
        modelSettings.setColors(this.colixes, this.cartoonTranslucency);
        this.modelSettings.addLast((Object)modelSettings);
    }

    private void setRibbon(BS bS) {
        float f = this.getFloatSetting(19);
        boolean bl = f > 1.0f;
        ModelSettings modelSettings = new ModelSettings(bl ? 10 : 9, bS, null);
        modelSettings.setColors(this.colixes, 0.0f);
        modelSettings.setSize(this.getFloatSetting(106) * (bl ? 0.1f : 0.05f));
        this.modelSettings.addLast((Object)modelSettings);
    }

    private void setCartoon(String string, int n, float f) {
        BS bS = BSUtil.copy((BS)this.ssMapAtom.get(string));
        if (bS == null) {
            return;
        }
        bS.and(this.reps[5]);
        if (bS.isEmpty()) {
            return;
        }
        ModelSettings modelSettings = new ModelSettings(11, bS, null);
        modelSettings.setColors(this.colixes, this.cartoonTranslucency);
        modelSettings.setSize(this.getFloatSetting(n) * f);
        this.modelSettings.addLast((Object)modelSettings);
    }

    private void cleanSingletonCartoons(BS bS) {
        BS bS2 = new BS();
        for (int i = 0; i < 2; ++i) {
            int n = 1;
            int n2 = Integer.MIN_VALUE;
            int n3 = Integer.MIN_VALUE;
            int n4 = Integer.MIN_VALUE;
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0) {
                if (!this.isSequential(n5, n2)) {
                    ++n;
                }
                if ((n4 = this.atomSetCollection.getAtom((int)n5).sequenceNumber) != n3) {
                    n3 = n4;
                    ++n;
                }
                if (i == 0) {
                    bS2.set(n);
                } else if (!bS2.get(n)) {
                    bS.clear(n5);
                }
                n2 = n5;
                n5 = bS.nextSetBit(n5 + 1);
            }
            if (i == 1) break;
            BS bS3 = new BS();
            int n6 = bS2.nextSetBit(0);
            while (n6 >= 0) {
                if (!bS2.get(n6 - 1) && !bS2.get(n6 + 1)) {
                    bS3.set(n6);
                }
                n6 = bS2.nextSetBit(n6 + 1);
            }
            bS2.andNot(bS3);
        }
    }

    private boolean isSequential(int n, int n2) {
        if (n == 0 || n2 < 0) {
            return false;
        }
        Atom atom = this.atomSetCollection.getAtom(n2);
        Atom atom2 = this.atomSetCollection.getAtom(n);
        return atom.chainID == atom2.chainID && atom.atomSetIndex == atom2.atomSetIndex;
    }

    private void setFrame() {
        BS bS;
        BS bS2 = bS = this.totalAtomCount > 0 ? BSUtil.newAndSetBit((int)0) : null;
        if (!this.allStates && this.isMovie) {
            this.modelSettings.addLast((Object)new ModelSettings(0x400000D0, bS, this.pymol.get("movie")));
        } else if (!this.allStates || this.isMovie) {
            this.modelSettings.addLast((Object)new ModelSettings(4115, bS, this.currentFrame));
        } else {
            this.modelSettings.addLast((Object)new ModelSettings(4115, bS, -1));
        }
    }

    private void setView(SB sB, JmolList<Object> jmolList) {
        float f;
        boolean bl;
        P3 p3 = PyMOLReader.pointAt(jmolList, 19, new P3());
        sB.append(";center ").append(Escape.eP((Tuple3f)p3));
        float f2 = this.getFloatSetting(152);
        float f3 = (float)Math.tan((double)(f2 / 2.0f) * Math.PI / 180.0);
        float f4 = 0.5f / f3;
        float f5 = f4 - 0.5f;
        String string = "100";
        float f6 = -PyMOLReader.floatAt(jmolList, 18);
        float f7 = f6 * f3 * 2.0f;
        boolean bl2 = bl = this.width == 0 || this.height == 0;
        if (bl) {
            this.width = this.viewer.getScreenWidth();
            this.height = this.viewer.getScreenHeight();
        }
        if ((f = (float)this.width * 1.0f / (float)this.height) < 1.0f) {
            string = "" + 100.0f / f;
        }
        float f8 = f6 / f7;
        float f9 = PyMOLReader.floatAt(jmolList, 22) / f7;
        float f10 = PyMOLReader.floatAt(jmolList, 23) / f7;
        int n = 50 + (int)((f8 - f9) * 100.0f);
        int n2 = 50 + (int)((f8 - f10) * 100.0f);
        sB.append(";set perspectiveDepth " + !this.getBooleanSetting(23));
        sB.append(";set cameraDepth " + f5);
        sB.append(";set rotationRadius " + f7 / 2.0f);
        sB.append(";zoom " + string + "; slab on; slab " + n + "; depth " + n2);
        sB.append(";rotate @{quaternion({").appendF(PyMOLReader.floatAt(jmolList, 0)).append(" ").appendF(PyMOLReader.floatAt(jmolList, 1)).append(" ").appendF(PyMOLReader.floatAt(jmolList, 2)).append("}{").appendF(PyMOLReader.floatAt(jmolList, 4)).append(" ").appendF(PyMOLReader.floatAt(jmolList, 5)).append(" ").appendF(PyMOLReader.floatAt(jmolList, 6)).append("})}");
        sB.append(";translate X ").appendF(PyMOLReader.floatAt(jmolList, 16)).append(" angstroms;");
        sB.append(";translate Y ").appendF(-PyMOLReader.floatAt(jmolList, 17)).append(" angstroms");
        boolean bl3 = this.getBooleanSetting(84);
        boolean bl4 = this.getBooleanSetting(88);
        if (bl3 && bl4) {
            float f11 = n2 - n;
            float f12 = this.getFloatSetting(192);
            sB.append(";set zShade true; set zshadePower 1;set zslab " + Math.min(100.0f, (float)n + f12 * f11) + "; set zdepth " + Math.max(n2, n2));
        } else if (bl3) {
            sB.append(";set zShade true; set zshadePower 1;set zslab " + (float)(n + n2) / 2.0f + "; set zdepth " + n2);
        } else {
            sB.append(";set zShade false");
        }
        sB.append(";set traceAlpha " + this.getBooleanSetting(111));
        sB.append(";set cartoonRockets " + this.cartoonRockets);
        if (this.cartoonRockets) {
            sB.append(";set rocketBarrels " + this.cartoonRockets);
        }
        sB.append(";set cartoonLadders " + this.haveNucleicLadder);
        sB.append(";set ribbonBorder " + this.getBooleanSetting(118));
        sB.append(";set cartoonFancy " + (!this.isMovie && !this.getBooleanSetting(118)));
        JmolList<Object> jmolList2 = PyMOLReader.listAt(this.settings, 6);
        Object object = jmolList2.get(2);
        if (jmolList2.get(1).equals(5)) {
            String string2 = "000000" + Integer.toHexString((Integer)object);
            object = "[x" + string2.substring(string2.length() - 6) + "]";
        }
        sB.append(";background " + object);
        if (this.isMovie) {
            sB.append(";animation mode loop");
        }
        sB.append(";");
    }

    public void finalizeModelSet(ModelSet modelSet, int n, int n2) {
        BS bS;
        BS bS2 = bS = this.haveTraceOrBackbone ? modelSet.getAtomBits(3145764, null) : null;
        if (this.modelSettings != null) {
            for (int i = 0; i < this.modelSettings.size(); ++i) {
                try {
                    ModelSettings modelSettings = (ModelSettings)this.modelSettings.get(i);
                    modelSettings.offset(n, n2);
                    modelSettings.createShape(modelSet, bS);
                    continue;
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
            }
        }
        this.viewer.setTrajectoryBs(BSUtil.newBitSet2((int)n, (int)modelSet.modelCount));
    }
}

