/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix4f;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.TriangleData;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

class SymmetryOperation
extends Matrix4f {
    String xyzOriginal;
    String xyz;
    boolean doNormalize = true;
    boolean isFinalized;
    int opId;
    private P3 atomTest;
    private P3 temp3;
    private static final String[] twelfths = new String[]{"0", "1/12", "1/6", "1/4", "1/3", "5/12", "1/2", "7/12", "2/3", "3/4", "5/6", "11/12"};

    SymmetryOperation(SymmetryOperation symmetryOperation, P3[] p3Array, int n, int n2, boolean bl) {
        this.doNormalize = bl;
        if (symmetryOperation == null) {
            this.opId = n2;
            return;
        }
        this.xyzOriginal = symmetryOperation.xyzOriginal;
        this.xyz = symmetryOperation.xyz;
        this.opId = symmetryOperation.opId;
        this.setM(symmetryOperation);
        this.doFinalize();
        if (bl) {
            this.setOffset(p3Array, n, n2);
        }
    }

    void doFinalize() {
        this.m03 /= 12.0f;
        this.m13 /= 12.0f;
        this.m23 /= 12.0f;
        this.isFinalized = true;
    }

    String getXyz(boolean bl) {
        return bl || this.xyzOriginal == null ? this.xyz : this.xyzOriginal;
    }

    void newPoint(P3 p3, P3 p32, int n, int n2, int n3) {
        if (this.temp3 == null) {
            this.temp3 = new P3();
        }
        this.temp3.setT(p3);
        this.transform2(this.temp3, this.temp3);
        p32.set(this.temp3.x + (float)n, this.temp3.y + (float)n2, this.temp3.z + (float)n3);
    }

    String dumpInfo() {
        return "\n" + this.xyz + "\ninternal matrix representation:\n" + this.toString();
    }

    static final String dumpSeitz(Matrix4f matrix4f) {
        return new SB().append("{\t").appendI((int)matrix4f.m00).append("\t").appendI((int)matrix4f.m01).append("\t").appendI((int)matrix4f.m02).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m03)).append("\t}\n").append("{\t").appendI((int)matrix4f.m10).append("\t").appendI((int)matrix4f.m11).append("\t").appendI((int)matrix4f.m12).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m13)).append("\t}\n").append("{\t").appendI((int)matrix4f.m20).append("\t").appendI((int)matrix4f.m21).append("\t").appendI((int)matrix4f.m22).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m23)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    static final String dumpCanonicalSeitz(Matrix4f matrix4f) {
        return new SB().append("{\t").appendI((int)matrix4f.m00).append("\t").appendI((int)matrix4f.m01).append("\t").appendI((int)matrix4f.m02).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m03 + 12.0f)).append("\t}\n").append("{\t").appendI((int)matrix4f.m10).append("\t").appendI((int)matrix4f.m11).append("\t").appendI((int)matrix4f.m12).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m13 + 12.0f)).append("\t}\n").append("{\t").appendI((int)matrix4f.m20).append("\t").appendI((int)matrix4f.m21).append("\t").appendI((int)matrix4f.m22).append("\t").append(SymmetryOperation.twelfthsOf(matrix4f.m23 + 12.0f)).append("\t}\n").append("{\t0\t0\t0\t1\t}\n").toString();
    }

    boolean setMatrixFromXYZ(String string) {
        if (string == null) {
            return false;
        }
        this.xyzOriginal = string;
        string = string.toLowerCase();
        float[] fArray = new float[16];
        boolean bl = string.startsWith("!");
        if (bl) {
            string = string.substring(1);
        }
        if (string.indexOf("xyz matrix:") == 0) {
            this.xyz = string;
            Parser.parseStringInfestedFloatArray(string, null, fArray);
            for (int i = 0; i < 16; ++i) {
                if (Float.isNaN(fArray[i])) {
                    return false;
                }
                float f = fArray[i];
                if (Math.abs(f) < 1.0E-5f) {
                    f = 0.0f;
                }
                if (i % 4 == 3) {
                    f = SymmetryOperation.normalizeTwelfths((f < 0.0f ? -1 : 1) * Math.round(Math.abs(f * 12.0f)), this.doNormalize);
                }
                fArray[i] = f;
            }
            fArray[15] = 1.0f;
            this.setA(fArray);
            this.isFinalized = true;
            if (bl) {
                this.invertM(this);
            }
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
            return true;
        }
        if (string.indexOf("[[") == 0) {
            string = string.replace('[', ' ').replace(']', ' ').replace(',', ' ');
            Parser.parseStringInfestedFloatArray(string, null, fArray);
            for (int i = 0; i < 16; ++i) {
                if (!Float.isNaN(fArray[i])) continue;
                return false;
            }
            this.setA(fArray);
            this.isFinalized = true;
            if (bl) {
                this.invertM(this);
            }
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, false, false, false);
            return true;
        }
        String string2 = SymmetryOperation.getMatrixFromString(string, fArray, this.doNormalize, false);
        if (string2 == null) {
            return false;
        }
        this.setA(fArray);
        if (bl) {
            this.invertM(this);
            this.xyz = SymmetryOperation.getXYZFromMatrix(this, true, false, false);
        } else {
            this.xyz = string2;
        }
        if (Logger.debugging) {
            Logger.debug("" + this);
        }
        return true;
    }

    static String getMatrixFromString(String string, float[] fArray, boolean bl, boolean bl2) {
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f = 0.0f;
        String string2 = "";
        int n4 = -1;
        float f2 = 1.0f;
        while (string.indexOf("x4") >= 0) {
            Logger.info("ignoring last parameter in " + string);
            string = string.substring(0, string.lastIndexOf(","));
            string = TextFormat.simpleReplace(string, "x1", "x");
            string = TextFormat.simpleReplace(string, "x2", "y");
            string = TextFormat.simpleReplace(string, "x3", "z");
        }
        string = string + ",";
        block13: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '\'': 
                case '{': 
                case '}': {
                    continue block13;
                }
                case '-': {
                    bl5 = true;
                    continue block13;
                }
                case '+': {
                    bl5 = false;
                    continue block13;
                }
                case '/': {
                    bl3 = true;
                    continue block13;
                }
                case 'X': 
                case 'x': {
                    int n5 = n = bl5 ? -1 : 1;
                    if (!bl2 || f == 0.0f) break;
                    n = (int)((float)n * f);
                    f = 0.0f;
                    break;
                }
                case 'Y': 
                case 'y': {
                    int n6 = n2 = bl5 ? -1 : 1;
                    if (!bl2 || f == 0.0f) break;
                    n2 = (int)((float)n2 * f);
                    f = 0.0f;
                    break;
                }
                case 'Z': 
                case 'z': {
                    int n7 = n3 = bl5 ? -1 : 1;
                    if (!bl2 || f == 0.0f) break;
                    n3 = (int)((float)n3 * f);
                    f = 0.0f;
                    break;
                }
                case ',': {
                    if (++n4 > 2) {
                        Logger.warn("Symmetry Operation? " + string);
                        return null;
                    }
                    int n8 = n4 * 4;
                    f = SymmetryOperation.normalizeTwelfths(f, bl);
                    fArray[n8++] = n;
                    fArray[n8++] = n2;
                    fArray[n8++] = n3;
                    fArray[n8] = f;
                    String string3 = "";
                    string3 = string3 + (n == 0 ? "" : (n < 0 ? "-x" : (string3.length() == 0 ? "x" : "+x")));
                    string3 = string3 + (n2 == 0 ? "" : (n2 < 0 ? "-y" : (string3.length() == 0 ? "y" : "+y")));
                    string3 = string3 + (n3 == 0 ? "" : (n3 < 0 ? "-z" : (string3.length() == 0 ? "z" : "+z")));
                    string3 = string3 + SymmetryOperation.xyzFraction(f, false, true);
                    string2 = string2 + (string2 == "" ? "" : ",") + string3;
                    if (n4 == 2) {
                        fArray[15] = 1.0f;
                        return string2;
                    }
                    n3 = 0;
                    n2 = 0;
                    n = 0;
                    f = 0.0f;
                    break;
                }
                case '.': {
                    bl4 = true;
                    f2 = 1.0f;
                    continue block13;
                }
                case '0': {
                    if (!bl4 && (bl3 || !bl2)) continue block13;
                }
                default: {
                    int n9 = c - 48;
                    if (bl4 && n9 >= 0 && n9 <= 9) {
                        f2 /= 10.0f;
                        if (f < 0.0f) {
                            bl5 = true;
                        }
                        f += f2 * (float)n9 * (float)(bl5 ? -1 : 1);
                        continue block13;
                    }
                    if (n9 >= 0 && n9 <= 9) {
                        if (bl3) {
                            f /= (float)n9;
                            break;
                        }
                        f = f * 10.0f + (float)((bl5 ? -1 : 1) * n9);
                        bl5 = false;
                        break;
                    }
                    Logger.warn("symmetry character?" + c);
                }
            }
            bl5 = false;
            bl3 = false;
            bl4 = false;
        }
        return null;
    }

    private static float normalizeTwelfths(float f, boolean bl) {
        f *= 12.0f;
        if (bl) {
            while (f > 6.0f) {
                f -= 12.0f;
            }
            while (f <= -6.0f) {
                f += 12.0f;
            }
        }
        return f;
    }

    static final String getXYZFromMatrix(Matrix4f matrix4f, boolean bl, boolean bl2, boolean bl3) {
        String string = "";
        float[] fArray = new float[4];
        for (int i = 0; i < 3; ++i) {
            matrix4f.getRow(i, fArray);
            String string2 = "";
            if (fArray[0] != 0.0f) {
                string2 = string2 + (fArray[0] < 0.0f ? "-" : "+") + "x";
            }
            if (fArray[1] != 0.0f) {
                string2 = string2 + (fArray[1] < 0.0f ? "-" : "+") + "y";
            }
            if (fArray[2] != 0.0f) {
                string2 = string2 + (fArray[2] < 0.0f ? "-" : "+") + "z";
            }
            if ((string2 = string2 + SymmetryOperation.xyzFraction(bl ? fArray[3] : fArray[3] * 12.0f, bl2, bl3)).length() > 0 && string2.charAt(0) == '+') {
                string2 = string2.substring(1);
            }
            string = string + "," + string2;
        }
        return string.substring(1);
    }

    private static final String twelfthsOf(float f) {
        int n;
        String string = "";
        int n2 = Math.round(f);
        if (n2 == 12) {
            return "1";
        }
        if (n2 == -12) {
            return "-1";
        }
        if (n2 < 0 && (n2 = -n2) % 12 != 0) {
            string = "-";
        }
        if ((n = n2 / 12) < 1) {
            return string + twelfths[n2 % 12];
        }
        int n3 = 0;
        switch (n2 % 12) {
            case 0: {
                return string + n;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: {
                n3 = 12;
                break;
            }
            case 2: 
            case 10: {
                n3 = 6;
                break;
            }
            case 3: 
            case 9: {
                n3 = 4;
                break;
            }
            case 4: 
            case 8: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
            }
        }
        return string + n2 * n3 / 12 + "/" + n3;
    }

    private static final String xyzFraction(float f, boolean bl, boolean bl2) {
        String string;
        if (bl) {
            for (f = (float)Math.round(f); f < 0.0f; f += 12.0f) {
            }
        } else if (bl2 && f > 6.0f) {
            f -= 12.0f;
        }
        return (string = SymmetryOperation.twelfthsOf(f)).charAt(0) == '0' ? "" : (f > 0.0f ? "+" + string : string);
    }

    private void setOffset(P3[] p3Array, int n, int n2) {
        int n3 = n;
        int n4 = n3 + n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.atomTest == null) {
            this.atomTest = new P3();
        }
        for (int i = n3; i < n4; ++i) {
            this.newPoint(p3Array[i], this.atomTest, 0, 0, 0);
            f += this.atomTest.x;
            f2 += this.atomTest.y;
            f3 += this.atomTest.z;
        }
        while ((double)f < -0.001 || (double)f >= (double)n2 + 0.001) {
            this.m03 += (float)(f < 0.0f ? 1 : -1);
            f += (float)(f < 0.0f ? n2 : -n2);
        }
        while ((double)f2 < -0.001 || (double)f2 >= (double)n2 + 0.001) {
            this.m13 += (float)(f2 < 0.0f ? 1 : -1);
            f2 += (float)(f2 < 0.0f ? n2 : -n2);
        }
        while ((double)f3 < -0.001 || (double)f3 >= (double)n2 + 0.001) {
            this.m23 += (float)(f3 < 0.0f ? 1 : -1);
            f3 += (float)(f3 < 0.0f ? n2 : -n2);
        }
    }

    private void transformCartesian(UnitCell unitCell, P3 p3) {
        unitCell.toFractional(p3, false);
        this.transform(p3);
        unitCell.toCartesian(p3, false);
    }

    V3[] rotateEllipsoid(P3 p3, V3[] v3Array, UnitCell unitCell, P3 p32, P3 p33) {
        V3[] v3Array2 = new V3[3];
        p33.setT(p3);
        this.transformCartesian(unitCell, p33);
        int n = v3Array.length;
        while (--n >= 0) {
            p32.setT(p3);
            p32.add(v3Array[n]);
            this.transformCartesian(unitCell, p32);
            v3Array2[n] = V3.newV(p32);
            v3Array2[n].sub(p33);
        }
        return v3Array2;
    }

    public Object[] getDescription(SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string) {
        if (!this.isFinalized) {
            this.doFinalize();
        }
        return SymmetryOperation.getDescription(this, this.xyzOriginal, symmetryInterface, p3, p32, string);
    }

    private static Object[] getDescription(SymmetryOperation symmetryOperation, String string, SymmetryInterface symmetryInterface, P3 p3, P3 p32, String string2) {
        float f;
        float f2;
        String string3;
        boolean bl;
        boolean bl2;
        V3 v3 = new V3();
        P3 p33 = new P3();
        P3 p34 = new P3();
        P3 p35 = new P3();
        P3 p36 = new P3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        String string4 = SymmetryOperation.getXYZFromMatrix(symmetryOperation, false, false, false);
        boolean bl3 = bl2 = string2 == null;
        if (p3 == null || Float.isNaN(p3.x)) {
            p3 = new P3();
        }
        if (p32 != null) {
            p34.setT(p3);
            p35.setT(p32);
            symmetryInterface.toUnitCell(p34, p33);
            symmetryInterface.toUnitCell(p35, p33);
            symmetryInterface.toFractional(p34, false);
            symmetryOperation.transform(p34);
            symmetryInterface.toCartesian(p34, false);
            symmetryInterface.toUnitCell(p34, p33);
            if (p34.distance(p35) > 0.1f) {
                return null;
            }
            p34.setT(p3);
            p35.setT(p32);
            symmetryInterface.toFractional(p34, false);
            symmetryInterface.toFractional(p35, false);
            symmetryOperation.transform(p34);
            v33.sub2(p35, p34);
            p34.set(0.0f, 0.0f, 0.0f);
            p35.set(0.0f, 0.0f, 0.0f);
        }
        p36.z = 1.0f;
        p35.y = 1.0f;
        p34.x = 1.0f;
        p34.add(p3);
        p35.add(p3);
        p36.add(p3);
        P3 p37 = P3.newP(p3);
        P3 p38 = P3.newP(p34);
        P3 p39 = P3.newP(p35);
        P3 p310 = P3.newP(p36);
        symmetryInterface.toFractional(p37, false);
        symmetryInterface.toFractional(p38, false);
        symmetryInterface.toFractional(p39, false);
        symmetryInterface.toFractional(p310, false);
        symmetryOperation.transform2(p37, p37);
        symmetryOperation.transform2(p38, p38);
        symmetryOperation.transform2(p39, p39);
        symmetryOperation.transform2(p310, p310);
        p37.add(v33);
        p38.add(v33);
        p39.add(v33);
        p310.add(v33);
        SymmetryOperation.approx(v33);
        symmetryInterface.toCartesian(p37, false);
        symmetryInterface.toCartesian(p38, false);
        symmetryInterface.toCartesian(p39, false);
        symmetryInterface.toCartesian(p310, false);
        V3 v34 = new V3();
        v34.sub2(p38, p37);
        V3 v35 = new V3();
        v35.sub2(p39, p37);
        V3 v36 = new V3();
        v36.sub2(p310, p37);
        v3.cross(v34, v35);
        boolean bl4 = bl = v3.dot(v36) < 0.0f;
        if (bl) {
            p38.scaleAdd2(-2.0f, v34, p38);
            p39.scaleAdd2(-2.0f, v35, p39);
            p310.scaleAdd2(-2.0f, v36, p310);
        }
        Object[] objectArray = (Object[])Measure.computeHelicalAxis(null, 135266306, p3, p37, Quaternion.getQuaternionFrame(p37, p38, p39).div(Quaternion.getQuaternionFrame(p3, p34, p35)));
        P3 p311 = (P3)objectArray[0];
        V3 v37 = (V3)objectArray[1];
        int n = (int)Math.abs(Parser.approx(((P3)objectArray[3]).x, 1.0f));
        float f3 = SymmetryOperation.approxF(((P3)objectArray[3]).y);
        if (bl) {
            p38.scaleAdd2(2.0f, v34, p38);
            p39.scaleAdd2(2.0f, v35, p39);
            p310.scaleAdd2(2.0f, v36, p310);
        }
        V3 v38 = V3.newV(p37);
        v38.sub(p3);
        if (v38.length() < 0.1f) {
            v38 = null;
        }
        P3 p312 = null;
        P3 p313 = null;
        P3 p314 = null;
        boolean bl5 = n == 0;
        boolean bl6 = !bl5;
        boolean bl7 = false;
        boolean bl8 = false;
        if (bl6 || bl) {
            v38 = null;
        }
        if (bl && bl5) {
            p313 = P3.newP(p3);
            p313.add(p37);
            p313.scale(0.5f);
            p312 = p37;
            bl7 = true;
        } else if (bl) {
            V3 v39 = f3 == 0.0f ? new V3() : v37;
            float f4 = 0.0f;
            switch (n) {
                case 60: {
                    f4 = 0.6666667f;
                    break;
                }
                case 120: {
                    f4 = 2.0f;
                    break;
                }
                case 90: {
                    f4 = 1.0f;
                    break;
                }
                case 180: {
                    p314 = new P3();
                    p314.setT(p3);
                    p314.add(v39);
                    p311.scaleAdd2(0.5f, v39, p3);
                    if (p314.distance(p37) > 0.1f) {
                        v38 = V3.newV(p37);
                        v38.sub(p314);
                        p33.setT(v38);
                        symmetryInterface.toFractional(p33, false);
                        v32.setT(p33);
                    } else {
                        v38 = null;
                    }
                    bl6 = false;
                    bl = false;
                    bl8 = true;
                }
            }
            if (f4 != 0.0f) {
                v3.setT(p3);
                v3.sub(p311);
                v3.add(p37);
                v3.sub(p311);
                v3.sub(v39);
                v3.scale(f4);
                p311.add(v3);
                p313 = new P3();
                p313.scaleAdd2(0.5f, v39, p311);
                p312 = new P3();
                p312.scaleAdd2(-2.0f, p313, p3);
                p312.scale(-1.0f);
            }
        } else if (v38 != null) {
            p33.setT(v38);
            symmetryInterface.toFractional(p33, false);
            if (SymmetryOperation.approxF(p33.x) == 1.0f) {
                p33.x = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.y) == 1.0f) {
                p33.y = 0.0f;
            }
            if (SymmetryOperation.approxF(p33.z) == 1.0f) {
                p33.z = 0.0f;
            }
            v32.setT(p33);
            symmetryInterface.toCartesian(p33, false);
            v38.setT(p33);
        }
        int n2 = n;
        SymmetryOperation.approx0(v37);
        if (bl6) {
            P3 p315 = new P3();
            v3.setT(v37);
            int n3 = n;
            if (bl) {
                p315.setT(p311);
                p315.add(v3);
                n3 = Math.round(Measure.computeTorsion(p312, p311, p315, p37, true));
            } else if (f3 == 0.0f) {
                p315.setT(p311);
                p33.scaleAdd2(1.0f, p315, v3);
                n3 = Math.round(Measure.computeTorsion(p3, p311, p33, p37, true));
            } else {
                p33.setT(p311);
                p33.add(v3);
                p315.scaleAdd2(0.5f, v3, p311);
                n3 = Math.round(Measure.computeTorsion(p3, p311, p33, p37, true));
            }
            if (n3 != 0) {
                n = n3;
            }
        }
        if (bl6 && !bl && f3 == 0.0f && (v37.z < 0.0f || v37.z == 0.0f && (v37.y < 0.0f || v37.y == 0.0f && v37.x < 0.0f))) {
            v37.scale(-1.0f);
            n = -n;
        }
        String string5 = "identity";
        SB sB = new SB();
        if (bl7) {
            p33.setT(p313);
            symmetryInterface.toFractional(p33, false);
            string5 = "inversion center|" + SymmetryOperation.fcoord(p33);
        } else if (bl6) {
            if (bl) {
                string5 = "" + 360 / n2 + "-bar axis";
            } else if (f3 != 0.0f) {
                string5 = "" + 360 / n2 + "-fold screw axis";
                p33.setT(v37);
                symmetryInterface.toFractional(p33, false);
                string5 = string5 + "|translation: " + SymmetryOperation.fcoord(p33);
            } else {
                string5 = "C" + 360 / n2 + " axis";
            }
        } else if (v38 != null) {
            string3 = " " + SymmetryOperation.fcoord(v32);
            if (bl5) {
                string5 = "translation:" + string3;
            } else if (bl8) {
                float f5 = SymmetryOperation.approxF(v32.x);
                f2 = SymmetryOperation.approxF(v32.y);
                f = SymmetryOperation.approxF(v32.z);
                string3 = " " + SymmetryOperation.fcoord(v32);
                string5 = f5 != 0.0f && f2 != 0.0f && f != 0.0f ? "d-" : (f5 != 0.0f && f2 != 0.0f || f2 != 0.0f && f != 0.0f || f != 0.0f && f5 != 0.0f ? "n-" : (f5 != 0.0f ? "a-" : (f2 != 0.0f ? "b-" : "c-")));
                string5 = string5 + "glide plane |translation:" + string3;
            }
        } else if (bl8) {
            string5 = "mirror plane";
        }
        if (bl && !bl7) {
            p33.setT(p313);
            symmetryInterface.toFractional(p33, false);
            string5 = string5 + "|inversion center at " + SymmetryOperation.fcoord(p33);
        }
        string3 = null;
        if (!bl2) {
            String string6 = "\ndraw ID " + string2 + "_";
            sB = new SB();
            sB.append("// " + string + "|" + string4 + "|" + string5 + "\n");
            sB.append(string6).append("* delete");
            SymmetryOperation.drawLine(sB, string6 + "frame1X", 0.15f, p3, p34, "red");
            SymmetryOperation.drawLine(sB, string6 + "frame1Y", 0.15f, p3, p35, "green");
            SymmetryOperation.drawLine(sB, string6 + "frame1Z", 0.15f, p3, p36, "blue");
            p33.setT(p38);
            p33.sub(p37);
            p33.scaleAdd2(0.9f, p33, p37);
            SymmetryOperation.drawLine(sB, string6 + "frame2X", 0.2f, p37, p33, "red");
            p33.setT(p39);
            p33.sub(p37);
            p33.scaleAdd2(0.9f, p33, p37);
            SymmetryOperation.drawLine(sB, string6 + "frame2Y", 0.2f, p37, p33, "green");
            p33.setT(p310);
            p33.sub(p37);
            p33.scaleAdd2(0.9f, p33, p37);
            SymmetryOperation.drawLine(sB, string6 + "frame2Z", 0.2f, p37, p33, "purple");
            if (bl6) {
                P3 p316 = new P3();
                String string7 = "red";
                n2 = n;
                f = 1.0f;
                v3.setT(v37);
                if (bl) {
                    p316.setT(p311);
                    p316.add(v3);
                    if (f3 == 0.0f) {
                        p316.setT(p313);
                        v3.scale(3.0f);
                        p33.scaleAdd2(-1.0f, v3, p311);
                        sB.append(string6).append("rotVector2 diameter 0.1 ").append(Escape.eP(p311)).append(Escape.eP(p33)).append(" color red");
                    }
                    f = p37.distance(p316);
                    sB.append(string6).append("rotLine1 ").append(Escape.eP(p316)).append(Escape.eP(p312)).append(" color red");
                    sB.append(string6).append("rotLine2 ").append(Escape.eP(p316)).append(Escape.eP(p37)).append(" color red");
                } else if (f3 == 0.0f) {
                    boolean bl9;
                    boolean bl10 = bl9 = p3.distance(p37) < 0.2f;
                    if (!bl9) {
                        sB.append(string6).append("rotLine1 ").append(Escape.eP(p3)).append(Escape.eP(p311)).append(" color red");
                        sB.append(string6).append("rotLine2 ").append(Escape.eP(p37)).append(Escape.eP(p311)).append(" color red");
                    }
                    v3.scale(3.0f);
                    p33.scaleAdd2(-1.0f, v3, p311);
                    sB.append(string6).append("rotVector2 diameter 0.1 ").append(Escape.eP(p311)).append(Escape.eP(p33)).append(" color red");
                    p316.setT(p311);
                    if (f3 == 0.0f && (double)p3.distance(p37) < 0.2) {
                        p316.scaleAdd2(0.5f, p316, v3);
                    }
                } else {
                    string7 = "orange";
                    sB.append(string6).append("rotLine1 ").append(Escape.eP(p3)).append(Escape.eP(p311)).append(" color red");
                    p33.setT(p311);
                    p33.add(v3);
                    sB.append(string6).append("rotLine2 ").append(Escape.eP(p37)).append(Escape.eP(p33)).append(" color red");
                    p316.scaleAdd2(0.5f, v3, p311);
                }
                p33.setT(p316);
                p33.add(v3);
                if (bl && f3 != 0.0f) {
                    sB.append(string6).append("rotRotLine1").append(Escape.eP(p316)).append(Escape.eP(p312)).append(" color red");
                    sB.append(string6).append("rotRotLine2").append(Escape.eP(p316)).append(Escape.eP(p37)).append(" color red");
                }
                sB.append(string6).append("rotRotArrow arrow width 0.10 scale " + f + " arc ").append(Escape.eP(p316)).append(Escape.eP(p33));
                if (bl) {
                    p33.setT(p312);
                } else {
                    p33.setT(p3);
                }
                if (p33.distance(p37) < 0.1f) {
                    p33.set((float)Math.random(), (float)Math.random(), (float)Math.random());
                }
                sB.append(Escape.eP(p33));
                p33.set(0.0f, n2, 0.0f);
                sB.append(Escape.eP(p33)).append(" color red");
                sB.append(string6).append("rotVector1 vector diameter 0.1 ").append(Escape.eP(p311)).append(Escape.eP(v3)).append("color ").append(string7);
            }
            if (bl8) {
                if ((double)p3.distance(p314) > 0.2) {
                    sB.append(string6).append("planeVector arrow ").append(Escape.eP(p3)).append(Escape.eP(p314)).append(" color indigo");
                }
                if (v38 != null) {
                    p33.scaleAdd2(-1.0f, p37, p38);
                    p33.add(p314);
                    SymmetryOperation.drawLine(sB, string6 + "planeFrameX", 0.15f, p314, p33, "translucent red");
                    p33.scaleAdd2(-1.0f, p37, p39);
                    p33.add(p314);
                    SymmetryOperation.drawLine(sB, string6 + "planeFrameY", 0.15f, p314, p33, "translucent green");
                    p33.scaleAdd2(-1.0f, p37, p310);
                    p33.add(p314);
                    SymmetryOperation.drawLine(sB, string6 + "planeFrameZ", 0.15f, p314, p33, "translucent blue");
                }
                String string8 = v38 == null ? "green" : "blue";
                v3.setT(v37);
                v3.normalize();
                f2 = -v3.x * p311.x - v3.y * p311.y - v3.z * p311.z;
                P4 p4 = P4.new4(v3.x, v3.y, v3.z, f2);
                JmolList<Object> jmolList = new JmolList<Object>();
                jmolList.addLast(symmetryInterface.getCanonicalCopy(1.05f));
                TriangleData.intersectPlane(p4, jmolList, 3);
                int n4 = jmolList.size();
                while (--n4 >= 0) {
                    P3[] p3Array = (P3[])jmolList.get(n4);
                    sB.append(string6).append("planep").appendI(n4).append(Escape.eP(p3Array[0])).append(Escape.eP(p3Array[1]));
                    if (p3Array.length == 3) {
                        sB.append(Escape.eP(p3Array[2]));
                    }
                    sB.append(" color translucent ").append(string8);
                }
                if (jmolList.size() == 0) {
                    p33.setT(p311);
                    p33.add(v37);
                    sB.append(string6).append("planeCircle scale 2.0 circle ").append(Escape.eP(p311)).append(Escape.eP(p33)).append(" color translucent ").append(string8).append(" mesh fill");
                }
            }
            if (bl) {
                sB.append(string6).append("invPoint diameter 0.4 ").append(Escape.eP(p313));
                sB.append(string6).append("invArrow arrow ").append(Escape.eP(p3)).append(Escape.eP(p312)).append(" color indigo");
                if (!bl7) {
                    p33.setT(p312);
                    p33.add(p3);
                    p33.sub(p34);
                    SymmetryOperation.drawLine(sB, string6 + "invFrameX", 0.15f, p312, p33, "translucent red");
                    p33.setT(p312);
                    p33.add(p3);
                    p33.sub(p35);
                    SymmetryOperation.drawLine(sB, string6 + "invFrameY", 0.15f, p312, p33, "translucent green");
                    p33.setT(p312);
                    p33.add(p3);
                    p33.sub(p36);
                    SymmetryOperation.drawLine(sB, string6 + "invFrameZ", 0.15f, p312, p33, "translucent blue");
                }
            }
            if (v38 != null) {
                if (p314 == null) {
                    p314 = P3.newP(p3);
                }
                sB.append(string6).append("transVector vector ").append(Escape.eP(p314)).append(Escape.eP(v38));
            }
            sB.append("\nvar pt00 = " + Escape.eP(p3));
            sB.append("\nvar p0 = " + Escape.eP(p37));
            sB.append("\nif (within(0.2,p0).length == 0) {");
            sB.append("\nvar set2 = within(0.2,p0.uxyz.xyz)");
            sB.append("\nif (set2) {");
            sB.append(string6).append("cellOffsetVector arrow @p0 @set2 color grey");
            sB.append(string6).append("offsetFrameX diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP(v34)).append("*0.9} color red");
            sB.append(string6).append("offsetFrameY diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP(v35)).append("*0.9} color green");
            sB.append(string6).append("offsetFrameZ diameter 0.20 @{set2.xyz} @{set2.xyz + ").append(Escape.eP(v36)).append("*0.9} color purple");
            sB.append("\n}}\n");
            string3 = sB.toString();
            sB = null;
            string6 = null;
        }
        if (v38 == null) {
            v32 = null;
        }
        if (bl6) {
            if (!bl && f3 != 0.0f) {
                v38 = V3.newV(v37);
                p33.setT(v38);
                symmetryInterface.toFractional(p33, false);
                v32 = V3.newV(p33);
            }
            if (!bl || f3 != 0.0f) {
                // empty if block
            }
        }
        if (bl8) {
            if (v38 != null) {
                // empty if block
            }
            n = 0;
        }
        if (bl) {
            if (bl7) {
                p311 = null;
                v37 = null;
                v38 = null;
                v32 = null;
            }
        } else if (bl5) {
            p311 = null;
            v37 = null;
        }
        if (v37 != null) {
            v37.normalize();
        }
        Matrix4f matrix4f = null;
        matrix4f = Matrix4f.newM(symmetryOperation);
        if (v33.length() != 0.0f) {
            matrix4f.m03 += v33.x;
            matrix4f.m13 += v33.y;
            matrix4f.m23 += v33.z;
        }
        string4 = SymmetryOperation.getXYZFromMatrix(matrix4f, false, false, false);
        return new Object[]{string4, string, string5, string3, SymmetryOperation.approx0(v32), SymmetryOperation.approx0(v38), SymmetryOperation.approx0(p313), SymmetryOperation.approx0(p311), SymmetryOperation.approx0(v37), n, matrix4f, v33};
    }

    private static void drawLine(SB sB, String string, float f, P3 p3, P3 p32, String string2) {
        sB.append(string).append(" diameter ").appendF(f).append(Escape.eP(p3)).append(Escape.eP(p32)).append(" color ").append(string2);
    }

    static String fcoord(Tuple3f tuple3f) {
        return SymmetryOperation.fc(tuple3f.x) + " " + SymmetryOperation.fc(tuple3f.y) + " " + SymmetryOperation.fc(tuple3f.z);
    }

    private static String fc(float f) {
        String string;
        float f2 = Math.abs(f);
        int n = (int)SymmetryOperation.approxF(f2 * 24.0f);
        String string2 = string = f < 0.0f ? "-" : "";
        if (n % 8 != 0) {
            return string + SymmetryOperation.twelfthsOf(n >> 1);
        }
        return n == 0 ? "0" : (n == 24 ? string + "1" : string + n / 8 + "/3");
    }

    private static Tuple3f approx0(Tuple3f tuple3f) {
        if (tuple3f != null) {
            if (Math.abs(tuple3f.x) < 1.0E-4f) {
                tuple3f.x = 0.0f;
            }
            if (Math.abs(tuple3f.y) < 1.0E-4f) {
                tuple3f.y = 0.0f;
            }
            if (Math.abs(tuple3f.z) < 1.0E-4f) {
                tuple3f.z = 0.0f;
            }
        }
        return tuple3f;
    }

    private static Tuple3f approx(Tuple3f tuple3f) {
        if (tuple3f != null) {
            tuple3f.x = SymmetryOperation.approxF(tuple3f.x);
            tuple3f.y = SymmetryOperation.approxF(tuple3f.y);
            tuple3f.z = SymmetryOperation.approxF(tuple3f.z);
        }
        return tuple3f;
    }

    private static float approxF(float f) {
        return Parser.approx(f, 100.0f);
    }

    public static void normalizeTranslation(Matrix4f matrix4f) {
        matrix4f.m03 = ((int)matrix4f.m03 + 12) % 12;
        matrix4f.m13 = ((int)matrix4f.m13 + 12) % 12;
        matrix4f.m23 = ((int)matrix4f.m23 + 12) % 12;
    }
}

