/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import org.jmol.util.BS;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.P3;
import org.jmol.viewer.Viewer;

public abstract class Object2d {
    public static final int POINTER_NONE = 0;
    public static final int POINTER_ON = 1;
    public static final int POINTER_BACKGROUND = 2;
    protected static final String[] hAlignNames = new String[]{"", "left", "center", "right", ""};
    public static final int ALIGN_NONE = 0;
    public static final int ALIGN_LEFT = 1;
    protected static final int ALIGN_CENTER = 2;
    protected static final int ALIGN_RIGHT = 3;
    protected static final String[] vAlignNames = new String[]{"xy", "top", "bottom", "middle"};
    public static final int VALIGN_XY = 0;
    protected static final int VALIGN_TOP = 1;
    protected static final int VALIGN_BOTTOM = 2;
    protected static final int VALIGN_MIDDLE = 3;
    public static final int VALIGN_XYZ = 4;
    public boolean isLabelOrHover;
    protected Viewer viewer;
    protected GData gdata;
    public P3 xyz;
    public String target;
    protected String script;
    public short colix;
    public short bgcolix;
    public int pointer;
    protected int align;
    public int valign;
    public int movableX;
    public int movableY;
    public int movableZ;
    protected int movableXPercent = Integer.MAX_VALUE;
    protected int movableYPercent = Integer.MAX_VALUE;
    public int movableZPercent = Integer.MAX_VALUE;
    protected int offsetX;
    protected int offsetY;
    public int z = 1;
    public int zSlab = Integer.MIN_VALUE;
    public float[] pymolOffset;
    protected int windowWidth;
    protected int windowHeight;
    protected boolean adjustForWindow;
    public float boxWidth;
    public float boxHeight;
    public float boxX;
    public float boxY;
    int modelIndex = -1;
    public boolean visible = true;
    public boolean hidden = false;
    public float[] boxXY = new float[5];
    protected float scalePixelsPerMicron;

    public float getScalePixelsPerMicron() {
        return this.scalePixelsPerMicron;
    }

    public void setScalePixelsPerMicron(float f) {
        this.scalePixelsPerMicron = f;
    }

    protected abstract void recalc();

    void setModel(int n) {
        this.modelIndex = n;
    }

    public void setVisibility(boolean bl) {
        this.visible = bl;
    }

    public void setXYZ(P3 p3) {
        this.valign = p3 == null ? 0 : 4;
        this.xyz = p3;
        this.setAdjustForWindow(p3 == null);
    }

    public void setAdjustForWindow(boolean bl) {
        this.adjustForWindow = bl;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    void setColixO(Object object) {
        this.colix = C.getColixO(object);
    }

    void setTranslucent(float f, boolean bl) {
        if (bl) {
            if (this.bgcolix != 0) {
                this.bgcolix = C.getColixTranslucent3(this.bgcolix, !Float.isNaN(f), f);
            }
        } else {
            this.colix = C.getColixTranslucent3(this.colix, !Float.isNaN(f), f);
        }
    }

    public void setBgColix(short s) {
        this.bgcolix = s;
    }

    void setBgColixO(Object object) {
        this.bgcolix = object == null ? (short)0 : C.getColixO(object);
    }

    private void setMovableX(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = n;
        this.movableXPercent = Integer.MAX_VALUE;
    }

    private void setMovableY(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = n;
        this.movableYPercent = Integer.MAX_VALUE;
    }

    public void setMovableXPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableX = Integer.MAX_VALUE;
        this.movableXPercent = n;
    }

    public void setMovableYPercent(int n) {
        this.valign = this.valign == 4 ? 4 : 0;
        this.movableY = Integer.MAX_VALUE;
        this.movableYPercent = n;
    }

    public void setMovableZPercent(int n) {
        if (this.valign != 4) {
            this.valign = 0;
        }
        this.movableZ = Integer.MAX_VALUE;
        this.movableZPercent = n;
    }

    public void setZs(int n, int n2) {
        this.z = n;
        this.zSlab = n2;
    }

    public void setXYZs(int n, int n2, int n3, int n4) {
        this.setMovableX(n);
        this.setMovableY(n2);
        this.setZs(n3, n4);
    }

    public void setScript(String string) {
        this.script = string == null || string.length() == 0 ? null : string;
    }

    public String getScript() {
        return this.script;
    }

    public void setOffset(int n) {
        this.offsetX = Object2d.getXOffset(n);
        this.offsetY = Object2d.getYOffset(n);
        this.valign = 0;
    }

    public static int getXOffset(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 32767: {
                return 0;
            }
        }
        return (int)((long)n << 48 >> 56);
    }

    public static int getYOffset(int n) {
        switch (n) {
            case 0: {
                return -4;
            }
            case 32767: {
                return 0;
            }
        }
        return -((int)((long)n << 56 >> 56));
    }

    boolean setAlignmentLCR(String string) {
        if ("left".equals(string)) {
            return this.setAlignment(1);
        }
        if ("center".equals(string)) {
            return this.setAlignment(2);
        }
        if ("right".equals(string)) {
            return this.setAlignment(3);
        }
        return false;
    }

    public boolean setAlignment(int n) {
        if (this.align != n) {
            this.align = n;
            this.recalc();
        }
        return true;
    }

    public static String getAlignmentName(int n) {
        return hAlignNames[n & 3];
    }

    public void setPointer(int n) {
        this.pointer = n;
    }

    public static String getPointer(int n) {
        return (n & 1) == 0 ? "" : ((n & 2) > 0 ? "background" : "on");
    }

    protected void setBoxOffsetsInWindow(float f, float f2, float f3) {
        float f4 = this.boxX;
        float f5 = this.boxWidth + f;
        if (f4 + f5 > (float)this.windowWidth) {
            f4 = (float)this.windowWidth - f5;
        }
        if (f4 < f) {
            f4 = f;
        }
        this.boxX = f4;
        float f6 = f3;
        float f7 = this.boxHeight;
        if (f6 + f7 > (float)this.windowHeight) {
            f6 = (float)this.windowHeight - f7;
        }
        if (f6 < f2) {
            f6 = f2;
        }
        this.boxY = f6;
    }

    public void setWindow(int n, int n2, float f) {
        this.windowWidth = n;
        this.windowHeight = n2;
        if (this.pymolOffset == null && this.scalePixelsPerMicron < 0.0f && f != 0.0f) {
            this.scalePixelsPerMicron = f;
        }
    }

    public boolean checkObjectClicked(int n, int n2, BS bS) {
        if (this.modelIndex >= 0 && !bS.get(this.modelIndex) || this.hidden) {
            return false;
        }
        if (this.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        return this.script != null && (float)n >= this.boxX && (float)n <= this.boxX + this.boxWidth && (float)n2 >= this.boxY && (float)n2 <= this.boxY + this.boxHeight;
    }

    public static boolean setProperty(String string, Object object, Object2d object2d) {
        if ("script" == string) {
            if (object2d != null) {
                object2d.setScript((String)object);
            }
            return true;
        }
        if ("xpos" == string) {
            if (object2d != null) {
                object2d.setMovableX((Integer)object);
            }
            return true;
        }
        if ("ypos" == string) {
            if (object2d != null) {
                object2d.setMovableY((Integer)object);
            }
            return true;
        }
        if ("%xpos" == string) {
            if (object2d != null) {
                object2d.setMovableXPercent((Integer)object);
            }
            return true;
        }
        if ("%ypos" == string) {
            if (object2d != null) {
                object2d.setMovableYPercent((Integer)object);
            }
            return true;
        }
        if ("%zpos" == string) {
            if (object2d != null) {
                object2d.setMovableZPercent((Integer)object);
            }
            return true;
        }
        if ("xypos" == string) {
            if (object2d == null) {
                return true;
            }
            P3 p3 = (P3)object;
            object2d.setXYZ(null);
            if (p3.z == Float.MAX_VALUE) {
                object2d.setMovableX((int)p3.x);
                object2d.setMovableY((int)p3.y);
            } else {
                object2d.setMovableXPercent((int)p3.x);
                object2d.setMovableYPercent((int)p3.y);
            }
            return true;
        }
        if ("xyz" == string) {
            if (object2d != null) {
                object2d.setXYZ((P3)object);
            }
            return true;
        }
        return false;
    }

    public static int getOffset(int n, int n2) {
        n = Math.min(Math.max(n, -127), 127);
        n2 = Math.min(Math.max(n2, -127), 127);
        return (n & 0xFF) << 8 | n2 & 0xFF;
    }
}

