/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeFileReader;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.SimpleUnitCell;

abstract class MapFileReader
extends VolumeFileReader {
    protected float dmin = Float.MAX_VALUE;
    protected float dmax;
    protected float dmean;
    protected float drange;
    protected int mapc;
    protected int mapr;
    protected int maps;
    protected int nx;
    protected int ny;
    protected int nz;
    protected int mode;
    protected int[] nxyzStart = new int[3];
    protected int na;
    protected int nb;
    protected int nc;
    protected float a;
    protected float b;
    protected float c;
    protected float alpha;
    protected float beta;
    protected float gamma;
    protected P3 origin = new P3();
    protected P3 adjustment = new P3();
    protected P3[] vectors = new P3[3];

    MapFileReader() {
    }

    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super.init2(surfaceGenerator, bufferedReader);
        this.isAngstroms = true;
        this.adjustment = surfaceGenerator.getParams().center;
        if (this.adjustment == null || this.adjustment.x == Float.MAX_VALUE) {
            this.adjustment = new P3();
        }
    }

    protected void getVectorsAndOrigin() {
        Logger.info("grid parameters: nx,ny,nz: " + this.nx + "," + this.ny + "," + this.nz);
        Logger.info("grid parameters: nxStart,nyStart,nzStart: " + this.nxyzStart[0] + "," + this.nxyzStart[1] + "," + this.nxyzStart[2]);
        Logger.info("grid parameters: mx,my,mz: " + this.na + "," + this.nb + "," + this.nc);
        Logger.info("grid parameters: a,b,c,alpha,beta,gamma: " + this.a + "," + this.b + "," + this.c + "," + this.alpha + "," + this.beta + "," + this.gamma);
        Logger.info("grid parameters: mapc,mapr,maps: " + this.mapc + "," + this.mapr + "," + this.maps);
        Logger.info("grid parameters: originX,Y,Z: " + this.origin);
        SimpleUnitCell simpleUnitCell = SimpleUnitCell.newA(new float[]{this.a / (float)this.na, this.b / (float)this.nb, this.c / (float)this.nc, this.alpha, this.beta, this.gamma});
        this.vectors[0] = P3.new3(1.0f, 0.0f, 0.0f);
        this.vectors[1] = P3.new3(0.0f, 1.0f, 0.0f);
        this.vectors[2] = P3.new3(0.0f, 0.0f, 1.0f);
        simpleUnitCell.toCartesian(this.vectors[0], false);
        simpleUnitCell.toCartesian(this.vectors[1], false);
        simpleUnitCell.toCartesian(this.vectors[2], false);
        Logger.info("Jmol unit cell vectors:");
        Logger.info("    a: " + this.vectors[0]);
        Logger.info("    b: " + this.vectors[1]);
        Logger.info("    c: " + this.vectors[2]);
        this.voxelCounts[0] = this.nz;
        this.voxelCounts[1] = this.ny;
        this.voxelCounts[2] = this.nx;
        this.volumetricVectors[0].setT(this.vectors[this.maps - 1]);
        this.volumetricVectors[1].setT(this.vectors[this.mapr - 1]);
        this.volumetricVectors[2].setT(this.vectors[this.mapc - 1]);
        if (this.origin.x == 0.0f && this.origin.y == 0.0f && this.origin.z == 0.0f) {
            int[] nArray = new int[3];
            nArray[this.mapc - 1] = 0;
            nArray[this.mapr - 1] = 1;
            nArray[this.maps - 1] = 2;
            int n = nArray[0];
            int n2 = nArray[1];
            int n3 = nArray[2];
            this.origin.scaleAdd2((float)this.nxyzStart[n] + this.adjustment.x, this.vectors[0], this.origin);
            this.origin.scaleAdd2((float)this.nxyzStart[n2] + this.adjustment.y, this.vectors[1], this.origin);
            this.origin.scaleAdd2((float)this.nxyzStart[n3] + this.adjustment.z, this.vectors[2], this.origin);
        }
        this.volumetricOrigin.setT(this.origin);
        Logger.info("Jmol grid origin in Cartesian coordinates: " + this.origin);
        Logger.info("Use  isosurface OFFSET {x y z}  if you want to shift it.\n");
    }

    protected void setCutoffAutomatic() {
        if (this.params.thePlane == null && this.params.cutoffAutomatic) {
            this.params.cutoff = -1.0f;
            Logger.info("MapReader: setting cutoff to default value of " + this.params.cutoff + (this.boundingBox == null ? " (no BOUNDBOX parameter)\n" : "\n"));
        }
    }
}

