/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import org.jmol.api.AtomIndexIterator;
import org.jmol.api.Interface;
import org.jmol.api.MepCalculationInterface;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.P3;

class AtomPropertyMapper
extends AtomDataReader {
    private MepCalculationInterface mepCalc;
    private String mepType;
    private int calcType = 0;
    private boolean doSmoothProperty;
    private AtomIndexIterator iter;
    private float smoothingPower;
    private int iAtomSurface;

    AtomPropertyMapper() {
    }

    void init(SurfaceGenerator surfaceGenerator) {
        super.init(surfaceGenerator);
        this.mepType = (String)surfaceGenerator.getReaderData();
    }

    protected void setup(boolean bl) {
        this.setup2();
        this.haveSurfaceAtoms = true;
        this.volumeData.sr = this;
        this.volumeData.doIterate = false;
        this.point = this.params.point;
        this.doSmoothProperty = this.params.propertySmoothing;
        this.doUseIterator = true;
        if (this.doSmoothProperty) {
            this.smoothingPower = this.params.propertySmoothingPower;
            if (this.smoothingPower < 0.0f) {
                this.smoothingPower = 0.0f;
            } else if (this.smoothingPower > 10.0f) {
                this.smoothingPower = 10.0f;
            }
            if (this.smoothingPower == 0.0f) {
                this.doSmoothProperty = false;
            }
            this.smoothingPower = (this.smoothingPower - 11.0f) / 2.0f;
        }
        this.maxDistance = this.params.propertyDistanceMax;
        if (this.mepType != null) {
            this.doSmoothProperty = true;
            if (this.params.mep_calcType >= 0) {
                this.calcType = this.params.mep_calcType;
            }
            this.mepCalc = (MepCalculationInterface)Interface.getOptionInterface("quantum." + this.mepType + "Calculation");
        }
        if (!this.doSmoothProperty && this.maxDistance == 2.1474836E9f) {
            this.maxDistance = 5.0f;
        }
        this.getAtoms(this.params.bsSelected, this.doAddHydrogens, true, false, false, true, false, Float.NaN);
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        if (!this.doSmoothProperty && this.meshData.vertexSource != null) {
            this.hasColorData = true;
            int n = this.meshData.vertexCount;
            while (--n >= 0) {
                int n2 = this.meshData.vertexSource[n];
                if (n2 >= 0) {
                    this.meshData.vertexValues[n] = this.params.theProperty[n2];
                    continue;
                }
                this.hasColorData = false;
                break;
            }
        }
        this.setHeader("property", this.params.calculationType);
        this.setRanges(this.params.solvent_ptsPerAngstrom, this.params.solvent_gridMax, 0.0f);
        this.params.cutoff = 0.0f;
    }

    protected void setVolumeData() {
        if (this.params.thePlane != null) {
            super.setVolumeData();
        }
    }

    protected void initializeMapping() {
        if (this.params.showTiming) {
            Logger.startTimer("property mapping");
        }
        if (this.bsNearby != null) {
            this.bsMySelected.or(this.bsNearby);
        }
        this.iter = this.atomDataServer.getSelectedAtomIterator(this.bsMySelected, false, false, false);
    }

    protected void finalizeMapping() {
        this.iter.release();
        this.iter = null;
        if (this.params.showTiming) {
            Logger.checkTimer("property mapping", false);
        }
    }

    protected void generateCube() {
    }

    public int getSurfaceAtomIndex() {
        return this.iAtomSurface;
    }

    public float getValueAtPoint(P3 p3, boolean bl) {
        if (this.haveOneProperty && !bl) {
            return this.theProperty;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = this.doSmoothProperty ? 0.0f : Float.NaN;
        float f4 = 0.0f;
        this.atomDataServer.setIteratorForPoint(this.iter, this.modelIndex, p3, this.maxDistance);
        this.iAtomSurface = -1;
        while (this.iter.hasNext()) {
            int n = this.iter.next();
            int n2 = this.myIndex[n];
            boolean bl2 = n2 >= this.firstNearbyAtom;
            P3 p32 = this.atomXyz[n2];
            float f5 = this.atomProp[n2];
            if (Float.isNaN(f5)) continue;
            float f6 = p3.distanceSquared(p32);
            if (bl2) {
                if (f6 < f2) {
                    f2 = f6;
                    if (!this.doSmoothProperty && f2 < f) {
                        f = f6;
                        f3 = Float.NaN;
                    }
                }
            } else if (f6 < f) {
                f = f6;
                this.iAtomSurface = n;
                if (!this.doSmoothProperty) {
                    f3 = f5;
                }
            }
            if (this.mepCalc != null) {
                f3 += this.mepCalc.valueFor(f5, f6, this.calcType);
                continue;
            }
            if (!this.doSmoothProperty) continue;
            f6 = (float)Math.pow(f6, this.smoothingPower);
            f4 += f6;
            f3 += f6 * f5;
        }
        return this.mepCalc != null ? f3 : (this.doSmoothProperty ? (f4 == 0.0f || f2 < f ? Float.NaN : f3 / f4) : f3);
    }
}

