/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.jmol.api.Interface;
import org.jmol.api.JmolDocument;
import org.jmol.api.ZInputStream;
import org.jmol.io.JmolBinary;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileReader {
    private final FileManager fm;
    private final Viewer viewer;
    private String fileNameIn;
    private String fullPathNameIn;
    private String nameAsGivenIn;
    private String fileTypeIn;
    private Object atomSetCollection;
    private Object reader;
    private Map<String, Object> htParams;
    private boolean isAppend;
    private byte[] bytes;

    public FileReader(FileManager fileManager, Viewer viewer, String string, String string2, String string3, String string4, Object object, Map<String, Object> map, boolean bl) {
        this.fm = fileManager;
        this.viewer = viewer;
        this.fileNameIn = string;
        this.fullPathNameIn = string2;
        this.nameAsGivenIn = string3;
        this.fileTypeIn = string4;
        this.reader = object instanceof BufferedReader ? object : (object instanceof Reader ? new BufferedReader((Reader)object) : null);
        this.bytes = Escape.isAB(object) ? (byte[])object : null;
        this.htParams = map;
        this.isAppend = bl;
    }

    public void run() {
        if (!this.isAppend && this.viewer.displayLoadErrors) {
            this.viewer.zap(false, true, false);
        }
        String string = null;
        Object object = null;
        if (this.reader == null) {
            boolean bl;
            if (this.fileTypeIn == null) {
                this.fileTypeIn = JmolBinary.getBinaryType(this.fullPathNameIn);
            }
            if ((object = this.fm.getUnzippedBufferedReaderOrErrorMessageFromName(this.fullPathNameIn, this.bytes, true, bl = JmolBinary.checkBinaryType(this.fileTypeIn), false, true)) == null || object instanceof String) {
                String string2 = string = object == null ? "error opening:" + this.nameAsGivenIn : (String)object;
                if (!string.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + string);
                }
                this.atomSetCollection = string;
                return;
            }
            if (object instanceof BufferedReader) {
                this.reader = object;
            } else if (object instanceof ZInputStream) {
                String string3 = this.fullPathNameIn;
                bl = JmolBinary.getBinaryType(string3) != null;
                String[] stringArray = null;
                if (string3.indexOf("|") >= 0 && !string3.endsWith(".zip")) {
                    stringArray = TextFormat.splitChars(string3, "|");
                    string3 = stringArray[0];
                }
                if (stringArray != null) {
                    this.htParams.put("subFileList", stringArray);
                }
                InputStream inputStream = (InputStream)object;
                String[] stringArray2 = this.fm.getZipDirectory(string3, true);
                this.atomSetCollection = object = JmolBinary.getAtomSetCollectionOrBufferedReaderFromZip(this.viewer.getModelAdapter(), inputStream, string3, stringArray2, this.htParams, false, bl);
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (object instanceof BufferedInputStream) {
            JmolDocument jmolDocument = (JmolDocument)Interface.getOptionInterface("io2.BinaryDocument");
            jmolDocument.setStream((BufferedInputStream)object, true);
            this.reader = jmolDocument;
        }
        if (this.reader != null) {
            this.atomSetCollection = this.viewer.getModelAdapter().getAtomSetCollectionReader(this.fullPathNameIn, this.fileTypeIn, this.reader, this.htParams);
            if (!(this.atomSetCollection instanceof String)) {
                this.atomSetCollection = this.viewer.getModelAdapter().getAtomSetCollection(this.atomSetCollection);
            }
            try {
                if (this.reader instanceof BufferedReader) {
                    ((BufferedReader)this.reader).close();
                } else if (this.reader instanceof JmolDocument) {
                    ((JmolDocument)this.reader).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.atomSetCollection instanceof String) {
            return;
        }
        if (!this.isAppend && !this.viewer.displayLoadErrors) {
            this.viewer.zap(false, true, false);
        }
        this.fm.fullPathName = this.fullPathNameIn;
        this.fm.nameAsGiven = this.nameAsGivenIn;
        this.fm.fileName = this.fileNameIn;
    }

    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

