/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import org.jmol.g3d.Graphics3D;

class Pixelator {
    protected final Graphics3D g;

    Pixelator(Graphics3D graphics3D) {
        this.g = graphics3D;
    }

    void clearPixel(int n, int n2) {
        if (!this.g.isPass2 && this.g.zbuf[n] > n2) {
            this.g.zbuf[n] = Integer.MAX_VALUE;
        }
    }

    void addPixel(int n, int n2, int n3) {
        this.addPixel1(n, n2, n3);
    }

    protected void addPixel1(int n, int n2, int n3) {
        if (!this.g.isPass2) {
            this.g.zbuf[n] = n2;
            this.g.pbuf[n] = n3;
            return;
        }
        int n4 = this.g.zbufT[n];
        if (n2 < n4) {
            int n5 = this.g.pbufT[n];
            if (!this.g.translucentCoverOnly && n5 != 0 && n4 - n2 > this.g.zMargin) {
                Graphics3D.mergeBufferPixel(this.g.pbuf, n, n5, this.g.bgcolor);
            }
            this.g.zbufT[n] = n2;
            this.g.pbufT[n] = n3 & this.g.translucencyMask;
        } else if (n2 != n4 && !this.g.translucentCoverOnly && n2 - n4 > this.g.zMargin) {
            Graphics3D.mergeBufferPixel(this.g.pbuf, n, n3 & this.g.translucencyMask, this.g.bgcolor);
        }
    }
}

