/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;

public class WebMOReader
extends MopacSlaterReader {
    private static String DS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String DC_LIST = "xx    yy    zz    xy    xz    yz";
    private static String FS_LIST = "NOT IMPLEMENTED IN THIS READER";
    private static String FC_LIST = "xxx   yyy   zzz   yyx   xxy   xxz   zzx   zzy   yyz   xyz";

    protected boolean checkLine() throws Exception {
        if (this.line.equals("[HEADER]")) {
            this.readHeader();
            return true;
        }
        if (this.line.equals("[ATOMS]")) {
            this.readAtoms();
            return false;
        }
        if (this.line.equals("[BONDS]")) {
            this.readBonds();
            return false;
        }
        if (!this.doReadMolecularOrbitals) {
            return true;
        }
        if (this.line.equals("[AO_ORDER]")) {
            this.readAtomicOrbitalOrder();
            return false;
        }
        if (this.line.equals("[GTO]")) {
            this.readGaussianBasis();
            return false;
        }
        if (this.line.equals("[STO]")) {
            this.readSlaterBasis();
            return false;
        }
        if (this.line.indexOf("[MO") == 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readMolecularOrbital();
            return false;
        }
        return true;
    }

    protected void finalizeReader() throws Exception {
        super.finalizeReader();
        if (this.nOrbitals > 0) {
            this.setMOs("eV");
        }
        if (Logger.debugging) {
            Logger.debug(this.orbitals.size() + " molecular orbitals read");
        }
    }

    void readHeader() throws Exception {
        this.moData.put("isNormalized", Boolean.TRUE);
        while (this.readLine() != null && this.line.length() > 0) {
            this.moData.put("calculationType", "?");
            String[] stringArray = this.getTokens();
            stringArray[0] = stringArray[0].substring(0, 1).toLowerCase() + stringArray[0].substring(1, stringArray[0].length());
            String string = "";
            for (int i = 1; i < stringArray.length; ++i) {
                string = string + (i == 1 ? "" : " ") + stringArray[i].toLowerCase();
            }
            this.moData.put(stringArray[0], string);
        }
    }

    void readAtoms() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            int n = this.parseIntStr(this.line);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = n == Integer.MIN_VALUE ? stringArray[0] : WebMOReader.getElementSymbol(n);
            this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[1]) * 0.5291772f, this.parseFloatStr(stringArray[2]) * 0.5291772f, this.parseFloatStr(stringArray[3]) * 0.5291772f);
        }
    }

    void readBonds() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            int n = this.parseIntStr(stringArray[0]);
            int n2 = this.parseIntStr(stringArray[1]);
            int n3 = this.parseIntStr(stringArray[2]);
            this.atomSetCollection.addBond(new Bond(n - 1, n2 - 1, n3));
        }
    }

    void readAtomicOrbitalOrder() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length == 0) continue;
            String string = this.line.substring(9).trim().toLowerCase();
            boolean bl = false;
            switch (stringArray.length - 1) {
                case 3: 
                case 4: {
                    bl = true;
                    break;
                }
                case 5: {
                    bl = stringArray[0].equals("DOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_D_SPHERICAL, DS_LIST, 99);
                    break;
                }
                case 6: {
                    bl = stringArray[0].equals("DOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_D_CARTESIAN, DC_LIST, 2);
                    break;
                }
                case 7: {
                    bl = stringArray[0].equals("FOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_F_SPHERICAL, FS_LIST, 99);
                    break;
                }
                case 10: {
                    boolean bl2 = bl = stringArray[0].equals("FOrbitals") && this.getDFMap(string, JmolAdapter.SHELL_F_CARTESIAN, FC_LIST, 3);
                }
            }
            if (bl) continue;
            Logger.error("atomic orbital order is unrecognized -- skipping reading of MOs due to line: " + this.line);
            this.orbitals = null;
        }
    }

    private boolean getLine() throws Exception {
        return this.readLine() != null && (this.line.length() == 0 || this.line.charAt(0) != '[');
    }

    void readGaussianBasis() throws Exception {
        Object object;
        JmolList<int[]> jmolList = new JmolList<int[]>();
        JmolList<float[]> jmolList2 = new JmolList<float[]>();
        int n = 0;
        int n2 = 0;
        while (this.getLine()) {
            object = this.getTokens();
            if (((String[])object).length == 0) continue;
            if (((String[])object).length != 1) {
                throw new Exception("Error reading GTOs: missing atom index");
            }
            int[] nArray = new int[4];
            n = this.parseIntStr(object[0]) - 1;
            object = WebMOReader.getTokensStr(this.readLine());
            int n3 = this.parseIntStr(object[1]);
            nArray[0] = n;
            nArray[1] = JmolAdapter.getQuantumShellTagID(object[0]);
            nArray[2] = n2;
            nArray[3] = n3;
            for (int i = 0; i < n3; ++i) {
                String[] stringArray = WebMOReader.getTokensStr(this.readLine());
                int n4 = stringArray.length;
                float[] fArray = new float[n4];
                for (int j = 0; j < n4; ++j) {
                    fArray[j] = this.parseFloatStr(stringArray[j]);
                }
                jmolList2.addLast(fArray);
                ++n2;
            }
            jmolList.addLast(nArray);
        }
        object = ArrayUtil.newFloat2(n2);
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])jmolList2.get(i);
        }
        this.moData.put("shells", jmolList);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug(jmolList.size() + " slater shells read");
            Logger.debug(((String[])object).length + " gaussian primitives read");
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
    }

    void readSlaterBasis() throws Exception {
        while (this.getLine()) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 7) continue;
            this.addSlater(this.parseIntStr(stringArray[0]) - 1, this.parseIntStr(stringArray[1]), this.parseIntStr(stringArray[2]), this.parseIntStr(stringArray[3]), this.parseIntStr(stringArray[4]), this.parseFloatStr(stringArray[5]), this.parseFloatStr(stringArray[6]));
        }
        this.setSlaters(false, false);
    }

    void readMolecularOrbital() throws Exception {
        Object[] objectArray;
        if (this.orbitals == null) {
            Logger.error("MOLECULAR ORBITALS SKIPPED");
            while (this.getLine()) {
            }
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        JmolList<String> jmolList = new JmolList<String>();
        float f = this.parseFloatStr(this.readLine());
        float f2 = this.parseFloatStr(this.readLine());
        while (this.getLine()) {
            objectArray = this.getTokens();
            if (objectArray.length == 0) continue;
            jmolList.addLast(objectArray[1]);
        }
        objectArray = new float[jmolList.size()];
        int n = jmolList.size();
        while (--n >= 0) {
            objectArray[n] = (String)this.parseFloatStr((String)jmolList.get(n));
        }
        hashtable.put("energy", Float.valueOf(f));
        hashtable.put("occupancy", Float.valueOf(f2));
        hashtable.put("coefficients", objectArray);
        this.orbitals.addLast(hashtable);
        ++this.nOrbitals;
        if (f2 > 0.0f) {
            this.moData.put("HOMO", this.nOrbitals);
        }
    }
}

