/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.SpartanSmolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.JmolAdapter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.V3;

class SpartanArchive {
    private int atomCount = 0;
    private String bondData;
    private int moCount = 0;
    private int coefCount = 0;
    private int shellCount = 0;
    private int gaussianCount = 0;
    private String endCheck;
    private BasisFunctionReader r;
    private int modelAtomCount;
    private String line;

    SpartanArchive(BasisFunctionReader basisFunctionReader) {
        this.initialize(basisFunctionReader, "");
    }

    SpartanArchive(BasisFunctionReader basisFunctionReader, String string, String string2) {
        this.initialize(basisFunctionReader, string);
        this.endCheck = string2;
    }

    private void initialize(BasisFunctionReader basisFunctionReader, String string) {
        this.r = basisFunctionReader;
        basisFunctionReader.moData.put("isNormalized", Boolean.TRUE);
        basisFunctionReader.moData.put("energyUnits", "");
        this.bondData = string;
    }

    int readArchive(String string, boolean bl, int n, boolean bl2) throws Exception {
        this.modelAtomCount = this.setInfo(string);
        this.line = bl ? "GEOMETRY" : "";
        boolean bl3 = false;
        while (this.line != null) {
            if (this.line.equals("GEOMETRY")) {
                this.readAtoms(n, bl2);
                if (bl2 && this.bondData.length() > 0) {
                    this.addBonds(this.bondData, n);
                }
            } else if (this.line.indexOf("BASIS") == 0) {
                this.readBasis();
            } else if (this.line.indexOf("WAVEFUNC") == 0 || this.line.indexOf("BETA") == 0) {
                if (this.r.doReadMolecularOrbitals) {
                    this.readMolecularOrbital();
                    bl3 = true;
                }
            } else if (this.line.indexOf("ENERGY") == 0) {
                this.readEnergy();
            } else if (this.line.equals("ENDARCHIVE") || this.endCheck != null && this.line.indexOf(this.endCheck) == 0) break;
            this.readLine();
        }
        if (bl3) {
            this.r.setMOData(this.r.moData);
        }
        return this.atomCount;
    }

    private void readEnergy() throws Exception {
        String[] stringArray = this.getTokens(this.readLine());
        float f = this.parseFloat(stringArray[0]);
        this.r.atomSetCollection.setAtomSetAuxiliaryInfo("energy", (Object)Float.valueOf(f));
        if (this.r instanceof SpartanSmolReader) {
            String string = ((SpartanSmolReader)this.r).constraints;
            this.r.atomSetCollection.setAtomSetName(string + (string.length() == 0 ? "" : " ") + "Energy=" + f + " KJ");
        }
        this.r.atomSetCollection.setAtomSetEnergy(stringArray[0], f);
    }

    private int setInfo(String string) throws Exception {
        String[] stringArray = this.getTokens(string);
        if (Logger.debugging) {
            Logger.debug((String)("reading Spartan archive info :" + string));
        }
        this.modelAtomCount = this.parseInt(stringArray[0]);
        this.coefCount = this.parseInt(stringArray[1]);
        this.shellCount = this.parseInt(stringArray[2]);
        this.gaussianCount = this.parseInt(stringArray[3]);
        this.moCount = this.parseInt(stringArray[6]);
        this.r.calculationType = stringArray[9];
        String string2 = (String)this.r.moData.get("calculationType");
        if (string2 == null) {
            string2 = this.r.calculationType;
        } else if (string2.indexOf(this.r.calculationType) < 0) {
            string2 = this.r.calculationType + string2;
        }
        this.r.calculationType = string2;
        this.r.moData.put("calculationType", this.r.calculationType);
        return this.modelAtomCount;
    }

    private void readAtoms(int n, boolean bl) throws Exception {
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String[] stringArray = this.getTokens(this.readLine());
            Atom atom = bl ? this.r.atomSetCollection.addNewAtom() : this.r.atomSetCollection.getAtom(n - this.modelAtomCount + i);
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol((int)this.parseInt(stringArray[0]));
            this.r.setAtomCoordXYZ(atom, this.parseFloat(stringArray[1]) * 0.5291772f, this.parseFloat(stringArray[2]) * 0.5291772f, this.parseFloat(stringArray[3]) * 0.5291772f);
        }
        if (bl && Logger.debugging) {
            Logger.debug((String)(this.atomCount + " atoms read"));
        }
    }

    void addBonds(String string, int n) {
        String[] stringArray = this.getTokens(string);
        int n2 = this.modelAtomCount;
        while (n2 < stringArray.length) {
            int n3;
            int n4 = this.parseInt(stringArray[n2++]) - 1 + n;
            int n5 = this.parseInt(stringArray[n2++]) - 1 + n;
            if ((n3 = this.parseInt(stringArray[n2++])) <= 0) continue;
            this.r.atomSetCollection.addBond(new Bond(n4, n5, n3 < 4 ? n3 : (n3 == 5 ? 515 : 1)));
        }
        n2 = this.r.atomSetCollection.getBondCount();
        if (Logger.debugging) {
            Logger.debug((String)(n2 + " bonds read"));
        }
    }

    void readBasis() throws Exception {
        int n;
        int n2;
        JmolList jmolList = new JmolList();
        float[][] fArray = ArrayUtil.newFloat2((int)this.gaussianCount);
        int[] nArray = new int[this.gaussianCount];
        for (n2 = 0; n2 < this.shellCount; ++n2) {
            String[] stringArray = this.getTokens(this.readLine());
            boolean bl = stringArray[4].charAt(0) == '1';
            int[] nArray2 = new int[4];
            nArray2[0] = this.parseInt(stringArray[3]) - 1;
            int n3 = this.parseInt(stringArray[0]);
            switch (n3) {
                case 0: {
                    n3 = JmolAdapter.SHELL_S;
                    break;
                }
                case 1: {
                    n3 = JmolAdapter.SHELL_SP;
                    break;
                }
                case 2: {
                    n3 = bl ? JmolAdapter.SHELL_D_SPHERICAL : JmolAdapter.SHELL_D_CARTESIAN;
                    break;
                }
                case 3: {
                    n3 = bl ? JmolAdapter.SHELL_F_SPHERICAL : JmolAdapter.SHELL_F_CARTESIAN;
                }
            }
            nArray2[1] = n3;
            int n4 = nArray2[2] = this.parseInt(stringArray[2]) - 1;
            int n5 = nArray2[3] = this.parseInt(stringArray[1]);
            for (int i = 0; i < n5; ++i) {
                nArray[n4 + i] = n3;
            }
            jmolList.addLast((Object)nArray2);
        }
        for (n2 = 0; n2 < this.gaussianCount; ++n2) {
            float f = this.parseFloat(this.readLine());
            String[] stringArray = this.getTokens(this.readLine());
            int n6 = stringArray.length;
            float[] fArray2 = new float[n6 + 1];
            fArray2[0] = f;
            switch (JmolAdapter.getShellEnumeration((int)nArray[n2])) {
                case S: {
                    fArray2[1] = this.parseFloat(stringArray[0]);
                    break;
                }
                case SP: {
                    fArray2[1] = this.parseFloat(stringArray[0]);
                    fArray2[2] = this.parseFloat(stringArray[1]);
                    if (fArray2[1] != 0.0f) break;
                    fArray2[1] = fArray2[2];
                    nArray[n2] = JmolAdapter.SHELL_P;
                    break;
                }
                case D_CARTESIAN: 
                case D_SPHERICAL: {
                    fArray2[1] = this.parseFloat(stringArray[2]);
                    break;
                }
                case F_CARTESIAN: 
                case F_SPHERICAL: {
                    fArray2[1] = this.parseFloat(stringArray[3]);
                }
            }
            fArray[n2] = fArray2;
        }
        n2 = 0;
        block28: for (n = 0; n < this.shellCount; ++n) {
            int[] nArray3 = (int[])jmolList.get(n);
            switch (JmolAdapter.getShellEnumeration((int)nArray[nArray3[2]])) {
                case S: {
                    ++n2;
                    continue block28;
                }
                case P: {
                    nArray3[1] = JmolAdapter.SHELL_P;
                    n2 += 3;
                    continue block28;
                }
                case SP: {
                    n2 += 4;
                    continue block28;
                }
                case D_SPHERICAL: {
                    n2 += 5;
                    continue block28;
                }
                case D_CARTESIAN: {
                    n2 += 6;
                    continue block28;
                }
                case F_SPHERICAL: {
                    n2 += 7;
                    continue block28;
                }
                case F_CARTESIAN: {
                    n2 += 10;
                }
            }
        }
        int n7 = n = n2 < this.coefCount ? 1 : 0;
        if (n != 0) {
            block29: for (int i = 0; i < this.shellCount; ++i) {
                int[] nArray4 = (int[])jmolList.get(i);
                switch (JmolAdapter.getShellEnumeration((int)nArray[i])) {
                    case D_CARTESIAN: {
                        nArray4[1] = JmolAdapter.SHELL_D_SPHERICAL;
                        continue block29;
                    }
                    case F_CARTESIAN: {
                        nArray4[1] = JmolAdapter.SHELL_F_SPHERICAL;
                    }
                }
            }
        }
        this.r.moData.put("shells", jmolList);
        this.r.moData.put("gaussians", fArray);
        if (Logger.debugging) {
            Logger.debug((String)(jmolList.size() + " slater shells read"));
            Logger.debug((String)(fArray.length + " gaussian primitives read"));
        }
    }

    void readMolecularOrbital() throws Exception {
        int n;
        int n2 = 0;
        this.r.orbitals = new JmolList();
        String[] stringArray = this.getTokens("");
        float[] fArray = new float[this.moCount];
        float[][] fArray2 = new float[this.moCount][this.coefCount];
        for (n = 0; n < this.moCount; ++n) {
            if (n2 == stringArray.length) {
                stringArray = this.getTokens(this.readLine());
                n2 = 0;
            }
            fArray[n] = this.parseFloat(stringArray[n2++]);
        }
        for (n = 0; n < this.moCount; ++n) {
            for (int i = 0; i < this.coefCount; ++i) {
                if (n2 == stringArray.length) {
                    stringArray = this.getTokens(this.readLine());
                    n2 = 0;
                }
                fArray2[n][i] = this.parseFloat(stringArray[n2++]);
            }
        }
        for (n = 0; n < this.moCount; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("energy", Float.valueOf(fArray[n]));
            hashtable.put("coefficients", fArray2[n]);
            this.r.setMO(hashtable);
        }
        if (Logger.debugging) {
            Logger.debug((String)(this.r.orbitals.size() + " molecular orbitals read"));
        }
        this.r.moData.put("mos", this.r.orbitals);
    }

    void readProperties() throws Exception {
        Logger.debug((String)"Reading PROPARC properties records...");
        while (this.readLine() != null && !this.line.startsWith("ENDPROPARC") && !this.line.startsWith("END Directory Entry ")) {
            if (this.line.startsWith("PROP")) {
                this.readProperty();
                continue;
            }
            if (this.line.startsWith("DIPOLE")) {
                this.readDipole();
                continue;
            }
            if (!this.line.startsWith("VIBFREQ")) continue;
            this.readVibFreqs();
        }
        this.setVibrationsFromProperties();
    }

    void readDipole() throws Exception {
        this.setDipole(this.getTokens(this.readLine()));
    }

    private void setDipole(String[] stringArray) {
        if (stringArray.length != 3) {
            return;
        }
        V3 v3 = V3.new3((float)this.parseFloat(stringArray[0]), (float)this.parseFloat(stringArray[1]), (float)this.parseFloat(stringArray[2]));
        this.r.atomSetCollection.setAtomSetAuxiliaryInfo("dipole", (Object)v3);
    }

    private void readProperty() throws Exception {
        String[] stringArray = this.getTokens(this.line);
        if (stringArray.length == 0) {
            return;
        }
        boolean bl = stringArray[1].startsWith("STRING");
        String string = stringArray[2];
        boolean bl2 = string.equals("DIPOLE_VEC");
        Object object = new Object();
        JmolList jmolList = new JmolList();
        if (stringArray[3].equals("=")) {
            object = bl ? this.getQuotedString(stringArray[4].substring(0, 1)) : Float.valueOf(this.parseFloat(stringArray[4]));
        } else if (stringArray[stringArray.length - 1].equals("BEGIN")) {
            int n = this.parseInt(stringArray[stringArray.length - 2]);
            if (n == 0) {
                n = 1;
            }
            boolean bl3 = stringArray.length == 6;
            JmolList jmolList2 = new JmolList();
            int n2 = 0;
            while (this.readLine() != null && !this.line.substring(0, 3).equals("END")) {
                if (bl) {
                    object = this.getQuotedString("\"");
                    jmolList.addLast(object);
                    continue;
                }
                String[] stringArray2 = this.getTokens(this.line);
                if (bl2) {
                    this.setDipole(stringArray2);
                }
                int n3 = 0;
                while (n3 < stringArray2.length) {
                    if (bl3) {
                        jmolList2.addLast((Object)Float.valueOf(this.parseFloat(stringArray2[n3])));
                        if ((n2 + 1) % n == 0) {
                            jmolList.addLast((Object)jmolList2);
                            jmolList2 = new JmolList();
                        }
                    } else {
                        object = Float.valueOf(this.parseFloat(stringArray2[n3]));
                        jmolList.addLast(object);
                    }
                    ++n3;
                    ++n2;
                }
            }
            object = null;
        } else if (Logger.debugging) {
            Logger.debug((String)(" Skipping property line " + this.line));
        }
        if (object != null) {
            this.r.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(string, object);
        }
        if (jmolList.size() != 0) {
            this.r.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(string, (Object)jmolList);
        }
    }

    void readVibFreqs() throws Exception {
        Object object;
        int n;
        this.readLine();
        String string = "";
        int n2 = this.parseInt(this.line);
        JmolList jmolList = new JmolList();
        JmolList jmolList2 = new JmolList();
        if (Logger.debugging) {
            Logger.debug((String)("reading VIBFREQ vibration records: frequencyCount = " + n2));
        }
        boolean[] blArray = new boolean[n2];
        for (n = 0; n < n2; ++n) {
            int n3 = this.r.atomSetCollection.getAtomCount();
            boolean bl = blArray[n] = !this.r.doGetVibration(n + 1);
            if (!blArray[n] && this.r.desiredVibrationNumber <= 0) {
                this.r.atomSetCollection.cloneLastAtomSet();
                this.addBonds(this.bondData, n3);
            }
            this.readLine();
            object = new Hashtable();
            float f = this.parseFloat(this.line);
            object.put("freq", Float.valueOf(f));
            if (this.line.length() > 15 && !(string = this.line.substring(15, this.line.length())).equals("???")) {
                object.put("label", string);
            }
            jmolList2.addLast(object);
            if (blArray[n]) continue;
            this.r.atomSetCollection.setAtomSetFrequency(null, string, "" + f, null);
        }
        this.r.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", (Object)jmolList2);
        n = this.r.atomSetCollection.getFirstAtomSetAtomCount();
        JmolList jmolList3 = new JmolList();
        object = new JmolList();
        int n4 = 0;
        int n5 = n;
        int n6 = 3;
        float[] fArray = new float[3];
        while (this.readLine() != null) {
            String[] stringArray = this.getTokens(this.line);
            for (int i = 0; i < stringArray.length; ++i) {
                float f;
                fArray[i % n6] = f = this.parseFloat(stringArray[i]);
                object.addLast((Object)Float.valueOf(f));
                if ((i + 1) % n6 != 0) continue;
                if (!blArray[n4]) {
                    this.r.atomSetCollection.addVibrationVector(n5, fArray[0], fArray[1], fArray[2]);
                    jmolList3.addLast(object);
                    object = new JmolList();
                }
                ++n5;
            }
            if (n5 % n != 0) continue;
            if (!blArray[n4]) {
                jmolList.addLast((Object)jmolList3);
            }
            jmolList3 = new JmolList();
            if (++n4 != n2) continue;
            break;
        }
        this.r.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", (Object)jmolList);
    }

    private void setVibrationsFromProperties() throws Exception {
        Object object;
        Float f;
        int n;
        int n2;
        JmolList jmolList = (JmolList)this.r.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_MODES");
        if (jmolList == null) {
            return;
        }
        JmolList jmolList2 = (JmolList)this.r.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_LAB");
        JmolList jmolList3 = (JmolList)this.r.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("FREQ_VAL");
        int n3 = jmolList3.size();
        JmolList jmolList4 = new JmolList();
        JmolList jmolList5 = new JmolList();
        if (Logger.debugging) {
            Logger.debug((String)("reading PROP VALUE:VIB FREQ_MODE vibration records: frequencyCount = " + n3));
        }
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.r.atomSetCollection.getAtomCount();
            this.r.atomSetCollection.cloneLastAtomSet();
            this.addBonds(this.bondData, n);
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            f = (Float)jmolList3.get(n2);
            hashtable.put("freq", f);
            float f2 = f.floatValue();
            object = (String)jmolList2.get(n2);
            if (!((String)object).equals("???")) {
                hashtable.put("label", object);
            }
            jmolList5.addLast(hashtable);
            this.r.atomSetCollection.setAtomSetName((String)object + " " + f2 + " cm^-1");
            this.r.atomSetCollection.setAtomSetModelProperty("Frequency", f2 + " cm^-1");
            this.r.atomSetCollection.setAtomSetModelProperty(".PATH", "Frequencies");
        }
        this.r.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", (Object)jmolList5);
        n = n2 = this.r.atomSetCollection.getFirstAtomSetAtomCount();
        for (int i = 0; i < n3; ++i) {
            if (!this.r.doGetVibration(i + 1)) continue;
            int n4 = 0;
            object = new JmolList();
            JmolList jmolList6 = (JmolList)jmolList.get(i);
            int n5 = 0;
            while (n5 < n2) {
                JmolList jmolList7 = new JmolList();
                f = (Float)jmolList6.get(n4++);
                float f3 = f.floatValue();
                jmolList7.addLast((Object)f);
                f = (Float)jmolList6.get(n4++);
                float f4 = f.floatValue();
                jmolList7.addLast((Object)f);
                f = (Float)jmolList6.get(n4++);
                float f5 = f.floatValue();
                jmolList7.addLast((Object)f);
                this.r.atomSetCollection.addVibrationVector(n, f3, f4, f5);
                object.addLast((Object)jmolList7);
                ++n5;
                ++n;
            }
            jmolList4.addLast(object);
        }
        this.r.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", (Object)jmolList4);
    }

    private String getQuotedString(String string) {
        int n = this.line.indexOf(string);
        int n2 = this.line.lastIndexOf(string);
        return n2 == n ? "" : this.line.substring(n + 1, n2);
    }

    private int parseInt(String string) {
        return this.r.parseIntStr(string);
    }

    private float parseFloat(String string) {
        return this.r.parseFloatStr(string);
    }

    private String[] getTokens(String string) {
        return AtomSetCollectionReader.getTokensStr((String)string);
    }

    private String readLine() throws Exception {
        this.line = this.r.readLine();
        return this.line;
    }
}

