/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.util.Map;
import org.jmol.io2.BinaryDocument;
import org.jmol.io2.CompoundDocDirEntry;
import org.jmol.io2.CompoundDocHeader;
import org.jmol.io2.ZipData;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundDocument
extends BinaryDocument {
    CompoundDocHeader header = new CompoundDocHeader(this);
    JmolList<CompoundDocDirEntry> directory = new JmolList();
    CompoundDocDirEntry rootEntry;
    int[] SAT;
    int[] SSAT;
    int sectorSize;
    int shortSectorSize;
    int nShortSectorsPerStandardSector;
    int nIntPerSector;
    int nDirEntriesperSector;
    SB data;

    public CompoundDocument() {
        this.isBigEndian = true;
    }

    @Override
    public void setStream(BufferedInputStream bufferedInputStream, boolean bl) {
        if (!this.isRandom) {
            this.stream = new DataInputStream(bufferedInputStream);
        }
        this.stream.mark(Integer.MAX_VALUE);
        if (!this.readHeader()) {
            return;
        }
        this.getSectorAllocationTable();
        this.getShortSectorAllocationTable();
        this.getDirectoryTable();
    }

    public JmolList<CompoundDocDirEntry> getDirectory() {
        return this.directory;
    }

    public String getDirectoryListing(String string) {
        String string2 = "";
        for (int i = 0; i < this.directory.size(); ++i) {
            CompoundDocDirEntry compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(i);
            if (compoundDocDirEntry.isEmpty) continue;
            string2 = string2 + string + compoundDocDirEntry.entryName + "\tlen=" + compoundDocDirEntry.lenStream + "\tSID=" + compoundDocDirEntry.SIDfirstSector + (compoundDocDirEntry.isStandard ? "\tfileOffset=" + this.getOffset(compoundDocDirEntry.SIDfirstSector) : "");
        }
        return string2;
    }

    public SB getAllData() {
        return this.getAllDataFiles(null, null);
    }

    @Override
    public void getAllDataMapped(String string, String string2, Map<String, String> map) {
        map.put("#Directory_Listing", this.getDirectoryListing("|"));
        string2 = "|" + string2 + "|";
        for (int i = 0; i < this.directory.size(); ++i) {
            boolean bl;
            CompoundDocDirEntry compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(i);
            if (compoundDocDirEntry.isEmpty || compoundDocDirEntry.entryType == 5) continue;
            String string3 = compoundDocDirEntry.entryName;
            Logger.info((String)("CompoundDocument file " + string3));
            boolean bl2 = bl = string2.indexOf("|" + string3 + "|") >= 0;
            if (bl) {
                string3 = string3 + ":asBinaryString";
            }
            SB sB = new SB();
            sB.append("BEGIN Directory Entry ").append(string3).append("\n");
            sB.appendSB(this.getEntryAsString(compoundDocDirEntry, bl));
            sB.append("\nEND Directory Entry ").append(string3).append("\n");
            map.put(string + "/" + string3, sB.toString());
        }
        this.close();
    }

    @Override
    public SB getAllDataFiles(String string, String string2) {
        CompoundDocDirEntry compoundDocDirEntry;
        int n;
        if (string2 != null) {
            for (n = 0; n < this.directory.size(); ++n) {
                compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(n);
                if (!compoundDocDirEntry.entryName.equals(string2)) continue;
                this.directory.remove(n);
                this.directory.add(1, (Object)compoundDocDirEntry);
                break;
            }
        }
        this.data = new SB();
        this.data.append("Compound Document File Directory: ");
        this.data.append(this.getDirectoryListing("|"));
        this.data.append("\n");
        string = "|" + string + "|";
        for (n = 0; n < this.directory.size(); ++n) {
            compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(n);
            Logger.info((String)("reading " + compoundDocDirEntry.entryName));
            if (compoundDocDirEntry.isEmpty || compoundDocDirEntry.entryType == 5) continue;
            String string3 = compoundDocDirEntry.entryName;
            if (string3.endsWith(".gz")) {
                string3 = string3.substring(0, string3.length() - 3);
            }
            this.data.append("BEGIN Directory Entry ").append(string3).append("\n");
            this.data.appendSB(this.getEntryAsString(compoundDocDirEntry, string.indexOf("|" + compoundDocDirEntry.entryName + "|") >= 0));
            this.data.append("\n");
            this.data.append("END Directory Entry ").append(compoundDocDirEntry.entryName).append("\n");
        }
        this.close();
        return this.data;
    }

    public SB getFileAsString(String string) {
        for (int i = 0; i < this.directory.size(); ++i) {
            CompoundDocDirEntry compoundDocDirEntry = (CompoundDocDirEntry)this.directory.get(i);
            if (!compoundDocDirEntry.entryName.equals(string)) continue;
            return this.getEntryAsString(compoundDocDirEntry, false);
        }
        return new SB();
    }

    private long getOffset(int n) {
        return (n + 1) * this.sectorSize;
    }

    private void gotoSector(int n) {
        this.seek(this.getOffset(n));
    }

    private boolean readHeader() {
        if (!this.header.readData()) {
            return false;
        }
        this.sectorSize = 1 << this.header.sectorPower;
        this.shortSectorSize = 1 << this.header.shortSectorPower;
        this.nShortSectorsPerStandardSector = this.sectorSize / this.shortSectorSize;
        this.nIntPerSector = this.sectorSize / 4;
        this.nDirEntriesperSector = this.sectorSize / 128;
        if (Logger.debugging) {
            Logger.debug((String)("compound document: revNum=" + this.header.revNumber + " verNum=" + this.header.verNumber + " isBigEndian=" + this.isBigEndian + " bytes per standard/short sector=" + this.sectorSize + "/" + this.shortSectorSize));
        }
        return true;
    }

    private void getSectorAllocationTable() {
        block9: {
            int n = 0;
            this.SAT = new int[this.header.nSATsectors * this.nIntPerSector + 109];
            try {
                int n2;
                int n3;
                for (n3 = 0; n3 < 109 && (n2 = this.header.MSAT0[n3]) >= 0; ++n3) {
                    this.gotoSector(n2);
                    for (int i = 0; i < this.nIntPerSector; ++i) {
                        this.SAT[n++] = this.readInt();
                    }
                }
                n3 = this.header.nAdditionalMATsectors;
                n2 = this.header.SID_MSAT_next;
                int[] nArray = new int[this.nIntPerSector];
                while (n3-- > 0 && n2 >= 0) {
                    int n4;
                    this.gotoSector(n2);
                    for (n4 = 0; n4 < this.nIntPerSector; ++n4) {
                        nArray[n4] = this.readInt();
                    }
                    for (n4 = 0; n4 < this.nIntPerSector - 1; ++n4) {
                        n2 = nArray[n4];
                        if (n2 >= 0) {
                            this.gotoSector(n2);
                            int n5 = this.nIntPerSector;
                            while (--n5 >= 0) {
                                this.SAT[n++] = this.readInt();
                            }
                            continue;
                        }
                        break block9;
                    }
                    n2 = nArray[this.nIntPerSector - 1];
                }
            }
            catch (Exception exception) {
                Logger.errorEx(null, (Throwable)exception);
            }
        }
    }

    private void getShortSectorAllocationTable() {
        int n = 0;
        int n2 = this.header.SID_SSAT_start;
        int n3 = this.header.nSSATsectors * this.nIntPerSector;
        this.SSAT = new int[n3];
        try {
            while (n2 > 0 && n < n3) {
                this.gotoSector(n2);
                for (int i = 0; i < this.nIntPerSector; ++i) {
                    this.SSAT[n++] = this.readInt();
                }
                n2 = this.SAT[n2];
            }
        }
        catch (Exception exception) {
            Logger.errorEx(null, (Throwable)exception);
        }
    }

    private void getDirectoryTable() {
        int n = this.header.SID_DIR_start;
        this.rootEntry = null;
        try {
            while (n > 0) {
                this.gotoSector(n);
                int n2 = this.nDirEntriesperSector;
                while (--n2 >= 0) {
                    CompoundDocDirEntry compoundDocDirEntry = new CompoundDocDirEntry(this);
                    compoundDocDirEntry.readData();
                    if (compoundDocDirEntry.lenStream > 0) {
                        this.directory.addLast((Object)compoundDocDirEntry);
                    }
                    if (compoundDocDirEntry.entryType != 5) continue;
                    this.rootEntry = compoundDocDirEntry;
                }
                n = this.SAT[n];
            }
        }
        catch (Exception exception) {
            Logger.errorEx(null, (Throwable)exception);
        }
        if (Logger.debugging) {
            Logger.debug((String)("CompoundDocument directory entry: \n" + this.getDirectoryListing("\n")));
        }
    }

    private SB getEntryAsString(CompoundDocDirEntry compoundDocDirEntry, boolean bl) {
        if (compoundDocDirEntry.isEmpty) {
            return new SB();
        }
        return compoundDocDirEntry.isStandard ? this.getStandardStringData(compoundDocDirEntry.SIDfirstSector, compoundDocDirEntry.lenStream, bl) : this.getShortStringData(compoundDocDirEntry.SIDfirstSector, compoundDocDirEntry.lenStream, bl);
    }

    private SB getStandardStringData(int n, int n2, boolean bl) {
        SB sB = new SB();
        byte[] byArray = new byte[this.sectorSize];
        ZipData zipData = new ZipData(n2);
        try {
            while (n > 0 && n2 > 0) {
                this.gotoSector(n);
                n2 = this.getSectorData(sB, byArray, this.sectorSize, n2, bl, zipData);
                n = this.SAT[n];
            }
            if (n2 == -9999) {
                return new SB();
            }
        }
        catch (Exception exception) {
            Logger.errorEx(null, (Throwable)exception);
        }
        if (zipData.isEnabled) {
            zipData.addTo(sB);
        }
        return sB;
    }

    private int getSectorData(SB sB, byte[] byArray, int n, int n2, boolean bl, ZipData zipData) throws Exception {
        this.readByteArray(byArray, 0, byArray.length);
        int n3 = zipData.addBytes(byArray, n, n2);
        if (n3 >= 0) {
            return n3;
        }
        if (bl) {
            for (int i = 0; i < n; ++i) {
                sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
                if (--n2 >= 1) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == 0) {
                    return -9999;
                }
                sB.appendC((char)byArray[i]);
                if (--n2 >= 1) {
                    continue;
                }
                break;
            }
        }
        return n2;
    }

    private SB getShortStringData(int n, int n2, boolean bl) {
        SB sB = new SB();
        if (this.rootEntry == null) {
            return sB;
        }
        int n3 = this.rootEntry.SIDfirstSector;
        int n4 = 0;
        byte[] byArray = new byte[this.shortSectorSize];
        ZipData zipData = new ZipData(n2);
        try {
            while (n3 >= 0 && n >= 0 && n2 > 0) {
                while (n - n4 >= this.nShortSectorsPerStandardSector) {
                    n4 += this.nShortSectorsPerStandardSector;
                    n3 = this.SAT[n3];
                }
                this.seek(this.getOffset(n3) + (long)((n - n4) * this.shortSectorSize));
                n2 = this.getSectorData(sB, byArray, this.shortSectorSize, n2, bl, zipData);
                n = this.SSAT[n];
            }
        }
        catch (Exception exception) {
            Logger.error((String)sB.toString());
            Logger.errorEx(null, (Throwable)exception);
        }
        if (zipData.isEnabled) {
            zipData.addTo(sB);
        }
        return sB;
    }
}

