/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.jmol.util.P3;

public class MdCrdReader
extends AtomSetCollectionReader {
    private int ptFloat = 0;
    private int lenLine = 0;

    protected void initializeReader() {
        this.initializeTrajectoryFile();
    }

    protected boolean checkLine() throws Exception {
        this.readCoordinates();
        Logger.info((String)("Total number of trajectory steps=" + this.trajectorySteps.size()));
        this.continuing = false;
        return false;
    }

    private void readCoordinates() throws Exception {
        this.line = null;
        int n = this.bsFilter == null ? this.templateAtomCount : (Integer)this.htParams.get("filteredAtomCount");
        boolean bl = this.htParams.containsKey("isPeriodic");
        int n2 = this.templateAtomCount * 3 + (bl ? 3 : 0);
        while (true) {
            if (this.doGetModel(++this.modelNumber, null)) {
                P3[] p3Array = new P3[n];
                if (!this.getTrajectoryStep(p3Array, bl)) {
                    return;
                }
                this.trajectorySteps.addLast((Object)p3Array);
                if (!this.isLastModel(this.modelNumber)) continue;
                return;
            }
            if (!this.skipFloats(n2)) break;
        }
    }

    private float getFloat() throws Exception {
        while (this.line == null || this.ptFloat >= this.lenLine) {
            if (this.readLine() == null) {
                return Float.NaN;
            }
            this.ptFloat = 0;
            this.lenLine = this.line.length();
        }
        this.ptFloat += 8;
        return this.parseFloatRange(this.line, this.ptFloat - 8, this.ptFloat);
    }

    private P3 getPoint() throws Exception {
        float f = this.getFloat();
        float f2 = this.getFloat();
        float f3 = this.getFloat();
        return Float.isNaN(f3) ? null : P3.new3((float)f, (float)f2, (float)f3);
    }

    private boolean getTrajectoryStep(P3[] p3Array, boolean bl) throws Exception {
        int n = p3Array.length;
        int n2 = -1;
        for (int i = 0; i < this.templateAtomCount; ++i) {
            P3 p3 = this.getPoint();
            if (p3 == null) {
                return false;
            }
            if (this.bsFilter != null && !this.bsFilter.get(i)) continue;
            if (++n2 == n) {
                return false;
            }
            p3Array[n2] = p3;
        }
        if (bl) {
            this.getPoint();
        }
        return this.line != null;
    }

    private boolean skipFloats(int n) throws Exception {
        for (int i = 0; i < n && this.readLine() != null; i += this.getTokens().length) {
        }
        return this.line != null;
    }
}

