/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class Parser {
    private static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f};
    private static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};

    public static int parseStringInfestedFloatArray(String string, BS bS, float[] fArray) {
        return Parser.parseFloatArrayBsData(Parser.getTokens(string), bS, fArray);
    }

    public static float[] parseFloatArray(String string) {
        return Parser.parseFloatArrayNext(string, new int[1], null, null, null);
    }

    public static float[] parseFloatArrayNext(String string, int[] nArray, float[] fArray, String string2, String string3) {
        int n = 0;
        int n2 = nArray[0];
        if (n2 >= 0) {
            int n3;
            if (string2 != null && (n3 = string.indexOf(string2, n2)) >= 0) {
                nArray[0] = n3 + string2.length();
            }
            string = string.substring(nArray[0]);
            int n4 = n2 = string3 == null ? -1 : string.indexOf(string3);
            if (n2 < 0) {
                n2 = string.length();
            } else {
                string = string.substring(0, n2);
            }
            nArray[0] = nArray[0] + (n2 + 1);
            String[] stringArray = Parser.getTokens(string);
            if (fArray == null) {
                fArray = new float[stringArray.length];
            }
            n = Parser.parseFloatArrayBsData(stringArray, null, fArray);
        }
        if (fArray == null) {
            return new float[0];
        }
        for (int i = n; i < fArray.length; ++i) {
            fArray[i] = Float.NaN;
        }
        return fArray;
    }

    public static int parseFloatArrayBsData(String[] stringArray, BS bS, float[] fArray) {
        int n;
        int n2 = fArray.length;
        int n3 = stringArray.length;
        int n4 = 0;
        int n5 = 0;
        boolean bl = bS != null;
        int n6 = n = bl ? bS.nextSetBit(0) : 0;
        while (n >= 0 && n < n2 && n4 < n3) {
            float f;
            while (Float.isNaN(f = Parser.parseFloatStr(stringArray[n4++])) && n4 < n3) {
            }
            if (!Float.isNaN(f)) {
                n5 = n;
                fArray[n5] = f;
            }
            if (n4 == n3) break;
            n = bl ? bS.nextSetBit(n + 1) : n + 1;
        }
        return n5 + 1;
    }

    private static String fixDataString(String string) {
        string = string.replace(';', string.indexOf(10) < 0 ? (char)'\n' : ' ');
        string = TextFormat.trim(string, "\n \t");
        string = TextFormat.simpleReplace(string, "\n ", "\n");
        string = TextFormat.simpleReplace(string, "\n\n", "\n");
        return string;
    }

    public static float[][] parseFloatArray2d(String string) {
        string = Parser.fixDataString(string);
        int[] nArray = Parser.markLines(string, '\n');
        int n = nArray.length;
        float[][] fArray = ArrayUtil.newFloat2(n);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            String[] stringArray = Parser.getTokens(string.substring(n3, nArray[n2]));
            fArray[n2] = new float[stringArray.length];
            Parser.parseFloatArrayData(stringArray, fArray[n2]);
            n3 = nArray[n2++];
        }
        return fArray;
    }

    public static float[][][] parseFloatArray3d(String string) {
        string = Parser.fixDataString(string);
        int[] nArray = Parser.markLines(string, '\n');
        int n = nArray.length;
        String[] stringArray = Parser.getTokens(string.substring(0, nArray[0]));
        if (stringArray.length != 3) {
            return new float[0][0][0];
        }
        int n2 = Parser.parseInt(stringArray[0]);
        int n3 = Parser.parseInt(stringArray[1]);
        int n4 = Parser.parseInt(stringArray[2]);
        if (n2 < 1 || n3 < 1 || n4 < 1) {
            return new float[1][1][1];
        }
        float[][][] fArray = ArrayUtil.newFloat3(n2, n3);
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        int n8 = nArray[0];
        while (n7 < n && n5 < n2) {
            stringArray = Parser.getTokens(string.substring(n8, nArray[n7]));
            if (stringArray.length >= n4) {
                float[] fArray2 = new float[stringArray.length];
                fArray[n5][n6] = fArray2;
                Parser.parseFloatArrayData(stringArray, fArray2);
                if (++n6 == n3) {
                    ++n5;
                    n6 = 0;
                }
            }
            n8 = nArray[n7++];
        }
        if (n5 != n2) {
            Logger.info("Error reading 3D data -- nX = " + n2 + ", but only " + n5 + " blocks read");
            return new float[1][1][1];
        }
        return fArray;
    }

    public static void setSelectedFloats(float f, BS bS, float[] fArray) {
        int n;
        boolean bl = bS == null;
        int n2 = n = bl ? 0 : bS.nextSetBit(0);
        while (n2 >= 0 && n2 < fArray.length) {
            fArray[n2] = f;
            n2 = bl ? n2 + 1 : bS.nextSetBit(n2 + 1);
        }
    }

    public static float[] extractData(String string, int n, int n2, int n3) {
        return Parser.parseFloatArrayFromMatchAndField(string, null, 0, 0, null, n, n2, null, n3);
    }

    public static float[] parseFloatArrayFromMatchAndField(String string, BS bS, int n, int n2, int[] nArray, int n3, int n4, float[] fArray, int n5) {
        boolean bl;
        int n6 = -1;
        boolean bl2 = nArray != null;
        int[] nArray2 = Parser.markLines(string, string.indexOf(10) >= 0 ? (char)'\n' : ';');
        int n7 = n5 <= 1 || n5 >= nArray2.length ? 0 : n5 - 1;
        int n8 = n7 == 0 ? 0 : nArray2[n7 - 1];
        int n9 = nArray2.length;
        if (fArray == null) {
            fArray = new float[n9 - n7];
        }
        int n10 = fArray.length;
        int n11 = n4 <= 0 ? Math.max(n3, n) : Math.max(n3 + n4, n + n2) - 1;
        boolean bl3 = bl = bS != null;
        while (n7 < n9) {
            block4: {
                float f;
                block6: {
                    int n12;
                    block5: {
                        String[] stringArray;
                        String string2 = string.substring(n8, nArray2[n7]).trim();
                        n8 = nArray2[n7];
                        String[] stringArray2 = stringArray = n4 <= 0 ? Parser.getTokens(string2) : null;
                        if (n4 > 0 ? string2.length() < n11 || Float.isNaN(f = Parser.parseFloatStr(string2.substring(n3 - 1, n3 + n4 - 1))) : stringArray.length < n11 || Float.isNaN(f = Parser.parseFloatStr(stringArray[n3 - 1]))) break block4;
                        if (!bl2) break block5;
                        n12 = Parser.parseInt(stringArray == null ? string2.substring(n - 1, n + n2 - 1) : stringArray[n - 1]);
                        if (n12 == Integer.MIN_VALUE || n12 < 0 || n12 >= n10 || (n12 = nArray[n12]) < 0) break block4;
                        if (bl) {
                            bS.set(n12);
                        }
                        break block6;
                    }
                    n6 = bl ? bS.nextSetBit(n6 + 1) : ++n6;
                    if (n6 < 0 || n6 >= n10) {
                        return fArray;
                    }
                    n12 = n6;
                }
                fArray[n12] = f;
            }
            ++n7;
        }
        return fArray;
    }

    public static void parseFloatArrayData(String[] stringArray, float[] fArray) {
        Parser.parseFloatArrayDataN(stringArray, fArray, fArray.length);
    }

    public static void parseFloatArrayDataN(String[] stringArray, float[] fArray, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            fArray[n2] = n2 >= stringArray.length ? Float.NaN : Parser.parseFloatStr(stringArray[n2]);
        }
    }

    public static float parseFloatStr(String string) {
        return Parser.parseFloatNext(string, new int[]{0});
    }

    public static float parseFloatStrict(String string) {
        int n = string.length();
        if (n == 0) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(string, n, new int[]{0}, true);
    }

    public static int parseInt(String string) {
        return Parser.parseIntNext(string, new int[]{0});
    }

    public static String[] getTokens(String string) {
        return Parser.getTokensAt(string, 0);
    }

    public static String parseToken(String string) {
        return Parser.parseTokenNext(string, new int[]{0});
    }

    public static String parseTrimmed(String string) {
        return Parser.parseTrimmedRange(string, 0, string.length());
    }

    public static String parseTrimmedAt(String string, int n) {
        return Parser.parseTrimmedRange(string, n, string.length());
    }

    public static String parseTrimmedRange(String string, int n, int n2) {
        int n3 = string.length();
        if (n2 < n3) {
            n3 = n2;
        }
        if (n3 < n) {
            return "";
        }
        return Parser.parseTrimmedChecked(string, n, n3);
    }

    public static int[] markLines(String string, char c) {
        int n = 0;
        int n2 = string.length();
        while (--n2 >= 0) {
            if (string.charAt(n2) != c) continue;
            ++n;
        }
        int[] nArray = new int[n + 1];
        nArray[n--] = string.length();
        int n3 = string.length();
        while (--n3 >= 0) {
            if (string.charAt(n3) != c) continue;
            nArray[n--] = n3 + 1;
        }
        return nArray;
    }

    public static float parseFloatNext(String string, int[] nArray) {
        int n = string.length();
        if (nArray[0] < 0 || nArray[0] >= n) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(string, n, nArray, false);
    }

    public static float parseFloatRange(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        if (nArray[0] < 0 || nArray[0] >= n) {
            return Float.NaN;
        }
        return Parser.parseFloatChecked(string, n, nArray, false);
    }

    private static float parseFloatChecked(String string, int n, int[] nArray, boolean bl) {
        int n2;
        int n3;
        boolean bl2 = false;
        float f = 0.0f;
        if (bl && string.indexOf(10) != string.lastIndexOf(10)) {
            return Float.NaN;
        }
        for (n3 = nArray[0]; n3 < n && Parser.isWhiteSpace(string, n3); ++n3) {
        }
        boolean bl3 = false;
        if (n3 < n && string.charAt(n3) == '-') {
            ++n3;
            bl3 = true;
        }
        char c = '\u0000';
        while (n3 < n && (c = string.charAt(n3)) >= '0' && c <= '9') {
            f = f * 10.0f + (float)(c - 48);
            ++n3;
            bl2 = true;
        }
        boolean bl4 = false;
        if (c == '.') {
            bl4 = true;
            n2 = 0;
            while (++n3 < n && (c = string.charAt(n3)) >= '0' && c <= '9') {
                if (n2 < decimalScale.length) {
                    f += (float)(c - 48) * decimalScale[n2];
                }
                ++n2;
                bl2 = true;
            }
        }
        n2 = 0;
        if (!bl2) {
            f = Float.NaN;
        } else if (bl3) {
            f = -f;
        }
        if (n3 < n && (c == 'E' || c == 'e' || c == 'D')) {
            n2 = 1;
            if (++n3 >= n) {
                return Float.NaN;
            }
            c = string.charAt(n3);
            if (c == '+' && ++n3 >= n) {
                return Float.NaN;
            }
            nArray[0] = n3;
            int n4 = Parser.parseIntChecked(string, n, nArray);
            if (n4 == Integer.MIN_VALUE) {
                return Float.NaN;
            }
            if (n4 > 0) {
                f = (float)((double)f * (n4 < tensScale.length ? (double)tensScale[n4 - 1] : Math.pow(10.0, n4)));
            } else if (n4 < 0) {
                f = (float)((double)f * (-n4 < decimalScale.length ? (double)decimalScale[-n4 - 1] : Math.pow(10.0, n4)));
            }
        } else {
            nArray[0] = n3;
        }
        if (f == Float.NEGATIVE_INFINITY) {
            f = -3.4028235E38f;
        } else if (f == Float.POSITIVE_INFINITY) {
            f = Float.MAX_VALUE;
        }
        return !bl || (n2 == 0 || bl4) && Parser.checkTrailingText(string, nArray[0], n) ? f : Float.NaN;
    }

    private static boolean checkTrailingText(String string, int n, int n2) {
        char c;
        while (n < n2 && ((c = string.charAt(n)) == ' ' || c == '\t' || c == '\n' || c == ';')) {
            ++n;
        }
        return n == n2;
    }

    public static int parseIntNext(String string, int[] nArray) {
        int n = string.length();
        if (nArray[0] < 0 || nArray[0] >= n) {
            return Integer.MIN_VALUE;
        }
        return Parser.parseIntChecked(string, n, nArray);
    }

    public static int parseIntRange(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        if (nArray[0] < 0 || nArray[0] >= n) {
            return Integer.MIN_VALUE;
        }
        return Parser.parseIntChecked(string, n, nArray);
    }

    private static int parseIntChecked(String string, int n, int[] nArray) {
        char c;
        boolean bl = false;
        int n2 = 0;
        int n3 = nArray[0];
        if (n3 < 0) {
            return Integer.MIN_VALUE;
        }
        while (n3 < n && Parser.isWhiteSpace(string, n3)) {
            ++n3;
        }
        boolean bl2 = false;
        if (n3 < n && string.charAt(n3) == '-') {
            bl2 = true;
            ++n3;
        }
        while (n3 < n && (c = string.charAt(n3)) >= '0' && c <= '9') {
            n2 = n2 * 10 + (c - 48);
            bl = true;
            ++n3;
        }
        if (!bl) {
            n2 = Integer.MIN_VALUE;
        } else if (bl2) {
            n2 = -n2;
        }
        nArray[0] = n3;
        return n2;
    }

    public static String[] getTokensAt(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n < 0 || n > n2) {
            return null;
        }
        int n3 = Parser.countTokens(string, n);
        String[] stringArray = new String[n3];
        int[] nArray = new int[]{n};
        for (int i = 0; i < n3; ++i) {
            stringArray[i] = Parser.parseTokenChecked(string, n2, nArray);
        }
        return stringArray;
    }

    private static int countTokens(String string, int n) {
        int n2 = 0;
        if (string != null) {
            int n3 = string.length();
            while (true) {
                if (n < n3 && Parser.isWhiteSpace(string, n)) {
                    ++n;
                    continue;
                }
                if (n == n3) break;
                ++n2;
                while (++n < n3 && !Parser.isWhiteSpace(string, n)) {
                }
            }
        }
        return n2;
    }

    public static String parseTokenNext(String string, int[] nArray) {
        int n = string.length();
        if (nArray[0] < 0 || nArray[0] >= n) {
            return null;
        }
        return Parser.parseTokenChecked(string, n, nArray);
    }

    public static String parseTokenRange(String string, int n, int[] nArray) {
        int n2 = string.length();
        if (n > n2) {
            n = n2;
        }
        if (nArray[0] < 0 || nArray[0] >= n) {
            return null;
        }
        return Parser.parseTokenChecked(string, n, nArray);
    }

    private static String parseTokenChecked(String string, int n, int[] nArray) {
        int n2;
        for (n2 = nArray[0]; n2 < n && Parser.isWhiteSpace(string, n2); ++n2) {
        }
        int n3 = n2;
        while (n2 < n && !Parser.isWhiteSpace(string, n2)) {
            ++n2;
        }
        nArray[0] = n2;
        if (n3 == n2) {
            return null;
        }
        return string.substring(n3, n2);
    }

    private static String parseTrimmedChecked(String string, int n, int n2) {
        int n3;
        while (n < n2 && Parser.isWhiteSpace(string, n)) {
            ++n;
        }
        for (n3 = n2 - 1; n3 >= n && Parser.isWhiteSpace(string, n3); --n3) {
        }
        if (n3 < n) {
            return "";
        }
        return string.substring(n, n3 + 1);
    }

    public static String concatTokens(String[] stringArray, int n, int n2) {
        String string = "";
        String string2 = "";
        for (int i = n; i < n2; ++i) {
            if (i >= stringArray.length) continue;
            string = string + string2 + stringArray[i];
            string2 = " ";
        }
        return string;
    }

    public static String getQuotedStringAt(String string, int n) {
        int[] nArray = new int[]{n};
        return Parser.getQuotedStringNext(string, nArray);
    }

    public static String getQuotedStringNext(String string, int[] nArray) {
        String string2 = string;
        int n = nArray[0];
        if (n < 0 || (n = string2.indexOf("\"", n)) < 0) {
            return "";
        }
        nArray[0] = ++n;
        string2 = string2.substring(n);
        n = -1;
        while (++n < string2.length() && string2.charAt(n) != '\"') {
            if (string2.charAt(n) != '\\') continue;
            ++n;
        }
        nArray[0] = nArray[0] + (n + 1);
        return string2.substring(0, n);
    }

    private static boolean isWhiteSpace(String string, int n) {
        char c;
        return n >= 0 && ((c = string.charAt(n)) == ' ' || c == '\t' || c == '\n');
    }

    public static boolean isOneOf(String string, String string2) {
        return string.indexOf(";") < 0 && (';' + string2 + ';').indexOf(';' + string + ';') >= 0;
    }

    public static String getQuotedAttribute(String string, String string2) {
        int n = string.indexOf(string2 + "=");
        return n < 0 ? null : Parser.getQuotedStringAt(string, n);
    }

    public static int parseIntRadix(String string, int n) throws NumberFormatException {
        return Integer.parseInt(string, n);
    }

    public static float approx(float f, float f2) {
        return (float)Math.round(f * f2) / f2;
    }

    public static double dVal(String string) throws NumberFormatException {
        return Double.valueOf(string);
    }

    public static float fVal(String string) throws NumberFormatException {
        return Float.valueOf(string).floatValue();
    }
}

