/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.util.JmolList;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.P4;
import org.jmol.util.Point3fi;
import org.jmol.util.TriangleData;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoxInfo {
    private final P3 bbCorner0 = new P3();
    private final P3 bbCorner1 = new P3();
    private final P3 bbCenter = new P3();
    private final V3 bbVector = new V3();
    private final Point3fi[] bbVertices = new Point3fi[8];
    private boolean isScaleSet;
    public static char[] bbcageTickEdges = new char[]{'z', '\u0000', '\u0000', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static char[] uccageTickEdges = new char[]{'z', 'y', 'x', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
    public static final byte[] edges = new byte[]{0, 1, 0, 2, 0, 4, 1, 3, 1, 5, 2, 3, 2, 6, 3, 7, 4, 5, 4, 6, 5, 7, 6, 7};
    public static final P3[] unitCubePoints = new P3[]{P3.new3(0.0f, 0.0f, 0.0f), P3.new3(0.0f, 0.0f, 1.0f), P3.new3(0.0f, 1.0f, 0.0f), P3.new3(0.0f, 1.0f, 1.0f), P3.new3(1.0f, 0.0f, 0.0f), P3.new3(1.0f, 0.0f, 1.0f), P3.new3(1.0f, 1.0f, 0.0f), P3.new3(1.0f, 1.0f, 1.0f)};
    private static P3i[] facePoints = new P3i[]{P3i.new3(4, 0, 6), P3i.new3(4, 6, 5), P3i.new3(5, 7, 1), P3i.new3(1, 3, 0), P3i.new3(6, 2, 7), P3i.new3(1, 0, 5)};
    public static final int[] toCanonical = new int[]{0, 3, 4, 7, 1, 2, 5, 6};
    protected static final P3i[] cubeVertexOffsets = new P3i[]{P3i.new3(0, 0, 0), P3i.new3(1, 0, 0), P3i.new3(1, 0, 1), P3i.new3(0, 0, 1), P3i.new3(0, 1, 0), P3i.new3(1, 1, 0), P3i.new3(1, 1, 1), P3i.new3(0, 1, 1)};
    private static final P3[] unitBboxPoints = new P3[8];

    public BoxInfo() {
        int n = 8;
        while (--n >= 0) {
            this.bbVertices[n] = new Point3fi();
        }
        for (n = 0; n < 8; ++n) {
            BoxInfo.unitBboxPoints[n] = P3.new3(-1.0f, -1.0f, -1.0f);
            unitBboxPoints[n].scaleAdd2(2.0f, unitCubePoints[n], unitBboxPoints[n]);
        }
        this.reset();
    }

    public JmolList<Object> intersectPlane(P4 p4, float f, int n) {
        JmolList<Object> jmolList = new JmolList<Object>();
        jmolList.addLast(this.getCanonicalCopy(f));
        return TriangleData.intersectPlane(p4, jmolList, n);
    }

    public P3[] getCanonicalCopy(float f) {
        return BoxInfo.getCanonicalCopy(this.bbVertices, f);
    }

    public static final P3[] getCanonicalCopy(P3[] p3Array, float f) {
        P3[] p3Array2 = new P3[8];
        for (int i = 0; i < 8; ++i) {
            p3Array2[BoxInfo.toCanonical[i]] = P3.newP(p3Array[i]);
        }
        BoxInfo.scaleBox(p3Array2, f);
        return p3Array2;
    }

    public static void scaleBox(P3[] p3Array, float f) {
        int n;
        if (f == 0.0f || f == 1.0f) {
            return;
        }
        P3 p3 = new P3();
        V3 v3 = new V3();
        for (n = 0; n < 8; ++n) {
            p3.add(p3Array[n]);
        }
        p3.scale(0.125f);
        for (n = 0; n < 8; ++n) {
            v3.sub2(p3Array[n], p3);
            v3.scale(f);
            p3Array[n].add2(p3, v3);
        }
    }

    public static P4[] getFacesFromCriticalPoints(P3[] p3Array) {
        int n;
        P4[] p4Array = new P4[6];
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        P3 p3 = new P3();
        P3 p32 = new P3();
        P3 p33 = new P3();
        P3[] p3Array2 = new P3[8];
        for (n = 0; n < 8; ++n) {
            p3Array2[n] = P3.newP(p3Array[0]);
            if ((n & 1) == 1) {
                p3Array2[n].add(p3Array[1]);
            }
            if ((n & 2) == 2) {
                p3Array2[n].add(p3Array[2]);
            }
            if ((n & 4) != 4) continue;
            p3Array2[n].add(p3Array[3]);
        }
        for (n = 0; n < 6; ++n) {
            p3.setT(p3Array2[BoxInfo.facePoints[n].x]);
            p32.setT(p3Array2[BoxInfo.facePoints[n].y]);
            p33.setT(p3Array2[BoxInfo.facePoints[n].z]);
            p4Array[n] = new P4();
            Measure.getPlaneThroughPoints(p3, p32, p33, v3, v32, v33, p4Array[n]);
        }
        return p4Array;
    }

    public static final P3[] getCriticalPoints(P3[] p3Array, Tuple3f tuple3f) {
        P3 p3 = P3.newP(p3Array[0]);
        P3 p32 = P3.newP(p3Array[1]);
        P3 p33 = P3.newP(p3Array[2]);
        P3 p34 = P3.newP(p3Array[4]);
        p32.sub(p3);
        p33.sub(p3);
        p34.sub(p3);
        if (tuple3f != null) {
            p3.add(tuple3f);
        }
        return new P3[]{p3, p32, p33, p34};
    }

    public P3 getBoundBoxCenter() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbCenter;
    }

    public V3 getBoundBoxCornerVector() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbVector;
    }

    public P3[] getBoundBoxPoints(boolean bl) {
        P3[] p3Array;
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        if (bl) {
            P3[] p3Array2 = new P3[4];
            p3Array2[0] = this.bbCenter;
            p3Array2[1] = P3.newP(this.bbVector);
            p3Array2[2] = this.bbCorner0;
            p3Array = p3Array2;
            p3Array2[3] = this.bbCorner1;
        } else {
            P3[] p3Array3 = new P3[2];
            p3Array3[0] = this.bbCorner0;
            p3Array = p3Array3;
            p3Array3[1] = this.bbCorner1;
        }
        return p3Array;
    }

    public Point3fi[] getBboxVertices() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return this.bbVertices;
    }

    public Map<String, Object> getBoundBoxInfo() {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("center", P3.newP(this.bbCenter));
        hashtable.put("vector", V3.newV(this.bbVector));
        hashtable.put("corner0", P3.newP(this.bbCorner0));
        hashtable.put("corner1", P3.newP(this.bbCorner1));
        return hashtable;
    }

    public void setBoundBox(P3 p3, P3 p32, boolean bl, float f) {
        if (p3 != null) {
            if (f == 0.0f) {
                return;
            }
            if (bl) {
                if (p3.distance(p32) == 0.0f) {
                    return;
                }
                this.bbCorner0.set(Math.min(p3.x, p32.x), Math.min(p3.y, p32.y), Math.min(p3.z, p32.z));
                this.bbCorner1.set(Math.max(p3.x, p32.x), Math.max(p3.y, p32.y), Math.max(p3.z, p32.z));
            } else {
                if (p32.x == 0.0f || p32.y == 0.0f && p32.z == 0.0f) {
                    return;
                }
                this.bbCorner0.set(p3.x - p32.x, p3.y - p32.y, p3.z - p32.z);
                this.bbCorner1.set(p3.x + p32.x, p3.y + p32.y, p3.z + p32.z);
            }
        }
        this.setBbcage(f);
    }

    public void reset() {
        this.isScaleSet = false;
        this.bbCorner0.set(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.bbCorner1.set(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
    }

    public void addBoundBoxPoint(P3 p3) {
        this.isScaleSet = false;
        BoxInfo.addPoint(p3, this.bbCorner0, this.bbCorner1, 0.0f);
    }

    public static void addPoint(P3 p3, P3 p32, P3 p33, float f) {
        if (p3.x - f < p32.x) {
            p32.x = p3.x - f;
        }
        if (p3.x + f > p33.x) {
            p33.x = p3.x + f;
        }
        if (p3.y - f < p32.y) {
            p32.y = p3.y - f;
        }
        if (p3.y + f > p33.y) {
            p33.y = p3.y + f;
        }
        if (p3.z - f < p32.z) {
            p32.z = p3.z - f;
        }
        if (p3.z + f > p33.z) {
            p33.z = p3.z + f;
        }
    }

    public static void addPointXYZ(float f, float f2, float f3, P3 p3, P3 p32, float f4) {
        if (f - f4 < p3.x) {
            p3.x = f - f4;
        }
        if (f + f4 > p32.x) {
            p32.x = f + f4;
        }
        if (f2 - f4 < p3.y) {
            p3.y = f2 - f4;
        }
        if (f2 + f4 > p32.y) {
            p32.y = f2 + f4;
        }
        if (f3 - f4 < p3.z) {
            p3.z = f3 - f4;
        }
        if (f3 + f4 > p32.z) {
            p32.z = f3 + f4;
        }
    }

    public void setBbcage(float f) {
        this.isScaleSet = true;
        this.bbCenter.add2(this.bbCorner0, this.bbCorner1);
        this.bbCenter.scale(0.5f);
        this.bbVector.sub2(this.bbCorner1, this.bbCenter);
        if (f > 0.0f) {
            this.bbVector.scale(f);
        } else {
            this.bbVector.x -= f / 2.0f;
            this.bbVector.y -= f / 2.0f;
            this.bbVector.z -= f / 2.0f;
        }
        int n = 8;
        while (--n >= 0) {
            Point3fi point3fi = this.bbVertices[n];
            point3fi.setT(unitBboxPoints[n]);
            point3fi.x *= this.bbVector.x;
            point3fi.y *= this.bbVector.y;
            point3fi.z *= this.bbVector.z;
            point3fi.add(this.bbCenter);
        }
        this.bbCorner0.setT(this.bbVertices[0]);
        this.bbCorner1.setT(this.bbVertices[7]);
    }

    public boolean isWithin(P3 p3) {
        if (!this.isScaleSet) {
            this.setBbcage(1.0f);
        }
        return p3.x >= this.bbCorner0.x && p3.x <= this.bbCorner1.x && p3.y >= this.bbCorner0.y && p3.y <= this.bbCorner1.y && p3.z >= this.bbCorner0.z && p3.z <= this.bbCorner1.z;
    }
}

