/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.util.BS;

class BondIteratorSelected
implements BondIterator {
    private Bond[] bonds;
    private int bondCount;
    private int bondType;
    private int iBond;
    private BS bsSelected;
    private boolean bondSelectionModeOr;

    BondIteratorSelected(Bond[] bondArray, int n, int n2, BS bS, boolean bl) {
        this.bonds = bondArray;
        this.bondCount = n;
        this.bondType = n2;
        this.bsSelected = bS;
        this.bondSelectionModeOr = bl;
    }

    public boolean hasNext() {
        if (this.bondType == 131071) {
            this.iBond = this.bsSelected.nextSetBit(this.iBond);
            return this.iBond >= 0 && this.iBond < this.bondCount;
        }
        while (this.iBond < this.bondCount) {
            Bond bond = this.bonds[this.iBond];
            if (!(this.bondType != 65535 && (bond.order & this.bondType) == 0 || this.bondType == 65535 && (bond.order & 0x8000) != 0)) {
                boolean bl = this.bsSelected.get(bond.atom1.index);
                boolean bl2 = this.bsSelected.get(bond.atom2.index);
                if (!this.bondSelectionModeOr && bl && bl2 || this.bondSelectionModeOr && (bl || bl2)) {
                    return true;
                }
            }
            ++this.iBond;
        }
        return false;
    }

    public int nextIndex() {
        return this.iBond;
    }

    public Bond next() {
        return this.bonds[this.iBond++];
    }
}

