/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.Calculations;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.util.JmolList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CalculationsUFF
extends Calculations {
    private Map<Object, FFParam> ffParams;
    protected FFParam parA;
    protected FFParam parB;
    protected FFParam parC;
    public static final int PAR_R = 0;
    public static final int PAR_THETA = 1;
    public static final int PAR_X = 2;
    public static final int PAR_D = 3;
    public static final int PAR_ZETA = 4;
    public static final int PAR_Z = 5;
    public static final int PAR_V = 6;
    public static final int PAR_U = 7;
    public static final int PAR_XI = 8;
    public static final int PAR_HARD = 9;
    public static final int PAR_RADIUS = 10;
    DistanceCalc bondCalc;
    AngleCalc angleCalc;
    TorsionCalc torsionCalc;
    OOPCalc oopCalc;
    VDWCalc vdwCalc;
    static final double KCAL332 = 1390.2842991599998;
    static final double KCAL644 = 2696.8016159999997;
    static final double KCAL6 = 25.1208;
    static final double KCAL22 = 92.1096;
    static final double KCAL44 = 184.2192;

    CalculationsUFF(ForceField forceField, Map<Object, FFParam> map, MinAtom[] minAtomArray, MinBond[] minBondArray, MinAngle[] minAngleArray, MinTorsion[] minTorsionArray, JmolList<Object[]> jmolList) {
        super(forceField, minAtomArray, minBondArray, minAngleArray, minTorsionArray, jmolList);
        this.ffParams = map;
        this.bondCalc = new DistanceCalc();
        this.angleCalc = new AngleCalc();
        this.torsionCalc = new TorsionCalc();
        this.oopCalc = new OOPCalc();
        this.vdwCalc = new VDWCalc();
    }

    @Override
    String getUnits() {
        return "kJ";
    }

    @Override
    boolean setupCalculations() {
        DistanceCalc distanceCalc = new DistanceCalc();
        JmolList<Object> jmolList = this.calculations[0] = new JmolList<Object[]>();
        for (int i = 0; i < this.bondCount; ++i) {
            MinBond minBond = this.minBonds[i];
            double d = minBond.order;
            if (minBond.isAromatic) {
                d = 1.5;
            }
            if (minBond.isAmide) {
                d = 1.41;
            }
            distanceCalc.setData(jmolList, minBond.data[0], minBond.data[1], d);
        }
        this.calculations[1] = new JmolList();
        jmolList = this.calculations[1];
        AngleCalc angleCalc = new AngleCalc();
        int n = this.minAngles.length;
        while (--n >= 0) {
            angleCalc.setData(jmolList, this.minAngles[n].data);
        }
        this.calculations[3] = new JmolList();
        jmolList = this.calculations[3];
        TorsionCalc torsionCalc = new TorsionCalc();
        int n2 = this.minTorsions.length;
        while (--n2 >= 0) {
            torsionCalc.setData(jmolList, this.minTorsions[n2].data);
        }
        this.calculations[4] = new JmolList();
        jmolList = this.calculations[4];
        OOPCalc oOPCalc = new OOPCalc();
        for (int i = 0; i < this.atomCount; ++i) {
            short s;
            MinAtom minAtom = this.minAtoms[i];
            if (minAtom.nBonds != 3 || !CalculationsUFF.isInvertible(s = minAtom.atom.getElementNumber())) continue;
            oOPCalc.setData(jmolList, i, s);
        }
        this.calculations[5] = new JmolList<Object[]>();
        this.pairSearch(this.calculations[5], new VDWCalc(), null, null);
        return true;
    }

    private static boolean isInvertible(int n) {
        switch (n) {
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 33: 
            case 51: 
            case 83: {
                return true;
            }
        }
        return false;
    }

    static double calculateR0(double d, double d2, double d3, double d4, double d5) {
        double d6 = -0.1332 * (d + d2) * Math.log(d5);
        double d7 = Math.sqrt(d3) - Math.sqrt(d4);
        double d8 = d * d2 * d7 * d7 / (d3 * d + d4 * d2);
        return d + d2 + d6 - d8;
    }

    @Override
    double compute(int n, Object[] objectArray) {
        switch (n) {
            case 0: {
                return this.bondCalc.compute(objectArray);
            }
            case 1: {
                return this.angleCalc.compute(objectArray);
            }
            case 3: {
                return this.torsionCalc.compute(objectArray);
            }
            case 4: {
                return this.oopCalc.compute(objectArray);
            }
            case 5: {
                return this.vdwCalc.compute(objectArray);
            }
        }
        return 0.0;
    }

    FFParam getParameter(Object object) {
        return this.ffParams.get(object);
    }

    @Override
    String getDebugHeader(int n) {
        switch (n) {
            case -1: {
                return "Universal Force Field -- Rappe, A. K., et. al.; J. Am. Chem. Soc. (1992) 114(25) p. 10024-10035\n";
            }
        }
        return this.getDebugHeader2(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VDWCalc
    extends Calculations.PairCalc {
        VDWCalc() {
        }

        @Override
        void setData(JmolList<Object[]> jmolList, int n, int n2) {
            this.a = CalculationsUFF.this.minAtoms[n];
            this.b = CalculationsUFF.this.minAtoms[n2];
            FFParam fFParam = CalculationsUFF.this.getParameter(this.a.sType);
            FFParam fFParam2 = CalculationsUFF.this.getParameter(this.b.sType);
            double d = fFParam.dVal[2];
            double d2 = fFParam.dVal[3];
            double d3 = fFParam2.dVal[2];
            double d4 = fFParam2.dVal[3];
            double d5 = 4.1868 * Math.sqrt(d2 * d4);
            double d6 = Math.sqrt(d * d3);
            jmolList.addLast(new Object[]{new int[]{n, n2}, new double[]{d6, d5}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = this.dData[0];
            double d2 = this.dData[1];
            CalculationsUFF.this.setPairVariables(this);
            double d3 = d / this.rab;
            double d4 = d3 * d3 * d3;
            d4 *= d4;
            this.energy = d2 * d4 * (d4 - 2.0);
            if (CalculationsUFF.this.gradients) {
                this.dE = d2 * 12.0 * (1.0 - d4) * d4 * d3 / d;
                CalculationsUFF.this.addForces(this, 2);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(5, this));
            }
            return this.energy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OOPCalc
    extends Calculation {
        OOPCalc() {
        }

        void setData(JmolList<Object[]> jmolList, int n, int n2) {
            this.b = CalculationsUFF.this.minAtoms[n];
            int[] nArray = this.b.getBondedAtomIndexes();
            this.ia = nArray[0];
            this.a = CalculationsUFF.this.minAtoms[this.ia];
            this.ic = nArray[1];
            this.c = CalculationsUFF.this.minAtoms[this.ic];
            this.id = nArray[2];
            this.d = CalculationsUFF.this.minAtoms[this.id];
            double d = 1.0;
            double d2 = -1.0;
            double d3 = 0.0;
            double d4 = 25.1208;
            switch (n2) {
                case 6: {
                    if ((this.b.sType != "C_2" || this.b.hCount <= 1) && this.b.sType != "C_2+" && this.a.sType != "O_2" && this.c.sType != "O_2" && this.d.sType != "O_2") break;
                    d4 += 184.2192;
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
                default: {
                    d4 = 92.1096;
                    double d5 = Math.PI / 180;
                    switch (n2) {
                        case 15: {
                            d5 *= 84.4339;
                            break;
                        }
                        case 33: {
                            d5 *= 86.9735;
                            break;
                        }
                        case 51: {
                            d5 *= 87.7047;
                            break;
                        }
                        case 83: {
                            d5 *= 90.0;
                        }
                    }
                    double d6 = Math.cos(d5);
                    d = d6 * d6;
                    d2 = -2.0 * d6;
                    d3 = 1.0;
                }
            }
            jmolList.addLast(new Object[]{new int[]{this.ia, n, this.ic, this.id}, new double[]{d4 /= 3.0, d, d2, d3, d4 * 10.0}});
            jmolList.addLast(new Object[]{new int[]{this.ic, n, this.id, this.ia}, new double[]{d4, d, d2, d3, d4 * 10.0}});
            jmolList.addLast(new Object[]{new int[]{this.id, n, this.ia, this.ic}, new double[]{d4, d, d2, d3, d4 * 10.0}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            double d = CalculationsUFF.this.isPreliminary ? this.dData[4] : this.dData[0];
            double d2 = this.dData[1];
            double d3 = this.dData[2];
            double d4 = this.dData[3];
            CalculationsUFF.this.setOopVariables(this, true);
            double d5 = Math.cos(this.theta);
            this.energy = d * (d2 + d3 * d5 + d4 * d5 * d5);
            if (CalculationsUFF.this.gradients) {
                this.dE = d * (d3 * Math.sin(this.theta) + d4 * 2.0 * Math.sin(this.theta) * d5);
                CalculationsUFF.this.addForces(this, 4);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(4, this));
            }
            return this.energy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TorsionCalc
    extends Calculation {
        TorsionCalc() {
        }

        void setData(JmolList<Object[]> jmolList, int[] nArray) {
            double d = -1.0;
            int n = 0;
            double d2 = 0.0;
            this.ia = nArray[0];
            this.a = CalculationsUFF.this.minAtoms[this.ia];
            this.ib = nArray[1];
            this.b = CalculationsUFF.this.minAtoms[this.ib];
            this.ic = nArray[2];
            this.c = CalculationsUFF.this.minAtoms[this.ic];
            this.id = nArray[3];
            this.d = CalculationsUFF.this.minAtoms[this.id];
            MinBond minBond = this.c.getBondTo(this.ib);
            double d3 = minBond.order;
            if (minBond.isAromatic) {
                d3 = 1.5;
            }
            if (minBond.isAmide) {
                d3 = 1.41;
            }
            CalculationsUFF.this.parB = CalculationsUFF.this.getParameter(this.b.sType);
            CalculationsUFF.this.parC = CalculationsUFF.this.getParameter(this.c.sType);
            switch (CalculationsUFF.this.parB.iVal[0] * CalculationsUFF.this.parC.iVal[0]) {
                case 9: {
                    n = 3;
                    double d4 = CalculationsUFF.this.parB.dVal[6];
                    double d5 = CalculationsUFF.this.parC.dVal[6];
                    double d6 = 0.0;
                    switch (this.b.atom.getElementNumber()) {
                        case 8: {
                            d6 = 2.0;
                            break;
                        }
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            d6 = 6.8;
                        }
                    }
                    if (d6 != 0.0) {
                        switch (this.c.atom.getElementNumber()) {
                            case 8: {
                                d4 = d6;
                                d5 = 2.0;
                                n = 2;
                                break;
                            }
                            case 16: 
                            case 34: 
                            case 52: 
                            case 84: {
                                d4 = d6;
                                d5 = 6.8;
                                n = 2;
                            }
                        }
                    }
                    d2 = 2.0934 * Math.sqrt(d4 * d5);
                    break;
                }
                case 4: {
                    d = 1.0;
                    n = 2;
                    d2 = 10.466999999999999 * Math.sqrt(CalculationsUFF.this.parB.dVal[7] * CalculationsUFF.this.parC.dVal[7]) * (1.0 + 4.18 * Math.log(d3));
                    break;
                }
                case 6: {
                    d = 1.0;
                    n = 6;
                    boolean bl = CalculationsUFF.this.parC.iVal[0] == 3;
                    block13 : switch ((bl ? this.c : this.b).atom.getElementNumber()) {
                        case 8: 
                        case 16: 
                        case 34: 
                        case 52: 
                        case 84: {
                            switch ((bl ? this.b : this.c).atom.getElementNumber()) {
                                case 8: 
                                case 16: 
                                case 34: 
                                case 52: 
                                case 84: {
                                    break block13;
                                }
                            }
                            n = 2;
                            d = -1.0;
                        }
                    }
                    d2 = 2.0934;
                }
            }
            if (Util.isNearZero(d2)) {
                return;
            }
            jmolList.addLast(new Object[]{new int[]{this.ia, this.ib, this.ic, this.id, n}, new double[]{d2, d}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            int n = this.iData[4];
            double d = this.dData[0];
            double d2 = this.dData[1];
            CalculationsUFF.this.setTorsionVariables(this);
            this.energy = d * (1.0 - d2 * Math.cos(this.theta * (double)n));
            if (CalculationsUFF.this.gradients) {
                this.dE = d * (double)n * d2 * Math.sin((double)n * this.theta);
                CalculationsUFF.this.addForces(this, 4);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(3, this));
            }
            return this.energy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AngleCalc
    extends Calculation {
        AngleCalc() {
        }

        void setData(JmolList<Object[]> jmolList, int[] nArray) {
            double d;
            double d2;
            double d3;
            this.ia = nArray[0];
            this.a = CalculationsUFF.this.minAtoms[this.ia];
            this.ib = nArray[1];
            this.b = CalculationsUFF.this.minAtoms[this.ib];
            this.ic = nArray[2];
            this.c = CalculationsUFF.this.minAtoms[this.ic];
            double d4 = this.a.sType == "H_" && this.c.sType == "H_" ? 10 : 1;
            CalculationsUFF.this.parA = CalculationsUFF.this.getParameter(this.a.sType);
            CalculationsUFF.this.parB = CalculationsUFF.this.getParameter(this.b.sType);
            CalculationsUFF.this.parC = CalculationsUFF.this.getParameter(this.c.sType);
            int n = CalculationsUFF.this.parB.iVal[0];
            double d5 = CalculationsUFF.this.parA.dVal[5];
            double d6 = CalculationsUFF.this.parC.dVal[5];
            double d7 = CalculationsUFF.this.parB.dVal[1];
            double d8 = Math.cos(d7);
            double d9 = Math.sin(d7);
            switch (n) {
                case 1: 
                case 2: 
                case 4: 
                case 6: {
                    d3 = 0.0;
                    d2 = 0.0;
                    d = 0.0;
                    break;
                }
                default: {
                    d3 = 1.0 / (4.0 * d9 * d9);
                    d2 = -4.0 * d3 * d8;
                    d = d3 * (2.0 * d8 * d8 + 1.0);
                }
            }
            MinBond minBond = this.a.getBondTo(this.ib);
            double d10 = minBond.order;
            if (minBond.isAromatic) {
                d10 = 1.5;
            }
            if (minBond.isAmide) {
                d10 = 1.41;
            }
            this.rab = CalculationsUFF.calculateR0(CalculationsUFF.this.parA.dVal[0], CalculationsUFF.this.parB.dVal[0], CalculationsUFF.this.parA.dVal[8], CalculationsUFF.this.parB.dVal[8], d10);
            minBond = this.c.getBondTo(this.ib);
            d10 = minBond.order;
            if (minBond.isAromatic) {
                d10 = 1.5;
            }
            if (minBond.isAmide) {
                d10 = 1.41;
            }
            double d11 = CalculationsUFF.calculateR0(CalculationsUFF.this.parB.dVal[0], CalculationsUFF.this.parC.dVal[0], CalculationsUFF.this.parB.dVal[8], CalculationsUFF.this.parC.dVal[8], d10);
            double d12 = Math.sqrt(this.rab * this.rab + d11 * d11 - 2.0 * this.rab * d11 * d8);
            double d13 = 2696.8016159999997 * (d5 * d6 / Math.pow(d12, 5.0)) * (3.0 * this.rab * d11 * (1.0 - d8 * d8) - d12 * d12 * d8);
            jmolList.addLast(new Object[]{new int[]{this.ia, this.ib, this.ic, n}, new double[]{d13, d7 * 57.29577951308232, d - d3, d2, 2.0 * d3, d4 * d13}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            int n = this.iData[3];
            double d = CalculationsUFF.this.isPreliminary ? this.dData[5] : this.dData[0];
            double d2 = this.dData[2];
            double d3 = this.dData[3];
            double d4 = this.dData[4];
            CalculationsUFF.this.setAngleVariables(this);
            if ((n == 4 || n == 6) && (this.theta > 2.35619 || this.theta < 0.785398)) {
                n = 1;
            }
            double d5 = Math.cos(this.theta);
            double d6 = Math.sin(this.theta);
            switch (n) {
                case 0: 
                case 1: {
                    this.energy = d * (1.0 + d5) * (1.0 + d5) / 4.0;
                    break;
                }
                case 2: {
                    this.energy = d * (1.0 + 4.0 * d5 * (1.0 + d5)) / 9.0;
                    break;
                }
                case 4: 
                case 6: {
                    this.energy = d * d5 * d5;
                    break;
                }
                default: {
                    this.energy = d * (d2 + d3 * d5 + d4 * d5 * d5);
                }
            }
            if (CalculationsUFF.this.gradients) {
                switch (n) {
                    case 0: 
                    case 1: {
                        this.dE = -0.5 * d * d6 * (1.0 + d5);
                        break;
                    }
                    case 2: {
                        this.dE = -4.0 * d6 * d * (1.0 - 2.0 * d5) / 9.0;
                        break;
                    }
                    case 4: 
                    case 6: {
                        this.dE = -d * d6 * d5;
                        break;
                    }
                    default: {
                        this.dE = -d * (d3 * d6 - 2.0 * d4 * d5 * d6);
                    }
                }
                CalculationsUFF.this.addForces(this, 3);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(1, this));
            }
            return this.energy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DistanceCalc
    extends Calculation {
        double r0;
        double kb;

        DistanceCalc() {
        }

        void setData(JmolList<Object[]> jmolList, int n, int n2, double d) {
            CalculationsUFF.this.parA = CalculationsUFF.this.getParameter(CalculationsUFF.this.minAtoms[n].sType);
            CalculationsUFF.this.parB = CalculationsUFF.this.getParameter(CalculationsUFF.this.minAtoms[n2].sType);
            this.r0 = CalculationsUFF.calculateR0(CalculationsUFF.this.parA.dVal[0], CalculationsUFF.this.parB.dVal[0], CalculationsUFF.this.parA.dVal[8], CalculationsUFF.this.parB.dVal[8], d);
            this.kb = 1390.2842991599998 * CalculationsUFF.this.parA.dVal[5] * CalculationsUFF.this.parB.dVal[5] / (this.r0 * this.r0 * this.r0);
            jmolList.addLast(new Object[]{new int[]{n, n2}, new double[]{this.r0, this.kb, d}});
        }

        @Override
        double compute(Object[] objectArray) {
            this.getPointers(objectArray);
            this.r0 = this.dData[0];
            this.kb = this.dData[1];
            CalculationsUFF.this.setPairVariables(this);
            this.delta = this.rab - this.r0;
            this.energy = this.kb * this.delta * this.delta;
            if (CalculationsUFF.this.gradients) {
                this.dE = 2.0 * this.kb * this.delta;
                CalculationsUFF.this.addForces(this, 2);
            }
            if (CalculationsUFF.this.logging) {
                CalculationsUFF.this.appendLogData(CalculationsUFF.this.getDebugLine(0, this));
            }
            return this.energy;
        }
    }
}

