/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;

public class MdTopReader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int atomCount = 0;
    String[] atomTypes;
    String[] group3s;

    protected void initializeReader() throws Exception {
        this.setUserAtomTypes();
    }

    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("%FLAG ") != 0) {
            return true;
        }
        this.line = this.line.substring(6).trim();
        if (this.line.equals("POINTERS")) {
            this.getPointers();
        } else if (this.line.equals("ATOM_NAME")) {
            this.getAtomNames();
        } else if (this.line.equals("CHARGE")) {
            this.getCharges();
        } else if (this.line.equals("RESIDUE_LABEL")) {
            this.getResidueLabels();
        } else if (this.line.equals("RESIDUE_POINTER")) {
            this.getResiduePointers();
        } else if (this.line.equals("AMBER_ATOM_TYPE")) {
            this.getAtomTypes();
        } else if (this.line.equals("MASS")) {
            this.getMasses();
        }
        return false;
    }

    protected void finalizeReader() throws Exception {
        int n;
        super.finalizeReader();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = atomArray[i];
            atom.isHetero = JmolAdapter.isHetero(atom.group3);
            String string = this.atomTypes[i];
            if (this.getElementSymbol(atom, string)) continue;
            atom.elementSymbol = MdTopReader.deducePdbElementSymbol(atom.isHetero, atom.atomName, atom.group3);
        }
        Atom[] atomArray2 = null;
        if (this.filter == null) {
            this.nAtoms = this.atomCount;
        } else {
            atomArray2 = new Atom[atomArray.length];
            this.nAtoms = 0;
            for (int i = 0; i < this.atomCount; ++i) {
                if (!this.filterAtom(atomArray[i], i)) continue;
                atomArray2[this.nAtoms++] = atomArray[i];
            }
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < this.atomCount; ++n) {
            if (this.filter != null && !this.bsFilter.get(n)) continue;
            if (n3 % 100 == 0) {
                ++n2;
            }
            this.setAtomCoordXYZ(atomArray[n], n % 100 * 2, n2 * 2, 0.0f);
        }
        if (atomArray2 != null) {
            this.atomSetCollection.discardPreviousAtoms();
            for (n = 0; n < this.nAtoms; ++n) {
                this.atomSetCollection.addAtom(atomArray2[n]);
            }
        }
        Logger.info("Total number of atoms used=" + this.nAtoms);
        this.setIsPDB();
        this.htParams.put("defaultType", "mdcrd");
    }

    private String[] getDataBlock() throws Exception {
        JmolList<String> jmolList = new JmolList<String>();
        this.discardLinesUntilContains("FORMAT");
        int n = (Integer)MdTopReader.getFortranFormatLengths(this.line.substring(this.line.indexOf("("))).get(0);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n2 >= n3) {
                if (this.readLine() == null) break;
                n2 = 0;
                n3 = this.line.length();
                if (n3 == 0 || this.line.indexOf("FLAG") >= 0) break;
            }
            jmolList.addLast(this.line.substring(n2, n2 + n).trim());
            n2 += n;
        }
        return jmolList.toArray(new String[jmolList.size()]);
    }

    private void getPointers() throws Exception {
        boolean bl;
        String[] stringArray = this.getDataBlock();
        this.atomCount = this.parseIntStr(stringArray[0]);
        boolean bl2 = bl = stringArray[27].charAt(0) != '0';
        if (bl) {
            Logger.info("Periodic type: " + stringArray[27]);
            this.htParams.put("isPeriodic", Boolean.TRUE);
        }
        Logger.info("Total number of atoms read=" + this.atomCount);
        this.htParams.put("templateAtomCount", this.atomCount);
        for (int i = 0; i < this.atomCount; ++i) {
            this.atomSetCollection.addAtom(new Atom());
        }
    }

    private void getAtomTypes() throws Exception {
        this.atomTypes = this.getDataBlock();
    }

    private void getCharges() throws Exception {
        String[] stringArray = this.getDataBlock();
        if (stringArray.length != this.atomCount) {
            return;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomCount;
        while (--n >= 0) {
            atomArray[n].partialCharge = this.parseFloatStr(stringArray[n]);
        }
    }

    private void getResiduePointers() throws Exception {
        String[] stringArray = this.getDataBlock();
        Logger.info("Total number of residues=" + stringArray.length);
        int n = this.atomCount;
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            int n3;
            int n4 = n3 = this.parseIntStr(stringArray[n2]) - 1;
            while (n4 < n) {
                if (this.group3s != null) {
                    atomArray[n4].group3 = this.group3s[n2];
                }
                atomArray[n4++].sequenceNumber = n2 + 1;
            }
            n = n3;
        }
    }

    private void getResidueLabels() throws Exception {
        this.group3s = this.getDataBlock();
    }

    private void getAtomNames() throws Exception {
        String[] stringArray = this.getDataBlock();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = 0; i < this.atomCount; ++i) {
            atomArray[i].atomName = stringArray[i];
        }
    }

    private void getMasses() throws Exception {
    }
}

