/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jmol.api.JmolStateCreator;
import org.jmol.modelset.Atom;
import org.jmol.shape.AtomShape;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Eigen;
import org.jmol.util.Escape;
import org.jmol.util.Matrix3f;
import org.jmol.util.P3;
import org.jmol.util.Quadric;
import org.jmol.util.SB;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

public class Ellipsoids
extends AtomShape {
    public Map<String, Ellipsoid> htEllipsoids = new Hashtable<String, Ellipsoid>();
    public boolean haveEllipsoids;
    public short[][] colixset;
    byte[][] paletteIDset;
    public short[][] madset;
    Ellipsoid ellipsoid;
    private int iSelect;

    public int getIndexFromName(String string) {
        this.ellipsoid = this.htEllipsoids.get(string);
        return this.ellipsoid == null ? -1 : 1;
    }

    protected void setSize(int n, BS bS) {
        this.setSize2(n, bS);
        this.checkSets();
        this.madset[this.iSelect] = this.mads;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (n != 0) {
                this.atoms[n2].scaleEllipsoid(n, this.iSelect);
            }
            boolean bl = this.madset[0] != null && this.madset[0].length > n2 && this.madset[0][n2] > 0 || this.madset[1] != null && this.madset[1].length > n2 && this.madset[1][n2] > 0 || this.madset[2] != null && this.madset[2].length > n2 && this.madset[2][n2] > 0;
            this.bsSizeSet.setBitTo(n2, bl);
            this.atoms[n2].setShapeVisibility(this.myVisibilityFlag, bl);
            n2 = bS.nextSetBit(n2 + 1);
        }
    }

    public void setProperty(String string, Object object, BS bS) {
        if (string == "thisID") {
            Ellipsoid ellipsoid = this.ellipsoid = object == null ? null : this.htEllipsoids.get(object);
            if (object == null) {
                return;
            }
            if (this.ellipsoid == null) {
                String string2 = (String)object;
                this.ellipsoid = new Ellipsoid(string2, this.viewer.getCurrentModelIndex());
                this.htEllipsoids.put(string2, this.ellipsoid);
                this.haveEllipsoids = true;
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            Iterator<Ellipsoid> iterator = this.htEllipsoids.values().iterator();
            while (iterator.hasNext()) {
                Ellipsoid ellipsoid = iterator.next();
                if (ellipsoid.modelIndex > n) {
                    --ellipsoid.modelIndex;
                    continue;
                }
                if (ellipsoid.modelIndex != n) continue;
                iterator.remove();
            }
            this.haveEllipsoids = !this.htEllipsoids.isEmpty();
            this.ellipsoid = null;
            return;
        }
        if (this.ellipsoid != null) {
            if ("delete" == string) {
                this.htEllipsoids.remove(this.ellipsoid.id);
                this.haveEllipsoids = !this.htEllipsoids.isEmpty();
                return;
            }
            if ("modelindex" == string) {
                this.ellipsoid.modelIndex = (Integer)object;
                return;
            }
            if ("on" == string) {
                this.ellipsoid.isOn = (Boolean)object;
                return;
            }
            if ("atoms" == string) {
                this.setAtoms((BS)object);
                return;
            }
            if ("points" == string) {
                this.setPoints((Object[])object);
                return;
            }
            if ("axes" == string) {
                int n;
                this.ellipsoid.isValid = false;
                this.ellipsoid.axes = (V3[])object;
                this.ellipsoid.lengths = new float[3];
                this.ellipsoid.scale = 1.0f;
                for (n = 0; n < 2; ++n) {
                    if (!(this.ellipsoid.axes[n].length() > this.ellipsoid.axes[n + 1].length())) continue;
                    V3 v3 = this.ellipsoid.axes[n];
                    this.ellipsoid.axes[n] = this.ellipsoid.axes[n + 1];
                    this.ellipsoid.axes[n + 1] = v3;
                    if (n != 1) continue;
                    n = -1;
                }
                for (n = 0; n < 3; ++n) {
                    this.ellipsoid.lengths[n] = this.ellipsoid.axes[n].length();
                    if (this.ellipsoid.lengths[n] == 0.0f) {
                        return;
                    }
                    this.ellipsoid.axes[n].normalize();
                }
                if (Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f || Math.abs(this.ellipsoid.axes[0].dot(this.ellipsoid.axes[1])) > 1.0E-4f) {
                    return;
                }
                Ellipsoids.updateEquation(this.ellipsoid);
                return;
            }
            if ("equation" == string) {
                this.ellipsoid.coef = (double[])object;
                this.ellipsoid.axes = new V3[3];
                this.ellipsoid.lengths = new float[3];
                Quadric.getAxesForEllipsoid((double[])this.ellipsoid.coef, (V3[])this.ellipsoid.axes, (float[])this.ellipsoid.lengths);
                return;
            }
            if ("center" == string) {
                this.ellipsoid.center = (P3)object;
                Ellipsoids.updateEquation(this.ellipsoid);
                return;
            }
            if ("scale" == string) {
                float f = ((Float)object).floatValue();
                if (f <= 0.0f || this.ellipsoid.lengths == null) {
                    this.ellipsoid.isValid = false;
                } else {
                    int n = 0;
                    while (n < 3) {
                        int n2 = n++;
                        this.ellipsoid.lengths[n2] = this.ellipsoid.lengths[n2] * (f / this.ellipsoid.scale);
                    }
                    this.ellipsoid.scale = f;
                    Ellipsoids.updateEquation(this.ellipsoid);
                }
                return;
            }
            if ("color" == string) {
                this.ellipsoid.colix = C.getColixO((Object)object);
                return;
            }
            if ("translucentLevel" == string) {
                this.setPropAS(string, object, bS);
                return;
            }
            if ("translucency" == string) {
                boolean bl = object.equals("translucent");
                this.ellipsoid.colix = C.getColixTranslucent3((short)this.ellipsoid.colix, (boolean)bl, (float)this.translucentLevel);
                return;
            }
        }
        if ("select" == string) {
            this.iSelect = (Integer)object - 1;
            this.checkSets();
            this.colixes = this.colixset[this.iSelect];
            this.paletteIDs = this.paletteIDset[this.iSelect];
            this.mads = this.madset[this.iSelect];
            return;
        }
        this.setPropAS(string, object, bS);
        if (this.colixset != null && ("color" == string || "translucency" == string || "deleteModelAtoms" == string)) {
            this.colixset[this.iSelect] = this.colixes;
            this.paletteIDset[this.iSelect] = this.paletteIDs;
            this.madset[this.iSelect] = this.mads;
        }
    }

    private void setPoints(Object[] objectArray) {
        P3[] p3Array = (P3[])objectArray[1];
        if (p3Array == null) {
            return;
        }
        BS bS = (BS)objectArray[2];
        int n = bS.cardinality();
        if (n < 3) {
            return;
        }
        P3 p3 = new P3();
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            p3.add((Tuple3f)p3Array[n2]);
            n2 = bS.nextSetBit(n2 + 1);
        }
        p3.scale(1.0f / (float)n);
        this.ellipsoid.center = p3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        P3 p32 = new P3();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            p32.setT((Tuple3f)p3Array[n3]);
            p32.sub((Tuple3f)p3);
            d += (double)p32.x * (double)p32.x;
            d2 += (double)p32.y * (double)p32.y;
            d3 += (double)p32.z * (double)p32.z;
            d4 += (double)p32.x * (double)p32.y;
            d5 += (double)p32.x * (double)p32.z;
            d6 += (double)p32.y * (double)p32.z;
            n3 = bS.nextSetBit(n3 + 1);
        }
        double[][] dArray = new double[3][3];
        dArray[0][0] = d2 + d3;
        double d7 = -d4;
        dArray[1][0] = d7;
        dArray[0][1] = d7;
        double d8 = -d5;
        dArray[2][0] = d8;
        dArray[0][2] = d8;
        dArray[1][1] = d + d3;
        double d9 = -d6;
        dArray[2][1] = d9;
        dArray[1][2] = d9;
        dArray[2][2] = d + d2;
        Eigen eigen = Eigen.newM((double[][])dArray);
        this.ellipsoid.axes = eigen.getEigenVectors3();
        double[] dArray2 = eigen.getEigenvalues();
        this.ellipsoid.lengths = new float[3];
        for (int i = 0; i < 3; ++i) {
            this.ellipsoid.lengths[i] = (float)dArray2[i] / (float)n / 3.0f;
        }
        this.ellipsoid.scale = 1.0f;
        Ellipsoids.updateEquation(this.ellipsoid);
    }

    private void setAtoms(BS bS) {
        int n = bS.cardinality();
        if (n == 0) {
            return;
        }
        Atom[] atomArray = this.viewer.modelSet.atoms;
        P3 p3 = new P3();
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            p3.add((Tuple3f)atomArray[n2]);
            n2 = bS.nextSetBit(n2 + 1);
        }
        p3.scale(1.0f / (float)n);
        this.ellipsoid.center = p3;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        P3 p32 = new P3();
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            p32.setT((Tuple3f)atomArray[n3]);
            p32.sub((Tuple3f)p3);
            d += (double)p32.x * (double)p32.x;
            d2 += (double)p32.y * (double)p32.y;
            d3 += (double)p32.z * (double)p32.z;
            d4 += (double)p32.x * (double)p32.y;
            d5 += (double)p32.x * (double)p32.z;
            d6 += (double)p32.y * (double)p32.z;
            n3 = bS.nextSetBit(n3 + 1);
        }
        double[][] dArray = new double[3][3];
        dArray[0][0] = d2 + d3;
        double d7 = -d4;
        dArray[1][0] = d7;
        dArray[0][1] = d7;
        double d8 = -d5;
        dArray[2][0] = d8;
        dArray[0][2] = d8;
        dArray[1][1] = d + d3;
        double d9 = -d6;
        dArray[2][1] = d9;
        dArray[1][2] = d9;
        dArray[2][2] = d + d2;
        Eigen eigen = Eigen.newM((double[][])dArray);
        this.ellipsoid.axes = eigen.getEigenVectors3();
        double[] dArray2 = eigen.getEigenvalues();
        this.ellipsoid.lengths = new float[3];
        for (int i = 0; i < 3; ++i) {
            this.ellipsoid.lengths[i] = (float)dArray2[i] / (float)n / 3.0f;
        }
        this.ellipsoid.scale = 1.0f;
        Ellipsoids.updateEquation(this.ellipsoid);
    }

    private void checkSets() {
        if (this.colixset == null) {
            this.colixset = ArrayUtil.newShort2((int)3);
            this.paletteIDset = ArrayUtil.newByte2((int)3);
            this.madset = ArrayUtil.newShort2((int)3);
        }
    }

    private static void updateEquation(Ellipsoid ellipsoid) {
        if (ellipsoid.axes == null || ellipsoid.lengths == null) {
            return;
        }
        Matrix3f matrix3f = new Matrix3f();
        Matrix3f matrix3f2 = new Matrix3f();
        V3 v3 = new V3();
        ellipsoid.coef = new double[10];
        Quadric.getEquationForQuadricWithCenter((float)ellipsoid.center.x, (float)ellipsoid.center.y, (float)ellipsoid.center.z, (Matrix3f)matrix3f, (V3)v3, (Matrix3f)matrix3f2, (double[])ellipsoid.coef, null);
        ellipsoid.isValid = true;
    }

    public String getShapeState() {
        SB sB = new SB();
        this.getStateID(sB);
        this.getStateAtoms(sB);
        return sB.toString();
    }

    private void getStateID(SB sB) {
        if (!this.haveEllipsoids) {
            return;
        }
        Iterator<Ellipsoid> iterator = this.htEllipsoids.values().iterator();
        V3 v3 = new V3();
        while (iterator.hasNext()) {
            Ellipsoid ellipsoid = iterator.next();
            if (ellipsoid.axes == null || ellipsoid.lengths == null) continue;
            sB.append("  Ellipsoid ID ").append(ellipsoid.id).append(" modelIndex ").appendI(ellipsoid.modelIndex).append(" center ").append(Escape.eP((Tuple3f)ellipsoid.center)).append(" axes");
            for (int i = 0; i < 3; ++i) {
                v3.setT((Tuple3f)ellipsoid.axes[i]);
                v3.scale(ellipsoid.lengths[i]);
                sB.append(" ").append(Escape.eP((Tuple3f)v3));
            }
            sB.append(" " + Ellipsoids.getColorCommandUnk((String)"", (short)ellipsoid.colix, (boolean)this.translucentAllowed));
            if (!ellipsoid.isOn) {
                sB.append(" off");
            }
            sB.append(";\n");
        }
    }

    private void getStateAtoms(SB sB) {
        if (this.madset == null) {
            return;
        }
        JmolStateCreator jmolStateCreator = this.viewer.getStateCreator();
        if (jmolStateCreator == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            int n;
            if (this.madset[i] == null) continue;
            Ellipsoids.appendCmd((SB)sB, (String)("Ellipsoids set " + (i + 1) + "\n"));
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            if (this.bsSizeSet != null) {
                n = this.bsSizeSet.nextSetBit(0);
                while (n >= 0) {
                    BSUtil.setMapBitSet(hashtable, (int)n, (int)n, (String)("Ellipsoids " + this.madset[i][n]));
                    n = this.bsSizeSet.nextSetBit(n + 1);
                }
            }
            if (this.bsColixSet != null && this.colixset[i] != null) {
                n = this.bsColixSet.nextSetBit(0);
                while (n >= 0) {
                    BSUtil.setMapBitSet(hashtable2, (int)n, (int)n, (String)Ellipsoids.getColorCommand((String)"Ellipsoids", (byte)this.paletteIDset[i][n], (short)this.colixset[i][n], (boolean)this.translucentAllowed));
                    n = this.bsColixSet.nextSetBit(n + 1);
                }
            }
            sB.append(jmolStateCreator.getCommands(hashtable, hashtable2, "select"));
        }
    }

    public void setVisibilityFlags(BS bS) {
        if (!this.haveEllipsoids) {
            return;
        }
        for (Ellipsoid ellipsoid : this.htEllipsoids.values()) {
            ellipsoid.visible = ellipsoid.isOn && (ellipsoid.modelIndex < 0 || bS.get(ellipsoid.modelIndex));
        }
    }

    public static class Ellipsoid {
        String id;
        public V3[] axes;
        public float[] lengths;
        public P3 center = P3.new3((float)0.0f, (float)0.0f, (float)0.0f);
        double[] coef;
        public short colix = (short)23;
        int modelIndex;
        float scale = 1.0f;
        public boolean visible;
        public boolean isValid;
        boolean isOn = true;

        Ellipsoid(String string, int n) {
            this.id = string;
            this.modelIndex = n;
        }
    }
}

