/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jmol.modelset.Bond;
import org.jmol.script.T;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SV
extends T {
    private static final SV vT = SV.newScriptVariableIntValue(0x10000D, 1, "true");
    private static final SV vF = SV.newScriptVariableIntValue(0x10000C, 0, "false");
    int index = Integer.MAX_VALUE;
    private static final int FLAG_CANINCREMENT = 1;
    private static final int FLAG_LOCALVAR = 2;
    private int flags = 2;
    private String myName;
    private static final P3 pt0 = new P3();

    public static SV newVariable(int n, Object object) {
        SV sV = new SV();
        sV.tok = n;
        sV.value = object;
        return sV;
    }

    public static SV newScriptVariableInt(int n) {
        SV sV = new SV();
        sV.tok = 2;
        sV.intValue = n;
        return sV;
    }

    static SV newScriptVariableBs(BS bS, int n) {
        SV sV = SV.newVariable(10, bS);
        if (n >= 0) {
            sV.index = n;
        }
        return sV;
    }

    static SV newScriptVariableToken(T t) {
        return SV.newScriptVariableIntValue(t.tok, t.intValue, t.value);
    }

    static SV newScriptVariableIntValue(int n, int n2, Object object) {
        SV sV = SV.newVariable(n, object);
        sV.intValue = n2;
        return sV;
    }

    static int sizeOf(T t) {
        switch (t == null ? 0 : t.tok) {
            case 10: {
                return BSUtil.cardinalityOf(SV.bsSelectToken(t));
            }
            case 0x10000C: 
            case 0x10000D: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 8: {
                return -8;
            }
            case 9: {
                return -16;
            }
            case 11: {
                return -32;
            }
            case 12: {
                return -64;
            }
            case 4: {
                return ((String)t.value).length();
            }
            case 7: {
                return t.intValue == Integer.MAX_VALUE ? ((SV)t).getList().size() : SV.sizeOf(SV.selectItemTok(t));
            }
            case 6: {
                return ((Map)t.value).size();
            }
        }
        return 0;
    }

    static boolean isVariableType(Object object) {
        return object instanceof SV || object instanceof BS || object instanceof Boolean || object instanceof Float || object instanceof Integer || object instanceof String || object instanceof P3 || object instanceof V3 || object instanceof P4 || object instanceof Quaternion || object instanceof Map || SV.isArray(object);
    }

    public static SV getVariable(Object object) {
        if (object == null) {
            return SV.newVariable(4, "");
        }
        if (object instanceof SV) {
            return (SV)object;
        }
        if (object instanceof Boolean) {
            return SV.getBoolean((Boolean)object);
        }
        if (object instanceof Integer) {
            return SV.newScriptVariableInt((Integer)object);
        }
        if (object instanceof Float) {
            return SV.newVariable(3, object);
        }
        if (object instanceof String) {
            if ((object = SV.unescapePointOrBitsetAsVariable(object)) instanceof SV) {
                return (SV)object;
            }
            return SV.newVariable(4, object);
        }
        if (object instanceof P3) {
            return SV.newVariable(8, object);
        }
        if (object instanceof V3) {
            return SV.newVariable(8, P3.newP((V3)object));
        }
        if (object instanceof BS) {
            return SV.newVariable(10, object);
        }
        if (object instanceof P4) {
            return SV.newVariable(9, object);
        }
        if (object instanceof Quaternion) {
            return SV.newVariable(9, ((Quaternion)object).toPoint4f());
        }
        if (object instanceof Matrix3f) {
            return SV.newVariable(11, object);
        }
        if (object instanceof Matrix4f) {
            return SV.newVariable(12, object);
        }
        if (object instanceof Map) {
            return SV.getVariableMap((Map)object);
        }
        if (object instanceof JmolList) {
            return SV.getVariableList((JmolList)object);
        }
        if (Escape.isAV(object)) {
            return SV.getVariableAV((SV[])object);
        }
        if (Escape.isAI(object)) {
            return SV.getVariableAI((int[])object);
        }
        if (Escape.isAF(object)) {
            return SV.getVariableAF((float[])object);
        }
        if (Escape.isAD(object)) {
            return SV.getVariableAD((double[])object);
        }
        if (Escape.isAS(object)) {
            return SV.getVariableAS((String[])object);
        }
        if (Escape.isAP(object)) {
            return SV.getVariableAP((P3[])object);
        }
        if (Escape.isAII(object)) {
            return SV.getVariableAII((int[][])object);
        }
        if (Escape.isAFF(object)) {
            return SV.getVariableAFF((float[][])object);
        }
        if (Escape.isAFloat(object)) {
            return SV.newVariable(13, object);
        }
        return SV.newVariable(4, Escape.toReadable(null, object));
    }

    private static boolean isArray(Object object) {
        return object instanceof JmolList || object instanceof SV[] || object instanceof int[] || object instanceof float[] || object instanceof double[] || object instanceof String[] || object instanceof P3[] || object instanceof int[][] || object instanceof float[][] || object instanceof Float[];
    }

    static SV getVariableMap(Map<String, ?> map) {
        Map<String, ?> map2 = map;
        Iterator<String> iterator = map2.keySet().iterator();
        if (iterator.hasNext() && !(map2.get(iterator.next()) instanceof SV)) {
            Hashtable hashtable = new Hashtable();
            for (Map.Entry<String, ?> entry : map2.entrySet()) {
                String string = entry.getKey();
                Object obj = entry.getValue();
                if (SV.isVariableType(obj)) {
                    hashtable.put(string, SV.getVariable(obj));
                    continue;
                }
                hashtable.put(string, SV.newVariable(4, Escape.toReadable(null, obj)));
            }
            map = hashtable;
        }
        return SV.newVariable(6, map);
    }

    static SV getVariableList(JmolList<?> jmolList) {
        int n = jmolList.size();
        if (n > 0 && jmolList.get(0) instanceof SV) {
            return SV.newVariable(7, jmolList);
        }
        JmolList<SV> jmolList2 = new JmolList<SV>();
        for (int i = 0; i < n; ++i) {
            jmolList2.addLast(SV.getVariable(jmolList.get(i)));
        }
        return SV.newVariable(7, jmolList2);
    }

    static SV getVariableAV(SV[] sVArray) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < sVArray.length; ++i) {
            jmolList.addLast(sVArray[i]);
        }
        return SV.newVariable(7, jmolList);
    }

    static SV getVariableAD(double[] dArray) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < dArray.length; ++i) {
            jmolList.addLast(SV.newVariable(3, Float.valueOf((float)dArray[i])));
        }
        return SV.newVariable(7, jmolList);
    }

    static SV getVariableAS(String[] stringArray) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < stringArray.length; ++i) {
            jmolList.addLast(SV.newVariable(4, stringArray[i]));
        }
        return SV.newVariable(7, jmolList);
    }

    static SV getVariableAP(P3[] p3Array) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < p3Array.length; ++i) {
            jmolList.addLast(SV.newVariable(8, p3Array[i]));
        }
        return SV.newVariable(7, jmolList);
    }

    static SV getVariableAFF(float[][] fArray) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < fArray.length; ++i) {
            jmolList.addLast(SV.getVariableAF(fArray[i]));
        }
        return SV.newVariable(7, jmolList);
    }

    static SV getVariableAII(int[][] nArray) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < nArray.length; ++i) {
            jmolList.addLast(SV.getVariableAI(nArray[i]));
        }
        return SV.newVariable(7, jmolList);
    }

    static SV getVariableAF(float[] fArray) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < fArray.length; ++i) {
            jmolList.addLast(SV.newVariable(3, Float.valueOf(fArray[i])));
        }
        return SV.newVariable(7, jmolList);
    }

    static SV getVariableAI(int[] nArray) {
        JmolList<SV> jmolList = new JmolList<SV>();
        for (int i = 0; i < nArray.length; ++i) {
            jmolList.addLast(SV.newVariable(2, nArray[i]));
        }
        return SV.newVariable(7, jmolList);
    }

    SV setv(SV sV, boolean bl) {
        this.index = sV.index;
        this.intValue = sV.intValue;
        this.tok = sV.tok;
        this.value = sV.value;
        if (bl) {
            switch (this.tok) {
                case 6: {
                    this.value = new Hashtable((Map)sV.value);
                    break;
                }
                case 7: {
                    JmolList jmolList = new JmolList();
                    JmolList<SV> jmolList2 = sV.getList();
                    for (int i = 0; i < jmolList2.size(); ++i) {
                        jmolList.addLast(jmolList2.get(i));
                    }
                    this.value = jmolList;
                }
            }
        }
        return this;
    }

    public SV setName(String string) {
        this.myName = string;
        this.flags |= 1;
        return this;
    }

    public SV setGlobal() {
        this.flags &= 0xFFFFFFFD;
        return this;
    }

    boolean canIncrement() {
        return SV.tokAttr(this.flags, 1);
    }

    boolean increment(int n) {
        if (!this.canIncrement()) {
            return false;
        }
        switch (this.tok) {
            case 2: {
                this.intValue += n;
                break;
            }
            case 3: {
                this.value = Float.valueOf(((Float)this.value).floatValue() + (float)n);
                break;
            }
            default: {
                this.value = SV.nValue(this);
                if (this.value instanceof Integer) {
                    this.tok = 2;
                    this.intValue = (Integer)this.value;
                    break;
                }
                this.tok = 3;
            }
        }
        return true;
    }

    public boolean asBoolean() {
        return SV.bValue(this);
    }

    public int asInt() {
        return SV.iValue(this);
    }

    float asFloat() {
        return SV.fValue(this);
    }

    public String asString() {
        return SV.sValue(this);
    }

    public static Object oValue(SV sV) {
        switch (sV == null ? 0 : sV.tok) {
            case 0x10000D: {
                return Boolean.TRUE;
            }
            case 0: 
            case 0x10000C: {
                return Boolean.FALSE;
            }
            case 2: {
                return sV.intValue;
            }
            case 10: 
            case 135266306: {
                return SV.selectItemVar((SV)sV).value;
            }
        }
        return sV.value;
    }

    static Object nValue(T t) {
        int n;
        switch (t == null ? 0 : t.tok) {
            case 3: {
                return t.value;
            }
            case 2: {
                n = t.intValue;
                break;
            }
            case 4: {
                if (((String)t.value).indexOf(".") >= 0) {
                    return Float.valueOf(SV.toFloat((String)t.value));
                }
                n = (int)SV.toFloat((String)t.value);
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    private static boolean bValue(T t) {
        switch (t == null ? 0 : t.tok) {
            case 6: 
            case 0x10000D: {
                return true;
            }
            case 0x10000C: {
                return false;
            }
            case 2: {
                return t.intValue != 0;
            }
            case 3: 
            case 4: 
            case 7: {
                return SV.fValue(t) != 0.0f;
            }
            case 10: {
                return SV.iValue(t) != 0;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return Math.abs(SV.fValue(t)) > 1.0E-4f;
            }
        }
        return false;
    }

    static int iValue(T t) {
        switch (t == null ? 0 : t.tok) {
            case 0x10000D: {
                return 1;
            }
            case 0x10000C: {
                return 0;
            }
            case 2: {
                return t.intValue;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return (int)SV.fValue(t);
            }
            case 10: {
                return BSUtil.cardinalityOf(SV.bsSelectToken(t));
            }
        }
        return 0;
    }

    static float fValue(T t) {
        switch (t == null ? 0 : t.tok) {
            case 0x10000D: {
                return 1.0f;
            }
            case 0x10000C: {
                return 0.0f;
            }
            case 2: {
                return t.intValue;
            }
            case 3: {
                return ((Float)t.value).floatValue();
            }
            case 7: {
                int n = t.intValue;
                if (n == Integer.MAX_VALUE) {
                    return ((SV)t).getList().size();
                }
            }
            case 4: {
                return SV.toFloat(SV.sValue(t));
            }
            case 10: {
                return SV.iValue(t);
            }
            case 8: {
                return ((P3)t.value).distance(pt0);
            }
            case 9: {
                return Measure.distanceToPlane((P4)t.value, pt0);
            }
            case 11: {
                P3 p3 = new P3();
                ((Matrix3f)t.value).transform(p3);
                return p3.distance(pt0);
            }
            case 12: {
                P3 p3 = new P3();
                ((Matrix4f)t.value).transform(p3);
                return p3.distance(pt0);
            }
        }
        return 0.0f;
    }

    static String sValue(T t) {
        if (t == null) {
            return "";
        }
        switch (t.tok) {
            case 0x10000D: {
                return "true";
            }
            case 0x10000C: {
                return "false";
            }
            case 2: {
                return "" + t.intValue;
            }
            case 10: {
                BS bS = SV.bsSelectToken(t);
                return t.value instanceof Bond.BondSet ? Escape.eBond(bS) : Escape.eBS(bS);
            }
            case 7: {
                JmolList<SV> jmolList = ((SV)t).getList();
                int n = t.intValue;
                if (n <= 0) {
                    n = jmolList.size() - n;
                }
                if (n != Integer.MAX_VALUE) {
                    return n < 1 || n > jmolList.size() ? "" : SV.sValue((T)jmolList.get(n - 1));
                }
            }
            case 6: {
                SB sB = new SB();
                Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
                SV.sValueArray(sB, (SV)t, hashtable, 0, false);
                return sB.toString();
            }
            case 4: {
                String string = (String)t.value;
                int n = t.intValue;
                if (n <= 0) {
                    n = string.length() - n;
                }
                if (n == Integer.MAX_VALUE) {
                    return string;
                }
                if (n < 1 || n > string.length()) {
                    return "";
                }
                return "" + string.charAt(n - 1);
            }
            case 8: {
                return Escape.eP((P3)t.value);
            }
            case 9: {
                return Escape.eP4((P4)t.value);
            }
            case 11: 
            case 12: {
                return Escape.e(t.value);
            }
        }
        return t.value.toString();
    }

    private static void sValueArray(SB sB, SV sV, Map<Object, Boolean> map, int n, boolean bl) {
        switch (sV.tok) {
            case 6: {
                if (map.containsKey(sV)) {
                    sB.append(bl ? "{}" : (sV.myName == null ? "<circular reference>" : "<" + sV.myName + ">"));
                    break;
                }
                map.put(sV, Boolean.TRUE);
                Map map2 = (Map)sV.value;
                Set set = map2.keySet();
                Object[] objectArray = map2.keySet().toArray(new String[set.size()]);
                Arrays.sort(objectArray);
                if (bl) {
                    sB.append("{ ");
                    String string = "";
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object = objectArray[i];
                        sB.append(string).append(Escape.eS((String)object)).appendC(':');
                        SV.sValueArray(sB, (SV)map2.get(object), map, n + 1, true);
                        string = ", ";
                    }
                    sB.append(" }");
                    break;
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    sB.append((String)objectArray[i]).append("\t:");
                    SV sV2 = (SV)map2.get(objectArray[i]);
                    SB sB2 = new SB();
                    SV.sValueArray(sB2, sV2, map, n + 1, bl);
                    String string = sB2.toString();
                    sB.append(string.indexOf("\n") >= 0 ? "\n" : "\t");
                    sB.append(string).append("\n");
                }
                break;
            }
            case 7: {
                if (map.containsKey(sV)) {
                    sB.append(bl ? "[]" : (sV.myName == null ? "<circular reference>" : "<" + sV.myName + ">"));
                    break;
                }
                map.put(sV, Boolean.TRUE);
                if (bl) {
                    sB.append("[");
                }
                JmolList<SV> jmolList = sV.getList();
                for (int i = 0; i < jmolList.size(); ++i) {
                    if (bl && i > 0) {
                        sB.append(",");
                    }
                    SV sV3 = (SV)jmolList.get(i);
                    SV.sValueArray(sB, sV3, map, n + 1, bl);
                    if (bl) continue;
                    sB.append("\n");
                }
                if (!bl) break;
                sB.append("]");
                break;
            }
            default: {
                if (!bl) {
                    for (int i = 0; i < n - 1; ++i) {
                        sB.append("\t");
                    }
                }
                sB.append(bl ? sV.escape() : SV.sValue(sV));
            }
        }
    }

    static P3 ptValue(SV sV) {
        switch (sV.tok) {
            case 8: {
                return (P3)sV.value;
            }
            case 4: {
                Object object = Escape.uP((String)sV.value);
                if (!(object instanceof P3)) break;
                return (P3)object;
            }
        }
        return null;
    }

    static P4 pt4Value(SV sV) {
        switch (sV.tok) {
            case 9: {
                return (P4)sV.value;
            }
            case 4: {
                Object object = Escape.uP((String)sV.value);
                if (!(object instanceof P4)) break;
                return (P4)object;
            }
        }
        return null;
    }

    private static float toFloat(String string) {
        if (string.equalsIgnoreCase("true")) {
            return 1.0f;
        }
        if (string.equalsIgnoreCase("false") || string.length() == 0) {
            return 0.0f;
        }
        return Parser.parseFloatStrict(string);
    }

    static SV concatList(SV sV, SV sV2, boolean bl) {
        int n;
        JmolList<SV> jmolList = sV.getList();
        JmolList<SV> jmolList2 = sV2.getList();
        if (!bl) {
            if (jmolList2 == null) {
                jmolList.addLast(SV.newScriptVariableToken(sV2));
            } else {
                for (int i = 0; i < jmolList2.size(); ++i) {
                    jmolList.addLast((SV)jmolList2.get(i));
                }
            }
            return sV;
        }
        JmolList<SV> jmolList3 = new JmolList<SV>();
        if (jmolList == null) {
            jmolList3.addLast(sV);
        } else {
            for (n = 0; n < jmolList.size(); ++n) {
                jmolList3.addLast((SV)jmolList.get(n));
            }
        }
        if (jmolList2 == null) {
            jmolList3.addLast(sV2);
        } else {
            for (n = 0; n < jmolList2.size(); ++n) {
                jmolList3.addLast((SV)jmolList2.get(n));
            }
        }
        return SV.getVariableList(jmolList3);
    }

    static BS bsSelectToken(T t) {
        t = SV.selectItemTok2(t, Integer.MIN_VALUE);
        return (BS)t.value;
    }

    static BS bsSelectVar(SV sV) {
        if (sV.index == Integer.MAX_VALUE) {
            sV = SV.selectItemVar(sV);
        }
        return (BS)sV.value;
    }

    static BS bsSelectRange(T t, int n) {
        t = SV.selectItemTok(t);
        t = SV.selectItemTok2(t, n <= 0 ? n : 1);
        t = SV.selectItemTok2(t, n <= 0 ? 0x7FFFFFFE : n);
        return (BS)t.value;
    }

    static SV selectItemVar(SV sV) {
        if (sV.index != Integer.MAX_VALUE || sV.tok == 7 && sV.intValue == Integer.MAX_VALUE) {
            return sV;
        }
        return SV.selectItemVar2(sV, Integer.MIN_VALUE);
    }

    static T selectItemTok(T t) {
        return SV.selectItemTok2(t, Integer.MIN_VALUE);
    }

    static SV selectItemVar2(SV sV, int n) {
        return (SV)SV.selectItemTok2(sV, n);
    }

    static T selectItemTok2(T t, int n) {
        switch (t.tok) {
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            default: {
                return t;
            }
        }
        BS bS = null;
        String string = null;
        int n2 = t.intValue;
        if (n2 == Integer.MAX_VALUE) {
            if (n == Integer.MIN_VALUE) {
                n = n2;
            }
            SV sV = SV.newScriptVariableIntValue(t.tok, n, t.value);
            return sV;
        }
        int n3 = 0;
        boolean bl = t instanceof SV && ((SV)t).index != Integer.MAX_VALUE;
        SV sV = SV.newScriptVariableIntValue(t.tok, Integer.MAX_VALUE, null);
        switch (t.tok) {
            case 10: {
                if (t.value instanceof Bond.BondSet) {
                    bS = new Bond.BondSet((BS)t.value, ((Bond.BondSet)t.value).getAssociatedAtoms());
                    n3 = BSUtil.cardinalityOf(bS);
                    break;
                }
                bS = BSUtil.copy((BS)t.value);
                n3 = bl ? 1 : BSUtil.cardinalityOf(bS);
                break;
            }
            case 7: {
                n3 = ((SV)t).getList().size();
                break;
            }
            case 4: {
                string = (String)t.value;
                n3 = string.length();
                break;
            }
            case 11: {
                n3 = -3;
                break;
            }
            case 12: {
                n3 = -4;
            }
        }
        if (n3 < 0) {
            n3 = -n3;
            if (n2 > 0 && Math.abs(n2) > n3) {
                int n4 = n2 % 10;
                int n5 = (n2 - n4) / 10;
                if (n4 > 0 && n4 <= n3 && n5 <= n3) {
                    if (t.tok == 11) {
                        return SV.newVariable(3, Float.valueOf(((Matrix3f)t.value).getElement(n5 - 1, n4 - 1)));
                    }
                    return SV.newVariable(3, Float.valueOf(((Matrix4f)t.value).getElement(n5 - 1, n4 - 1)));
                }
                return SV.newVariable(4, "");
            }
            if (Math.abs(n2) > n3) {
                return SV.newVariable(4, "");
            }
            float[] fArray = new float[n3];
            if (n3 == 3) {
                if (n2 < 0) {
                    ((Matrix3f)t.value).getColumn(-1 - n2, fArray);
                } else {
                    ((Matrix3f)t.value).getRow(n2 - 1, fArray);
                }
            } else if (n2 < 0) {
                ((Matrix4f)t.value).getColumn(-1 - n2, fArray);
            } else {
                ((Matrix4f)t.value).getRow(n2 - 1, fArray);
            }
            if (n == Integer.MIN_VALUE) {
                return SV.getVariableAF(fArray);
            }
            if (n < 1 || n > n3) {
                return SV.newVariable(4, "");
            }
            return SV.newVariable(3, Float.valueOf(fArray[n - 1]));
        }
        if (n2 <= 0) {
            n2 = n3 + n2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n == 0) {
            n = n3;
        } else if (n < 0) {
            n = n3 + n;
        }
        if (n > n3) {
            n = n3;
        } else if (n < n2) {
            n = n2;
        }
        switch (t.tok) {
            case 10: {
                sV.value = bS;
                if (bl) {
                    if (n2 <= 1) break;
                    bS.clearAll();
                    break;
                }
                int n6 = 0;
                int n7 = bS.nextSetBit(0);
                while (n7 >= 0) {
                    if (++n6 < n2 || n6 > n) {
                        bS.clear(n7);
                    }
                    n7 = bS.nextSetBit(n7 + 1);
                }
                break;
            }
            case 4: {
                if (n2 < 1 || n2 > n3) {
                    sV.value = "";
                    break;
                }
                sV.value = string.substring(n2 - 1, n);
                break;
            }
            case 7: {
                if (n2 < 1 || n2 > n3 || n > n3) {
                    return SV.newVariable(4, "");
                }
                if (n == n2) {
                    return (T)((SV)t).getList().get(n2 - 1);
                }
                JmolList<SV> jmolList = new JmolList<SV>();
                JmolList<SV> jmolList2 = ((SV)t).getList();
                int n8 = n - n2 + 1;
                for (int i = 0; i < n8; ++i) {
                    jmolList.addLast(SV.newScriptVariableToken((T)jmolList2.get(i + n2 - 1)));
                }
                sV.value = jmolList;
            }
        }
        return sV;
    }

    boolean setSelectedValue(int n, SV sV) {
        if (n == Integer.MAX_VALUE) {
            return false;
        }
        switch (this.tok) {
            case 11: 
            case 12: {
                JmolList<SV> jmolList;
                int n2;
                int n3 = n2 = this.tok == 11 ? 3 : 4;
                if (n > 10) {
                    int n4 = n % 10;
                    int n5 = (n - n4) / 10;
                    if (n4 > 0 && n4 <= n2 && n5 <= n2) {
                        if (this.tok == 11) {
                            ((Matrix3f)this.value).setElement(n5 - 1, n4 - 1, SV.fValue(sV));
                        } else {
                            ((Matrix4f)this.value).setElement(n5 - 1, n4 - 1, SV.fValue(sV));
                        }
                        return true;
                    }
                }
                if (n != 0 && Math.abs(n) <= n2 && sV.tok == 7 && (jmolList = sV.getList()).size() == n2) {
                    float[] fArray = new float[n2];
                    for (int i = 0; i < n2; ++i) {
                        fArray[i] = SV.fValue((T)jmolList.get(i));
                    }
                    if (n > 0) {
                        if (this.tok == 11) {
                            ((Matrix3f)this.value).setRowA(n - 1, fArray);
                        } else {
                            ((Matrix4f)this.value).setRow(n - 1, fArray);
                        }
                    } else if (this.tok == 11) {
                        ((Matrix3f)this.value).setColumnA(-1 - n, fArray);
                    } else {
                        ((Matrix4f)this.value).setColumn(-1 - n, fArray);
                    }
                    return true;
                }
                return false;
            }
            case 4: {
                String string = (String)this.value;
                int n6 = string.length();
                if (n <= 0) {
                    n = n6 + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                while (n >= string.length()) {
                    string = string + " ";
                }
                this.value = string.substring(0, n) + SV.sValue(sV) + string.substring(n + 1);
                return true;
            }
            case 7: {
                int n7 = this.getList().size();
                if (n <= 0) {
                    n = n7 + n;
                }
                if (--n < 0) {
                    n = 0;
                }
                if (n7 <= n) {
                    for (int i = n7; i <= n; ++i) {
                        this.getList().addLast(SV.newVariable(4, ""));
                    }
                }
                this.getList().set(n, sV);
                return true;
            }
        }
        return false;
    }

    public String escape() {
        switch (this.tok) {
            case 4: {
                return Escape.eS((String)this.value);
            }
            case 6: 
            case 7: {
                SB sB = new SB();
                Hashtable<Object, Boolean> hashtable = new Hashtable<Object, Boolean>();
                SV.sValueArray(sB, this, hashtable, 0, true);
                return sB.toString();
            }
        }
        return SV.sValue(this);
    }

    static Object unescapePointOrBitsetAsVariable(Object object) {
        if (object == null) {
            return object;
        }
        Object object2 = null;
        String string = null;
        if (object instanceof SV) {
            SV sV = (SV)object;
            switch (sV.tok) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    object2 = sV.value;
                    break;
                }
                case 4: {
                    string = (String)sV.value;
                    break;
                }
                default: {
                    string = SV.sValue(sV);
                    break;
                }
            }
        } else if (object instanceof String) {
            string = (String)object;
        }
        if (string != null && string.length() == 0) {
            return string;
        }
        if (object2 == null) {
            object2 = Escape.unescapePointOrBitsetOrMatrixOrArray(string);
        }
        if (object2 instanceof P3) {
            return SV.newVariable(8, object2);
        }
        if (object2 instanceof P4) {
            return SV.newVariable(9, object2);
        }
        if (object2 instanceof BS) {
            if (string != null && string.indexOf("[{") == 0) {
                object2 = new Bond.BondSet((BS)object2);
            }
            return SV.newVariable(10, object2);
        }
        if (object2 instanceof Matrix3f) {
            return SV.newVariable(11, object2);
        }
        if (object2 instanceof Matrix4f) {
            return SV.newVariable(12, object2);
        }
        return object;
    }

    public static SV getBoolean(boolean bl) {
        return SV.newScriptVariableToken(bl ? vT : vF);
    }

    static Object sprintf(String string, SV sV) {
        if (sV == null) {
            return string;
        }
        int[] nArray = (int[])(string.indexOf("d") >= 0 || string.indexOf("i") >= 0 ? new int[1] : null);
        float[] fArray = string.indexOf("f") >= 0 ? new float[1] : null;
        double[] dArray = string.indexOf("e") >= 0 ? new double[1] : null;
        boolean bl = string.indexOf("s") >= 0;
        boolean bl2 = string.indexOf("p") >= 0 && sV.tok == 8;
        boolean bl3 = string.indexOf("q") >= 0 && sV.tok == 9;
        Object[] objectArray = new Object[]{nArray, fArray, dArray, null, null, null};
        if (sV.tok != 7) {
            return SV.sprintf(string, sV, objectArray, nArray, fArray, dArray, bl, bl2, bl3);
        }
        JmolList<SV> jmolList = sV.getList();
        String[] stringArray = new String[jmolList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = SV.sprintf(string, (SV)jmolList.get(i), objectArray, nArray, fArray, dArray, bl, bl2, bl3);
        }
        return stringArray;
    }

    private static String sprintf(String string, SV sV, Object[] objectArray, int[] nArray, float[] fArray, double[] dArray, boolean bl, boolean bl2, boolean bl3) {
        if (nArray != null) {
            nArray[0] = SV.iValue(sV);
        }
        if (fArray != null) {
            fArray[0] = SV.fValue(sV);
        }
        if (dArray != null) {
            dArray[0] = SV.fValue(sV);
        }
        if (bl) {
            objectArray[3] = SV.sValue(sV);
        }
        if (bl2) {
            objectArray[4] = sV.value;
        }
        if (bl3) {
            objectArray[5] = sV.value;
        }
        return TextFormat.sprintf(string, "IFDspq", objectArray);
    }

    static String sprintfArray(SV[] sVArray) {
        switch (sVArray.length) {
            case 0: {
                return "";
            }
            case 1: {
                return SV.sValue(sVArray[0]);
            }
        }
        String[] stringArray = TextFormat.split(TextFormat.simpleReplace(SV.sValue(sVArray[0]), "%%", "\u0001"), '%');
        SB sB = new SB();
        sB.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            Object object = SV.sprintf(TextFormat.formatCheck("%" + stringArray[i]), i < sVArray.length ? sVArray[i] : null);
            if (Escape.isAS(object)) {
                String[] stringArray2 = (String[])object;
                for (int j = 0; j < stringArray2.length; ++j) {
                    sB.append(stringArray2[j]).append("\n");
                }
                continue;
            }
            sB.append((String)object);
        }
        return sB.toString();
    }

    @Override
    public String toString() {
        return this.toString2() + "[" + this.myName + " index =" + this.index + " intValue=" + this.intValue + "]";
    }

    public static BS getBitSet(SV sV, boolean bl) {
        switch (sV.tok) {
            case 10: {
                return SV.bsSelectVar(sV);
            }
            case 7: {
                BS bS = new BS();
                JmolList jmolList = (JmolList)sV.value;
                for (int i = 0; i < jmolList.size(); ++i) {
                    if (((SV)jmolList.get(i)).unEscapeBitSetArray(bS) || !bl) continue;
                    return null;
                }
                return bS;
            }
        }
        return bl ? null : new BS();
    }

    static boolean areEqual(SV sV, SV sV2) {
        if (sV == null || sV2 == null) {
            return false;
        }
        if (sV.tok == 4 && sV2.tok == 4) {
            return SV.sValue(sV).equalsIgnoreCase(SV.sValue(sV2));
        }
        if (sV.tok == 8 && sV2.tok == 8) {
            return (double)((P3)sV.value).distance((P3)sV2.value) < 1.0E-6;
        }
        if (sV.tok == 9 && sV2.tok == 9) {
            return (double)((P4)sV.value).distance((P4)sV2.value) < 1.0E-6;
        }
        return (double)Math.abs(SV.fValue(sV) - SV.fValue(sV2)) < 1.0E-6;
    }

    SV sortOrReverse(int n) {
        JmolList<SV> jmolList = this.getList();
        if (jmolList == null || jmolList.size() < 2) {
            return this;
        }
        if (n == Integer.MIN_VALUE) {
            int n2 = jmolList.size();
            for (int i = 0; i < n2; ++i) {
                SV sV = (SV)jmolList.get(i);
                jmolList.set(i, jmolList.get(--n2));
                jmolList.set(n2, sV);
            }
        } else {
            Collections.sort(this.getList(), new Sort(--n));
        }
        return this;
    }

    boolean unEscapeBitSetArray(BS bS) {
        switch (this.tok) {
            case 4: {
                BS bS2 = Escape.uB((String)this.value);
                if (bS2 == null) {
                    return false;
                }
                bS.or(bS2);
                return true;
            }
            case 10: {
                bS.or((BS)this.value);
                return true;
            }
        }
        return false;
    }

    static BS unEscapeBitSetArray(ArrayList<SV> arrayList, boolean bl) {
        BS bS = new BS();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (arrayList.get(i).unEscapeBitSetArray(bS) || !bl) continue;
            return null;
        }
        return bS;
    }

    static String[] listValue(T t) {
        if (t.tok != 7) {
            return new String[]{SV.sValue(t)};
        }
        JmolList<SV> jmolList = ((SV)t).getList();
        String[] stringArray = new String[jmolList.size()];
        int n = jmolList.size();
        while (--n >= 0) {
            stringArray[n] = SV.sValue((T)jmolList.get(n));
        }
        return stringArray;
    }

    static float[] flistValue(T t, int n) {
        if (t.tok != 7) {
            return new float[]{SV.fValue(t)};
        }
        JmolList<SV> jmolList = ((SV)t).getList();
        float[] fArray = new float[Math.max(n, jmolList.size())];
        if (n == 0) {
            n = fArray.length;
        }
        int n2 = Math.min(jmolList.size(), n);
        while (--n2 >= 0) {
            fArray[n2] = SV.fValue((T)jmolList.get(n2));
        }
        return fArray;
    }

    void toArray() {
        int n;
        Matrix3f matrix3f = null;
        Matrix4f matrix4f = null;
        switch (this.tok) {
            case 11: {
                matrix3f = (Matrix3f)this.value;
                n = 3;
                break;
            }
            case 12: {
                matrix4f = (Matrix4f)this.value;
                n = 4;
                break;
            }
            default: {
                return;
            }
        }
        this.tok = 7;
        JmolList jmolList = new JmolList();
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[n];
            if (matrix3f == null) {
                matrix4f.getRow(i, fArray);
            } else {
                matrix3f.getRow(i, fArray);
            }
            jmolList.set(i, SV.getVariableAF(fArray));
        }
        this.value = jmolList;
    }

    SV mapValue(String string) {
        return this.tok == 6 ? (SV)((Map)this.value).get(string) : null;
    }

    public JmolList<SV> getList() {
        return this.tok == 7 ? (JmolList)this.value : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Sort
    implements Comparator<SV> {
        private int arrayPt;

        protected Sort(int n) {
            this.arrayPt = n;
        }

        @Override
        public int compare(SV sV, SV sV2) {
            if (sV.tok != sV2.tok) {
                if (sV.tok == 3 || sV.tok == 2 || sV2.tok == 3 || sV2.tok == 2) {
                    float f;
                    float f2 = SV.fValue(sV);
                    return f2 < (f = SV.fValue(sV2)) ? -1 : (f2 > f ? 1 : 0);
                }
                if (sV.tok == 4 || sV2.tok == 4) {
                    return SV.sValue(sV).compareTo(SV.sValue(sV2));
                }
            }
            switch (sV.tok) {
                case 4: {
                    return SV.sValue(sV).compareTo(SV.sValue(sV2));
                }
                case 7: {
                    JmolList<SV> jmolList = sV.getList();
                    JmolList<SV> jmolList2 = sV2.getList();
                    if (jmolList.size() != jmolList2.size()) {
                        return jmolList.size() < jmolList2.size() ? -1 : 1;
                    }
                    int n = this.arrayPt;
                    if (n < 0) {
                        n += jmolList.size();
                    }
                    if (n < 0 || n >= jmolList.size()) {
                        return 0;
                    }
                    return this.compare((SV)jmolList.get(n), (SV)jmolList2.get(n));
                }
            }
            float f = SV.fValue(sV);
            float f3 = SV.fValue(sV2);
            return f < f3 ? -1 : (f > f3 ? 1 : 0);
        }
    }
}

