/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.constant.EnumPalette;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.render.ShapeRenderer;
import org.jmol.util.BS;
import org.jmol.util.C;
import org.jmol.util.JmolEdge;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.V3;

public class SticksRenderer
extends ShapeRenderer {
    private boolean showMultipleBonds;
    private float multipleBondSpacing;
    private float multipleBondRadiusFactor;
    private byte modeMultipleBond;
    private boolean isCartesianExport;
    private byte endcaps;
    private boolean ssbondsBackbone;
    private boolean hbondsBackbone;
    private boolean bondsBackbone;
    private boolean hbondsSolid;
    private Atom atomA;
    private Atom atomB;
    private Bond bond;
    private int xA;
    private int yA;
    private int zA;
    private int xB;
    private int yB;
    private int zB;
    private int dx;
    private int dy;
    private int mag2d;
    private short colixA;
    private short colixB;
    private int width;
    private boolean lineBond;
    private int bondOrder;
    private boolean renderWireframe;
    private boolean isAntialiased;
    private boolean slabbing;
    private boolean slabByAtom;
    private int[] dashDots;
    private final V3 x = new V3();
    private final V3 y = new V3();
    private final V3 z = new V3();
    private final P3 p1 = new P3();
    private final P3 p2 = new P3();
    private final P3i s1 = new P3i();
    private final P3i s2 = new P3i();
    private final BS bsForPass2 = BS.newN(64);
    private boolean isPass2;
    private Atom atomA0;
    private Atom atomB0;
    private int xAxis1;
    private int yAxis1;
    private int xAxis2;
    private int yAxis2;
    private int dxStep;
    private int dyStep;
    private static final int[] dashes = new int[]{12, 0, 0, 2, 5, 7, 10};
    private static final int[] hDashes = new int[]{10, 7, 6, 1, 3, 4, 6, 7, 9};
    private static final int[] sixdots = new int[]{12, 3, 6, 1, 3, 5, 7, 9, 11};
    private static final int[] fourdots = new int[]{13, 3, 5, 2, 5, 8, 11};
    private static final int[] twodots = new int[]{12, 3, 4, 3, 9};

    protected boolean render() {
        this.isPass2 = this.g3d.isPass2();
        if (!this.isPass2) {
            this.bsForPass2.clearAll();
        }
        this.slabbing = this.viewer.getSlabEnabled();
        this.slabByAtom = this.viewer.getBoolean(603979938);
        this.endcaps = (byte)3;
        this.dashDots = this.viewer.getBoolean(603979888) ? sixdots : dashes;
        this.multipleBondSpacing = this.viewer.getFloat(570425369);
        boolean bl = this.isCartesianExport = this.exportType == 1;
        if (this.multipleBondSpacing == 0.0f && this.isCartesianExport) {
            this.multipleBondSpacing = 0.2f;
        }
        this.multipleBondRadiusFactor = this.viewer.getFloat(570425368);
        this.showMultipleBonds = this.multipleBondSpacing != 0.0f && this.viewer.getBoolean(603979928);
        this.modeMultipleBond = this.viewer.getModeMultipleBond();
        this.renderWireframe = this.viewer.getInMotion() && this.viewer.getBoolean(603979976);
        this.ssbondsBackbone = this.viewer.getBoolean(603979952);
        this.hbondsBackbone = this.viewer.getBoolean(603979852);
        this.bondsBackbone = this.hbondsBackbone | this.ssbondsBackbone;
        this.hbondsSolid = this.viewer.getBoolean(603979854);
        this.isAntialiased = this.g3d.isAntialiased();
        Bond[] bondArray = this.modelSet.bonds;
        boolean bl2 = false;
        if (!this.isExport && this.isPass2) {
            int n = this.bsForPass2.nextSetBit(0);
            while (n >= 0) {
                this.bond = bondArray[n];
                this.renderBond();
                n = this.bsForPass2.nextSetBit(n + 1);
            }
        } else {
            int n = this.modelSet.bondCount;
            while (--n >= 0) {
                this.bond = bondArray[n];
                if ((this.bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || !this.renderBond()) continue;
                bl2 = true;
                this.bsForPass2.set(n);
            }
        }
        return bl2;
    }

    private boolean renderBond() {
        int n;
        this.atomA = this.atomA0 = this.bond.getAtom1();
        this.atomB = this.atomB0 = this.bond.getAtom2();
        int n2 = this.bond.order & 0xFFFDFFFF;
        if (this.bondsBackbone) {
            if (this.ssbondsBackbone && (n2 & 0x100) != 0) {
                this.atomA = this.atomA.getGroup().getLeadAtomOr(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtomOr(this.atomB);
            } else if (this.hbondsBackbone && Bond.isOrderH(n2)) {
                this.atomA = this.atomA.getGroup().getLeadAtomOr(this.atomA);
                this.atomB = this.atomB.getGroup().getLeadAtomOr(this.atomB);
            }
        }
        if (!(this.isPass2 || this.atomA.isInFrame() && this.atomB.isInFrame() && this.g3d.isInDisplayRange(this.atomA.screenX, this.atomA.screenY) && this.g3d.isInDisplayRange(this.atomB.screenX, this.atomB.screenY) && !this.modelSet.isAtomHidden(this.atomA.getIndex()) && !this.modelSet.isAtomHidden(this.atomB.getIndex()))) {
            return false;
        }
        if (this.slabbing) {
            if (this.g3d.isClippedZ(this.atomA.screenZ) && this.g3d.isClippedZ(this.atomB.screenZ)) {
                return false;
            }
            if (this.slabByAtom && (this.g3d.isClippedZ(this.atomA.screenZ) || this.g3d.isClippedZ(this.atomB.screenZ))) {
                return false;
            }
        }
        this.zA = this.atomA.screenZ;
        this.zB = this.atomB.screenZ;
        if (this.zA == 1 || this.zB == 1) {
            return false;
        }
        this.colixA = this.atomA0.getColix();
        this.colixB = this.atomB0.getColix();
        this.colix = this.bond.colix;
        if ((this.colix & 0xFFFF87FF) == 2) {
            this.colix = (short)(this.colix & 0x7800);
            this.colixA = C.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomA0, EnumPalette.CPK.id)), this.colixA);
            this.colixB = C.getColixInherited((short)(this.colix | this.viewer.getColixAtomPalette(this.atomB0, EnumPalette.CPK.id)), this.colixB);
        } else {
            this.colixA = C.getColixInherited(this.colix, this.colixA);
            this.colixB = C.getColixInherited(this.colix, this.colixB);
        }
        boolean bl = false;
        if (!this.isExport && !this.isPass2) {
            boolean bl2;
            n = !C.isColixTranslucent(this.colixA) ? 1 : 0;
            boolean bl3 = bl2 = !C.isColixTranslucent(this.colixB);
            if (n == 0 || !bl2) {
                if (n == 0 && !bl2 && !bl) {
                    this.g3d.setColix(n == 0 ? this.colixA : this.colixB);
                    return true;
                }
                bl = true;
            }
        }
        this.bondOrder = n2 & 0xFFFDFFFF;
        if ((this.bondOrder & 0xE0) == 0) {
            if ((this.bondOrder & 0x100) != 0) {
                this.bondOrder &= 0xFFFFFEFF;
            }
            if ((this.bondOrder & 0x3FF) != 0 && (!this.showMultipleBonds || this.modeMultipleBond == 0 || this.modeMultipleBond == 2 && this.mad > 500)) {
                this.bondOrder = 1;
            }
        }
        n = 0;
        switch (this.bondOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 17: 
            case 513: {
                this.bondOrder = 1;
                n = n2 == 513 ? 0 : 1;
                break;
            }
            case 514: 
            case 515: {
                this.bondOrder = 2;
                n = n2 == 515 ? this.getAromaticDottedBondMask() : 0;
                break;
            }
            default: {
                if ((this.bondOrder & 0xE0) != 0) {
                    this.bondOrder = JmolEdge.getPartialBondOrder(n2);
                    n = JmolEdge.getPartialBondDotted(n2);
                    break;
                }
                if (Bond.isOrderH(this.bondOrder)) {
                    this.bondOrder = 1;
                    if (this.hbondsSolid) break;
                    n = -1;
                    break;
                }
                if (this.bondOrder != 32768) break;
                this.bondOrder = 1;
            }
        }
        this.xA = this.atomA.screenX;
        this.yA = this.atomA.screenY;
        this.xB = this.atomB.screenX;
        this.yB = this.atomB.screenY;
        this.mad = this.bond.mad;
        if (this.multipleBondRadiusFactor > 0.0f && this.bondOrder > 1) {
            this.mad = (short)((float)this.mad * this.multipleBondRadiusFactor);
        }
        this.dx = this.xB - this.xA;
        this.dy = this.yB - this.yA;
        this.width = (int)this.viewer.scaleToScreen((this.zA + this.zB) / 2, this.mad);
        if (this.renderWireframe && this.width > 0) {
            this.width = 1;
        }
        if (!this.isCartesianExport) {
            boolean bl4 = this.lineBond = this.width <= 1;
            if (this.lineBond && this.isAntialiased) {
                this.width = 3;
                this.lineBond = false;
            }
        }
        switch (n) {
            case -1: {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, hDashes);
                break;
            }
            default: {
                this.drawBond(n);
            }
        }
        return bl;
    }

    private void drawBond(int n) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        if (this.isCartesianExport && this.bondOrder == 1) {
            this.g3d.drawBond(this.atomA, this.atomB, this.colixA, this.colixB, this.endcaps, this.mad, -1);
            return;
        }
        boolean bl4 = bl3 = this.dx == 0 && this.dy == 0;
        if (bl3 && this.lineBond) {
            return;
        }
        boolean bl5 = this.bondOrder > 1 && this.multipleBondSpacing > 0.0f;
        boolean bl6 = bl2 = bl5 && (this.viewer.getHybridizationAndAxes(this.atomA.index, this.z, this.x, "pz") != null || this.viewer.getHybridizationAndAxes(this.atomB.index, this.z, this.x, "pz") != null) && !Float.isNaN(this.x.x);
        if (bl3 && !bl5) {
            int n2 = this.width / 8 + 3;
            int n3 = this.width + n2;
            int n4 = this.yA - (this.bondOrder - 1) * n3 / 2;
            do {
                this.fillCylinder(this.colixA, this.colixA, this.endcaps, this.width, this.xA, n4, this.zA, this.xA, n4, this.zA);
                n4 += n3;
            } while (--this.bondOrder > 0);
            return;
        }
        boolean bl7 = bl = (n & 1) != 0;
        if (this.bondOrder == 1) {
            if (bl) {
                this.drawDashed(this.xA, this.yA, this.zA, this.xB, this.yB, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xA, this.yA, this.zA, this.xB, this.yB, this.zB);
            }
            return;
        }
        if (bl5) {
            if (!bl2) {
                this.z.set((float)Math.PI, (float)Math.E, 8.539734f);
            }
            this.x.sub2(this.atomB, this.atomA);
            this.y.cross(this.x, this.z);
            this.y.normalize();
            if (Float.isNaN(this.y.x)) {
                this.z.set((float)Math.PI, (float)Math.E, 8.539734f);
                this.y.cross(this.x, this.z);
                this.y.cross(this.y, this.x);
                this.y.normalize();
            }
            this.y.scale(this.multipleBondSpacing);
            this.x.setT(this.y);
            this.x.scale((float)(this.bondOrder - 1) / 2.0f);
            this.p1.sub2(this.atomA, this.x);
            this.p2.sub2(this.atomB, this.x);
            while (true) {
                if (this.isCartesianExport && !bl) {
                    this.g3d.drawBond(this.p1, this.p2, this.colixA, this.colixB, this.endcaps, this.mad, -2);
                } else {
                    this.viewer.transformPtScr(this.p1, this.s1);
                    this.viewer.transformPtScr(this.p2, this.s2);
                    if (bl) {
                        this.drawDashed(this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z, this.dashDots);
                    } else {
                        this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.s1.x, this.s1.y, this.s1.z, this.s2.x, this.s2.y, this.s2.z);
                    }
                    boolean bl8 = bl = ((n >>= 1) & 1) != 0;
                }
                if (--this.bondOrder <= 0) break;
                this.p1.add(this.y);
                this.p2.add(this.y);
                this.stepAxisCoordinates();
            }
            return;
        }
        int n5 = this.dx * this.dx;
        int n6 = this.dy * this.dy;
        this.mag2d = (int)Math.round(Math.sqrt(n5 + n6));
        this.resetAxisCoordinates();
        while (true) {
            if ((n & 1) != 0) {
                this.drawDashed(this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB, this.dashDots);
            } else {
                this.fillCylinder(this.colixA, this.colixB, this.endcaps, this.width, this.xAxis1, this.yAxis1, this.zA, this.xAxis2, this.yAxis2, this.zB);
            }
            n >>= 1;
            if (--this.bondOrder <= 0) break;
            this.stepAxisCoordinates();
        }
    }

    private void resetAxisCoordinates() {
        int n = this.mag2d >> 3;
        if (this.multipleBondSpacing != -1.0f && this.multipleBondSpacing < 0.0f) {
            n = (int)((float)n * -this.multipleBondSpacing);
        }
        int n2 = this.width + n;
        this.dxStep = n2 * this.dy / this.mag2d;
        this.dyStep = n2 * -this.dx / this.mag2d;
        this.xAxis1 = this.xA;
        this.yAxis1 = this.yA;
        this.xAxis2 = this.xB;
        this.yAxis2 = this.yB;
        int n3 = this.bondOrder - 1;
        this.xAxis1 -= this.dxStep * n3 / 2;
        this.yAxis1 -= this.dyStep * n3 / 2;
        this.xAxis2 -= this.dxStep * n3 / 2;
        this.yAxis2 -= this.dyStep * n3 / 2;
    }

    private void stepAxisCoordinates() {
        this.xAxis1 += this.dxStep;
        this.yAxis1 += this.dyStep;
        this.xAxis2 += this.dxStep;
        this.yAxis2 += this.dyStep;
    }

    private int getAromaticDottedBondMask() {
        Atom atom = this.atomB.findAromaticNeighbor(this.atomA.getIndex());
        if (atom == null) {
            return 1;
        }
        int n = atom.screenY - this.yA;
        int n2 = atom.screenX - this.xA;
        return this.dx * n - this.dy * n2 < 0 ? 2 : 1;
    }

    private void drawDashed(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        boolean bl;
        int n7 = n4 - n;
        int n8 = n5 - n2;
        int n9 = n6 - n3;
        boolean bl2 = bl = nArray == sixdots;
        if (bl) {
            if (this.mad * 4 > 1500) {
                nArray = twodots;
            } else if (this.mad * 6 > 1500) {
                nArray = fourdots;
            }
        }
        float f = nArray[0];
        int n10 = nArray[1];
        int n11 = nArray[2];
        short s = this.colixA;
        short s2 = n11 == 0 ? this.colixB : this.colixA;
        for (int i = 3; i < nArray.length; ++i) {
            int n12 = nArray[i];
            int n13 = (int)Math.floor((float)n + (float)(n7 * n12) / f);
            int n14 = (int)Math.floor((float)n2 + (float)(n8 * n12) / f);
            int n15 = (int)Math.floor((float)n3 + (float)(n9 * n12) / f);
            if (bl) {
                this.s1.set(n13, n14, n15);
                if (i == n10) {
                    this.g3d.setColix(this.colixA);
                } else if (i == n11) {
                    this.g3d.setColix(this.colixB);
                }
                this.g3d.fillSphereI(this.width, this.s1);
                continue;
            }
            if (i == n10) {
                s = this.colixB;
            }
            n12 = nArray[++i];
            if (i == n11) {
                s2 = this.colixB;
            }
            int n16 = (int)Math.floor((float)n + (float)(n7 * n12) / f);
            int n17 = (int)Math.floor((float)n2 + (float)(n8 * n12) / f);
            int n18 = (int)Math.floor((float)n3 + (float)(n9 * n12) / f);
            this.fillCylinder(s, s2, (byte)2, this.width, n13, n14, n15, n16, n17, n18);
        }
    }

    private void fillCylinder(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.lineBond) {
            this.g3d.drawLine(s, s2, n2, n3, n4, n5, n6, n7);
        } else {
            this.g3d.fillCylinderXYZ(s, s2, by, !this.isExport || this.mad == 1 ? n : (int)this.mad, n2, n3, n4, n5, n6, n7);
        }
    }
}

