/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.render.ShapeRenderer;
import org.jmol.render.TextRenderer;
import org.jmol.shape.Labels;
import org.jmol.shape.Object2d;
import org.jmol.shape.Text;
import org.jmol.util.JmolFont;
import org.jmol.util.P3;
import org.jmol.util.P3i;

public class LabelsRenderer
extends ShapeRenderer {
    byte fidPrevious;
    protected JmolFont font3d;
    protected int ascent;
    protected int descent;
    final int[] minZ = new int[1];
    private int zCutoff;
    protected float[] xy = new float[3];
    private P3 pTemp = new P3();
    private P3i screen = new P3i();

    protected boolean render() {
        this.fidPrevious = 0;
        this.zCutoff = this.viewer.getZShadeStart();
        Labels labels = (Labels)this.shape;
        String[] stringArray = labels.strings;
        short[] sArray = labels.bgcolixes;
        if (this.isExport) {
            sArray = this.g3d.getBgColixes(sArray);
        }
        byte[] byArray = labels.fids;
        int[] nArray = labels.offsets;
        if (stringArray == null) {
            return false;
        }
        Atom[] atomArray = this.modelSet.atoms;
        short s = this.viewer.getColixBackgroundContrast();
        int n = this.viewer.getBackgroundArgb();
        float f = this.viewer.getScalePixelsPerAngstrom(true);
        float f2 = this.viewer.getBoolean(603979845) ? f * 10000.0f : 0.0f;
        float f3 = this.viewer.getImageFontScaling();
        int n2 = -1;
        this.minZ[0] = Integer.MAX_VALUE;
        boolean bl = this.g3d.isAntialiased();
        int n3 = stringArray.length;
        while (--n3 >= 0) {
            float[] fArray;
            Object object;
            String string;
            Atom atom = atomArray[n3];
            if (!atom.isVisible(this.myVisibilityFlag) || (string = stringArray[n3]) == null || string.length() == 0 || labels.mads != null && labels.mads[n3] < 0) continue;
            short s2 = labels.getColix2(n3, atom, false);
            short s3 = labels.getColix2(n3, atom, true);
            if (s3 == 0 && this.g3d.getColorArgbOrGray(s2) == n) {
                s2 = s;
            }
            byte by = byArray == null || n3 >= byArray.length || byArray[n3] == 0 ? labels.zeroFontId : byArray[n3];
            int n4 = nArray == null || n3 >= nArray.length ? 0 : nArray[n3];
            boolean bl2 = (n4 & 0x20) != 0;
            boolean bl3 = (n4 & 0x10) != 0;
            boolean bl4 = (n4 & 0x80) != 0;
            int n5 = n4 >> 8;
            int n6 = Labels.getAlignment(n4);
            int n7 = n4 & 3;
            int n8 = atom.screenZ - atom.screenDiameter / 2 - 3;
            if (this.zCutoff > 0 && n8 > this.zCutoff) continue;
            if (n8 < 1) {
                n8 = 1;
            }
            int n9 = n8;
            if (bl3) {
                object = atom.getGroup();
                int n10 = ((Group)object).getGroupIndex();
                if (n10 != n2) {
                    ((Group)object).getMinZ(atomArray, this.minZ);
                    n2 = n10;
                }
                n9 = this.minZ[0];
            } else if (bl2) {
                n9 = 1;
            }
            if (n9 < 1) {
                n9 = 1;
            }
            object = labels.getLabel(n3);
            float[] fArray2 = fArray = !this.isExport || this.viewer.creatingImage ? labels.getBox(n3) : new float[5];
            if (fArray == null) {
                fArray = new float[5];
                labels.putBox(n3, fArray);
            }
            if (object != null) {
                if (((Text)object).font == null) {
                    ((Text)object).setFontFromFid(by);
                }
                if (((Text)object).pymolOffset == null) {
                    ((Object2d)object).setXYZs(atom.screenX, atom.screenY, n9, n8);
                } else {
                    if (((Text)object).pymolOffset[0] == 1.0f) {
                        this.pTemp.setT(atom);
                    } else {
                        this.pTemp.set(0.0f, 0.0f, 0.0f);
                    }
                    this.pTemp.x += ((Text)object).pymolOffset[4];
                    this.pTemp.y += ((Text)object).pymolOffset[5];
                    this.pTemp.z += ((Text)object).pymolOffset[6];
                    this.viewer.transformPtScr(this.pTemp, this.screen);
                    ((Object2d)object).setXYZs(this.screen.x, this.screen.y, this.screen.z, n8);
                }
                if (((Text)object).pymolOffset == null) {
                    ((Object2d)object).setColix(s2);
                    ((Object2d)object).setBgColix(s3);
                } else {
                    ((Text)object).setScalePixelsPerMicron(f);
                }
            } else {
                boolean bl5;
                boolean bl6;
                boolean bl7 = bl6 = n6 == 1 || n6 == 0;
                if (by != this.fidPrevious || this.ascent == 0) {
                    this.g3d.setFontFid(by);
                    this.fidPrevious = by;
                    this.font3d = this.g3d.getFont3DCurrent();
                    if (bl6) {
                        this.ascent = this.font3d.getAscent();
                        this.descent = this.font3d.getDescent();
                    }
                }
                boolean bl8 = bl5 = bl6 && f3 == 1.0f && f2 == 0.0f && string.indexOf("|") < 0 && string.indexOf("<su") < 0;
                if (bl5) {
                    boolean bl9 = (n7 & 1) != 0;
                    short s4 = (n7 & 2) != 0 && s3 != 0 ? s3 : s2;
                    fArray[0] = atom.screenX;
                    fArray[1] = atom.screenY;
                    TextRenderer.renderSimpleLabel(this.g3d, this.font3d, string, s2, s3, fArray, n9, n8, Object2d.getXOffset(n5), Object2d.getYOffset(n5), this.ascent, this.descent, bl9, s4, bl4);
                    atom = null;
                } else {
                    object = Text.newLabel(this.g3d.getGData(), this.font3d, string, s2, s3, n6, 0.0f, null);
                    ((Object2d)object).setXYZs(atom.screenX, atom.screenY, n9, n8);
                    labels.putLabel(n3, (Text)object);
                }
            }
            if (atom != null) {
                ((Object2d)object).setOffset(n5);
                if (n6 != 0 && ((Text)object).pymolOffset == null) {
                    ((Object2d)object).setAlignment(n6);
                }
                ((Object2d)object).setPointer(n7);
                TextRenderer.render((Text)object, this.viewer, this.g3d, f2, f3, bl4, fArray, this.xy);
            }
            if (bl) {
                fArray[0] = fArray[0] / 2.0f;
                fArray[1] = fArray[1] / 2.0f;
            }
            fArray[4] = n9;
        }
        return false;
    }
}

