/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.jmol.api.SymmetryInterface;
import org.jmol.constant.EnumStructure;
import org.jmol.io.OutputStringBuilder;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.JmolList;
import org.jmol.util.P3;
import org.jmol.util.SB;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model {
    public ModelSet modelSet;
    public int modelIndex;
    int fileIndex;
    public int hydrogenCount;
    public boolean isBioModel;
    public boolean isPdbWithMultipleBonds;
    protected boolean hasRasmolHBonds;
    public String loadState = "";
    public SB loadScript = new SB();
    public boolean isModelKit;
    Map<String, Integer> dataFrames;
    int dataSourceFrame = -1;
    String jmolData;
    String jmolFrameType;
    public int firstAtomIndex;
    public int atomCount = 0;
    protected final BS bsAtoms = new BS();
    final BS bsAtomsDeleted = new BS();
    public int trajectoryBaseIndex;
    public boolean isTrajectory;
    private int selectedTrajectory = -1;
    private int bondCount = -1;
    int firstMoleculeIndex;
    public int moleculeCount;
    public int nAltLocs;
    int nInsertions;
    int groupCount = -1;
    protected int chainCount = 0;
    protected Chain[] chains = new Chain[8];
    int biosymmetryCount;
    protected Map<String, Object> auxiliaryInfo;
    public Properties properties;
    float defaultRotationRadius;
    String defaultStructure;
    public StateManager.Orientation orientation;
    protected boolean structureTainted;
    public boolean isJmolDataFrame;
    public long frameDelay;
    public SymmetryInterface simpleCage;

    public ModelSet getModelSet() {
        return this.modelSet;
    }

    public boolean isModelkit() {
        return this.isModelKit;
    }

    public int getTrueAtomCount() {
        return this.bsAtoms.cardinality() - this.bsAtomsDeleted.cardinality();
    }

    void setSelectedTrajectory(int n) {
        this.selectedTrajectory = n;
    }

    public int getSelectedTrajectory() {
        return this.selectedTrajectory;
    }

    public void resetBoundCount() {
        this.bondCount = -1;
    }

    public int getBondCount() {
        if (this.bondCount >= 0) {
            return this.bondCount;
        }
        Bond[] bondArray = this.modelSet.bonds;
        this.bondCount = 0;
        int n = this.modelSet.bondCount;
        while (--n >= 0) {
            if (bondArray[n].atom1.modelIndex != this.modelIndex) continue;
            ++this.bondCount;
        }
        return this.bondCount;
    }

    public Model(ModelSet modelSet, int n, int n2, String string, Properties properties, Map<String, Object> map) {
        this.modelSet = modelSet;
        this.dataSourceFrame = this.modelIndex = n;
        this.isTrajectory = n2 >= 0;
        int n3 = this.trajectoryBaseIndex = this.isTrajectory ? n2 : n;
        if (map == null) {
            map = new Hashtable<String, Object>();
        }
        this.auxiliaryInfo = map;
        if (map.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)map.get("biosymmetryCount");
        }
        this.properties = properties;
        if (string == null) {
            this.jmolFrameType = "modelSet";
        } else {
            this.jmolData = string;
            this.isJmolDataFrame = true;
            map.put("jmolData", string);
            map.put("title", string);
            this.jmolFrameType = string.indexOf("ramachandran") >= 0 ? "ramachandran" : (string.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
    }

    void setNAltLocs(int n) {
        this.nAltLocs = n;
    }

    void setNInsertions(int n) {
        this.nInsertions = n;
    }

    public String getModelNumberDotted() {
        return this.modelSet.getModelNumberDotted(this.modelIndex);
    }

    public String getModelTitle() {
        return this.modelSet.getModelTitle(this.modelIndex);
    }

    public boolean isStructureTainted() {
        return this.structureTainted;
    }

    public Chain[] getChains() {
        return this.chains;
    }

    public int getChainCount(boolean bl) {
        if (this.chainCount > 1 && !bl) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != '\u0000') continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    public int getGroupCountHetero(boolean bl) {
        int n = 0;
        int n2 = this.chainCount;
        while (--n2 >= 0) {
            int n3 = this.chains[n2].groupCount;
            while (--n3 >= 0) {
                if (this.chains[n2].groups[n3].isHetero() != bl) continue;
                ++n;
            }
        }
        return n;
    }

    void calcSelectedGroupsCount(BS bS) {
        int n = this.chainCount;
        while (--n >= 0) {
            this.chains[n].calcSelectedGroupsCount(bS);
        }
    }

    public int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int n = this.chainCount;
            while (--n >= 0) {
                this.groupCount += this.chains[n].getGroupCount();
            }
        }
        return this.groupCount;
    }

    public Chain getChainAt(int n) {
        return n < this.chainCount ? this.chains[n] : null;
    }

    Chain getChain(char c) {
        int n = this.chainCount;
        while (--n >= 0) {
            Chain chain = this.chains[n];
            if (chain.chainID != c) continue;
            return chain;
        }
        return null;
    }

    public void fixIndices(int n, int n2, BS bS) {
        if (this.dataSourceFrame > n) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > n) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= n2;
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].fixIndices(n2, bS);
        }
        BSUtil.deleteBits(this.bsAtoms, bS);
        BSUtil.deleteBits(this.bsAtomsDeleted, bS);
    }

    public void freeze() {
        this.chains = (Chain[])ArrayUtil.arrayCopyObject(this.chains, this.chainCount);
        this.groupCount = -1;
        this.getGroupCount();
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].groups = (Group[])ArrayUtil.arrayCopyObject(this.chains[i].groups, this.chains[i].groupCount);
        }
    }

    public void getPdbData(Viewer viewer, String string, char c, boolean bl, BS bS, OutputStringBuilder outputStringBuilder, LabelToken[] labelTokenArray, SB sB, BS bS2) {
    }

    public void getDefaultLargePDBRendering(SB sB, int n) {
    }

    public JmolList<BS> getBioBranches(JmolList<BS> jmolList) {
        return jmolList;
    }

    public void getGroupsWithin(int n, BS bS, BS bS2) {
    }

    public void getSequenceBits(String string, BS bS, BS bS2) {
    }

    public void getRasmolHydrogenBonds(BS bS, BS bS2, JmolList<Bond> jmolList, boolean bl, int n, boolean bl2, BS bS3) {
    }

    public void clearRasmolHydrogenBonds(BS bS) {
    }

    public void clearBioPolymers() {
    }

    public void calcSelectedMonomersCount(BS bS) {
    }

    public void calculatePolymers(Group[] groupArray, int n, int n2, BS bS, boolean bl) {
    }

    public void getAllPolymerInfo(BS bS, Map<String, JmolList<Map<String, Object>>> map, JmolList<Map<String, Object>> jmolList) {
    }

    public int getBioPolymerCount() {
        return 0;
    }

    public void getPolymerPointsAndVectors(BS bS, JmolList<P3[]> jmolList, boolean bl, float f) {
    }

    public P3[] getPolymerLeadMidPoints(int n) {
        return null;
    }

    public void recalculateLeadMidpointsAndWingVectors() {
    }

    public void addSecondaryStructure(EnumStructure enumStructure, String string, int n, int n2, char c, int n3, char c2, int n4, int n5, int n6, BS bS) {
    }

    public String calculateStructures(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return "";
    }

    public void setStructureList(Map<EnumStructure, float[]> map) {
    }

    public void getChimeInfo(SB sB, int n) {
        sB.append("\nNumber of Atoms ..... " + (this.modelSet.atomCount - n));
        if (n > 0) {
            sB.append(" (" + n + ")");
        }
        sB.append("\nNumber of Bonds ..... " + this.modelSet.bondCount);
        sB.append("\nNumber of Models ...... " + this.modelSet.modelCount);
    }

    public int calculateStruts(ModelSet modelSet, BS bS, BS bS2) {
        return 0;
    }

    public void calculateStraightness(Viewer viewer, char c, char c2, int n) {
    }

    public void selectSeqcodeRange(int n, int n2, char c, BS bS, boolean bl) {
    }

    public void setConformation(BS bS) {
    }

    public boolean getPdbConformation(BS bS, int n) {
        return false;
    }

    public String getProteinStructureState(BS bS, boolean bl, boolean bl2, int n) {
        return null;
    }

    public String getFullPDBHeader() {
        return null;
    }
}

