/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.export.UseTable;
import org.jmol.export.__CartesianExporter;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.BS;
import org.jmol.util.Escape;
import org.jmol.util.JmolFont;
import org.jmol.util.JmolList;
import org.jmol.util.P3;
import org.jmol.util.Quaternion;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _VrmlExporter
extends __CartesianExporter {
    protected UseTable useTable;
    private P3 tempQ1 = new P3();
    private P3 tempQ2 = new P3();
    private Map<String, Boolean> htSpheresRendered = new Hashtable<String, Boolean>();

    public _VrmlExporter() {
        this.useTable = new UseTable("USE ");
        this.commentChar = "# ";
    }

    @Override
    protected void output(Tuple3f tuple3f) {
        this.output(_VrmlExporter.round(tuple3f));
    }

    @Override
    protected void outputHeader() {
        this.output("#VRML V2.0 utf8 Generated by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("WorldInfo { \n");
        this.output(" title " + Escape.eS(this.viewer.getModelSetName()) + "\n");
        this.output(" info [ \"Generated by Jmol " + Viewer.getJmolVersion() + " \", \n");
        this.output("  \"http://www.jmol.org \", \n");
        this.output("  \"Creation date: " + _VrmlExporter.getExportDate() + " \" ]\n");
        this.output("} \n");
        this.output("NavigationInfo { type \"EXAMINE\" } \n");
        this.output("Background { skyColor [" + this.rgbFractionalFromColix(this.backgroundColix) + "] } \n");
        float f = (float)((double)this.aperatureAngle * Math.PI / 180.0);
        this.viewer.getAxisAngle(this.viewpoint);
        this.output("Viewpoint{fieldOfView " + f + " position " + this.cameraPosition.x + " " + this.cameraPosition.y + " " + this.cameraPosition.z + " orientation " + this.viewpoint.x + " " + this.viewpoint.y + " " + (this.viewpoint.angle == 0.0f ? 1.0f : this.viewpoint.z) + " " + -this.viewpoint.angle);
        this.output("\n jump TRUE description \"v1\"\n}\n\n");
        this.output(this.getJmolPerspective());
        this.output("\nTransform{children Transform{translation ");
        this.tempP1.setT(this.center);
        this.tempP1.scale(-1.0f);
        this.output(this.tempP1);
        this.output("\nchildren [\n");
    }

    @Override
    protected void outputFooter() {
        this.useTable = null;
        this.output("\n]\n");
        this.output("}}\n");
    }

    protected void outputAppearance(short s, boolean bl) {
        String string = this.useTable.getDef((bl ? "T" : "") + s);
        this.output(" appearance ");
        if (string.charAt(0) == '_') {
            String string2 = this.rgbFractionalFromColix(s);
            this.output(" DEF " + string + " Appearance{material Material{diffuseColor ");
            if (bl) {
                this.output(" 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + string2 + " }}");
            } else {
                this.output(string2 + " transparency " + _VrmlExporter.translucencyFractionalFromColix(s) + "}}");
            }
            return;
        }
        this.output(string);
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
        if (bl) {
            this.output("Transform{translation ");
            this.tempV1.setT(p3);
            this.tempV1.add(p32);
            this.tempV1.scale(0.5f);
            this.output(this.tempV1);
            this.output(" children Billboard{axisOfRotation 0 0 0 children Transform{rotation 1 0 0 1.5708");
            this.outputCylinderChild(p3, p32, s, (byte)2, (int)(f * 2000.0f));
            this.output("}}}\n");
            return;
        }
        String string = this.useTable.getDef("C" + s + "_" + f);
        this.outputTransRot(p3, p32, 0, 0, 1);
        this.tempP3.set(1.0f, 1.0f, 1.0f);
        this.tempP3.scale(f);
        this.output(" scale ");
        this.output(this.tempP3);
        this.output(" children ");
        if (string.charAt(0) == '_') {
            int n;
            this.output("DEF " + string);
            this.output(" Billboard{axisOfRotation 0 0 0 children Transform{children");
            this.output(" Shape{geometry Extrusion{beginCap FALSE convex FALSE endCap FALSE creaseAngle 1.57");
            this.output(" crossSection [");
            float f2 = (float)Math.PI / 180;
            float f3 = 0.02f / f;
            for (n = 0; n <= 360; n += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)n * f2) * (double)f3) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)n * f2) * (double)f3) + " ");
            }
            this.output("] spine [");
            for (n = 0; n <= 360; n += 10) {
                this.output(_VrmlExporter.round(Math.cos((float)n * f2)) + " ");
                this.output(_VrmlExporter.round(Math.sin((float)n * f2)) + " 0 ");
            }
            this.output("]}");
            this.outputAppearance(s, false);
            this.output("}}}");
        } else {
            this.output(string);
        }
        this.output("}\n");
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s) {
        float f2 = this.tempP1.distance(this.tempP2);
        this.outputTransRot(this.tempP1, this.tempP2, 0, 1, 0);
        this.output(" children ");
        String string = "o" + (int)(f2 * 100.0f) + "_" + (int)(f * 100.0f);
        String string2 = this.useTable.getDef("c" + string + "_" + s);
        if (string2.charAt(0) == '_') {
            this.output("DEF " + string2 + " Shape{geometry ");
            string = this.useTable.getDef(string);
            if (string.charAt(0) == '_') {
                this.output("DEF " + string + " Cone{height " + _VrmlExporter.round(f2) + " bottomRadius " + _VrmlExporter.round(f) + "}");
            } else {
                this.output(string);
            }
            this.outputAppearance(s, false);
            this.output("}");
        } else {
            this.output(string2);
        }
        this.output("}\n");
    }

    @Override
    protected boolean outputCylinder(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35, boolean bl) {
        if (p34 == null) {
            this.outputTransRot(p32, p33, 0, 1, 0);
        } else {
            this.output("Transform{translation ");
            this.output(p3);
            this.outputQuaternionFrame(p3, p35, p32, p34, 2.0f, " ", "");
            p32.set(0.0f, 0.0f, -1.0f);
            p33.set(0.0f, 0.0f, 1.0f);
        }
        this.outputCylinderChild(p32, p33, s, by, f);
        this.output("}\n");
        if (by == 3) {
            this.outputSphere(p32, f * 1.01f, s, bl);
            this.outputSphere(p33, f * 1.01f, s, bl);
        }
        return true;
    }

    private void outputCylinderChild(P3 p3, P3 p32, short s, byte by, float f) {
        this.output(" children ");
        float f2 = p3.distance(p32);
        String string = this.useTable.getDef("C" + s + "_" + (int)(f2 * 100.0f) + "_" + f + "_" + by);
        if (string.charAt(0) == '_') {
            this.output("DEF " + string);
            this.output(" Shape{geometry ");
            String string2 = this.useTable.getDef("c" + _VrmlExporter.round(f2) + "_" + by + "_" + f);
            if (string2.charAt(0) == '_') {
                this.output("DEF " + string2 + " Cylinder{height " + _VrmlExporter.round(f2) + " radius " + f + (by == 2 ? "" : " top FALSE bottom FALSE") + "}");
            } else {
                this.output(string2);
            }
            this.outputAppearance(s, false);
            this.output("}");
        } else {
            this.output(string);
        }
    }

    @Override
    protected void outputEllipsoid(P3 p3, P3[] p3Array, short s) {
        this.output("Transform{translation ");
        this.output(p3);
        this.outputQuaternionFrame(p3, p3Array[1], p3Array[3], p3Array[5], 1.0f, " ", "");
        this.output(" children ");
        this.tempP3.set(0.0f, 0.0f, 0.0f);
        this.outputSphereChild(this.tempP3, 1.0f, s);
        this.output("}\n");
    }

    protected void outputQuaternionFrame(P3 p3, P3 p32, P3 p33, P3 p34, float f, String string, String string2) {
        this.tempQ1.setT(p32);
        this.tempQ2.setT(p33);
        AxisAngle4f axisAngle4f = Quaternion.getQuaternionFrame(p3, this.tempQ1, this.tempQ2).toAxisAngle4f();
        if (!Float.isNaN(axisAngle4f.x)) {
            this.output(" rotation");
            this.output(string);
            this.output(axisAngle4f.x + " " + axisAngle4f.y + " " + axisAngle4f.z + " " + axisAngle4f.angle);
            this.output(string2);
        }
        float f2 = p32.distance(p3);
        float f3 = p33.distance(p3) * f;
        float f4 = p34.distance(p3);
        this.output(" scale");
        this.output(string);
        this.output(f2 + " " + f3 + " " + f4);
        this.output(string2);
    }

    @Override
    protected void outputSurface(P3[] p3Array, V3[] v3Array, short[] sArray, int[][] nArray, short[] sArray2, int n, int n2, int n3, BS bS, int n4, short s, JmolList<Short> jmolList, Map<Short, Integer> map, P3 p3) {
        this.output("Shape {\n");
        this.outputAppearance(s, false);
        this.output(" geometry IndexedFaceSet {\n");
        if (sArray2 != null) {
            this.output(" colorPerVertex FALSE\n");
        }
        this.output("coord Coordinate {\n   point [\n");
        this.outputVertices(p3Array, n, p3);
        this.output("   ]\n");
        this.output("  }\n");
        this.output("  coordIndex [\n");
        int[] nArray2 = new int[n];
        this.getCoordinateMap(p3Array, nArray2, null);
        this.outputIndices(nArray, nArray2, n2, bS, n4);
        this.output("  ]\n");
        if (v3Array != null) {
            JmolList<String> jmolList2 = new JmolList<String>();
            nArray2 = this.getNormalMap(v3Array, n, null, jmolList2);
            this.output("  solid FALSE\n  normalPerVertex TRUE\n   normal Normal {\n  vector [\n");
            this.outputNormals(jmolList2);
            this.output("   ]\n");
            this.output("  }\n");
            this.output("  normalIndex [\n");
            this.outputIndices(nArray, nArray2, n2, bS, n4);
            this.output("  ]\n");
        }
        nArray2 = null;
        if (jmolList != null) {
            this.output("  color Color { color [\n");
            this.outputColors(jmolList);
            this.output("  ] } \n");
            this.output("  colorIndex [\n");
            this.outputColorIndices(nArray, n2, bS, n4, map, sArray, sArray2);
            this.output("  ]\n");
        }
        this.output(" }\n");
        this.output("}\n");
    }

    @Override
    protected void outputFace(int[] nArray, int[] nArray2, int n) {
        this.output(nArray2[nArray[0]] + " " + nArray2[nArray[1]] + " " + nArray2[nArray[2]] + " -1\n");
        if (n == 4 && nArray.length == 4) {
            this.output(nArray2[nArray[0]] + " " + nArray2[nArray[2]] + " " + nArray2[nArray[3]] + " -1\n");
        }
    }

    protected void outputNormals(JmolList<String> jmolList) {
        int n = jmolList.size();
        for (int i = 0; i < n; ++i) {
            this.output((String)jmolList.get(i));
        }
    }

    protected void outputColors(JmolList<Short> jmolList) {
        int n = jmolList.size();
        for (int i = 0; i < n; ++i) {
            String string = this.rgbFractionalFromColix((Short)jmolList.get(i));
            this.output(" ");
            this.output(string);
            this.output("\n");
        }
    }

    protected void outputColorIndices(int[][] nArray, int n, BS bS, int n2, Map<Short, Integer> map, short[] sArray, short[] sArray2) {
        int n3;
        boolean bl = bS == null;
        int n4 = n3 = bl ? n - 1 : bS.nextSetBit(0);
        while (n4 >= 0) {
            if (sArray2 == null) {
                this.output(map.get(sArray[nArray[n4][0]]) + " " + map.get(sArray[nArray[n4][1]]) + " " + map.get(sArray[nArray[n4][2]]) + " -1\n");
                if (n2 == 4 && nArray[n4].length == 4) {
                    this.output(map.get(sArray[nArray[n4][0]]) + " " + map.get(sArray[nArray[n4][2]]) + " " + map.get(sArray[nArray[n4][3]]) + " -1\n");
                }
            } else {
                this.output(map.get(sArray2[n4]) + "\n");
            }
            n4 = bl ? n4 - 1 : bS.nextSetBit(n4 + 1);
        }
    }

    @Override
    protected void outputSphere(P3 p3, float f, short s, boolean bl) {
        String string = _VrmlExporter.round(p3) + (bl ? " " + (int)(f * 100.0f) : "");
        if (this.htSpheresRendered.get(string) != null) {
            return;
        }
        this.htSpheresRendered.put(string, Boolean.TRUE);
        this.outputSphereChild(p3, f, s);
    }

    protected void outputSphereChild(P3 p3, float f, short s) {
        int n = (int)(f * 100.0f);
        String string = this.useTable.getDef("S" + s + "_" + n);
        this.output("Transform{translation ");
        this.output(p3);
        this.output(" children ");
        if (string.charAt(0) == '_') {
            this.output("DEF " + string);
            this.output(" Shape{geometry Sphere{radius " + f + "}");
            this.outputAppearance(s, false);
            this.output("}");
        } else {
            this.output(string);
        }
        this.output("}\n");
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
        String string = this.rgbFractionalFromArgb(n);
        this.output("Transform{translation ");
        this.output(p3);
        this.output(" children ");
        String string2 = this.useTable.getDef("p" + n);
        if (string2.charAt(0) == '_') {
            this.output("DEF " + string2 + " Shape{geometry Sphere{radius 0.01}");
            this.output(" appearance Appearance{material Material{diffuseColor 0 0 0 specularColor 0 0 0 ambientIntensity 0.0 shininess 0.0 emissiveColor " + string + " }}}");
        } else {
            this.output(string2);
        }
        this.output("}\n");
    }

    private void outputTransRot(P3 p3, P3 p32, int n, int n2, int n3) {
        this.output("Transform{");
        this.outputTransRot(p3, p32, n, n2, n3, " ", "");
    }

    protected void outputTransRot(P3 p3, P3 p32, int n, int n2, int n3, String string, String string2) {
        this.tempV1.setT(p32);
        this.tempV1.add(p3);
        this.tempV1.scale(0.5f);
        this.output("translation");
        this.output(string);
        this.output(this.tempV1);
        this.output(string2);
        this.tempV1.sub(p3);
        this.tempV1.normalize();
        this.tempV2.set(n, n2, n3);
        this.tempV2.add(this.tempV1);
        this.tempA.set4(this.tempV2.x, this.tempV2.y, this.tempV2.z, 3.14159f);
        this.output(" rotation");
        this.output(string);
        this.output(_VrmlExporter.round(this.tempA.x) + " " + _VrmlExporter.round(this.tempA.y) + " " + _VrmlExporter.round(this.tempA.z) + " " + _VrmlExporter.round(this.tempA.angle));
        this.output(string2);
    }

    @Override
    protected void outputTriangle(P3 p3, P3 p32, P3 p33, short s) {
        this.output("Shape{geometry IndexedFaceSet{solid FALSE coord Coordinate{point[");
        this.output(p3);
        this.output(" ");
        this.output(p32);
        this.output(" ");
        this.output(p33);
        this.output("]}coordIndex[ 0 1 2 -1 ]}");
        this.outputAppearance(s, false);
        this.output("}\n");
    }

    @Override
    void plotText(int n, int n2, int n3, short s, String string, JmolFont jmolFont) {
        if (n3 < 3) {
            n3 = this.viewer.getFrontPlane();
        }
        String string2 = jmolFont.fontStyle.toUpperCase();
        String string3 = jmolFont.fontFace.toUpperCase();
        String string4 = string3.equals("MONOSPACED") ? "TYPEWRITER" : (string3.equals("SERIF") ? "SERIF" : "SANS");
        this.output("Transform{translation ");
        this.tempP3.set(n, n2, n3);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        this.output(this.tempP1);
        this.output(" children ");
        String string5 = this.useTable.getDef("T" + s + string4 + string2 + "_" + string);
        if (string5.charAt(0) == '_') {
            this.output("DEF " + string5 + " Billboard{axisOfRotation 0 0 0 children Transform{children Shape{");
            this.outputAppearance(s, true);
            this.output(" geometry Text{fontStyle ");
            String string6 = this.useTable.getDef("F" + string4 + string2);
            if (string6.charAt(0) == '_') {
                this.output("DEF " + string6 + " FontStyle{size 0.4 family \"" + string4 + "\" style \"" + string2 + "\"}");
            } else {
                this.output(string6);
            }
            this.output(" string " + Escape.eS(string) + "}}}}");
        } else {
            this.output(string5);
        }
        this.output("}\n");
    }
}

