/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.util.BS;
import org.jmol.util.P3;
import org.jmol.util.Quadric;

class AtomIterator
extends JmolAdapterAtomIterator {
    private int iatom;
    private Atom atom;
    private int atomCount;
    private Atom[] atoms;
    private BS bsAtoms;

    AtomIterator(AtomSetCollection atomSetCollection) {
        this.atomCount = atomSetCollection.getAtomCount();
        this.atoms = atomSetCollection.getAtoms();
        this.bsAtoms = atomSetCollection.bsAtoms;
        this.iatom = 0;
    }

    public boolean hasNext() {
        if (this.iatom == this.atomCount) {
            return false;
        }
        while ((this.atom = this.atoms[this.iatom++]) == null || this.bsAtoms != null && !this.bsAtoms.get(this.atom.atomIndex)) {
            if (this.iatom != this.atomCount) continue;
            return false;
        }
        this.atoms[this.iatom - 1] = null;
        return true;
    }

    public int getAtomSetIndex() {
        return this.atom.atomSetIndex;
    }

    public BS getAtomSymmetry() {
        return this.atom.bsSymmetry;
    }

    public int getAtomSite() {
        return this.atom.atomSite + 1;
    }

    public Object getUniqueID() {
        return this.atom.atomIndex;
    }

    public short getElementNumber() {
        return this.atom.elementNumber > 0 ? this.atom.elementNumber : JmolAdapter.getElementNumber(this.atom.getElementSymbol());
    }

    public String getAtomName() {
        return this.atom.atomName;
    }

    public int getFormalCharge() {
        return this.atom.formalCharge;
    }

    public float getPartialCharge() {
        return this.atom.partialCharge;
    }

    public Quadric[] getEllipsoid() {
        return this.atom.ellipsoid;
    }

    public float getRadius() {
        return this.atom.radius;
    }

    public float getX() {
        return this.atom.x;
    }

    public float getY() {
        return this.atom.y;
    }

    public float getZ() {
        return this.atom.z;
    }

    public float getVectorX() {
        return this.atom.vectorX;
    }

    public float getVectorY() {
        return this.atom.vectorY;
    }

    public float getVectorZ() {
        return this.atom.vectorZ;
    }

    public float getBfactor() {
        return Float.isNaN(this.atom.bfactor) && this.atom.anisoBorU != null ? this.atom.anisoBorU[7] * 100.0f : this.atom.bfactor;
    }

    public int getOccupancy() {
        return this.atom.occupancy;
    }

    public boolean getIsHetero() {
        return this.atom.isHetero;
    }

    public int getAtomSerial() {
        return this.atom.atomSerial;
    }

    public char getChainID() {
        return JmolAdapter.canonizeChainID(this.atom.chainID);
    }

    public char getAlternateLocationID() {
        return JmolAdapter.canonizeAlternateLocationID(this.atom.alternateLocationID);
    }

    public String getGroup3() {
        return this.atom.group3;
    }

    public int getSequenceNumber() {
        return this.atom.sequenceNumber;
    }

    public char getInsertionCode() {
        return JmolAdapter.canonizeInsertionCode(this.atom.insertionCode);
    }

    public P3 getXYZ() {
        return this.atom;
    }
}

