/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.renderbio.RocketsRenderer;
import org.jmol.shapebio.BioShape;
import org.jmol.util.C;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.Tuple3f;
import org.jmol.util.Tuple3i;

public class CartoonRenderer
extends RocketsRenderer {
    private boolean renderAsRockets;
    private boolean renderEdges;
    private boolean ladderOnly;
    P3i ptConnectScr = new P3i();
    P3 ptConnect = new P3();
    private final P3[] ring6Points = new P3[6];
    private final P3i[] ring6Screens = new P3i[6];
    private final P3[] ring5Points = new P3[5];
    private final P3i[] ring5Screens = new P3i[5];

    public CartoonRenderer() {
        this.ring6Screens[5] = new P3i();
        int n = 5;
        while (--n >= 0) {
            this.ring5Screens[n] = new P3i();
            this.ring6Screens[n] = new P3i();
        }
    }

    protected void renderBioShape(BioShape bioShape) {
        this.newRockets = true;
        if (bioShape.wingVectors == null || this.isCarbohydrate) {
            return;
        }
        this.getScreenControlPoints();
        if (this.isNucleic) {
            this.renderNucleic();
            return;
        }
        boolean bl = this.viewer.getBoolean(603979818);
        if (this.renderAsRockets != bl) {
            bioShape.falsifyMesh();
            this.renderAsRockets = bl;
        }
        boolean bl2 = bl = !this.viewer.getBoolean(603979900);
        if (this.renderArrowHeads != bl) {
            bioShape.falsifyMesh();
            this.renderArrowHeads = bl;
        }
        this.ribbonTopScreens = this.calcScreens(0.5f);
        this.ribbonBottomScreens = this.calcScreens(-0.5f);
        this.calcRopeMidPoints(this.newRockets);
        if (!this.renderArrowHeads) {
            this.calcScreenControlPoints(this.cordMidPoints);
            this.controlPoints = this.cordMidPoints;
        }
        this.render1();
        this.viewer.freeTempPoints(this.cordMidPoints);
        this.viewer.freeTempScreens(this.ribbonTopScreens);
        this.viewer.freeTempScreens(this.ribbonBottomScreens);
    }

    void renderNucleic() {
        this.renderEdges = this.viewer.getBoolean(603979817);
        this.ladderOnly = this.viewer.getBoolean(603979820);
        boolean bl = this.viewer.getBoolean(603979967);
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            if (bl) {
                this.ptConnectScr.set((this.controlPointScreens[n].x + this.controlPointScreens[n + 1].x) / 2, (this.controlPointScreens[n].y + this.controlPointScreens[n + 1].y) / 2, (this.controlPointScreens[n].z + this.controlPointScreens[n + 1].z) / 2);
                this.ptConnect.setT((Tuple3f)this.controlPoints[n]);
                this.ptConnect.scale(0.5f);
                this.ptConnect.scaleAdd2(0.5f, (Tuple3f)this.controlPoints[n + 1], (Tuple3f)this.ptConnect);
            } else {
                this.ptConnectScr.setT((Tuple3i)this.controlPointScreens[n + 1]);
                this.ptConnect.setT((Tuple3f)this.controlPoints[n + 1]);
            }
            this.renderHermiteConic(n, false);
            this.colix = this.getLeadColix(n);
            if (this.setBioColix(this.colix)) {
                this.renderNucleicBaseStep((NucleicMonomer)this.monomers[n], this.mads[n], this.ptConnectScr, this.ptConnect);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
    }

    protected void render1() {
        boolean bl = false;
        boolean bl2 = false;
        ProteinStructure proteinStructure = null;
        int n = this.monomerCount;
        while (--n >= 0) {
            boolean bl3;
            ProteinStructure proteinStructure2 = this.monomers[n].getProteinStructure();
            if (proteinStructure2 != proteinStructure) {
                if (this.renderAsRockets) {
                    bl2 = false;
                }
                bl = false;
            }
            proteinStructure = proteinStructure2;
            boolean bl4 = this.isHelix(n);
            boolean bl5 = this.isSheet(n);
            boolean bl6 = bl3 = this.renderAsRockets || !this.renderArrowHeads ? bl4 : false;
            if (this.bsVisible.get(n) && !bl3) {
                if (bl5 || bl4) {
                    if (bl && bl5 || bl2 && bl4) {
                        this.renderHermiteRibbon(true, n, true);
                    } else {
                        this.renderHermiteArrowHead(n);
                    }
                } else {
                    this.renderHermiteConic(n, true);
                }
            }
            bl = bl5;
            bl2 = bl4;
        }
        if (this.renderAsRockets || !this.renderArrowHeads) {
            this.renderRockets();
        }
    }

    private void renderRockets() {
        this.tPending = false;
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            if (this.isHelix(n)) {
                this.renderSpecialSegment(this.monomers[n], this.getLeadColix(n), this.mads[n]);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
        this.renderPending();
    }

    private void renderNucleicBaseStep(NucleicMonomer nucleicMonomer, short n, P3i p3i, P3 p3) {
        P3 p32;
        P3i p3i2;
        if (this.renderEdges) {
            this.renderLeontisWesthofEdges(nucleicMonomer, (short)n);
            return;
        }
        nucleicMonomer.getBaseRing6Points(this.ring6Points);
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderRing6();
        boolean bl = nucleicMonomer.maybeGetBaseRing5Points(this.ring5Points);
        if (bl) {
            this.viewer.transformPoints(this.ring5Points, this.ring5Screens);
            this.renderRing5();
            if (this.ladderOnly) {
                p3i2 = this.ring6Screens[2];
                p32 = this.ring6Points[2];
            } else {
                p3i2 = this.ring5Screens[3];
                p32 = this.ring5Points[3];
            }
        } else {
            int n2 = this.ladderOnly ? 4 : 2;
            p3i2 = this.ring6Screens[n2];
            p32 = this.ring6Points[n2];
        }
        this.mad = (short)(n > 1 ? n / 2 : n);
        this.g3d.fillCylinderScreen3I((byte)3, (int)this.viewer.scaleToScreen(p3i.z, (int)this.mad), p3i, p3i2, p3, p32, (float)this.mad / 2000.0f);
        if (this.ladderOnly) {
            return;
        }
        --this.ring6Screens[5].z;
        int n3 = 5;
        while (--n3 >= 0) {
            --this.ring6Screens[n3].z;
            if (!bl) continue;
            --this.ring5Screens[n3].z;
        }
        n3 = 6;
        while (--n3 > 0) {
            this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring6Screens[n3], this.ring6Screens[n3 - 1], this.ring6Points[n3], this.ring6Points[n3 - 1], 0.005f);
        }
        if (bl) {
            n3 = 5;
            while (--n3 > 0) {
                this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring5Screens[n3], this.ring5Screens[n3 - 1], this.ring5Points[n3], this.ring5Points[n3 - 1], 0.005f);
            }
        } else {
            this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring6Screens[5], this.ring6Screens[0], this.ring6Points[5], this.ring6Points[0], 0.005f);
        }
    }

    private void renderLeontisWesthofEdges(NucleicMonomer nucleicMonomer, short n) {
        if (!nucleicMonomer.getEdgePoints(this.ring6Points)) {
            return;
        }
        this.viewer.transformPoints(this.ring6Points, this.ring6Screens);
        this.renderTriangle();
        this.mad = (short)(n > 1 ? n / 2 : n);
        this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring6Screens[0], this.ring6Screens[1], this.ring6Points[0], this.ring6Points[1], 0.005f);
        this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring6Screens[1], this.ring6Screens[2], this.ring6Points[1], this.ring6Points[2], 0.005f);
        boolean bl = C.isColixTranslucent((short)this.colix);
        float f = C.getColixTranslucencyLevel((short)this.colix);
        short s = C.getColixTranslucent3((short)10, (boolean)bl, (float)f);
        short s2 = C.getColixTranslucent3((short)11, (boolean)bl, (float)f);
        short s3 = C.getColixTranslucent3((short)7, (boolean)bl, (float)f);
        this.g3d.setColix(s);
        this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring6Screens[2], this.ring6Screens[3], this.ring6Points[2], this.ring6Points[3], 0.005f);
        this.g3d.setColix(s2);
        this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring6Screens[3], this.ring6Screens[4], this.ring6Points[3], this.ring6Points[4], 0.005f);
        this.g3d.setColix(s3);
        this.g3d.fillCylinderScreen3I((byte)3, 3, this.ring6Screens[4], this.ring6Screens[5], this.ring6Points[4], this.ring6Points[5], 0.005f);
    }

    private void renderTriangle() {
        this.g3d.setNoisySurfaceShade(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4]);
        this.g3d.fillTriangle3i(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4], this.ring6Points[2], this.ring6Points[3], this.ring6Points[4]);
    }

    private void renderRing6() {
        if (this.ladderOnly) {
            return;
        }
        this.g3d.setNoisySurfaceShade(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4]);
        this.g3d.fillTriangle3i(this.ring6Screens[0], this.ring6Screens[2], this.ring6Screens[4], this.ring6Points[0], this.ring6Points[2], this.ring6Points[4]);
        this.g3d.fillTriangle3i(this.ring6Screens[0], this.ring6Screens[1], this.ring6Screens[2], this.ring6Points[0], this.ring6Points[1], this.ring6Points[2]);
        this.g3d.fillTriangle3i(this.ring6Screens[0], this.ring6Screens[4], this.ring6Screens[5], this.ring6Points[0], this.ring6Points[4], this.ring6Points[5]);
        this.g3d.fillTriangle3i(this.ring6Screens[2], this.ring6Screens[3], this.ring6Screens[4], this.ring6Points[2], this.ring6Points[3], this.ring6Points[4]);
    }

    private void renderRing5() {
        if (this.ladderOnly) {
            return;
        }
        this.g3d.fillTriangle3i(this.ring5Screens[0], this.ring5Screens[2], this.ring5Screens[3], this.ring5Points[0], this.ring5Points[2], this.ring5Points[3]);
        this.g3d.fillTriangle3i(this.ring5Screens[0], this.ring5Screens[1], this.ring5Screens[2], this.ring5Points[0], this.ring5Points[1], this.ring5Points[2]);
        this.g3d.fillTriangle3i(this.ring5Screens[0], this.ring5Screens[3], this.ring5Screens[4], this.ring5Points[0], this.ring5Points[3], this.ring5Points[4]);
    }
}

