/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.constant.EnumStructure;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.Model;
import org.jmol.modelsetbio.APBridge;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AminoPolymer
extends AlphaPolymer {
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.25f;
    private static int[][] sheetOffsets = new int[][]{{0, -1, 1, 0, 1, 0, 0, -1}, {0, 0, 0, 0, 1, -1, 1, -1}};
    private Map<EnumStructure, float[]> structureList;

    AminoPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 1;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)monomerArray[i]).hasOAtom()) continue;
            return;
        }
        this.hasWingPoints = true;
    }

    @Override
    protected void resetHydrogenPoints() {
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 != null && proteinStructure2 != proteinStructure) {
                proteinStructure = proteinStructure2;
                proteinStructure.resetAxes();
            }
            ((AminoMonomer)this.monomers[i]).resetHydrogenPoint();
        }
    }

    @Override
    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles2((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles2(AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        Atom atom = aminoMonomer.getNitrogenAtom();
        Atom atom2 = aminoMonomer.getLeadAtom();
        Atom atom3 = aminoMonomer.getCarbonylCarbonAtom();
        Atom atom4 = aminoMonomer2.getNitrogenAtom();
        Atom atom5 = aminoMonomer2.getLeadAtom();
        Atom atom6 = aminoMonomer2.getCarbonylCarbonAtom();
        aminoMonomer2.setGroupParameter(1112539143, Measure.computeTorsion((Tuple3f)atom3, (Tuple3f)atom4, (Tuple3f)atom5, (Tuple3f)atom6, (boolean)true));
        aminoMonomer.setGroupParameter(1112539144, Measure.computeTorsion((Tuple3f)atom, (Tuple3f)atom2, (Tuple3f)atom3, (Tuple3f)atom4, (boolean)true));
        aminoMonomer.setGroupParameter(1112539142, Measure.computeTorsion((Tuple3f)atom2, (Tuple3f)atom3, (Tuple3f)atom4, (Tuple3f)atom5, (boolean)true));
    }

    @Override
    protected float calculateRamachandranHelixAngle(int n, char c) {
        float f = n == 0 ? Float.NaN : this.monomers[n - 1].getGroupParameter(1112539144);
        float f2 = this.monomers[n].getGroupParameter(1112539144);
        float f3 = this.monomers[n].getGroupParameter(1112539143);
        float f4 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539143);
        float f5 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539144);
        switch (c) {
            default: {
                float f6 = (float)((double)((f4 - f3) / 2.0f) * Math.PI / 180.0);
                float f7 = (float)((double)((f5 - f2) / 2.0f) * Math.PI / 180.0);
                return (float)(114.59155902616465 * Math.acos(Math.cos(f7) * Math.cos(f6) - Math.sin(f7) * Math.sin(f6) / 3.0));
            }
            case 'C': 
            case 'c': 
        }
        return f2 - f + f4 - f3;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BS bS, BS bS2, JmolList<Bond> jmolList, int n, int[][][] nArray, boolean bl, boolean bl2) {
        if (bioPolymer == null) {
            bioPolymer = this;
        }
        if (!(bioPolymer instanceof AminoPolymer)) {
            return;
        }
        P3 p3 = new P3();
        V3 v3 = new V3();
        int[][] nArray2 = nArray == null ? new int[2][3] : (int[][])null;
        for (int i = 1; i < this.monomerCount; ++i) {
            boolean bl3;
            if (nArray == null) {
                int n2 = this.bioPolymerIndexInModel;
                nArray2[1][0] = n2;
                nArray2[0][0] = n2;
                nArray2[1][1] = Integer.MIN_VALUE;
                nArray2[0][1] = Integer.MIN_VALUE;
                nArray2[1][2] = 0;
                nArray2[0][2] = 0;
            } else {
                nArray2 = nArray[i];
            }
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[i];
            if (!aminoMonomer.getNHPoint(p3, v3, bl, bl2)) continue;
            boolean bl4 = bl3 = bS == null || bS.get(aminoMonomer.getNitrogenAtom().index);
            if (!bl3 || !bl && aminoMonomer.getCarbonylOxygenAtom() == null) continue;
            this.checkRasmolHydrogenBond(aminoMonomer, bioPolymer, i, p3, bl3 ? bS2 : bS, jmolList, nArray2, bl);
        }
    }

    private void checkRasmolHydrogenBond(AminoMonomer aminoMonomer, BioPolymer bioPolymer, int n, P3 p3, BS bS, JmolList<Bond> jmolList, int[][] nArray, boolean bl) {
        Atom atom = aminoMonomer.getLeadAtom();
        Atom atom2 = aminoMonomer.getNitrogenAtom();
        Atom atom3 = aminoMonomer.getNitrogenAtom();
        int n2 = bioPolymer.monomerCount;
        while (--n2 >= 0) {
            int[] nArray2;
            Atom atom4;
            float f;
            AminoMonomer aminoMonomer2;
            Atom atom5;
            if (bioPolymer == this && (n2 == n || n2 + 1 == n) || (atom5 = (aminoMonomer2 = (AminoMonomer)bioPolymer.monomers[n2]).getCarbonylOxygenAtom()) == null || bS != null && !bS.get(atom5.index) || (f = atom.distanceSquared((P3)(atom4 = aminoMonomer2.getLeadAtom()))) >= 81.0f) continue;
            int n3 = this.calcHbondEnergy((P3)atom2, p3, aminoMonomer2, bl);
            if (n3 < nArray[0][2]) {
                nArray2 = nArray[1];
                nArray[1] = nArray[0];
                nArray[0] = nArray2;
            } else {
                if (n3 >= nArray[1][2]) continue;
                nArray2 = nArray[1];
            }
            nArray2[0] = bioPolymer.bioPolymerIndexInModel;
            nArray2[1] = n3 < -500 ? n2 : -1 - n2;
            nArray2[2] = n3;
        }
        if (jmolList != null) {
            for (n2 = 0; n2 < 2; ++n2) {
                if (nArray[n2][1] < 0) continue;
                this.addResidueHydrogenBond(atom3, ((AminoMonomer)((AminoPolymer)bioPolymer).monomers[nArray[n2][1]]).getCarbonylOxygenAtom(), bioPolymer == this ? n : -99, nArray[n2][1], (float)nArray[n2][2] / 1000.0f, jmolList);
            }
        }
    }

    private int calcHbondEnergy(P3 p3, P3 p32, AminoMonomer aminoMonomer, boolean bl) {
        double d;
        double d2;
        double d3;
        Atom atom = aminoMonomer.getCarbonylOxygenAtom();
        if (atom == null) {
            return 0;
        }
        float f = atom.distanceSquared(p3);
        if (f < 0.25f) {
            return 0;
        }
        float f2 = atom.distanceSquared(p32);
        if (f2 < 0.25f) {
            return 0;
        }
        Atom atom2 = aminoMonomer.getCarbonylCarbonAtom();
        float f3 = atom2.distanceSquared(p32);
        if (f3 < 0.25f) {
            return 0;
        }
        float f4 = atom2.distanceSquared(p3);
        if (f4 < 0.25f) {
            return 0;
        }
        double d4 = Math.sqrt(f2);
        int n = HBond.getEnergy((double)d4, (double)(d3 = Math.sqrt(f3)), (double)(d2 = Math.sqrt(f4)), (double)(d = Math.sqrt(f)));
        boolean bl2 = n < -500 && (!bl || d2 > d3 && d4 <= 3.0);
        return !bl2 && bl || n < -9900 ? 0 : n;
    }

    private void addResidueHydrogenBond(Atom atom, Atom atom2, int n, int n2, float f, JmolList<Bond> jmolList) {
        int n3;
        switch (n - n2) {
            case 2: {
                n3 = 6144;
                break;
            }
            case 3: {
                n3 = 8192;
                break;
            }
            case 4: {
                n3 = 10240;
                break;
            }
            case 5: {
                n3 = 12288;
                break;
            }
            case -3: {
                n3 = 14336;
                break;
            }
            case -4: {
                n3 = 16384;
                break;
            }
            default: {
                n3 = 4096;
            }
        }
        jmolList.addLast((Object)new HBond(atom, atom2, n3, 1, 0, f));
    }

    protected static String calculateStructuresDssp(BioPolymer[] bioPolymerArray, int n, JmolList<Bond> jmolList, boolean bl, boolean bl2, boolean bl3) {
        AminoPolymer aminoPolymer;
        BS bS = new BS();
        for (int i = 0; i < n; ++i) {
            if (!(bioPolymerArray[i] instanceof AminoPolymer)) continue;
            bS.set(i);
        }
        if (bS.isEmpty()) {
            return "";
        }
        Model model = bioPolymerArray[0].model;
        SB sB = new SB();
        sB.append("Jmol ").append(Viewer.getJmolVersion()).append(" DSSP analysis for model ").append(model.getModelNumberDotted()).append(" - ").append(model.getModelTitle()).append("\n");
        if (model.modelIndex == 0) {
            sB.append("\nW. Kabsch and C. Sander, Biopolymers, vol 22, 1983, pp 2577-2637\n").append("\nWe thank Wolfgang Kabsch and Chris Sander for writing the DSSP software,\n").append("and we thank the CMBI for maintaining it to the extent that it was easy to\n").append("re-engineer for our purposes. At this point in time, we make no guarantee\n").append("that this code gives precisely the same analysis as the code available via license\n").append("from CMBI at http://swift.cmbi.ru.nl/gv/dssp\n");
        }
        if (bl3 && model.modelIndex == 0) {
            sB.append("\nAll bioshapes have been deleted and must be regenerated.\n");
        }
        if (model.nAltLocs > 0) {
            sB.append("\nNote: This model contains alternative locations. Use  'CONFIGURATION 1' to be consistent with CMBI DSSP.\n");
        }
        char[][] cArrayArray = new char[n][];
        BS[] bSArray = new BS[n];
        BS bS2 = new BS();
        boolean bl4 = false;
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            aminoPolymer = (AminoPolymer)bioPolymerArray[n2];
            if (!bl4 && ((AminoMonomer)aminoPolymer.monomers[0]).getExplicitNH() != null) {
                if (bl2) {
                    sB.append(GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be ignored. Their positions will be approximated, as in standard DSSP analysis.\nUse {0} to not use this approximation.\n\n", (String)"SET dsspCalculateHydrogenAlways FALSE"));
                } else {
                    sB.append(GT._((String)"NOTE: Backbone amide hydrogen positions are present and will be used. Results may differ significantly from standard DSSP analysis.\nUse {0} to ignore these hydrogen positions.\n\n", (String)"SET dsspCalculateHydrogenAlways TRUE"));
                }
                bl4 = true;
            }
            bioPolymerArray[n2].recalculateLeadMidpointsAndWingVectors();
            cArrayArray[n2] = new char[bioPolymerArray[n2].monomerCount];
            bSArray[n2] = new BS();
            for (int i = 0; i < aminoPolymer.monomerCount; ++i) {
                if (((AminoMonomer)aminoPolymer.monomers[i]).getCarbonylOxygenAtom() != null) continue;
                bS2.set(aminoPolymer.monomers[i].leadAtomIndex);
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        int[][][][] nArray = AminoPolymer.getDualHydrogenBondArray(bioPolymerArray, n, bl2);
        aminoPolymer = new JmolList();
        JmolList jmolList2 = new JmolList();
        Hashtable<String, APBridge> hashtable = new Hashtable<String, APBridge>();
        Hashtable<int[][], Boolean> hashtable2 = new Hashtable<int[][], Boolean>();
        AminoPolymer.getBridges(bioPolymerArray, nArray, (JmolList<APBridge>)aminoPolymer, (JmolList<APBridge>)jmolList2, hashtable, hashtable2, bS2, jmolList, bSArray);
        AminoPolymer.getSheetStructures(bioPolymerArray, (JmolList<APBridge>)aminoPolymer, (JmolList<APBridge>)jmolList2, hashtable, hashtable2, cArrayArray, bSArray, bl, bl3);
        String[] stringArray = new String[n];
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            if (nArray[n3] != null) {
                stringArray[n3] = ((AminoPolymer)bioPolymerArray[n3]).findHelixes(nArray[n3], n3, bSArray[n3], cArrayArray[n3], bl, bl3, jmolList, bS2);
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        if (bl) {
            SB sB2 = new SB();
            sB.append("\n------------------------------\n");
            int n4 = bS.nextSetBit(0);
            while (n4 >= 0) {
                if (cArrayArray[n4] != null) {
                    AminoPolymer aminoPolymer2 = (AminoPolymer)bioPolymerArray[n4];
                    sB2.append(aminoPolymer2.dumpSummary(cArrayArray[n4]));
                    sB.append(stringArray[n4]).append(aminoPolymer2.dumpTags("$.1: " + String.valueOf(cArrayArray[n4]), bS2, 2));
                }
                n4 = bS.nextSetBit(n4 + 1);
            }
            if (bS2.nextSetBit(0) >= 0) {
                sB.append("\nNOTE: '!' indicates a residue that is missing a backbone carbonyl oxygen atom.\n");
            }
            sB.append("\n").append("SUMMARY:" + sB2);
        }
        return sB.toString();
    }

    private static int[][][][] getDualHydrogenBondArray(BioPolymer[] bioPolymerArray, int n, boolean bl) {
        int n2;
        int n3;
        int[][][][] nArray = ArrayUtil.newInt4((int)n);
        for (n3 = 0; n3 < n; ++n3) {
            if (!(bioPolymerArray[n3] instanceof AminoPolymer)) continue;
            n2 = bioPolymerArray[n3].monomerCount;
            nArray[n3] = new int[n2][2][3];
            for (int i = 0; i < n2; ++i) {
                nArray[n3][i][1][1] = Integer.MIN_VALUE;
                nArray[n3][i][0][1] = Integer.MIN_VALUE;
                nArray[n3][i][1][2] = 0;
                nArray[n3][i][0][2] = 0;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (nArray[n3] == null) continue;
            for (n2 = 0; n2 < n; ++n2) {
                if (nArray[n2] == null) continue;
                bioPolymerArray[n3].calcRasmolHydrogenBonds(bioPolymerArray[n2], null, null, null, 2, nArray[n3], false, bl);
            }
        }
        return nArray;
    }

    private String findHelixes(int[][][] nArray, int n, BS bS, char[] cArray, boolean bl, boolean bl2, JmolList<Bond> jmolList, BS bS2) {
        if (Logger.debugging) {
            for (int i = 0; i < this.monomerCount; ++i) {
                Logger.debug((String)(n + "." + this.monomers[i].getResno() + "\t" + Escape.e((Object)nArray[i])));
            }
        }
        BS bS3 = new BS();
        String string = this.findHelixes2(4, nArray, n, EnumStructure.HELIXALPHA, 10240, bS, bS3, cArray, bl, bl2, jmolList, bS2);
        String string2 = this.findHelixes2(3, nArray, n, EnumStructure.HELIX310, 8192, bS, bS3, cArray, bl, bl2, jmolList, bS2);
        String string3 = this.findHelixes2(5, nArray, n, EnumStructure.HELIXPI, 12288, bS, bS3, cArray, bl, bl2, jmolList, bS2);
        if (bl2) {
            this.setStructure(bS3, EnumStructure.TURN);
        }
        if (bl) {
            this.setTag(cArray, bS3, 'T');
            return this.dumpTags("$.5: " + string3 + "\n" + "$.4: " + string + "\n" + "$.3: " + string2, bS2, 1);
        }
        return "";
    }

    private String findHelixes2(int n, int[][][] nArray, int n2, EnumStructure enumStructure, int n3, BS bS, BS bS2, char[] cArray, boolean bl, boolean bl2, JmolList<Bond> jmolList, BS bS3) {
        char[] cArray2;
        BS bS4 = new BS();
        BS bS5 = new BS();
        BS bS6 = new BS();
        BS bS7 = new BS();
        BS bS8 = new BS();
        String string = "";
        for (int i = n; i < this.monomerCount; ++i) {
            int n4;
            int n5;
            int n6 = i - n;
            int n7 = 0;
            if (nArray[i][0][0] != n2 || nArray[i][0][1] != n6) {
                n7 = 1;
                if (nArray[i][1][0] != n2 || nArray[i][1][1] != n6) continue;
            }
            if ((n5 = bS3.nextSetBit(n4 = this.monomers[n6].leadAtomIndex)) >= n4 && n5 <= this.monomers[i].leadAtomIndex) continue;
            bS4.set(n6);
            bS5.setBits(n6 + 1, i);
            bS7.set(i);
            n5 = bS.nextSetBit(n6);
            boolean bl3 = n5 < 0 || n5 >= i;
            boolean bl4 = false;
            if (n6 > 0 && bS4.get(n6 - 1) && (n == 4 || bl3)) {
                bS8.setBits(n6, i);
                if (!bl3) {
                    string = string + "  WARNING! Bridge to helix at " + (Object)((Object)this.monomers[n5]);
                }
                bl4 = true;
            } else if (bl3 || bS.nextClearBit(n5) < i) {
                bl4 = true;
            }
            if (bS7.get(n6)) {
                bS6.set(n6);
            }
            if (!bl4 || jmolList == null) continue;
            AminoPolymer.addHbond(jmolList, this.monomers[i], this.monomers[n6], nArray[i][n7][2], n3, null);
        }
        if (bl) {
            cArray2 = new char[this.monomerCount];
            this.setTag(cArray2, bS5, (char)(48 + n));
            this.setTag(cArray2, bS4, '>');
            this.setTag(cArray2, bS7, '<');
            this.setTag(cArray2, bS6, 'X');
        } else {
            cArray2 = null;
        }
        bS.or(bS8);
        bS5.andNot(bS);
        bS2.or(bS5);
        bS2.andNot(bS8);
        if (bl2) {
            this.setStructure(bS8, enumStructure);
        }
        if (bl) {
            this.setTag(cArray, bS8, (char)(68 + n));
            return String.valueOf(cArray2) + string;
        }
        return "";
    }

    private static void getBridges(BioPolymer[] bioPolymerArray, int[][][][] nArray, JmolList<APBridge> jmolList, JmolList<APBridge> jmolList2, Map<String, APBridge> map, Map<int[][], Boolean> map2, BS bS, JmolList<Bond> jmolList3, BS[] bSArray) {
        Atom[] atomArray = bioPolymerArray[0].model.getModelSet().atoms;
        APBridge aPBridge = null;
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        for (int i = 0; i < nArray.length; ++i) {
            if (!(bioPolymerArray[i] instanceof AminoPolymer)) continue;
            AminoPolymer aminoPolymer = (AminoPolymer)bioPolymerArray[i];
            int n = nArray[i].length - 1;
            for (int j = 1; j < n; ++j) {
                int n2 = aminoPolymer.monomers[j].leadAtomIndex;
                if (bS.get(n2)) continue;
                for (int k = i; k < nArray.length; ++k) {
                    int n3;
                    if (!(bioPolymerArray[k] instanceof AminoPolymer)) continue;
                    int n4 = n3 = i == k ? j + 3 : 1;
                    while (n3 < nArray[k].length - 1) {
                        block8: {
                            int n5;
                            block9: {
                                AminoPolymer aminoPolymer2 = (AminoPolymer)bioPolymerArray[k];
                                n5 = aminoPolymer2.monomers[n3].leadAtomIndex;
                                if (bS.get(n5)) break block8;
                                aPBridge = AminoPolymer.getBridge(nArray, i, j, k, n3, jmolList2, atomArray[n2], atomArray[n5], aminoPolymer, aminoPolymer2, jmolList3, hashtable, false, map2);
                                if (aPBridge != null) break block9;
                                aPBridge = AminoPolymer.getBridge(nArray, i, j, k, n3, jmolList, atomArray[n2], atomArray[n5], aminoPolymer, aminoPolymer2, jmolList3, hashtable, true, map2);
                                if (aPBridge == null) break block8;
                                aPBridge.isAntiparallel = true;
                            }
                            if (Logger.debugging) {
                                Logger.debug((String)("Bridge found " + aPBridge));
                            }
                            bSArray[i].set(j);
                            bSArray[k].set(n3);
                            map.put(n2 + "-" + n5, aPBridge);
                        }
                        ++n3;
                    }
                }
            }
        }
    }

    private static APBridge getBridge(int[][][][] nArray, int n, int n2, int n3, int n4, JmolList<APBridge> jmolList, Atom atom, Atom atom2, AminoPolymer aminoPolymer, AminoPolymer aminoPolymer2, JmolList<Bond> jmolList2, Map<String, Boolean> map, boolean bl, Map<int[][], Boolean> map2) {
        block5: {
            int[] nArray2;
            int n5;
            int[] nArray3;
            int[] nArray4;
            block4: {
                nArray4 = null;
                nArray3 = null;
                n5 = 0;
                nArray2 = bl ? sheetOffsets[1] : sheetOffsets[0];
                nArray4 = AminoPolymer.isHbonded(n2 + nArray2[0], n4 + nArray2[1], n, n3, nArray);
                if (nArray4 != null && (nArray3 = AminoPolymer.isHbonded(n4 + nArray2[2], n2 + nArray2[3], n3, n, nArray)) != null) break block4;
                n5 = 4;
                nArray4 = AminoPolymer.isHbonded(n2 + nArray2[4], n4 + nArray2[5], n, n3, nArray);
                if (nArray4 == null || (nArray3 = AminoPolymer.isHbonded(n4 + nArray2[6], n2 + nArray2[7], n3, n, nArray)) == null) break block5;
            }
            APBridge aPBridge = new APBridge(atom, atom2, map2);
            jmolList.addLast((Object)aPBridge);
            if (jmolList2 != null) {
                int n6 = bl ? 14336 : 6144;
                AminoPolymer.addHbond(jmolList2, aminoPolymer.monomers[n2 + nArray2[n5]], aminoPolymer2.monomers[n4 + nArray2[++n5]], nArray4[2], n6, map);
                AminoPolymer.addHbond(jmolList2, aminoPolymer2.monomers[n4 + nArray2[++n5]], aminoPolymer.monomers[n2 + nArray2[++n5]], nArray3[2], n6, map);
            }
            return aPBridge;
        }
        return null;
    }

    private static void addHbond(JmolList<Bond> jmolList, Monomer monomer, Monomer monomer2, int n, int n2, Map<String, Boolean> map) {
        Atom atom = ((AminoMonomer)monomer).getNitrogenAtom();
        Atom atom2 = ((AminoMonomer)monomer2).getCarbonylOxygenAtom();
        if (map != null) {
            String string = atom.index + " " + atom2.index;
            if (map.containsKey(string)) {
                return;
            }
            map.put(string, Boolean.TRUE);
        }
        jmolList.addLast((Object)new HBond(atom, atom2, n2, 1, 0, (float)n / 1000.0f));
    }

    private static void getSheetStructures(BioPolymer[] bioPolymerArray, JmolList<APBridge> jmolList, JmolList<APBridge> jmolList2, Map<String, APBridge> map, Map<int[][], Boolean> map2, char[][] cArray, BS[] bSArray, boolean bl, boolean bl2) {
        Object object2;
        if (jmolList.size() == 0 && jmolList2.size() == 0) {
            return;
        }
        AminoPolymer.createLadders(jmolList, map, map2, true);
        AminoPolymer.createLadders(jmolList2, map, map2, false);
        BS bS = new BS();
        BS bS2 = new BS();
        for (Object object2 : map2.keySet()) {
            if (object2[0][0] == object2[0][1] && object2[1][0] == object2[1][1]) {
                bS2.set(object2[0][0]);
                bS2.set(object2[1][0]);
                continue;
            }
            bS.setBits(object2[0][0], object2[0][1] + 1);
            bS.setBits(object2[1][0], object2[1][1] + 1);
        }
        object2 = new BS();
        BS bS3 = new BS();
        int n = bioPolymerArray.length;
        while (--n >= 0) {
            if (!(bioPolymerArray[n] instanceof AminoPolymer)) continue;
            object2.clearAll();
            bS3.clearAll();
            AminoPolymer aminoPolymer = (AminoPolymer)bioPolymerArray[n];
            int n2 = 0;
            while (n2 < aminoPolymer.monomerCount) {
                int n3 = aminoPolymer.monomers[n2].leadAtomIndex;
                if (bS.get(n3)) {
                    int n4;
                    for (n4 = n2 + 1; n4 < aminoPolymer.monomerCount && bS.get(aminoPolymer.monomers[n4].leadAtomIndex); ++n4) {
                    }
                    object2.setBits(n2, n4);
                    n2 = n4;
                    continue;
                }
                if (bS2.get(n3)) {
                    bS3.set(n2);
                }
                ++n2;
            }
            if (bl) {
                aminoPolymer.setTag(cArray[n], bS3, 'B');
                aminoPolymer.setTag(cArray[n], (BS)object2, 'E');
            }
            if (bl2) {
                aminoPolymer.setStructure((BS)object2, EnumStructure.SHEET);
            }
            bSArray[n].or((BS)object2);
            bSArray[n].or(bS3);
        }
    }

    private static void createLadders(JmolList<APBridge> jmolList, Map<String, APBridge> map, Map<int[][], Boolean> map2, boolean bl) {
        int n;
        int n2 = bl ? -1 : 1;
        int n3 = jmolList.size();
        for (n = 0; n < n3; ++n) {
            AminoPolymer.checkBridge((APBridge)jmolList.get(n), map, map2, bl, 1, n2);
        }
        for (n = 0; n < n3; ++n) {
            AminoPolymer.checkBulge((APBridge)jmolList.get(n), map, map2, bl, 1);
        }
    }

    private static boolean checkBridge(APBridge aPBridge, Map<String, APBridge> map, Map<int[][], Boolean> map2, boolean bl, int n, int n2) {
        APBridge aPBridge2 = map.get(aPBridge.a.getOffsetResidueAtom("0", n) + "-" + aPBridge.b.getOffsetResidueAtom("0", n2));
        return aPBridge2 != null && aPBridge.addBridge(aPBridge2, map2);
    }

    private static void checkBulge(APBridge aPBridge, Map<String, APBridge> map, Map<int[][], Boolean> map2, boolean bl, int n) {
        int n2 = bl ? -1 : 1;
        for (int i = 0; i < 3; ++i) {
            int n3;
            int n4 = n3 = i == 0 ? 1 : 0;
            while (n3 < 6) {
                AminoPolymer.checkBridge(aPBridge, map, map2, bl, i * n, n3 * n2);
                if (n3 > i) {
                    AminoPolymer.checkBridge(aPBridge, map, map2, bl, n3 * n, i * n2);
                }
                ++n3;
            }
        }
    }

    private void setStructure(BS bS, EnumStructure enumStructure) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            int n2 = bS.nextClearBit(n);
            if (n2 < 0) {
                n2 = this.monomerCount;
            }
            this.addStructureProtected(enumStructure, null, 0, 0, n, n2 - 1);
            n = n2;
            n = bS.nextSetBit(n + 1);
        }
    }

    private static int[] isHbonded(int n, int n2, int n3, int n4, int[][][][] nArray) {
        if (n < 0 || n2 < 0) {
            return null;
        }
        int[][][] nArray2 = nArray[n3];
        int[][][] nArray3 = nArray[n4];
        if (n >= nArray2.length || n2 >= nArray3.length) {
            return null;
        }
        return nArray2[n][0][0] == n4 && nArray2[n][0][1] == n2 ? nArray2[n][0] : (nArray2[n][1][0] == n4 && nArray2[n][1][1] == n2 ? nArray2[n][1] : null);
    }

    private void setTag(char[] cArray, BS bS, char c) {
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            cArray[n] = c;
            n = bS.nextSetBit(n + 1);
        }
    }

    private String dumpSummary(char[] cArray) {
        char c = this.monomers[0].getLeadAtom().getChainID();
        String string = c == '\u0000' ? "" : String.valueOf(c) + ":";
        SB sB = new SB();
        char c2 = '\u0000';
        char c3 = '\u0000';
        char c4 = '\u0000';
        int n = -1;
        int n2 = -1;
        for (int i = 0; i <= this.monomerCount; ++i) {
            if (i == this.monomerCount || cArray[i] != c2) {
                if (c2 != '\u0000') {
                    sB.appendC('\n').appendC(c2).append(" : ").append(string).appendI(n).append(c3 == '\u0000' ? "" : String.valueOf(c3)).append("_").append(string).appendI(n2).append(c4 == '\u0000' ? "" : String.valueOf(c4));
                }
                if (i == this.monomerCount) break;
                c2 = cArray[i];
                n = this.monomers[i].getResno();
                c3 = this.monomers[i].getInsertionCode();
            }
            n2 = this.monomers[i].getResno();
            c4 = this.monomers[i].getInsertionCode();
        }
        return sB.toString();
    }

    private String dumpTags(String string, BS bS, int n) {
        String string2 = this.monomers[0].getLeadAtom().getChainID() + "." + (this.bioPolymerIndexInModel + 1);
        string = TextFormat.simpleReplace((String)string, (String)"$", (String)string2);
        int n2 = this.monomers[0].getResno();
        String string3 = "\n" + string2;
        SB sB = new SB();
        SB sB2 = new SB().append(string3 + ".8: ");
        SB sB3 = new SB().append(string3 + ".7: ");
        SB sB4 = new SB().append(string3 + ".6: ");
        SB sB5 = new SB().append(string3 + ".0: ");
        int n3 = n2;
        for (int i = 0; i < this.monomerCount; ++i) {
            n3 = this.monomers[i].getResno();
            sB2.append(n3 % 100 == 0 ? "" + n3 / 100 % 100 : " ");
            sB3.append(n3 % 10 == 0 ? "" + n3 / 10 % 10 : " ");
            sB4.appendI(n3 % 10);
            sB5.appendC(bS.get(this.monomers[i].leadAtomIndex) ? (char)'!' : this.monomers[i].getGroup1());
        }
        if ((n & 1) == 1) {
            sB.appendSB(sB2).appendSB(sB3).appendSB(sB4);
        }
        sB.append("\n");
        sB.append(string);
        if ((n & 2) == 2) {
            sB.appendSB(sB5);
            sB.append("\n\n");
        }
        return sB.toString().replace('\u0000', '.');
    }

    @Override
    public void calculateStructures(boolean bl) {
        int n;
        if (bl) {
            return;
        }
        if (this.structureList == null) {
            this.structureList = this.model.getModelSet().getStructureList();
        }
        char[] cArray = new char[this.monomerCount];
        for (n = 0; n < this.monomerCount - 1; ++n) {
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
            AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n + 1];
            float f = aminoMonomer2.getGroupParameter(1112539143);
            float f2 = aminoMonomer.getGroupParameter(1112539144);
            cArray[n] = this.isHelix(f2, f) ? (f < 0.0f && f2 < 25.0f ? 52 : 51) : (this.isSheet(f2, f) ? 115 : (this.isTurn(f2, f) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug((String)('\u0000' + this.monomers[0].getChainID() + " aminopolymer:" + n + " " + aminoMonomer2.getGroupParameter(1112539143) + "," + aminoMonomer.getGroupParameter(1112539144) + " " + cArray[n]));
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n2;
            if (cArray[n] != '4') continue;
            for (n2 = n + 1; n2 < this.monomerCount && cArray[n2] == '4'; ++n2) {
            }
            if (--n2 >= n + 3) {
                this.addStructureProtected(EnumStructure.HELIX, null, 0, 0, n, n2);
            }
            n = n2;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n3;
            if (cArray[n] != '3') continue;
            for (n3 = n + 1; n3 < this.monomerCount && cArray[n3] == '3'; ++n3) {
            }
            if (--n3 >= n + 3) {
                this.addStructureProtected(EnumStructure.HELIX, null, 0, 0, n, n3);
            }
            n = n3;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n4;
            if (cArray[n] != 's') continue;
            for (n4 = n + 1; n4 < this.monomerCount && cArray[n4] == 's'; ++n4) {
            }
            if (--n4 >= n + 2) {
                this.addStructureProtected(EnumStructure.SHEET, null, 0, 0, n, n4);
            }
            n = n4;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n5;
            if (cArray[n] != 't') continue;
            for (n5 = n + 1; n5 < this.monomerCount && cArray[n5] == 't'; ++n5) {
            }
            if (--n5 >= n + 2) {
                this.addStructureProtected(EnumStructure.TURN, null, 0, 0, n, n5);
            }
            n = n5;
        }
    }

    private boolean isTurn(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.TURN), f, f2);
    }

    private boolean isSheet(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.SHEET), f, f2);
    }

    private boolean isHelix(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.HELIX), f, f2);
    }

    private static boolean checkPhiPsi(float[] fArray, float f, float f2) {
        for (int i = 0; i < fArray.length; i += 4) {
            if (!(f2 >= fArray[i]) || !(f2 <= fArray[i + 1]) || !(f >= fArray[i + 2]) || !(f <= fArray[i + 3])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setStructureList(Map<EnumStructure, float[]> map) {
        this.structureList = map;
    }
}

