/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jmol.api.JmolImageCreatorInterface;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.api.JmolScriptFunction;
import org.jmol.api.JmolStateCreator;
import org.jmol.api.SymmetryInterface;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumStereoMode;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.io.Base64;
import org.jmol.io.JmolBinary;
import org.jmol.io.OutputStringBuilder;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.Measurement;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.TickInfo;
import org.jmol.script.SV;
import org.jmol.shape.AtomShape;
import org.jmol.shape.Echo;
import org.jmol.shape.Halos;
import org.jmol.shape.Hover;
import org.jmol.shape.Labels;
import org.jmol.shape.Object2d;
import org.jmol.shape.Shape;
import org.jmol.shape.Text;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.ColorEncoder;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolFont;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.AnimationManager;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.DataManager;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateCreator
implements JmolStateCreator {
    private Viewer viewer;
    private Map<String, BS> temp = new Hashtable<String, BS>();
    private Map<String, BS> temp2 = new Hashtable<String, BS>();
    private Map<String, BS> temp3 = new Hashtable<String, BS>();
    private boolean undoWorking = false;
    private static final int MAX_ACTION_UNDO = 100;

    @Override
    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    @Override
    public Object getWrappedState(String string, String[] stringArray, boolean bl, boolean bl2, int n, int n2) {
        if (bl && !this.viewer.global.imageState && !bl2 || !this.viewer.global.preserveState) {
            return "";
        }
        String string2 = this.viewer.getStateInfo3(null, n, n2);
        if (bl2) {
            if (string != null) {
                this.viewer.fileManager.clearPngjCache(string);
            }
            return JmolBinary.createZipSet(this.viewer.fileManager, this.viewer, null, string2, stringArray, true);
        }
        try {
            string2 = JC.embedScript(FileManager.setScriptFileReferences(string2, ".", null, null));
        }
        catch (Throwable throwable) {
            Logger.error("state could not be saved: " + throwable.toString());
            string2 = "Jmol " + Viewer.getJmolVersion();
        }
        return string2;
    }

    @Override
    public String getStateScript(String string, int n, int n2) {
        SB sB;
        boolean bl = string == null || string.equalsIgnoreCase("all");
        SB sB2 = new SB();
        SB sB3 = sB = bl ? new SB().append("function _setState() {\n") : null;
        if (bl) {
            sB2.append("# Jmol state version " + Viewer.getJmolVersion() + ";\n");
        }
        if (this.viewer.isApplet() && bl) {
            StateCreator.appendCmd(sB2, "# fullName = " + Escape.eS(this.viewer.fullName));
            StateCreator.appendCmd(sB2, "# documentBase = " + Escape.eS(this.viewer.appletDocumentBase));
            StateCreator.appendCmd(sB2, "# codeBase = " + Escape.eS(this.viewer.appletCodeBase));
            sB2.append("\n");
        }
        StateManager.GlobalSettings globalSettings = this.viewer.global;
        if (bl || string.equalsIgnoreCase("windowState")) {
            sB2.append(this.getWindowState(sB, n, n2));
        }
        if (bl || string.equalsIgnoreCase("fileState")) {
            sB2.append(this.getFileState(sB));
        }
        if (bl || string.equalsIgnoreCase("definedState")) {
            sB2.append(this.getDefinedState(sB, true));
        }
        if (bl || string.equalsIgnoreCase("variableState")) {
            sB2.append(this.getVariableState(globalSettings, sB));
        }
        if (bl || string.equalsIgnoreCase("dataState")) {
            this.getDataState(this.viewer.dataManager, sB2, sB, this.getAtomicPropertyState((byte)-1, null));
        }
        if (bl || string.equalsIgnoreCase("modelState")) {
            sB2.append(this.getModelState(sB, true, this.viewer.getBooleanProperty("saveProteinStructureState")));
        }
        if (bl || string.equalsIgnoreCase("colorState")) {
            sB2.append(this.getColorState(this.viewer.colorManager, sB));
        }
        if (bl || string.equalsIgnoreCase("frameState")) {
            sB2.append(this.getAnimState(this.viewer.animationManager, sB));
        }
        if (bl || string.equalsIgnoreCase("perspectiveState")) {
            sB2.append(this.getViewState(this.viewer.transformManager, sB));
        }
        if (bl || string.equalsIgnoreCase("selectionState")) {
            sB2.append(this.getSelectionState(this.viewer.selectionManager, sB));
        }
        if (sB != null) {
            StateCreator.appendCmd(sB, "set refreshing true");
            StateCreator.appendCmd(sB, "set antialiasDisplay " + globalSettings.antialiasDisplay);
            StateCreator.appendCmd(sB, "set antialiasTranslucent " + globalSettings.antialiasTranslucent);
            StateCreator.appendCmd(sB, "set antialiasImages " + globalSettings.antialiasImages);
            if (this.viewer.getSpinOn()) {
                StateCreator.appendCmd(sB, "spin on");
            }
            sB.append("}\n\n_setState;\n");
        }
        if (bl) {
            sB2.appendSB(sB);
        }
        return sB2.toString();
    }

    private String getDefinedState(SB sB, boolean bl) {
        String string;
        ModelSet modelSet = this.viewer.modelSet;
        int n = modelSet.stateScripts.size();
        if (n == 0) {
            return "";
        }
        boolean bl2 = false;
        SB sB2 = new SB();
        for (int i = 0; i < n; ++i) {
            ModelCollection.StateScript stateScript = (ModelCollection.StateScript)modelSet.stateScripts.get(i);
            if (!stateScript.inDefinedStateBlock || (string = stateScript.toString()).length() <= 0) continue;
            sB2.append("  ").append(string).append("\n");
            bl2 = true;
        }
        if (!bl2) {
            return "";
        }
        string = "";
        if (bl && sB != null) {
            sB.append("  _setDefinedState;\n");
            string = "function _setDefinedState() {\n\n";
        }
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return string + sB2.toString();
    }

    @Override
    public String getModelState(SB sB, boolean bl, boolean bl2) {
        Object object;
        int n;
        SB sB2 = new SB();
        if (bl && sB != null) {
            sB.append("  _setModelState;\n");
            sB2.append("function _setModelState() {\n");
        }
        ModelSet modelSet = this.viewer.modelSet;
        Bond[] bondArray = modelSet.bonds;
        Model[] modelArray = modelSet.models;
        int n2 = modelSet.modelCount;
        if (bl) {
            n = modelSet.stateScripts.size();
            for (int i = 0; i < n; ++i) {
                String string;
                ModelCollection.StateScript stateScript = (ModelCollection.StateScript)modelSet.stateScripts.get(i);
                if (stateScript.inDefinedStateBlock || (string = stateScript.toString()).length() <= 0) continue;
                sB2.append("  ").append(string).append("\n");
            }
            SB sB3 = new SB();
            for (int i = 0; i < modelSet.bondCount; ++i) {
                if (modelArray[bondArray[i].atom1.modelIndex].isModelKit || !bondArray[i].isHydrogen() && (bondArray[i].order & 0x20000) == 0) continue;
                object = bondArray[i];
                int n3 = ((Bond)object).atom1.index;
                if (((Bond)object).atom1.getGroup().isAdded(n3)) {
                    n3 = -1 - n3;
                }
                sB3.appendI(n3).appendC('\t').appendI(((Bond)object).atom2.index).appendC('\t').appendI(((Bond)object).order & 0xFFFDFFFF).appendC('\t').appendF((float)((Bond)object).mad / 1000.0f).appendC('\t').appendF(((Bond)object).getEnergy()).appendC('\t').append(JmolEdge.getBondOrderNameFromOrder(((Bond)object).order)).append(";\n");
            }
            if (sB3.length() > 0) {
                sB2.append("data \"connect_atoms\"\n").appendSB(sB3).append("end \"connect_atoms\";\n");
            }
            sB2.append("\n");
        }
        if (modelSet.haveHiddenBonds) {
            Bond.BondSet bondSet = new Bond.BondSet();
            int n4 = modelSet.bondCount;
            while (--n4 >= 0) {
                if (bondArray[n4].mad == 0 || (bondArray[n4].shapeVisibilityFlags & Bond.myVisibilityFlag) != 0) continue;
                bondSet.set(n4);
            }
            if (bondSet.isEmpty()) {
                modelSet.haveHiddenBonds = false;
            } else {
                sB2.append("  hide ").append(Escape.eBond(bondSet)).append(";\n");
            }
        }
        this.viewer.setModelVisibility();
        if (bl2) {
            sB2.append(modelSet.getProteinStructureState(null, bl, false, 0));
        }
        this.getShapeState(sB2, bl, Integer.MAX_VALUE);
        if (bl) {
            int n5;
            n = 0;
            for (n5 = 0; n5 < n2; ++n5) {
                if (!modelArray[n5].isJmolDataFrame) continue;
                n = 1;
                break;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                String string;
                String string2 = "  frame " + modelSet.getModelNumberDotted(n5);
                object = (String)modelSet.getModelAuxiliaryInfoValue(n5, "modelID");
                if (object != null && !((String)object).equals(modelSet.getModelAuxiliaryInfoValue(n5, "modelID0"))) {
                    sB2.append(string2).append("; frame ID ").append(Escape.eS((String)object)).append(";\n");
                }
                if ((string = modelSet.frameTitles[n5]) != null && string.length() > 0) {
                    sB2.append(string2).append("; frame title ").append(Escape.eS(string)).append(";\n");
                }
                if (n != 0 && modelArray[n5].orientation != null && !modelSet.isTrajectorySubFrame(n5)) {
                    sB2.append(string2).append("; ").append(modelArray[n5].orientation.getMoveToText(false)).append(";\n");
                }
                if (modelArray[n5].frameDelay != 0L && !modelSet.isTrajectorySubFrame(n5)) {
                    sB2.append(string2).append("; frame delay ").appendF((float)modelArray[n5].frameDelay / 1000.0f).append(";\n");
                }
                if (modelArray[n5].simpleCage == null) continue;
                sB2.append(string2).append("; unitcell ").append(Escape.eAP(modelArray[n5].simpleCage.getUnitCellVectors())).append(";\n");
                this.getShapeState(sB2, bl, 33);
            }
            if (modelSet.unitCells != null) {
                for (n5 = 0; n5 < n2; ++n5) {
                    SymmetryInterface symmetryInterface = modelSet.getUnitCell(n5);
                    if (symmetryInterface == null) continue;
                    sB2.append("  frame ").append(modelSet.getModelNumberDotted(n5));
                    object = symmetryInterface.getFractionalOffset();
                    if (object != null) {
                        sB2.append("; set unitcell ").append(Escape.eP((Tuple3f)object));
                    }
                    if ((object = symmetryInterface.getUnitCellMultiplier()) != null) {
                        sB2.append("; set unitcell ").append(Escape.eP((Tuple3f)object));
                    }
                    sB2.append(";\n");
                }
                this.getShapeState(sB2, bl, 33);
            }
            sB2.append("  set fontScaling " + this.viewer.getBoolean(603979845) + ";\n");
            if (this.viewer.getBoolean(603979882)) {
                sB2.append("  set modelKitMode true;\n");
            }
        }
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return sB2.toString();
    }

    private void getShapeState(SB sB, boolean bl, int n) {
        int n2;
        int n3;
        Shape[] shapeArray = this.viewer.shapeManager.shapes;
        if (shapeArray == null) {
            return;
        }
        if (n == Integer.MAX_VALUE) {
            n3 = 0;
            n2 = 36;
        } else {
            n3 = n;
            n2 = n3 + 1;
        }
        while (n3 < n2) {
            String string;
            Shape shape = shapeArray[n3];
            if (shape != null && (bl || JC.isShapeSecondary(n3)) && (string = shape.getShapeState()) != null && string.length() > 1) {
                sB.append(string);
            }
            ++n3;
        }
        sB.append("  select *;\n");
    }

    private String getWindowState(SB sB, int n, int n2) {
        StateManager.GlobalSettings globalSettings = this.viewer.global;
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  initialize;\n  set refreshing false;\n  _setWindowState;\n");
            sB2.append("\nfunction _setWindowState() {\n");
        }
        if (n != 0) {
            sB2.append("# preferredWidthHeight ").appendI(n).append(" ").appendI(n2).append(";\n");
        }
        sB2.append("# width ").appendI(n == 0 ? this.viewer.getScreenWidth() : n).append(";\n# height ").appendI(n2 == 0 ? this.viewer.getScreenHeight() : n2).append(";\n");
        StateCreator.appendCmd(sB2, "stateVersion = " + globalSettings.getParameter("_version"));
        StateCreator.appendCmd(sB2, "background " + Escape.escapeColor(globalSettings.objColors[0]));
        for (int i = 1; i < 8; ++i) {
            if (globalSettings.objColors[i] == 0) continue;
            StateCreator.appendCmd(sB2, StateManager.getObjectNameFromId(i) + "Color = \"" + Escape.escapeColor(globalSettings.objColors[i]) + '\"');
        }
        if (globalSettings.backgroundImageFileName != null) {
            StateCreator.appendCmd(sB2, "background IMAGE /*file*/" + Escape.eS(globalSettings.backgroundImageFileName));
        }
        sB2.append(this.getSpecularState());
        StateCreator.appendCmd(sB2, "statusReporting  = " + globalSettings.statusReporting);
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    @Override
    public String getSpecularState() {
        SB sB = new SB();
        GData gData = this.viewer.gdata;
        StateCreator.appendCmd(sB, "set ambientPercent " + gData.getAmbientPercent());
        StateCreator.appendCmd(sB, "set diffusePercent " + gData.getDiffusePercent());
        StateCreator.appendCmd(sB, "set specular " + gData.getSpecular());
        StateCreator.appendCmd(sB, "set specularPercent " + gData.getSpecularPercent());
        StateCreator.appendCmd(sB, "set specularPower " + gData.getSpecularPower());
        StateCreator.appendCmd(sB, "set celShading " + gData.getCel());
        int n = gData.getSpecularExponent();
        int n2 = gData.getPhongExponent();
        if (Math.pow(2.0, n) == (double)n2) {
            StateCreator.appendCmd(sB, "set specularExponent " + n);
        } else {
            StateCreator.appendCmd(sB, "set phongExponent " + n2);
        }
        StateCreator.appendCmd(sB, "set zShadePower " + this.viewer.global.zShadePower);
        return sB.toString();
    }

    private String getFileState(SB sB) {
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  _setFileState;\n");
            sB2.append("function _setFileState() {\n\n");
        }
        if (sB2.indexOf("append") < 0 && this.viewer.getModelSetFileName().equals("zapped")) {
            sB2.append("  zap;\n");
        }
        this.appendLoadStates(sB2);
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return sB2.toString();
    }

    private void getDataState(DataManager dataManager, SB sB, SB sB2, String string) {
        String string2;
        if (dataManager.dataValues == null) {
            return;
        }
        Iterator<String> iterator = dataManager.dataValues.keySet().iterator();
        SB sB3 = new SB();
        int n = 0;
        if (string.length() > 0) {
            n = 1;
            sB3.append(string);
        }
        while (iterator.hasNext()) {
            Object object;
            Object[] objectArray;
            string2 = iterator.next();
            if (string2.indexOf("property_") == 0) {
                ++n;
                objectArray = dataManager.dataValues.get(string2);
                object = objectArray[1];
                if (object != null && (Integer)objectArray[3] == 1) {
                    this.getAtomicPropertyStateBuffer(sB3, (byte)14, (BS)objectArray[2], string2, (float[])object);
                    sB3.append("\n");
                    continue;
                }
                sB3.append("\n").append(Escape.encapsulateData(string2, object, 0));
                continue;
            }
            if (string2.indexOf("data2d") == 0) {
                objectArray = dataManager.dataValues.get(string2);
                object = objectArray[1];
                if (object == null || (Integer)objectArray[3] != 2) continue;
                ++n;
                sB3.append("\n").append(Escape.encapsulateData(string2, object, 2));
                continue;
            }
            if (string2.indexOf("data3d") != 0 || (object = (objectArray = dataManager.dataValues.get(string2))[1]) == null || (Integer)objectArray[3] != 3) continue;
            ++n;
            sB3.append("\n").append(Escape.encapsulateData(string2, object, 3));
        }
        if (dataManager.userVdws != null && (string2 = dataManager.getDefaultVdwNameOrData(0, EnumVdw.USER, dataManager.bsUserVdws)).length() > 0) {
            ++n;
            sB3.append(string2);
        }
        if (n == 0) {
            return;
        }
        if (sB2 != null) {
            sB.append("function _setDataState() {\n");
        }
        sB.appendSB(sB3);
        if (sB2 != null) {
            sB2.append("  _setDataState;\n");
            sB.append("}\n\n");
        }
    }

    private String getColorState(ColorManager colorManager, SB sB) {
        SB sB2 = new SB();
        int n = this.getCEState(colorManager.propertyColorEncoder, sB2);
        if (n > 0 && sB != null) {
            sB.append("\n  _setColorState\n");
        }
        return n > 0 && sB != null ? "function _setColorState() {\n" + sB2.append("}\n\n").toString() : sB2.toString();
    }

    private int getCEState(ColorEncoder colorEncoder, SB sB) {
        int n = 0;
        for (Map.Entry<String, int[]> entry : colorEncoder.schemes.entrySet()) {
            String string = entry.getKey();
            if (!(string.length() > 0 & n++ >= 0)) continue;
            sB.append("color \"" + string + "=" + ColorEncoder.getColorSchemeList(entry.getValue()) + "\";\n");
        }
        return n;
    }

    private String getAnimState(AnimationManager animationManager, SB sB) {
        BS bS;
        int n = this.viewer.getModelCount();
        if (n < 2) {
            return "";
        }
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  _setFrameState;\n");
            sB2.append("function _setFrameState() {\n");
        }
        sB2.append("# frame state;\n");
        sB2.append("# modelCount ").appendI(n).append(";\n# first ").append(this.viewer.getModelNumberDotted(0)).append(";\n# last ").append(this.viewer.getModelNumberDotted(n - 1)).append(";\n");
        if (animationManager.backgroundModelIndex >= 0) {
            StateCreator.appendCmd(sB2, "set backgroundModel " + this.viewer.getModelNumberDotted(animationManager.backgroundModelIndex));
        }
        if ((bS = this.viewer.getFrameOffsets()) != null) {
            StateCreator.appendCmd(sB2, "frame align " + Escape.eBS(bS));
        }
        StateCreator.appendCmd(sB2, "frame RANGE " + animationManager.getModelNumber(-1) + " " + animationManager.getModelNumber(1));
        StateCreator.appendCmd(sB2, "animation DIRECTION " + (animationManager.animationDirection == 1 ? "+1" : "-1"));
        StateCreator.appendCmd(sB2, "animation FPS " + animationManager.animationFps);
        StateCreator.appendCmd(sB2, "animation MODE " + animationManager.animationReplayMode.name() + " " + animationManager.firstFrameDelay + " " + animationManager.lastFrameDelay);
        if (animationManager.morphCount > 0) {
            StateCreator.appendCmd(sB2, "animation MORPH " + animationManager.morphCount);
        }
        StateCreator.appendCmd(sB2, "frame " + animationManager.getModelNumber(0));
        StateCreator.appendCmd(sB2, "animation " + (!animationManager.animationOn ? "OFF" : (animationManager.currentDirection == 1 ? "PLAY" : "PLAYREV")));
        if (animationManager.animationOn && animationManager.animationPaused) {
            StateCreator.appendCmd(sB2, "animation PAUSE");
        }
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    private String getVariableState(StateManager.GlobalSettings globalSettings, SB sB) {
        boolean bl;
        Object[] objectArray = new String[globalSettings.htBooleanParameterFlags.size() + globalSettings.htNonbooleanParameterValues.size()];
        SB sB2 = new SB();
        boolean bl2 = bl = sB != null;
        if (bl) {
            sB.append("  _setVariableState;\n");
            sB2.append("function _setVariableState() {\n\n");
        }
        int n = 0;
        for (String string : globalSettings.htBooleanParameterFlags.keySet()) {
            if (!StateManager.doReportProperty(string)) continue;
            objectArray[n++] = "set " + string + " " + globalSettings.htBooleanParameterFlags.get(string);
        }
        for (String string : globalSettings.htNonbooleanParameterValues.keySet()) {
            if (!StateManager.doReportProperty(string)) continue;
            Object object = globalSettings.htNonbooleanParameterValues.get(string);
            if (string.charAt(0) == '=') {
                string = string.substring(1);
            } else {
                string = string.indexOf("default") == 0 ? " set " + string : "set " + string;
                object = Escape.e(object);
            }
            objectArray[n++] = string + " " + object;
        }
        switch (globalSettings.axesMode) {
            case UNITCELL: {
                objectArray[n++] = "set axes unitcell";
                break;
            }
            case BOUNDBOX: {
                objectArray[n++] = "set axes window";
                break;
            }
            default: {
                objectArray[n++] = "set axes molecular";
            }
        }
        Arrays.sort(objectArray, 0, n);
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == null) continue;
            StateCreator.appendCmd(sB2, (String)objectArray[i]);
        }
        String string = StateManager.getVariableList(globalSettings.htUserVariables, 0, false, true);
        if (string.length() > 0) {
            sB2.append("\n#user-defined atom sets; \n");
            sB2.append(string);
        }
        this.viewer.loadShape(5);
        sB2.append(this.getDefaultLabelState((Labels)this.viewer.shapeManager.shapes[5]));
        if (globalSettings.haveSetStructureList) {
            Map<EnumStructure, float[]> map = globalSettings.structureList;
            sB2.append("struture HELIX set " + Escape.eAF(map.get((Object)EnumStructure.HELIX)));
            sB2.append("struture SHEET set " + Escape.eAF(map.get((Object)EnumStructure.SHEET)));
            sB2.append("struture TURN set " + Escape.eAF(map.get((Object)EnumStructure.TURN)));
        }
        if (sB != null) {
            sB2.append("\n}\n\n");
        }
        return sB2.toString();
    }

    private String getDefaultLabelState(Labels labels) {
        SB sB = new SB().append("\n# label defaults;\n");
        StateCreator.appendCmd(sB, "select none");
        StateCreator.appendCmd(sB, Shape.getColorCommand("label", labels.defaultPaletteID, labels.defaultColix, labels.translucentAllowed));
        StateCreator.appendCmd(sB, "background label " + Shape.encodeColor(labels.defaultBgcolix));
        StateCreator.appendCmd(sB, "set labelOffset " + Object2d.getXOffset(labels.defaultOffset) + " " + -Object2d.getYOffset(labels.defaultOffset));
        String string = Object2d.getAlignmentName(labels.defaultAlignment);
        StateCreator.appendCmd(sB, "set labelAlignment " + (string.length() < 5 ? "left" : string));
        String string2 = Object2d.getPointer(labels.defaultPointer);
        StateCreator.appendCmd(sB, "set labelPointer " + (string2.length() == 0 ? "off" : string2));
        if ((labels.defaultZPos & 0x20) != 0) {
            StateCreator.appendCmd(sB, "set labelFront");
        } else if ((labels.defaultZPos & 0x10) != 0) {
            StateCreator.appendCmd(sB, "set labelGroup");
        }
        StateCreator.appendCmd(sB, Shape.getFontCommand("label", JmolFont.getFont3D(labels.defaultFontId)));
        return sB.toString();
    }

    private String getSelectionState(SelectionManager selectionManager, SB sB) {
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  _setSelectionState;\n");
            sB2.append("function _setSelectionState() {\n");
        }
        StateCreator.appendCmd(sB2, this.getTrajectoryState());
        Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
        String string = null;
        StateCreator.addBs(sB2, "hide ", selectionManager.bsHidden);
        StateCreator.addBs(sB2, "subset ", selectionManager.bsSubset);
        StateCreator.addBs(sB2, "delete ", selectionManager.bsDeleted);
        StateCreator.addBs(sB2, "fix ", selectionManager.bsFixed);
        hashtable.put("-", selectionManager.bsSelection);
        string = this.getCommands(hashtable, null, "select");
        if (string == null) {
            StateCreator.appendCmd(sB2, "select none");
        } else {
            sB2.append(string);
        }
        StateCreator.appendCmd(sB2, "set hideNotSelected " + selectionManager.hideNotSelected);
        sB2.append((String)this.viewer.getShapeProperty(1, "selectionState"));
        if (this.viewer.getSelectionHaloEnabled(false)) {
            StateCreator.appendCmd(sB2, "SelectionHalos ON");
        }
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    @Override
    public String getTrajectoryState() {
        String string = "";
        ModelSet modelSet = this.viewer.modelSet;
        if (modelSet.trajectorySteps == null) {
            return "";
        }
        int n = modelSet.modelCount;
        while (--n >= 0) {
            int n2 = modelSet.models[n].getSelectedTrajectory();
            if (n2 < 0) continue;
            string = " or " + modelSet.getModelNumberDotted(n2) + string;
            n = modelSet.models[n].trajectoryBaseIndex;
        }
        if (string.length() > 0) {
            string = "set trajectory {" + string.substring(4) + "}";
        }
        return string;
    }

    private String getViewState(TransformManager transformManager, SB sB) {
        SB sB2 = new SB();
        if (sB != null) {
            sB.append("  _setPerspectiveState;\n");
            sB2.append("function _setPerspectiveState() {\n");
        }
        StateCreator.appendCmd(sB2, "set perspectiveModel " + transformManager.perspectiveModel);
        StateCreator.appendCmd(sB2, "set scaleAngstromsPerInch " + transformManager.scale3DAngstromsPerInch);
        StateCreator.appendCmd(sB2, "set perspectiveDepth " + transformManager.perspectiveDepth);
        StateCreator.appendCmd(sB2, "set visualRange " + transformManager.visualRange);
        if (!transformManager.isWindowCentered()) {
            StateCreator.appendCmd(sB2, "set windowCentered false");
        }
        StateCreator.appendCmd(sB2, "set cameraDepth " + transformManager.cameraDepth);
        if (transformManager.mode == 1) {
            StateCreator.appendCmd(sB2, "set navigationMode true");
        }
        StateCreator.appendCmd(sB2, this.viewer.getBoundBoxCommand(false));
        StateCreator.appendCmd(sB2, "center " + Escape.eP(transformManager.fixedRotationCenter));
        sB2.append(this.viewer.getSavedOrienationText(null));
        StateCreator.appendCmd(sB2, transformManager.getMoveToText(0.0f, false));
        if (transformManager.stereoMode != EnumStereoMode.NONE) {
            StateCreator.appendCmd(sB2, "stereo " + (transformManager.stereoColors == null ? transformManager.stereoMode.getName() : Escape.escapeColor(transformManager.stereoColors[0]) + " " + Escape.escapeColor(transformManager.stereoColors[1])) + " " + transformManager.stereoDegrees);
        }
        if (transformManager.mode != 1 && !transformManager.zoomEnabled) {
            StateCreator.appendCmd(sB2, "zoom off");
        }
        sB2.append("  slab ").appendI(transformManager.slabPercentSetting).append(";depth ").appendI(transformManager.depthPercentSetting).append(transformManager.slabEnabled && transformManager.mode != 1 ? ";slab on" : "").append(";\n");
        sB2.append("  set slabRange ").appendF(transformManager.slabRange).append(";\n");
        if (transformManager.zShadeEnabled) {
            sB2.append("  set zShade;\n");
        }
        try {
            if (transformManager.zSlabPoint != null) {
                sB2.append("  set zSlab ").append(Escape.eP(transformManager.zSlabPoint)).append(";\n");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (transformManager.slabPlane != null) {
            sB2.append("  slab plane ").append(Escape.eP4(transformManager.slabPlane)).append(";\n");
        }
        if (transformManager.depthPlane != null) {
            sB2.append("  depth plane ").append(Escape.eP4(transformManager.depthPlane)).append(";\n");
        }
        sB2.append(this.getSpinState(true)).append("\n");
        if (this.viewer.modelSetHasVibrationVectors() && transformManager.vibrationOn) {
            StateCreator.appendCmd(sB2, "set vibrationPeriod " + transformManager.vibrationPeriod + ";vibration on");
        }
        if (transformManager.mode == 1) {
            sB2.append(transformManager.getNavigationState());
            if (transformManager.depthPlane != null || transformManager.slabPlane != null) {
                sB2.append("  slab on;\n");
            }
        }
        if (sB != null) {
            sB2.append("}\n\n");
        }
        return sB2.toString();
    }

    @Override
    public String getSpinState(boolean bl) {
        String string;
        TransformManager transformManager = this.viewer.transformManager;
        String string2 = "  set spinX " + (int)transformManager.spinX + "; set spinY " + (int)transformManager.spinY + "; set spinZ " + (int)transformManager.spinZ + "; set spinFps " + (int)transformManager.spinFps + ";";
        if (!Float.isNaN(transformManager.navFps)) {
            string2 = string2 + "  set navX " + (int)transformManager.navX + "; set navY " + (int)transformManager.navY + "; set navZ " + (int)transformManager.navZ + "; set navFps " + (int)transformManager.navFps + ";";
        }
        if (transformManager.navOn) {
            string2 = string2 + " navigation on;";
        }
        if (!transformManager.spinOn) {
            return string2;
        }
        String string3 = string = transformManager.isSpinSelected ? "\n  select " + Escape.eBS(this.viewer.getSelectionSet(false)) + ";\n  rotateSelected" : "\n ";
        if (transformManager.isSpinInternal) {
            P3 p3 = P3.newP(transformManager.internalRotationCenter);
            p3.sub(transformManager.rotationAxis);
            string2 = string2 + string + " spin " + transformManager.rotationRate + " " + Escape.eP(transformManager.internalRotationCenter) + " " + Escape.eP(p3);
        } else {
            string2 = transformManager.isSpinFixed ? string2 + string + " spin axisangle " + Escape.eP(transformManager.rotationAxis) + " " + transformManager.rotationRate : string2 + " spin on";
        }
        return string2 + ";";
    }

    @Override
    public Map<String, Object> getInfo(Object object) {
        if (object instanceof AnimationManager) {
            return this.getAnimationInfo((AnimationManager)object);
        }
        return null;
    }

    private Map<String, Object> getAnimationInfo(AnimationManager animationManager) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("firstModelIndex", animationManager.firstFrameIndex);
        hashtable.put("lastModelIndex", animationManager.lastFrameIndex);
        hashtable.put("animationDirection", animationManager.animationDirection);
        hashtable.put("currentDirection", animationManager.currentDirection);
        hashtable.put("displayModelIndex", animationManager.currentModelIndex);
        hashtable.put("displayModelNumber", this.viewer.getModelNumberDotted(animationManager.currentModelIndex));
        hashtable.put("displayModelName", animationManager.currentModelIndex >= 0 ? this.viewer.getModelName(animationManager.currentModelIndex) : "");
        hashtable.put("animationFps", animationManager.animationFps);
        hashtable.put("animationReplayMode", animationManager.animationReplayMode.name());
        hashtable.put("firstFrameDelay", Float.valueOf(animationManager.firstFrameDelay));
        hashtable.put("lastFrameDelay", Float.valueOf(animationManager.lastFrameDelay));
        hashtable.put("animationOn", animationManager.animationOn);
        hashtable.put("animationPaused", animationManager.animationPaused);
        return hashtable;
    }

    @Override
    public String getCommands(Map<String, BS> map, Map<String, BS> map2, String string) {
        SB sB = new SB();
        String string2 = StateCreator.getCommands2(map, sB, null, string);
        if (map2 != null) {
            StateCreator.getCommands2(map2, sB, string2, "select");
        }
        return sB.toString();
    }

    private static String getCommands2(Map<String, BS> map, SB sB, String string, String string2) {
        if (map == null) {
            return "";
        }
        for (Map.Entry<String, BS> entry : map.entrySet()) {
            String string3 = entry.getKey();
            String string4 = Escape.eBS(entry.getValue());
            if (string4.length() < 5) continue;
            string4 = string2 + " " + string4;
            if (!string4.equals(string)) {
                StateCreator.appendCmd(sB, string4);
            }
            string = string4;
            if (string3.indexOf("-") == 0) continue;
            StateCreator.appendCmd(sB, string3);
        }
        return string;
    }

    private static void appendCmd(SB sB, String string) {
        if (string.length() == 0) {
            return;
        }
        sB.append("  ").append(string).append(";\n");
    }

    private static void addBs(SB sB, String string, BS bS) {
        if (bS == null || bS.length() == 0) {
            return;
        }
        StateCreator.appendCmd(sB, string + Escape.eBS(bS));
    }

    @Override
    public String getFontState(String string, JmolFont jmolFont) {
        int n = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n < 0) {
            return "";
        }
        int n2 = this.viewer.getObjectMad(n);
        SB sB = new SB().append("\n");
        StateCreator.appendCmd(sB, string + (n2 == 0 ? " off" : (n2 == 1 ? " on" : (n2 == -1 ? " dotted" : (n2 < 20 ? " " + n2 : " " + (float)n2 / 2000.0f)))));
        if (sB.length() < 3) {
            return "";
        }
        String string2 = Shape.getFontCommand(string, jmolFont);
        if (string2.length() > 0) {
            string2 = "  " + string2 + ";\n";
        }
        return sB + string2;
    }

    @Override
    public String getFontLineShapeState(String string, String string2, TickInfo[] tickInfoArray) {
        boolean bl = string.indexOf(" off") >= 0;
        SB sB = new SB();
        sB.append(string);
        for (int i = 0; i < 4; ++i) {
            if (tickInfoArray[i] == null) continue;
            this.appendTickInfo(string2, sB, tickInfoArray[i]);
        }
        if (bl) {
            sB.append("  " + string2 + " off;\n");
        }
        return sB.toString();
    }

    private void appendTickInfo(String string, SB sB, TickInfo tickInfo) {
        sB.append("  ");
        sB.append(string);
        StateCreator.addTickInfo(sB, tickInfo, false);
        sB.append(";\n");
    }

    private static void addTickInfo(SB sB, TickInfo tickInfo, boolean bl) {
        boolean bl2;
        sB.append(" ticks ").append(tickInfo.type).append(" ").append(Escape.eP(tickInfo.ticks));
        boolean bl3 = bl2 = tickInfo.scale != null && Float.isNaN(tickInfo.scale.x);
        if (bl2) {
            sB.append(" UNITCELL");
        }
        if (tickInfo.tickLabelFormats != null) {
            sB.append(" format ").append(Escape.eAS(tickInfo.tickLabelFormats, false));
        }
        if (!bl2 && tickInfo.scale != null) {
            sB.append(" scale ").append(Escape.eP(tickInfo.scale));
        }
        if (bl && !Float.isNaN(tickInfo.first) && tickInfo.first != 0.0f) {
            sB.append(" first ").appendF(tickInfo.first);
        }
        if (tickInfo.reference != null) {
            sB.append(" point ").append(Escape.eP(tickInfo.reference));
        }
    }

    @Override
    public void getShapeSetState(AtomShape atomShape, Shape shape, int n, Group[] groupArray, BS bS, Map<String, BS> map, Map<String, BS> map2) {
        String string = JC.shapeClassBases[shape.shapeID];
        for (int i = 0; i < n; ++i) {
            int n2 = groupArray[i].firstAtomIndex;
            int n3 = groupArray[i].lastAtomIndex;
            if (atomShape.bsSizeSet != null && (atomShape.bsSizeSet.get(i) || atomShape.bsColixSet != null && atomShape.bsColixSet.get(i))) {
                if (bS.get(i)) {
                    BSUtil.setMapBitSet(map, n2, n3, string + (atomShape.bsSizeSet.get(i) ? " on" : " off"));
                } else {
                    BSUtil.setMapBitSet(map, n2, n3, string + " " + (float)atomShape.mads[i] / 2000.0f);
                }
            }
            if (atomShape.bsColixSet == null || !atomShape.bsColixSet.get(i)) continue;
            BSUtil.setMapBitSet(map2, n2, n3, Shape.getColorCommand(string, atomShape.paletteIDs[i], atomShape.colixes[i], shape.translucentAllowed));
        }
    }

    @Override
    public String getMeasurementState(AtomShape atomShape, JmolList<Measurement> jmolList, int n, JmolFont jmolFont, TickInfo tickInfo) {
        String string;
        int n2;
        Object object;
        Object object2;
        int n3;
        SB sB = new SB();
        StateCreator.appendCmd(sB, "measures delete");
        for (n3 = 0; n3 < n; ++n3) {
            object2 = (Measurement)jmolList.get(n3);
            int n4 = ((Measurement)object2).getCount();
            SB sB2 = new SB().append("measure");
            object = ((Measurement)object2).tickInfo;
            if (object != null) {
                StateCreator.addTickInfo(sB2, (TickInfo)object, true);
            }
            for (int i = 1; i <= n4; ++i) {
                sB2.append(" ").append(((Measurement)object2).getLabel(i, true, true));
            }
            sB2.append("; # " + atomShape.getInfoAsString(n3));
            StateCreator.appendCmd(sB, sB2.toString());
        }
        StateCreator.appendCmd(sB, "select *; set measures " + this.viewer.getMeasureDistanceUnits());
        StateCreator.appendCmd(sB, Shape.getFontCommand("measures", jmolFont));
        n3 = 0;
        object2 = new Hashtable();
        BS bS = BSUtil.newBitSet(n);
        for (n2 = 0; n2 < n; ++n2) {
            object = (Measurement)jmolList.get(n2);
            if (((Measurement)object).isHidden) {
                ++n3;
                bS.set(n2);
            }
            if (atomShape.bsColixSet != null && atomShape.bsColixSet.get(n2)) {
                BSUtil.setMapBitSet((Map<String, BS>)object2, n2, n2, Shape.getColorCommandUnk("measure", ((Measurement)object).colix, atomShape.translucentAllowed));
            }
            if (((Measurement)object).getStrFormat() == null) continue;
            BSUtil.setMapBitSet((Map<String, BS>)object2, n2, n2, "measure " + Escape.eS(((Measurement)object).getStrFormat()));
        }
        if (n3 > 0) {
            if (n3 == n) {
                StateCreator.appendCmd(sB, "measures off; # lines and numbers off");
            } else {
                for (n2 = 0; n2 < n; ++n2) {
                    if (!bS.get(n2)) continue;
                    BSUtil.setMapBitSet((Map<String, BS>)object2, n2, n2, "measure off");
                }
            }
        }
        if (tickInfo != null) {
            sB.append(" measure ");
            StateCreator.addTickInfo(sB, tickInfo, true);
            sB.append(";\n");
        }
        if (atomShape.mad >= 0) {
            sB.append(" set measurements " + (float)atomShape.mad / 2000.0f).append(";\n");
        }
        if ((string = this.getCommands((Map<String, BS>)object2, null, "select measures")) != null && string.length() != 0) {
            sB.append(string);
            StateCreator.appendCmd(sB, "select measures ({null})");
        }
        return sB.toString();
    }

    @Override
    public String getBondState(Shape shape, BS bS, boolean bl) {
        int n;
        int n2;
        this.clearTemp();
        ModelSet modelSet = this.viewer.modelSet;
        boolean bl2 = false;
        Bond[] bondArray = modelSet.bonds;
        int n3 = modelSet.bondCount;
        if (bl || shape.bsSizeSet != null) {
            n = n2 = bl ? n3 - 1 : shape.bsSizeSet.nextSetBit(0);
            while (n >= 0) {
                short s;
                BSUtil.setMapBitSet(this.temp, n, n, "wireframe " + ((s = bondArray[n].mad) == 1 ? "on" : "" + (float)s / 2000.0f));
                n = bl ? n - 1 : shape.bsSizeSet.nextSetBit(n + 1);
            }
        }
        if (bl || bS != null) {
            n = n2 = bl ? n3 - 1 : bS.nextSetBit(0);
            while (n >= 0) {
                Bond bond = bondArray[n];
                if (bl || (bond.order & 0x20000) == 0) {
                    BSUtil.setMapBitSet(this.temp, n, n, "bondOrder " + JmolEdge.getBondOrderNameFromOrder(bond.order));
                }
                n = bl ? n - 1 : bS.nextSetBit(n + 1);
            }
        }
        if (shape.bsColixSet != null) {
            n2 = shape.bsColixSet.nextSetBit(0);
            while (n2 >= 0) {
                n = bondArray[n2].colix;
                if ((n & 0xFFFF87FF) == 2) {
                    BSUtil.setMapBitSet(this.temp, n2, n2, Shape.getColorCommand("bonds", EnumPalette.CPK.id, (short)n, shape.translucentAllowed));
                } else {
                    BSUtil.setMapBitSet(this.temp, n2, n2, Shape.getColorCommandUnk("bonds", (short)n, shape.translucentAllowed));
                }
                n2 = shape.bsColixSet.nextSetBit(n2 + 1);
            }
        }
        String string = this.getCommands(this.temp, null, "select BONDS") + "\n" + (bl2 ? this.getCommands(this.temp2, null, "select BONDS") + "\n" : "");
        this.clearTemp();
        return string;
    }

    private void clearTemp() {
        this.temp.clear();
        this.temp2.clear();
    }

    @Override
    public String getAtomShapeSetState(Shape shape, AtomShape[] atomShapeArray) {
        this.clearTemp();
        int n = atomShapeArray.length;
        while (--n >= 0) {
            AtomShape atomShape = atomShapeArray[n];
            if (atomShape.monomerCount <= 0 || !atomShape.isActive || atomShape.bsSizeSet == null && atomShape.bsColixSet == null) continue;
            this.viewer.getShapeSetState(atomShape, shape, atomShape.monomerCount, atomShape.getMonomers(), atomShape.bsSizeDefault, this.temp, this.temp2);
        }
        String string = "\n" + this.getCommands(this.temp, this.temp2, shape.shapeID == 9 ? "Backbone" : "select");
        this.clearTemp();
        return string;
    }

    @Override
    public String getShapeState(Shape shape) {
        String string;
        this.clearTemp();
        switch (shape.shapeID) {
            case 30: {
                Echo echo = (Echo)shape;
                SB sB = new SB();
                sB.append("\n  set echo off;\n");
                for (Text text : echo.objects.values()) {
                    sB.append(text.getState());
                    if (!text.hidden) continue;
                    sB.append("  set echo ID ").append(Escape.eS(text.target)).append(" hidden;\n");
                }
                string = sB.toString();
                break;
            }
            case 8: {
                Halos halos = (Halos)shape;
                string = this.getAtomShapeState(halos) + (halos.colixSelection == 2 ? "" : (halos.colixSelection == 0 ? "  color SelectionHalos NONE;\n" : Shape.getColorCommandUnk("selectionHalos", halos.colixSelection, halos.translucentAllowed) + ";\n"));
                if (halos.bsHighlight == null) break;
                string = string + "  set highlight " + Escape.eBS(halos.bsHighlight) + "; " + Shape.getColorCommandUnk("highlight", halos.colixHighlight, halos.translucentAllowed) + ";\n";
                break;
            }
            case 34: {
                Hover hover = (Hover)shape;
                if (hover.atomFormats != null) {
                    int n = this.viewer.getAtomCount();
                    while (--n >= 0) {
                        if (hover.atomFormats[n] == null) continue;
                        BSUtil.setMapBitSet(this.temp, n, n, "set hoverLabel " + Escape.eS(hover.atomFormats[n]));
                    }
                }
                string = "\n  hover " + Escape.eS(hover.labelFormat == null ? "" : hover.labelFormat) + ";\n" + this.getCommands(this.temp, null, "select");
                break;
            }
            case 5: {
                Labels labels = (Labels)shape;
                int n = labels.bsSizeSet.nextSetBit(0);
                while (n >= 0) {
                    Text text;
                    float f;
                    String string2;
                    Text text2 = labels.getLabel(n);
                    String string3 = string2 = text2 == null ? null : text2.getCommand();
                    if (string2 == null) {
                        string2 = "label " + Escape.eS(labels.formats[n]);
                    }
                    BSUtil.setMapBitSet(this.temp, n, n, string2);
                    if (labels.bsColixSet != null && labels.bsColixSet.get(n)) {
                        BSUtil.setMapBitSet(this.temp2, n, n, Shape.getColorCommand("label", labels.paletteIDs[n], labels.colixes[n], labels.translucentAllowed));
                    }
                    if (labels.bsBgColixSet != null && labels.bsBgColixSet.get(n)) {
                        BSUtil.setMapBitSet(this.temp2, n, n, "background label " + Shape.encodeColor(labels.bgcolixes[n]));
                    }
                    float f2 = f = (text = labels.getLabel(n)) != null ? text.getScalePixelsPerMicron() : 0.0f;
                    if (f > 0.0f) {
                        BSUtil.setMapBitSet(this.temp2, n, n, "set labelScaleReference " + 10000.0f / f);
                    }
                    if (labels.offsets != null && labels.offsets.length > n) {
                        int n2 = labels.offsets[n];
                        BSUtil.setMapBitSet(this.temp2, n, n, "set " + ((n2 & 0x80) == 128 ? "labelOffsetExact " : "labelOffset ") + Object2d.getXOffset(n2 >> 8) + " " + -Object2d.getYOffset(n2 >> 8));
                        String string4 = Object2d.getAlignmentName(n2 >> 2);
                        String string5 = Object2d.getPointer(n2);
                        if (string5.length() > 0) {
                            BSUtil.setMapBitSet(this.temp2, n, n, "set labelPointer " + string5);
                        }
                        if ((n2 & 0x20) != 0) {
                            BSUtil.setMapBitSet(this.temp2, n, n, "set labelFront");
                        } else if ((n2 & 0x10) != 0) {
                            BSUtil.setMapBitSet(this.temp2, n, n, "set labelGroup");
                        }
                        if (string4.length() > 0) {
                            BSUtil.setMapBitSet(this.temp3, n, n, "set labelAlignment " + string4);
                        }
                    }
                    if (labels.mads != null && labels.mads[n] < 0) {
                        BSUtil.setMapBitSet(this.temp2, n, n, "set toggleLabel");
                    }
                    if (labels.bsFontSet != null && labels.bsFontSet.get(n)) {
                        BSUtil.setMapBitSet(this.temp2, n, n, Shape.getFontCommand("label", JmolFont.getFont3D(labels.fids[n])));
                    }
                    n = labels.bsSizeSet.nextSetBit(n + 1);
                }
                string = this.getCommands(this.temp, this.temp2, "select") + this.getCommands(null, this.temp3, "select");
                this.temp3.clear();
                break;
            }
            case 0: {
                int n = this.viewer.getAtomCount();
                Atom[] atomArray = this.viewer.modelSet.atoms;
                float f = 0.0f;
                for (int i = 0; i < n; ++i) {
                    byte by;
                    if (shape.bsSizeSet != null && shape.bsSizeSet.get(i)) {
                        float f3;
                        f = atomArray[i].madAtom;
                        if (f3 < 0.0f) {
                            BSUtil.setMapBitSet(this.temp, i, i, "Spacefill on");
                        } else {
                            BSUtil.setMapBitSet(this.temp, i, i, "Spacefill " + f / 2000.0f);
                        }
                    }
                    if (shape.bsColixSet == null || !shape.bsColixSet.get(i) || (by = atomArray[i].getPaletteID()) == EnumPalette.CPK.id && !atomArray[i].isTranslucent()) continue;
                    BSUtil.setMapBitSet(this.temp, i, i, Shape.getColorCommand("atoms", by, atomArray[i].getColix(), shape.translucentAllowed));
                }
                string = this.getCommands(this.temp, null, "select");
                break;
            }
            default: {
                string = "";
            }
        }
        this.clearTemp();
        return string;
    }

    @Override
    public String getLoadState(Map<String, Object> map) {
        StateManager.GlobalSettings globalSettings = this.viewer.global;
        SB sB = new SB();
        StateCreator.appendCmd(sB, "set allowEmbeddedScripts false");
        if (globalSettings.allowEmbeddedScripts) {
            globalSettings.setB("allowEmbeddedScripts", true);
        }
        StateCreator.appendCmd(sB, "set appendNew " + globalSettings.appendNew);
        StateCreator.appendCmd(sB, "set appletProxy " + Escape.eS(globalSettings.appletProxy));
        StateCreator.appendCmd(sB, "set applySymmetryToBonds " + globalSettings.applySymmetryToBonds);
        if (globalSettings.atomTypes.length() > 0) {
            StateCreator.appendCmd(sB, "set atomTypes " + Escape.eS(globalSettings.atomTypes));
        }
        StateCreator.appendCmd(sB, "set autoBond " + globalSettings.autoBond);
        if (globalSettings.axesOrientationRasmol) {
            StateCreator.appendCmd(sB, "set axesOrientationRasmol true");
        }
        StateCreator.appendCmd(sB, "set bondRadiusMilliAngstroms " + globalSettings.bondRadiusMilliAngstroms);
        StateCreator.appendCmd(sB, "set bondTolerance " + globalSettings.bondTolerance);
        StateCreator.appendCmd(sB, "set defaultLattice " + Escape.eP(globalSettings.ptDefaultLattice));
        StateCreator.appendCmd(sB, "set defaultLoadFilter " + Escape.eS(globalSettings.defaultLoadFilter));
        StateCreator.appendCmd(sB, "set defaultLoadScript \"\"");
        if (globalSettings.defaultLoadScript.length() > 0) {
            globalSettings.setS("defaultLoadScript", globalSettings.defaultLoadScript);
        }
        StateCreator.appendCmd(sB, "set defaultStructureDssp " + globalSettings.defaultStructureDSSP);
        String string = this.viewer.getDefaultVdwTypeNameOrData(Integer.MIN_VALUE, null);
        StateCreator.appendCmd(sB, "set defaultVDW " + string);
        if (string.equals("User")) {
            StateCreator.appendCmd(sB, this.viewer.getDefaultVdwTypeNameOrData(Integer.MAX_VALUE, null));
        }
        StateCreator.appendCmd(sB, "set forceAutoBond " + globalSettings.forceAutoBond);
        StateCreator.appendCmd(sB, "#set defaultDirectory " + Escape.eS(globalSettings.defaultDirectory));
        StateCreator.appendCmd(sB, "#set loadFormat " + Escape.eS(globalSettings.loadFormat));
        StateCreator.appendCmd(sB, "#set loadLigandFormat " + Escape.eS(globalSettings.loadLigandFormat));
        StateCreator.appendCmd(sB, "#set smilesUrlFormat " + Escape.eS(globalSettings.smilesUrlFormat));
        StateCreator.appendCmd(sB, "#set nihResolverFormat " + Escape.eS(globalSettings.nihResolverFormat));
        StateCreator.appendCmd(sB, "#set pubChemFormat " + Escape.eS(globalSettings.pubChemFormat));
        StateCreator.appendCmd(sB, "#set edsUrlFormat " + Escape.eS(globalSettings.edsUrlFormat));
        StateCreator.appendCmd(sB, "#set edsUrlCutoff " + Escape.eS(globalSettings.edsUrlCutoff));
        StateCreator.appendCmd(sB, "set legacyAutoBonding " + globalSettings.legacyAutoBonding);
        StateCreator.appendCmd(sB, "set minBondDistance " + globalSettings.minBondDistance);
        StateCreator.appendCmd(sB, "set minimizationCriterion  " + globalSettings.minimizationCriterion);
        StateCreator.appendCmd(sB, "set minimizationSteps  " + globalSettings.minimizationSteps);
        StateCreator.appendCmd(sB, "set pdbAddHydrogens " + (map != null && map.get("pdbNoHydrogens") != Boolean.TRUE ? globalSettings.pdbAddHydrogens : false));
        StateCreator.appendCmd(sB, "set pdbGetHeader " + globalSettings.pdbGetHeader);
        StateCreator.appendCmd(sB, "set pdbSequential " + globalSettings.pdbSequential);
        StateCreator.appendCmd(sB, "set percentVdwAtom " + globalSettings.percentVdwAtom);
        StateCreator.appendCmd(sB, "set smallMoleculeMaxAtoms " + globalSettings.smallMoleculeMaxAtoms);
        StateCreator.appendCmd(sB, "set smartAromatic " + globalSettings.smartAromatic);
        if (globalSettings.zeroBasedXyzRasmol) {
            StateCreator.appendCmd(sB, "set zeroBasedXyzRasmol true");
        }
        return sB.toString();
    }

    @Override
    public String getAllSettings(String string) {
        Object object;
        StateManager.GlobalSettings globalSettings = this.viewer.global;
        SB sB = new SB();
        Object[] objectArray = new String[globalSettings.htBooleanParameterFlags.size() + globalSettings.htNonbooleanParameterValues.size() + globalSettings.htUserVariables.size()];
        int n = 0;
        String string2 = "_" + string;
        for (String string3 : globalSettings.htBooleanParameterFlags.keySet()) {
            if (string != null && string3.indexOf(string) != 0 && string3.indexOf(string2) != 0) continue;
            objectArray[n++] = (string3.indexOf("_") == 0 ? string3 + " = " : "set " + string3 + " ") + globalSettings.htBooleanParameterFlags.get(string3);
        }
        for (String string3 : globalSettings.htNonbooleanParameterValues.keySet()) {
            if (string3.charAt(0) == '@' || string != null && string3.indexOf(string) != 0 && string3.indexOf(string2) != 0) continue;
            object = globalSettings.htNonbooleanParameterValues.get(string3);
            if (object instanceof String) {
                object = StateCreator.chop(Escape.eS((String)object));
            }
            objectArray[n++] = (string3.indexOf("_") == 0 ? string3 + " = " : "set " + string3 + " ") + object;
        }
        for (String string3 : globalSettings.htUserVariables.keySet()) {
            if (string != null && string3.indexOf(string) != 0) continue;
            object = globalSettings.htUserVariables.get(string3);
            String string4 = ((SV)object).asString();
            objectArray[n++] = string3 + " " + (string3.startsWith("@") ? "" : "= ") + (((SV)object).tok == 4 ? StateCreator.chop(Escape.eS(string4)) : string4);
        }
        Arrays.sort(objectArray, 0, n);
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] == null) continue;
            StateCreator.appendCmd(sB, (String)objectArray[i]);
        }
        sB.append("\n");
        return sB.toString();
    }

    private static String chop(String string) {
        int n = string.length();
        if (n < 512) {
            return string;
        }
        SB sB = new SB();
        String string2 = "\"\\\n    + \"";
        int n2 = 0;
        for (int i = 72; i < n; i += 72) {
            while (string.charAt(i - 1) == '\\') {
                ++i;
            }
            sB.append(n2 == 0 ? "" : string2).append(string.substring(n2, i));
            n2 = i;
        }
        sB.append(string2).append(string.substring(n2, n));
        return sB.toString();
    }

    @Override
    public String getAtomShapeState(AtomShape atomShape) {
        int n;
        this.clearTemp();
        String string = JC.shapeClassBases[atomShape.shapeID];
        if (atomShape.bsSizeSet != null) {
            n = atomShape.bsSizeSet.nextSetBit(0);
            while (n >= 0) {
                BSUtil.setMapBitSet(this.temp, n, n, string + (atomShape.mads[n] < 0 ? " on" : " " + (float)atomShape.mads[n] / 2000.0f));
                n = atomShape.bsSizeSet.nextSetBit(n + 1);
            }
        }
        if (atomShape.bsColixSet != null) {
            n = atomShape.bsColixSet.nextSetBit(0);
            while (n >= 0) {
                BSUtil.setMapBitSet(this.temp2, n, n, Shape.getColorCommand(string, atomShape.paletteIDs[n], atomShape.colixes[n], atomShape.translucentAllowed));
                n = atomShape.bsColixSet.nextSetBit(n + 1);
            }
        }
        String string2 = this.getCommands(this.temp, this.temp2, "select");
        this.clearTemp();
        return string2;
    }

    @Override
    public String getFunctionCalls(String string) {
        boolean bl;
        if (string == null) {
            string = "";
        }
        SB sB = new SB();
        int n = string.indexOf("*");
        boolean bl2 = n >= 0;
        boolean bl3 = string.indexOf("static_") == 0;
        boolean bl4 = bl = string.equalsIgnoreCase("names") || string.equalsIgnoreCase("static_names");
        if (bl) {
            string = "";
        }
        if (bl2) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase();
        Map<String, JmolScriptFunction> map = bl3 ? Viewer.staticFunctions : this.viewer.localFunctions;
        Object[] objectArray = new String[map.size()];
        Iterator<String> iterator = map.keySet().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if ((string.length() != 0 || string2.startsWith("_")) && !string2.equalsIgnoreCase(string) && (!bl2 || string2.toLowerCase().indexOf(string) != 0)) continue;
            objectArray[n2++] = string2;
        }
        Arrays.sort(objectArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            JmolScriptFunction jmolScriptFunction = map.get(objectArray[i]);
            sB.append(bl ? jmolScriptFunction.getSignature() : jmolScriptFunction.toString());
            sB.appendC('\n');
        }
        return sB.toString();
    }

    private static boolean isTainted(BS[] bSArray, int n, byte by) {
        return bSArray != null && bSArray[by] != null && bSArray[by].get(n);
    }

    @Override
    public String getAtomicPropertyState(byte by, BS bS) {
        if (!this.viewer.global.preserveState) {
            return "";
        }
        SB sB = new SB();
        for (byte by2 = 0; by2 < 14; by2 = (byte)(by2 + 1)) {
            BS bS2;
            if (by >= 0 && by2 != by || (bS2 = bS != null ? bS : this.viewer.getTaintedAtoms(by2)) == null) continue;
            this.getAtomicPropertyStateBuffer(sB, by2, bS2, null, null);
        }
        return sB.toString();
    }

    @Override
    public void getAtomicPropertyStateBuffer(SB sB, byte by, BS bS, String string, float[] fArray) {
        if (!this.viewer.global.preserveState) {
            return;
        }
        SB sB2 = new SB();
        String string2 = (string == null ? AtomCollection.userSettableValues[by] : string) + " set";
        int n = 0;
        boolean bl = by == 2;
        Atom[] atomArray = this.viewer.modelSet.atoms;
        BS[] bSArray = this.viewer.modelSet.tainted;
        if (bS != null) {
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                sB2.appendI(n2 + 1).append(" ").append(atomArray[n2].getElementSymbol()).append(" ").append(atomArray[n2].getInfo().replace(' ', '_')).append(" ");
                switch (by) {
                    case 14: {
                        if (n2 >= fArray.length) break;
                        sB2.appendF(fArray[n2]);
                        break;
                    }
                    case 13: {
                        sB2.appendI(atomArray[n2].getAtomNumber());
                        break;
                    }
                    case 0: {
                        sB2.append(atomArray[n2].getAtomName());
                        break;
                    }
                    case 1: {
                        sB2.append(atomArray[n2].getAtomType());
                        break;
                    }
                    case 2: {
                        if (StateCreator.isTainted(bSArray, n2, (byte)2)) {
                            bl = false;
                        }
                        sB2.appendF(atomArray[n2].x).append(" ").appendF(atomArray[n2].y).append(" ").appendF(atomArray[n2].z);
                        break;
                    }
                    case 12: {
                        V3 v3 = atomArray[n2].getVibrationVector();
                        if (v3 == null) {
                            v3 = new V3();
                        }
                        sB2.appendF(v3.x).append(" ").appendF(v3.y).append(" ").appendF(v3.z);
                        break;
                    }
                    case 3: {
                        sB2.appendI(atomArray[n2].getAtomicAndIsotopeNumber());
                        break;
                    }
                    case 4: {
                        sB2.appendI(atomArray[n2].getFormalCharge());
                        break;
                    }
                    case 6: {
                        sB2.appendF(atomArray[n2].getBondingRadiusFloat());
                        break;
                    }
                    case 7: {
                        sB2.appendI(atomArray[n2].getOccupancy100());
                        break;
                    }
                    case 8: {
                        sB2.appendF(atomArray[n2].getPartialCharge());
                        break;
                    }
                    case 9: {
                        sB2.appendF((float)atomArray[n2].getBfactor100() / 100.0f);
                        break;
                    }
                    case 10: {
                        sB2.appendI(atomArray[n2].getValence());
                        break;
                    }
                    case 11: {
                        sB2.appendF(atomArray[n2].getVanderwaalsRadiusFloat(this.viewer, EnumVdw.AUTO));
                    }
                }
                sB2.append(" ;\n");
                ++n;
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        if (n == 0) {
            return;
        }
        if (bl) {
            string2 = string2 + "(default)";
        }
        sB.append("\n  DATA \"" + string2 + "\"\n").appendI(n).append(" ;\nJmol Property Data Format 1 -- Jmol ").append(Viewer.getJmolVersion()).append(";\n");
        sB.appendSB(sB2);
        sB.append("  end \"" + string2 + "\";\n");
    }

    @Override
    public void undoMoveAction(int n, int n2) {
        block0 : switch (n) {
            case 4139: 
            case 4165: {
                switch (n2) {
                    case -2: {
                        this.viewer.undoClear();
                        break block0;
                    }
                    case -1: {
                        (n == 4165 ? this.viewer.actionStates : this.viewer.actionStatesRedo).clear();
                        break block0;
                    }
                    case 0: {
                        n2 = Integer.MAX_VALUE;
                    }
                }
                if (n2 > 100) {
                    n2 = (n == 4165 ? this.viewer.actionStates : this.viewer.actionStatesRedo).size();
                }
                for (int i = 0; i < n2; ++i) {
                    this.undoMoveActionClear(0, n, true);
                }
                break;
            }
        }
    }

    @Override
    public void undoMoveActionClear(int n, int n2, boolean bl) {
        if (!this.viewer.global.preserveState) {
            return;
        }
        int n3 = n >= 0 ? (int)this.viewer.modelSet.atoms[n].modelIndex : this.viewer.modelSet.modelCount - 1;
        switch (n2) {
            case 4139: 
            case 4165: {
                JmolList<String> jmolList;
                JmolList<String> jmolList2;
                this.viewer.stopMinimization();
                String string = "";
                switch (n2) {
                    default: {
                        jmolList2 = this.viewer.actionStates;
                        jmolList = this.viewer.actionStatesRedo;
                        break;
                    }
                    case 4139: {
                        jmolList2 = this.viewer.actionStatesRedo;
                        jmolList = this.viewer.actionStates;
                        if (this.viewer.actionStatesRedo.size() != 1) break;
                        return;
                    }
                }
                if (jmolList2.size() == 0 || this.undoWorking) {
                    return;
                }
                this.undoWorking = true;
                jmolList.add(0, jmolList2.remove(0));
                string = (String)this.viewer.actionStatesRedo.get(0);
                if (n2 == 4165 && jmolList.size() == 1) {
                    int[] nArray = new int[]{1};
                    n2 = Parser.parseIntNext(string, nArray);
                    n = Parser.parseIntNext(string, nArray);
                    this.undoMoveActionClear(n, n2, false);
                }
                if (this.viewer.modelSet.models[n3].isModelkit() || string.indexOf("zap ") < 0) {
                    if (Logger.debugging) {
                        this.viewer.log(string);
                    }
                    this.viewer.evalStringQuiet(string);
                    break;
                }
                this.viewer.actionStates.clear();
                break;
            }
            default: {
                if (this.undoWorking && bl) {
                    return;
                }
                this.undoWorking = true;
                SB sB = new SB();
                sB.append("#" + n2 + " " + n + " " + new Date() + "\n");
                if (n >= 0) {
                    BS bS = this.viewer.getModelUndeletedAtomsBitSet(n3);
                    this.viewer.modelSet.taintAtoms(bS, (byte)n2);
                    sB.append(this.getAtomicPropertyState((byte)-1, null));
                } else {
                    BS bS = this.viewer.getModelUndeletedAtomsBitSet(n3);
                    sB.append("zap ");
                    sB.append(Escape.eBS(bS)).append(";");
                    DataManager.getInlineData(sB, this.viewer.getModelExtract(bS, false, true, "MOL"), true, null);
                    sB.append("set refreshing false;").append(this.viewer.actionManager.getPickingState()).append(this.viewer.transformManager.getMoveToText(0.0f, false)).append("set refreshing true;");
                }
                if (bl) {
                    this.viewer.actionStates.add(0, sB.toString());
                    this.viewer.actionStatesRedo.clear();
                } else {
                    this.viewer.actionStatesRedo.add(1, sB.toString());
                }
                if (this.viewer.actionStates.size() != 100) break;
                this.viewer.actionStates.remove(99);
            }
        }
        this.undoWorking = !bl;
    }

    void appendLoadStates(SB sB) {
        int n;
        Object object;
        Map<String, Boolean> map = this.viewer.ligandModelSet;
        if (map != null) {
            for (String object22 : map.keySet()) {
                object = (String)this.viewer.ligandModels.get(object22 + "_data");
                if (object == null) continue;
                sB.append("  ").append(Escape.encapsulateData("ligand_" + object22, ((String)object).trim() + "\n", 0));
            }
        }
        SB sB2 = new SB();
        ModelSet modelSet = this.viewer.modelSet;
        object = modelSet.models;
        int n2 = modelSet.modelCount;
        for (int string = 0; string < n2; ++string) {
            if (modelSet.isJmolDataFrameForModel(string) || modelSet.isTrajectorySubFrame(string)) continue;
            Model n3 = object[string];
            n = sB2.indexOf(n3.loadState);
            if (n < 0 || n != sB2.lastIndexOf(n3.loadState)) {
                sB2.append(object[string].loadState);
            }
            if (((Model)object[string]).isModelKit) {
                BS bS = modelSet.getModelAtomBitSetIncludingDeleted(string, false);
                if (modelSet.tainted != null) {
                    if (modelSet.tainted[2] != null) {
                        modelSet.tainted[2].andNot(bS);
                    }
                    if (modelSet.tainted[3] != null) {
                        modelSet.tainted[3].andNot(bS);
                    }
                }
                n3.loadScript = new SB();
                Viewer.getInlineData(sB2, this.viewer.getModelExtract(bS, false, true, "MOL"), string > 0);
                continue;
            }
            sB2.appendSB(n3.loadScript);
        }
        String string = sB2.toString();
        int n3 = string.indexOf("load /*data*/");
        n = string.indexOf("load /*file*/");
        if (n >= 0 && n < n3) {
            n3 = n;
        }
        if ((n = string.indexOf("load \"@")) >= 0 && n < n3) {
            n3 = n;
        }
        if (n3 >= 0) {
            string = string.substring(0, n3) + "zap;" + string.substring(n3);
        }
        sB.append(string);
    }

    private String createSceneSet(String string, String string2, int n, int n2) {
        String string3 = this.viewer.getFileAsString(string);
        if (string3 == null) {
            return "no such file: " + string;
        }
        String string4 = string = TextFormat.simpleReplace(string, ".spt", "");
        String string5 = string2.toLowerCase();
        String[] stringArray = TextFormat.splitChars(string3, "pause scene ");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        JmolList<Integer> jmolList = new JmolList<Integer>();
        String string6 = JmolBinary.getSceneScript(stringArray, hashtable, jmolList);
        Logger.debug(string6);
        string3 = TextFormat.simpleReplace(string3, "pause scene", "delay " + this.viewer.animationManager.lastFrameDelay + " # scene");
        String[] stringArray2 = new String[]{string3, string6, null};
        this.viewer.saveState("_scene0");
        int n3 = 0;
        if (stringArray[0] != "") {
            this.viewer.zap(true, true, false);
        }
        int n4 = -1;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            try {
                int n5 = (Integer)jmolList.get(i);
                if (n5 > n4) {
                    this.viewer.showString("Creating Scene " + n5, false);
                }
                this.viewer.eval.runScript(stringArray[i]);
                if (n5 <= n4) continue;
                n4 = n5;
                stringArray2[2] = "all";
                String string7 = string4 + "_scene_" + n5 + ".all." + string5;
                String string8 = (String)this.createImagePathCheck(string7, "PNGJ", null, null, stringArray2, null, -1, n, n2, null, false);
                stringArray2[0] = null;
                stringArray2[2] = "min";
                string7 = string4 + "_scene_" + n5 + ".min." + string5;
                string8 = string8 + "\n" + (String)this.createImagePathCheck(string7, "PNGJ", null, null, stringArray2, null, -1, Math.min(n, 200), Math.min(n2, 200), null, false);
                this.viewer.showString(string8, false);
                n3 += 2;
                continue;
            }
            catch (Exception exception) {
                return "script error " + exception.toString();
            }
        }
        try {
            this.viewer.eval.runScript(this.viewer.getSavedState("_scene0"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "OK " + n3 + " files created";
    }

    @Override
    public String createImageSet(String string, String string2, String string3, byte[] byArray, String[] stringArray, int n, int n2, int n3, BS bS, int n4, String[] stringArray2) {
        if (bS == null && n4 == 0) {
            return (String)this.createImagePathCheck(string, string2, string3, byArray, stringArray, null, n, n2, n3, stringArray2, true);
        }
        String string4 = "";
        int n5 = 0;
        string = this.getOutputFileNameFromDialog(string, n);
        if (stringArray2 != null) {
            stringArray2[0] = string;
        }
        if (string == null) {
            return null;
        }
        int n6 = string.indexOf(".");
        if (n6 < 0) {
            n6 = string.length();
        }
        String string5 = string.substring(0, n6);
        String string6 = string.substring(n6);
        SB sB = new SB();
        if (bS == null) {
            this.viewer.transformManager.vibrationOn = true;
            sB = new SB();
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < 20; ++j) {
                    this.viewer.transformManager.setVibrationT((float)j / 20.0f + 0.2501f);
                    if (this.writeFrame(++n5, string5, string6, stringArray2, string2, n, n2, n3, sB)) continue;
                    return "ERROR WRITING FILE SET: \n" + string4;
                }
            }
            this.viewer.setVibrationOff();
        } else {
            int n7 = bS.nextSetBit(0);
            while (n7 >= 0) {
                this.viewer.setCurrentModelIndex(n7);
                if (!this.writeFrame(++n5, string5, string6, stringArray2, string2, n, n2, n3, sB)) {
                    return "ERROR WRITING FILE SET: \n" + string4;
                }
                n7 = bS.nextSetBit(n7 + 1);
            }
        }
        if (string4.length() == 0) {
            string4 = "OK\n";
        }
        return string4 + "\n" + n5 + " files created";
    }

    private boolean writeFrame(int n, String string, String string2, String[] stringArray, String string3, int n2, int n3, int n4, SB sB) {
        String string4 = "0000" + n;
        string4 = string + string4.substring(string4.length() - 4) + string2;
        if (stringArray != null) {
            stringArray[0] = string4;
        }
        String string5 = (String)this.createImagePathCheck(string4, string3, null, null, null, "", n2, n3, n4, null, false);
        this.viewer.scriptEcho(string5);
        sB.append(string5).append("\n");
        return string5.startsWith("OK");
    }

    @Override
    public Object createImagePathCheck(String string, String string2, String string3, byte[] byArray, String[] stringArray, Object object, int n, int n2, int n3, String[] stringArray2, boolean bl) {
        boolean bl2;
        Object object2 = null;
        String string4 = null;
        boolean bl3 = bl2 = string == null;
        if (!bl2) {
            if (bl) {
                string = this.getOutputFileNameFromDialog(string, n);
            }
            if (string == null) {
                return null;
            }
            if (!this.viewer.isJS && FileManager.isLocal(string)) {
                string4 = string;
            }
            if (stringArray2 != null) {
                stringArray2[0] = string;
            }
        }
        int n4 = this.viewer.dimScreen.width;
        int n5 = this.viewer.dimScreen.height;
        this.viewer.creatingImage = true;
        if (n != Integer.MIN_VALUE) {
            this.viewer.mustRender = true;
            this.viewer.resizeImage(n2, n3, true, false, false);
            this.viewer.setModelVisibility();
        }
        try {
            if (bl2) {
                object2 = this.viewer.clipImage(string3);
            } else {
                if (string2.equals("JMOL")) {
                    string2 = "ZIPALL";
                }
                if (string2.equals("ZIP") || string2.equals("ZIPALL")) {
                    if (stringArray != null && string2.equals("ZIP")) {
                        string2 = "ZIPALL";
                    }
                    object2 = JmolBinary.createZipSet(this.viewer.fileManager, this.viewer, string4, string3, stringArray, string2.equals("ZIPALL"));
                } else if (string2.equals("SCENE")) {
                    object2 = this.viewer.isJS ? "ERROR: Not Available" : this.createSceneSet(string, string3, n2, n3);
                } else {
                    JmolImageCreatorInterface jmolImageCreatorInterface;
                    if (!string2.equals("OutputStream")) {
                        object2 = this.viewer.statusManager.createImage(string, string2, string3, byArray, n);
                    }
                    if (object2 == null && (object2 = (jmolImageCreatorInterface = this.viewer.getImageCreator()).createImage(string4, string2, string3, byArray, stringArray, null, n)) instanceof String) {
                        this.viewer.statusManager.createImage((String)object2, string2, null, null, n);
                    }
                }
                if (object2 instanceof byte[]) {
                    object2 = "OK " + JmolBinary.postByteArray(this.viewer.fileManager, string, (byte[])object2);
                }
            }
        }
        catch (Throwable throwable) {
            object2 = "ERROR creating image??: " + throwable;
            Logger.error(this.viewer.setErrorMessage((String)object2, null));
        }
        this.viewer.creatingImage = false;
        if (n != Integer.MIN_VALUE) {
            this.viewer.resizeImage(n4, n5, true, false, true);
        }
        return object2;
    }

    @Override
    public void syncScript(String string, String string2, int n) {
        StatusManager statusManager = this.viewer.statusManager;
        if ("GET_GRAPHICS".equalsIgnoreCase(string)) {
            statusManager.setSyncDriver(5);
            statusManager.syncSend(string, string2, 0);
            this.viewer.setBooleanProperty("_syncMouse", false);
            this.viewer.setBooleanProperty("_syncScript", false);
            return;
        }
        if ("=".equals(string2)) {
            string2 = "~";
            statusManager.setSyncDriver(2);
        }
        boolean bl = "~".equals(string2);
        if (n > 0 || !bl && !".".equals(string2)) {
            statusManager.syncSend(string, string2, n);
            if (!"*".equals(string2) || string.startsWith("{")) {
                return;
            }
        }
        if (string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true")) {
            statusManager.setSyncDriver(1);
            return;
        }
        if (string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false")) {
            statusManager.setSyncDriver(0);
            return;
        }
        if (string.equalsIgnoreCase("slave")) {
            statusManager.setSyncDriver(2);
            return;
        }
        int n2 = statusManager.getSyncMode();
        if (n2 == 0) {
            return;
        }
        if (n2 != 1) {
            bl = false;
        }
        if (Logger.debugging) {
            Logger.debug(this.viewer.htmlName + " syncing with script: " + string);
        }
        if (bl) {
            statusManager.setSyncDriver(3);
        }
        if (string.indexOf("Mouse: ") != 0) {
            if (string.startsWith("Select: ")) {
                int n3;
                String string3;
                boolean bl2;
                String string4 = Parser.getQuotedAttribute(string, "file");
                String string5 = Parser.getQuotedAttribute(string, "model");
                String string6 = Parser.getQuotedAttribute(string, "baseModel");
                String string7 = Parser.getQuotedAttribute(string, "atoms");
                String string8 = Parser.getQuotedAttribute(string, "select");
                String string9 = Parser.getQuotedAttribute(string, "script");
                boolean bl3 = bl2 = string5 != null && string5.startsWith("$");
                if (bl2) {
                    String string10 = string4 = string5.substring(1).equals(this.viewer.getParameter("_smilesstring")) ? null : string5;
                }
                String string11 = bl2 || string5 == null ? null : (string3 = (string4 == null ? "" : string4 + "#") + string5);
                if ("".equals(string6)) {
                    string3 = string3 + ".baseModel";
                }
                int n4 = n3 = string3 == null ? -3 : this.viewer.getModelIndexFromId(string3);
                if (n3 == -2) {
                    return;
                }
                String string12 = string = n3 == -1 && string4 != null ? (string = "load " + Escape.eS(string4)) : "";
                if (string3 != null) {
                    string = string + ";model " + Escape.eS(string3);
                }
                if (string7 != null) {
                    string = string + ";select visible & (@" + TextFormat.simpleReplace(string7, ",", " or @") + ")";
                } else if (string8 != null) {
                    string = string + ";select visible & (" + string8 + ")";
                }
                if (string9 != null) {
                    string = string + ";" + string9;
                }
            } else if (string.toLowerCase().startsWith("jspecview")) {
                if (!bl) {
                    statusManager.syncSend(this.viewer.fullName + "JSpecView" + string.substring(9), ">", 0);
                }
                return;
            }
            this.viewer.evalStringQuietSync(string, true, false);
            return;
        }
        this.quickScript(string);
        if (bl) {
            this.viewer.setSyncDriver(4);
        }
    }

    @Override
    public void quickScript(String string) {
        String[] stringArray = Parser.getTokens(string);
        String string2 = stringArray[1];
        switch (stringArray.length) {
            case 3: {
                if (string2.equals("zoomByFactor")) {
                    this.viewer.zoomByFactor(Parser.parseFloatStr(stringArray[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                    break;
                }
                if (string2.equals("zoomBy")) {
                    this.viewer.zoomBy(Parser.parseInt(stringArray[2]));
                    break;
                }
                if (!string2.equals("rotateZBy")) break;
                this.viewer.rotateZBy(Parser.parseInt(stringArray[2]), Integer.MAX_VALUE, Integer.MAX_VALUE);
                break;
            }
            case 4: {
                if (string2.equals("rotateXYBy")) {
                    this.viewer.rotateXYBy(Parser.parseFloatStr(stringArray[2]), Parser.parseFloatStr(stringArray[3]));
                    break;
                }
                if (string2.equals("translateXYBy")) {
                    this.viewer.translateXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]));
                    break;
                }
                if (!string2.equals("rotateMolecule")) break;
                this.viewer.rotateSelected(Parser.parseFloatStr(stringArray[2]), Parser.parseFloatStr(stringArray[3]), null);
                break;
            }
            case 5: {
                if (string2.equals("spinXYBy")) {
                    this.viewer.spinXYBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseFloatStr(stringArray[4]));
                    break;
                }
                if (string2.equals("zoomByFactor")) {
                    this.viewer.zoomByFactor(Parser.parseFloatStr(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseInt(stringArray[4]));
                    break;
                }
                if (string2.equals("rotateZBy")) {
                    this.viewer.rotateZBy(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseInt(stringArray[4]));
                    break;
                }
                if (!string2.equals("rotateArcBall")) break;
                this.viewer.rotateArcBall(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), Parser.parseFloatStr(stringArray[4]));
                break;
            }
            case 7: {
                if (!string2.equals("centerAt")) break;
                this.viewer.centerAt(Parser.parseInt(stringArray[2]), Parser.parseInt(stringArray[3]), P3.new3(Parser.parseFloatStr(stringArray[4]), Parser.parseFloatStr(stringArray[5]), Parser.parseFloatStr(stringArray[6])));
            }
        }
    }

    @Override
    public String generateOutputForExport(String string, String[] stringArray, int n, int n2) {
        String string2 = null;
        if (stringArray != null) {
            stringArray[0] = this.getOutputFileNameFromDialog(stringArray[0], Integer.MIN_VALUE);
            if (stringArray[0] == null) {
                return null;
            }
            string2 = stringArray[0];
        }
        this.viewer.mustRender = true;
        int n3 = this.viewer.dimScreen.width;
        int n4 = this.viewer.dimScreen.height;
        this.viewer.resizeImage(n, n2, true, true, false);
        this.viewer.setModelVisibility();
        String string3 = this.viewer.repaintManager.renderExport(string, this.viewer.gdata, this.viewer.modelSet, string2);
        this.viewer.resizeImage(n3, n4, true, true, true);
        return string3;
    }

    private String getOutputFileNameFromDialog(String string, int n) {
        boolean bl;
        if (string == null || this.viewer.isKiosk) {
            return null;
        }
        boolean bl2 = bl = string.indexOf("?") == 0;
        if (bl) {
            string = string.substring(1);
        }
        boolean bl3 = this.viewer.isApplet && string.indexOf("http:") < 0;
        string = FileManager.getLocalPathForWritingFile(this.viewer, string);
        if (bl |= bl3) {
            string = this.viewer.dialogAsk(n == Integer.MIN_VALUE ? "save" : "saveImage", string);
        }
        return string;
    }

    @Override
    public Object getImageAsWithComment(String string, int n, int n2, int n3, String string2, String[] stringArray, OutputStream outputStream, String string3) {
        int n4 = this.viewer.dimScreen.width;
        int n5 = this.viewer.dimScreen.height;
        this.viewer.mustRender = true;
        this.viewer.resizeImage(n2, n3, true, false, false);
        this.viewer.setModelVisibility();
        this.viewer.creatingImage = true;
        JmolImageCreatorInterface jmolImageCreatorInterface = null;
        Object object = null;
        string = string.toLowerCase();
        if (!Parser.isOneOf(string, "jpg;jpeg;jpg64;jpeg64")) {
            try {
                jmolImageCreatorInterface = this.viewer.getImageCreator();
            }
            catch (Error error) {
                // empty catch block
            }
        }
        if (jmolImageCreatorInterface == null) {
            try {
                object = this.viewer.apiPlatform.getJpgImage(this.viewer, n, string3);
                if (string.equals("jpg64") || string.equals("jpeg64")) {
                    object = object == null ? "" : Base64.getBase64((byte[])object).toString();
                }
            }
            catch (Error error) {
                this.viewer.releaseScreenImage();
                this.viewer.handleError(error, false);
                this.viewer.setErrorMessage("Error creating image: " + error, null);
                object = this.viewer.getErrorMessage();
            }
        } else {
            try {
                object = jmolImageCreatorInterface.getImageBytes(string, n, string2, stringArray, null, null, outputStream);
            }
            catch (IOException iOException) {
                object = iOException;
                this.viewer.setErrorMessage("Error creating image: " + iOException, null);
            }
            catch (Error error) {
                this.viewer.handleError(error, false);
                this.viewer.setErrorMessage("Error creating image: " + error, null);
                object = this.viewer.getErrorMessage();
            }
        }
        this.viewer.creatingImage = false;
        this.viewer.resizeImage(n4, n5, true, false, true);
        return object;
    }

    @Override
    public String streamFileData(String string, String string2, String string3, int n, Object[] objectArray) {
        String string4 = null;
        String[] stringArray = new String[1];
        OutputStream outputStream = this.getOutputStream(string, stringArray);
        if (outputStream == null) {
            return "";
        }
        if (string2.equals("PDB") || string2.equals("PQR")) {
            OutputStringBuilder outputStringBuilder = new OutputStringBuilder(new BufferedOutputStream(outputStream));
            outputStringBuilder.type = string2;
            string4 = this.viewer.getPdbData(null, outputStringBuilder);
        } else if (string2.equals("FILE")) {
            string4 = this.writeCurrentFile(outputStream);
        } else if (string2.equals("PLOT")) {
            OutputStringBuilder outputStringBuilder = new OutputStringBuilder(new BufferedOutputStream(outputStream));
            string4 = this.viewer.modelSet.getPdbData(n, string3, this.viewer.getSelectionSet(false), objectArray, outputStringBuilder);
        }
        if (string4 != null) {
            string4 = "OK " + string4 + " " + stringArray[0];
        }
        try {
            outputStream.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string4;
    }

    private String writeCurrentFile(OutputStream outputStream) {
        String string = this.viewer.getFullPathName();
        if (string.equals("string") || string.indexOf("[]") >= 0 || string.equals("JSNode")) {
            String string2 = this.viewer.getCurrentFileAsString();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            OutputStringBuilder outputStringBuilder = new OutputStringBuilder(bufferedOutputStream);
            outputStringBuilder.append(string2);
            return outputStringBuilder.toString();
        }
        String string3 = this.viewer.getModelSetPathName();
        return string3 == null ? "" : (String)this.viewer.getFileAsBytes(string3, outputStream);
    }

    @Override
    public OutputStream getOutputStream(String string, String[] stringArray) {
        if (!this.viewer.isRestricted(Viewer.ACCESS.ALL)) {
            return null;
        }
        Object object = this.createImagePathCheck(string, "OutputStream", null, null, null, null, Integer.MIN_VALUE, 0, 0, stringArray, true);
        if (object instanceof String) {
            Logger.error((String)object);
            return null;
        }
        return (OutputStream)object;
    }

    @Override
    public void openFileAsync(String string, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !(string = string.trim()).startsWith("\t");
        if (!bl2) {
            string = string.substring(1);
        }
        string = string.replace('\\', '/');
        if (this.viewer.isApplet && string.indexOf("://") < 0) {
            string = "file://" + (string.startsWith("/") ? "" : "/") + string;
        }
        if (string.endsWith(".pse")) {
            this.viewer.evalString("zap;load SYNC " + Escape.eS(string) + " filter 'DORESIZE'");
            return;
        }
        String string2 = null;
        if (string.endsWith("jvxl")) {
            string2 = "isosurface ";
        } else if (!string.endsWith(".spt")) {
            String string3 = this.viewer.fileManager.getFileTypeName(string);
            if (string3 == null) {
                string3 = JmolBinary.determineSurfaceTypeIs(this.viewer.getBufferedInputStream(string));
                if (string3 != null) {
                    this.viewer.evalString("if (_filetype == 'Pdb') { isosurface sigma 1.0 within 2.0 {*} " + Escape.eS(string) + " mesh nofill }; else; { isosurface " + Escape.eS(string) + "}");
                    return;
                }
            } else if (string3.equals("Jmol")) {
                string2 = "load ";
            } else if (string3.equals("Cube")) {
                string2 = "isosurface sign red blue ";
            } else if (!string3.equals("spt")) {
                string2 = this.viewer.global.defaultDropScript;
                string2 = TextFormat.simpleReplace(string2, "%FILE", string);
                string2 = TextFormat.simpleReplace(string2, "%ALLOWCARTOONS", "" + bl);
                this.viewer.evalString(string2);
                return;
            }
        }
        if (bl2 && this.viewer.scriptEditorVisible && string2 == null) {
            this.showEditor(new String[]{string, this.viewer.getFileAsString(string)});
        } else {
            this.viewer.evalString((string2 == null ? "script " : string2) + Escape.eS(string));
        }
    }

    @Override
    public void showEditor(String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{null, null};
        }
        if (stringArray[1] == null) {
            stringArray[1] = "<no data>";
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        JmolScriptEditorInterface jmolScriptEditorInterface = (JmolScriptEditorInterface)this.viewer.getProperty("DATA_API", "getScriptEditor", Boolean.TRUE);
        if (jmolScriptEditorInterface == null) {
            return;
        }
        if (string2 != null) {
            jmolScriptEditorInterface.setFilename(string);
            jmolScriptEditorInterface.output(JmolBinary.getEmbeddedScript(string2));
        }
        jmolScriptEditorInterface.setVisible(true);
    }

    @Override
    public void logToFile(String string) {
        try {
            boolean bl = string.equals("$CLEAR$");
            if (string.indexOf("$NOW$") >= 0) {
                string = TextFormat.simpleReplace(string, "$NOW$", new Date().toString());
            }
            if (this.viewer.logFile == null) {
                System.out.println(string);
                return;
            }
            FileWriter fileWriter = new FileWriter(this.viewer.logFile, !bl);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            if (!bl) {
                int n = string.indexOf(0);
                if (n >= 0) {
                    string = string.substring(0, n);
                }
                bufferedWriter.write(string);
                if (n < 0) {
                    bufferedWriter.write(10);
                }
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            Logger.debug("cannot log " + string);
        }
    }

    @Override
    public String getAtomDefs(Map<String, Object> map) {
        SB sB = new SB();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof BS)) continue;
            sB.append("{" + entry.getKey() + "} <" + ((BS)entry.getValue()).cardinality() + " atoms>\n");
        }
        return sB.append("\n").toString();
    }
}

