/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import org.jmol.modelset.ModelLoader;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BS;
import org.jmol.util.SB;
import org.jmol.viewer.Viewer;

class ModelManager {
    private final Viewer viewer;
    private ModelSet modelSet;
    private String modelSetPathName;
    private String fileName;

    ModelManager(Viewer viewer) {
        this.viewer = viewer;
    }

    ModelSet zap() {
        this.fileName = null;
        this.modelSetPathName = null;
        this.modelSet = new ModelLoader(this.viewer, this.viewer.getZapName(), null, null, null, null).getModelSet();
        return this.modelSet;
    }

    String getModelSetFileName() {
        return this.fileName != null ? this.fileName : this.viewer.getZapName();
    }

    String getModelSetPathName() {
        return this.modelSetPathName;
    }

    ModelSet createModelSet(String string, String string2, SB sB, Object object, BS bS, boolean bl) {
        String string3 = null;
        if (bl) {
            string3 = this.modelSet.modelSetName;
            if (string3.equals("zapped")) {
                string3 = null;
            } else if (string3.indexOf(" (modified)") < 0) {
                string3 = string3 + " (modified)";
            }
        } else {
            if (object == null) {
                return this.zap();
            }
            this.modelSetPathName = string;
            this.fileName = string2;
        }
        if (object != null) {
            if (string3 == null) {
                string3 = this.viewer.getModelAdapter().getAtomSetCollectionName(object);
                if (string3 != null && (string3 = string3.trim()).length() == 0) {
                    string3 = null;
                }
                if (string3 == null) {
                    string3 = ModelManager.reduceFilename(string2);
                }
            }
            this.modelSet = new ModelLoader(this.viewer, string3, sB, object, bl ? this.modelSet : null, bS).getModelSet();
        }
        if (this.modelSet.getAtomCount() == 0 && !this.modelSet.getModelSetAuxiliaryInfoBoolean("isPyMOL")) {
            this.zap();
        }
        return this.modelSet;
    }

    private static String reduceFilename(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        if (string.length() > 24) {
            string = string.substring(0, 20) + " ...";
        }
        return string;
    }

    void createAtomDataSet(Object object, int n) {
        ModelLoader.createAtomDataSet(this.viewer, this.modelSet, n, object, this.viewer.getSelectionSet(false));
    }
}

