/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.thread;

import org.jmol.api.JmolScriptEvaluator;
import org.jmol.thread.JmolThread;
import org.jmol.viewer.Viewer;

public class ScriptDelayThread
extends JmolThread {
    public static final int PAUSE_DELAY = -100;
    private int millis;
    private int seconds;
    private boolean doPopPush;
    private boolean isPauseDelay;

    public ScriptDelayThread(JmolScriptEvaluator jmolScriptEvaluator, Viewer viewer, int n) {
        this.setViewer(viewer, "ScriptDelayThread");
        this.millis = n;
        this.setEval(jmolScriptEvaluator);
    }

    protected void run1(int n) throws InterruptedException {
        while (true) {
            switch (n) {
                case -1: {
                    this.doPopPush = this.millis > 0;
                    boolean bl = this.isPauseDelay = this.millis == -100;
                    if (!this.doPopPush) {
                        this.millis = -this.millis;
                    } else {
                        int n2 = this.viewer.getDelayMaximumMs();
                        if (n2 > 0 && this.millis > n2) {
                            this.millis = n2;
                        }
                    }
                    this.millis = (int)((long)this.millis - (System.currentTimeMillis() - this.startTime));
                    if (this.isJS) {
                        this.seconds = 0;
                    } else {
                        this.seconds = this.millis / 1000;
                        this.millis -= this.seconds * 1000;
                        if (this.millis <= 0) {
                            this.millis = 1;
                        }
                    }
                    if (this.doPopPush) {
                        this.viewer.popHoldRepaintWhy("delay INIT");
                    }
                    n = 0;
                    break;
                }
                case 0: {
                    if (this.stopped || this.eval.isStopped()) {
                        n = -2;
                        break;
                    }
                    if (!this.runSleep(this.seconds-- > 0 ? 1000 : this.millis, -2)) {
                        return;
                    }
                    if (this.seconds < 0) {
                        this.millis = 0;
                    }
                    n = this.seconds > 0 || this.millis > 0 ? 0 : -2;
                    break;
                }
                case -2: {
                    if (this.doPopPush) {
                        this.viewer.pushHoldRepaintWhy("delay FINISH");
                    }
                    if (this.isPauseDelay) {
                        this.eval.notifyResumeStatus();
                    }
                    this.resumeEval();
                    return;
                }
            }
        }
    }
}

