/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import org.jmol.modelset.Atom;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolNode;
import org.jmol.viewer.JC;

public class Bond
extends JmolEdge {
    public Atom atom1;
    public Atom atom2;
    public short mad;
    public short colix;
    public int shapeVisibilityFlags;
    public static final int myVisibilityFlag = JC.getShapeVisibilityFlag(1);

    public Bond(Atom atom, Atom atom2, int n, short s, short s2) {
        this.atom1 = atom;
        this.atom2 = atom2;
        this.colix = s2;
        this.setOrder(n);
        this.setMad(s);
    }

    public void setMad(short s) {
        this.mad = s;
        this.setShapeVisibility(s != 0);
    }

    public void setShapeVisibilityFlags(int n) {
        this.shapeVisibilityFlags = n;
    }

    public int getShapeVisibilityFlags() {
        return this.shapeVisibilityFlags;
    }

    void setShapeVisibility(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (this.shapeVisibilityFlags & myVisibilityFlag) != 0;
        if (bl2 == bl) {
            return;
        }
        this.atom1.addDisplayedBond(myVisibilityFlag, bl);
        this.atom2.addDisplayedBond(myVisibilityFlag, bl);
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= myVisibilityFlag) : (this.shapeVisibilityFlags &= ~myVisibilityFlag);
    }

    public String getIdentity() {
        return this.index + 1 + " " + this.getOrderNumberAsString() + " " + this.atom1.getInfo() + " -- " + this.atom2.getInfo() + " " + this.atom1.distance(this.atom2);
    }

    public boolean isCovalent() {
        return (this.order & 0x3FF) != 0;
    }

    public boolean isHydrogen() {
        return Bond.isOrderH(this.order);
    }

    public static boolean isOrderH(int n) {
        return (n & 0x7800) != 0;
    }

    boolean isStereo() {
        return (this.order & 0x400) != 0;
    }

    boolean isPartial() {
        return (this.order & 0xE0) != 0;
    }

    boolean isAromatic() {
        return (this.order & 0x200) != 0;
    }

    public void setPaletteID(byte by) {
    }

    public float getEnergy() {
        return 0.0f;
    }

    public int getValence() {
        return !this.isCovalent() ? 0 : (this.isPartial() || this.is(515) ? 1 : this.order & 7);
    }

    void deleteAtomReferences() {
        if (this.atom1 != null) {
            this.atom1.deleteBond(this);
        }
        if (this.atom2 != null) {
            this.atom2.deleteBond(this);
        }
        this.atom2 = null;
        this.atom1 = null;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setTranslucent(boolean bl, float f) {
        this.colix = C.getColixTranslucent3(this.colix, bl, f);
    }

    public boolean isTranslucent() {
        return C.isColixTranslucent(this.colix);
    }

    public void setOrder(int n) {
        if (this.atom1.getElementNumber() == 16 && this.atom2.getElementNumber() == 16) {
            n |= 0x100;
        }
        if (n == 512) {
            n = 515;
        }
        this.order = n | this.order & 0x20000;
    }

    public Atom getAtom1() {
        return this.atom1;
    }

    public Atom getAtom2() {
        return this.atom2;
    }

    public int getAtomIndex1() {
        return this.atom1.index;
    }

    public int getAtomIndex2() {
        return this.atom2.index;
    }

    float getRadius() {
        return (float)this.mad / 2000.0f;
    }

    public int getCovalentOrder() {
        return JmolEdge.getCovalentBondOrder(this.order);
    }

    String getOrderName() {
        return JmolEdge.getBondOrderNameFromOrder(this.order);
    }

    String getOrderNumberAsString() {
        return JmolEdge.getBondOrderNumberFromOrder(this.order);
    }

    short getColix1() {
        return C.getColixInherited(this.colix, this.atom1.colixAtom);
    }

    short getColix2() {
        return C.getColixInherited(this.colix, this.atom2.colixAtom);
    }

    public Atom getOtherAtom(Atom atom) {
        return this.atom1 == atom ? this.atom2 : (this.atom2 == atom ? this.atom1 : null);
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean is(int n) {
        return (this.order & 0xFFFDFFFF) == n;
    }

    public JmolNode getOtherAtomNode(JmolNode jmolNode) {
        return this.atom1 == jmolNode ? this.atom2 : (this.atom2 == jmolNode ? this.atom1 : null);
    }

    public String toString() {
        return this.atom1 + " - " + this.atom2;
    }

    public static class BondSet
    extends BS {
        private int[] associatedAtoms;

        public BondSet() {
        }

        public int[] getAssociatedAtoms() {
            return this.associatedAtoms;
        }

        public BondSet(BS bS) {
            BSUtil.copy2(bS, this);
        }

        public BondSet(BS bS, int[] nArray) {
            this(bS);
            this.associatedAtoms = nArray;
        }
    }
}

