/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Arrays;
import java.util.Comparator;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.bspt.Bspf;
import org.jmol.constant.EnumPalette;
import org.jmol.constant.EnumStructure;
import org.jmol.constant.EnumVdw;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelCollection;
import org.jmol.script.T;
import org.jmol.util.ArrayUtil;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Quadric;
import org.jmol.util.Quaternion;
import org.jmol.util.Rectangle;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AtomCollection {
    private static final Float MINUSZERO = Float.valueOf(-0.0f);
    public Viewer viewer;
    protected GData g3d;
    public Atom[] atoms;
    public int atomCount;
    String[] atomNames;
    String[] atomTypes;
    int[] atomSerials;
    public V3[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    float[] ionicRadii;
    float[] hydrophobicities;
    protected Quadric[][] ellipsoids;
    protected int[] surfaceDistance100s;
    protected boolean haveStraightness;
    private BS bsHidden = new BS();
    protected float maxBondingRadius = Float.MIN_VALUE;
    private float maxVanderwaalsRadius = Float.MIN_VALUE;
    private boolean hasBfactorRange;
    private int bfactor100Lo;
    private int bfactor100Hi;
    private int surfaceDistanceMax;
    private BS bsSurface;
    private int nSurfaceAtoms;
    protected Bspf bspf = null;
    protected boolean preserveState = true;
    public static final byte TAINT_ATOMNAME = 0;
    public static final byte TAINT_ATOMTYPE = 1;
    public static final byte TAINT_COORD = 2;
    public static final byte TAINT_ELEMENT = 3;
    public static final byte TAINT_FORMALCHARGE = 4;
    public static final byte TAINT_HYDROPHOBICITY = 5;
    public static final byte TAINT_IONICRADIUS = 6;
    public static final byte TAINT_OCCUPANCY = 7;
    public static final byte TAINT_PARTIALCHARGE = 8;
    public static final byte TAINT_TEMPERATURE = 9;
    public static final byte TAINT_VALENCE = 10;
    public static final byte TAINT_VANDERWAALS = 11;
    public static final byte TAINT_VIBRATION = 12;
    public static final byte TAINT_ATOMNO = 13;
    public static final byte TAINT_MAX = 14;
    public static final String[] userSettableValues = new String[]{"atomName", "atomType", "coord", "element", "formalCharge", "hydrophobicity", "ionic", "occupany", "partialCharge", "temperature", "valence", "vanderWaals", "vibrationVector", "atomNo"};
    public BS[] tainted;
    public boolean canSkipLoad = true;
    private final BS bsEmpty = new BS();
    private final BS bsFoundRectangle = new BS();
    private int[] aaRet;
    private static final float sqrt3_2;
    private static final V3 vRef;
    private static final float almost180 = 2.984513f;

    protected void releaseModelSet() {
        this.atoms = null;
        this.viewer = null;
        this.g3d = null;
        this.bspf = null;
        this.surfaceDistance100s = null;
        this.bsSurface = null;
        this.tainted = null;
        this.atomNames = null;
        this.atomTypes = null;
        this.atomSerials = null;
        this.vibrationVectors = null;
        this.occupancies = null;
        this.bfactor100s = null;
        this.partialCharges = null;
        this.ionicRadii = null;
        this.ellipsoids = null;
    }

    protected void mergeAtomArrays(AtomCollection atomCollection) {
        this.tainted = atomCollection.tainted;
        this.atomNames = atomCollection.atomNames;
        this.atomTypes = atomCollection.atomTypes;
        this.atomSerials = atomCollection.atomSerials;
        this.vibrationVectors = atomCollection.vibrationVectors;
        this.occupancies = atomCollection.occupancies;
        this.bfactor100s = atomCollection.bfactor100s;
        this.ionicRadii = atomCollection.ionicRadii;
        this.partialCharges = atomCollection.partialCharges;
        this.ellipsoids = atomCollection.ellipsoids;
        this.setHaveStraightness(false);
        this.surfaceDistance100s = null;
    }

    public void setHaveStraightness(boolean bl) {
        this.haveStraightness = bl;
    }

    protected boolean getHaveStraightness() {
        return this.haveStraightness;
    }

    public JmolList<P3> getAtomPointVector(BS bS) {
        JmolList<P3> jmolList = new JmolList<P3>();
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                jmolList.addLast(this.atoms[n]);
                n = bS.nextSetBit(n + 1);
            }
        }
        return jmolList;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public boolean modelSetHasVibrationVectors() {
        return this.vibrationVectors != null;
    }

    public String[] getAtomTypes() {
        return this.atomTypes;
    }

    public float[] getPartialCharges() {
        return this.partialCharges;
    }

    public float[] getIonicRadii() {
        return this.ionicRadii;
    }

    public short[] getBFactors() {
        return this.bfactor100s;
    }

    public float[] getHydrophobicity() {
        return this.hydrophobicities;
    }

    public void setBsHidden(BS bS) {
        this.bsHidden = bS;
    }

    public boolean isAtomHidden(int n) {
        return this.bsHidden.get(n);
    }

    public String getAtomInfo(int n, String string) {
        return string == null ? this.atoms[n].getInfo() : LabelToken.formatLabel(this.viewer, this.atoms[n], string);
    }

    public String getAtomInfoXYZ(int n, boolean bl) {
        return this.atoms[n].getInfoXYZ(bl);
    }

    public String getElementSymbol(int n) {
        return this.atoms[n].getElementSymbol();
    }

    public int getElementNumber(int n) {
        return this.atoms[n].getElementNumber();
    }

    public String getElementName(int n) {
        return Elements.elementNameFromNumber(this.atoms[n].getAtomicAndIsotopeNumber());
    }

    public String getAtomName(int n) {
        return this.atoms[n].getAtomName();
    }

    public int getAtomNumber(int n) {
        return this.atoms[n].getAtomNumber();
    }

    public P3 getAtomPoint3f(int n) {
        return this.atoms[n];
    }

    public float getAtomRadius(int n) {
        return this.atoms[n].getRadius();
    }

    public float getAtomVdwRadius(int n, EnumVdw enumVdw) {
        return this.atoms[n].getVanderwaalsRadiusFloat(this.viewer, enumVdw);
    }

    public short getAtomColix(int n) {
        return this.atoms[n].getColix();
    }

    public String getAtomChain(int n) {
        return "" + this.atoms[n].getChainID();
    }

    public Quadric[] getEllipsoid(int n) {
        return n < 0 || this.ellipsoids == null || n >= this.ellipsoids.length ? null : this.ellipsoids[n];
    }

    public Quaternion getQuaternion(int n, char c) {
        return n < 0 ? null : this.atoms[n].group.getQuaternion(c);
    }

    public Object getHelixData(BS bS, int n) {
        int n2 = bS.nextSetBit(0);
        return n2 < 0 ? "null" : this.atoms[n2].group.getHelixData(n, this.viewer.getQuaternionFrame(), this.viewer.getInt(0x21000012));
    }

    public int getAtomIndexFromAtomNumber(int n, BS bS) {
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = this.atoms[i];
            if (atom.getAtomNumber() != n || !bS.get(atom.modelIndex)) continue;
            return i;
        }
        return -1;
    }

    public void setFormalCharges(BS bS, int n) {
        if (bS != null) {
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                this.atoms[n2].setFormalCharge(n);
                this.taintAtom(n2, (byte)4);
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
    }

    public float[] getAtomicCharges() {
        float[] fArray = new float[this.atomCount];
        int n = this.atomCount;
        while (--n >= 0) {
            fArray[n] = this.atoms[n].getElementNumber();
        }
        return fArray;
    }

    protected float getRadiusVdwJmol(Atom atom) {
        return (float)Elements.getVanderwaalsMar(atom.getElementNumber(), EnumVdw.JMOL) / 1000.0f;
    }

    public float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    protected void findMaxRadii() {
        int n = this.atomCount;
        while (--n >= 0) {
            float f;
            Atom atom = this.atoms[n];
            float f2 = atom.getBondingRadiusFloat();
            if (f2 > this.maxBondingRadius) {
                this.maxBondingRadius = f2;
            }
            if (!((f = atom.getVanderwaalsRadiusFloat(this.viewer, EnumVdw.AUTO)) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = f;
        }
    }

    public void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    private void calcBfactorRange(BS bS) {
        if (this.hasBfactorRange) {
            return;
        }
        this.bfactor100Lo = Integer.MAX_VALUE;
        this.bfactor100Hi = Integer.MIN_VALUE;
        if (bS == null) {
            for (int i = 0; i < this.atomCount; ++i) {
                this.setBf(i);
            }
        } else {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.setBf(n);
                n = bS.nextSetBit(n + 1);
            }
        }
        this.hasBfactorRange = true;
    }

    private void setBf(int n) {
        int n2 = this.atoms[n].getBfactor100();
        if (n2 < this.bfactor100Lo) {
            this.bfactor100Lo = n2;
        } else if (n2 > this.bfactor100Hi) {
            this.bfactor100Hi = n2;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.viewer.global.rangeSelected) {
                this.calcBfactorRange(this.viewer.getSelectionSet(false));
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    public int getSurfaceDistanceMax() {
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    public float calculateVolume(BS bS, EnumVdw enumVdw) {
        float f = 0.0f;
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                f += this.atoms[n].getVolume(this.viewer, enumVdw);
                n = bS.nextSetBit(n + 1);
            }
        }
        return f;
    }

    int getSurfaceDistance100(int n) {
        if (this.nSurfaceAtoms == 0) {
            return -1;
        }
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistance100s[n];
    }

    private void calcSurfaceDistances() {
        this.calculateSurface(null, -1.0f);
    }

    public P3[] calculateSurface(BS bS, float f) {
        if (f < 0.0f) {
            f = 3.0f;
        }
        EnvelopeCalculation envelopeCalculation = new EnvelopeCalculation(this.viewer, this.atomCount, null);
        envelopeCalculation.calculate(new RadiusData(null, f, RadiusData.EnumType.ABSOLUTE, null), Float.MAX_VALUE, bS, BSUtil.copyInvert(bS, this.atomCount), false, false, false, true);
        P3[] p3Array = envelopeCalculation.getPoints();
        this.surfaceDistanceMax = 0;
        this.bsSurface = envelopeCalculation.getBsSurfaceClone();
        this.surfaceDistance100s = new int[this.atomCount];
        this.nSurfaceAtoms = BSUtil.cardinalityOf(this.bsSurface);
        if (this.nSurfaceAtoms == 0 || p3Array == null || p3Array.length == 0) {
            return p3Array;
        }
        float f2 = f == Float.MAX_VALUE ? 0.0f : f;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.bsSurface.get(i)) {
                this.surfaceDistance100s[i] = 0;
                continue;
            }
            float f3 = Float.MAX_VALUE;
            Atom atom = this.atoms[i];
            int n = p3Array.length;
            while (--n >= 0) {
                float f4 = Math.abs(p3Array[n].distance(atom) - f2);
                if (f4 < 0.0f && Logger.debugging) {
                    Logger.debug("draw d" + n + " " + Escape.eP(p3Array[n]) + " \"" + f4 + " ? " + atom.getInfo() + "\"");
                }
                f3 = Math.min(f4, f3);
            }
            n = this.surfaceDistance100s[i] = (int)Math.floor(f3 * 100.0f);
            this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, n);
        }
        return p3Array;
    }

    protected void setAtomCoord2(BS bS, int n, Object object) {
        P3 p3 = null;
        P3[] p3Array = null;
        JmolList jmolList = null;
        int n2 = 0;
        int n3 = 1;
        if (object instanceof P3) {
            p3 = (P3)object;
        } else if (object instanceof JmolList) {
            jmolList = (JmolList)object;
            n3 = jmolList.size();
            if (n3 == 0) {
                return;
            }
            n2 = 1;
        } else if (Escape.isAP(object)) {
            p3Array = (P3[])object;
            n3 = p3Array.length;
            if (n3 == 0) {
                return;
            }
            n2 = 2;
        } else {
            return;
        }
        int n4 = 0;
        if (bS != null) {
            int n5 = bS.nextSetBit(0);
            while (n5 >= 0) {
                switch (n2) {
                    case 1: {
                        if (n4 >= n3) {
                            return;
                        }
                        p3 = (P3)jmolList.get(n4++);
                        break;
                    }
                    case 2: {
                        if (n4 >= n3) {
                            return;
                        }
                        p3 = p3Array[n4++];
                    }
                }
                switch (n) {
                    case 1146095626: {
                        this.setAtomCoord(n5, p3.x, p3.y, p3.z);
                        break;
                    }
                    case 1146095627: {
                        this.atoms[n5].setFractionalCoordTo(p3, true);
                        this.taintAtom(n5, (byte)2);
                        break;
                    }
                    case 1146095629: {
                        this.atoms[n5].setFractionalCoordTo(p3, false);
                        this.taintAtom(n5, (byte)2);
                        break;
                    }
                    case 1146095631: {
                        this.setAtomVibrationVector(n5, p3.x, p3.y, p3.z);
                    }
                }
                n5 = bS.nextSetBit(n5 + 1);
            }
        }
    }

    private void setAtomVibrationVector(int n, float f, float f2, float f3) {
        this.setVibrationVector(n, f, f2, f3);
        this.taintAtom(n, (byte)12);
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.atoms[n].x = f;
        this.atoms[n].y = f2;
        this.atoms[n].z = f3;
        this.taintAtom(n, (byte)2);
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.atoms[n].x += f;
        this.atoms[n].y += f2;
        this.atoms[n].z += f3;
        this.taintAtom(n, (byte)2);
    }

    protected void setAtomsCoordRelative(BS bS, float f, float f2, float f3) {
        if (bS != null) {
            int n = bS.nextSetBit(0);
            while (n >= 0) {
                this.setAtomCoordRelative(n, f, f2, f3);
                n = bS.nextSetBit(n + 1);
            }
        }
    }

    protected void setAPa(BS bS, int n, int n2, float f, String string, float[] fArray, String[] stringArray) {
        int n3 = 0;
        if (fArray != null && fArray.length == 0 || bS == null) {
            return;
        }
        boolean bl = fArray != null && fArray.length == this.atomCount || stringArray != null && stringArray.length == this.atomCount;
        int n4 = bS.nextSetBit(0);
        while (n4 >= 0) {
            if (bl) {
                n3 = n4;
            }
            if (fArray != null) {
                if (n3 >= fArray.length) {
                    return;
                }
                f = fArray[n3++];
                n2 = (int)f;
            } else if (stringArray != null) {
                if (n3 >= stringArray.length) {
                    return;
                }
                string = stringArray[n3++];
            }
            Atom atom = this.atoms[n4];
            switch (n) {
                case 1087375362: {
                    this.taintAtom(n4, (byte)0);
                    this.setAtomName(n4, string);
                    break;
                }
                case 1095763969: {
                    this.taintAtom(n4, (byte)13);
                    this.setAtomNumber(n4, n2);
                    break;
                }
                case 1087375361: {
                    this.taintAtom(n4, (byte)1);
                    this.setAtomType(n4, string);
                    break;
                }
                case 1112541185: 
                case 1112541205: {
                    this.setAtomCoord(n4, f, atom.y, atom.z);
                    break;
                }
                case 1112541186: 
                case 1112541206: {
                    this.setAtomCoord(n4, atom.x, f, atom.z);
                    break;
                }
                case 1112541187: 
                case 1112541207: {
                    this.setAtomCoord(n4, atom.x, atom.y, f);
                    break;
                }
                case 1112541202: 
                case 1112541203: 
                case 1112541204: {
                    this.setVibrationVector2(n4, n, f);
                    break;
                }
                case 1112541188: 
                case 1112541189: 
                case 1112541190: {
                    atom.setFractionalCoord(n, f, true);
                    this.taintAtom(n4, (byte)2);
                    break;
                }
                case 1112541191: 
                case 1112541192: 
                case 1112541193: {
                    atom.setFractionalCoord(n, f, false);
                    this.taintAtom(n4, (byte)2);
                    break;
                }
                case 1087375365: 
                case 1095763976: {
                    this.setElement(atom, n2);
                    break;
                }
                case 1632634889: {
                    atom.setFormalCharge(n2);
                    this.taintAtom(n4, (byte)4);
                    break;
                }
                case 1114638346: {
                    if (!this.setHydrophobicity(n4, f)) break;
                    this.taintAtom(n4, (byte)5);
                    break;
                }
                case 1288701960: 
                case 1826248715: {
                    this.viewer.setAtomLabel(string, n4);
                    break;
                }
                case 1129318401: {
                    if (n2 < 2) {
                        n2 = (int)Math.floor(100.0f * f);
                    }
                    if (!this.setOccupancy(n4, n2)) break;
                    this.taintAtom(n4, (byte)7);
                    break;
                }
                case 1112541196: {
                    if (!this.setPartialCharge(n4, f)) break;
                    this.taintAtom(n4, (byte)8);
                    break;
                }
                case 1112541195: {
                    if (!this.setIonicRadius(n4, f)) break;
                    this.taintAtom(n4, (byte)6);
                    break;
                }
                case 1113200651: 
                case 1666189314: {
                    if (f < 0.0f) {
                        f = 0.0f;
                    } else if (f > 16.0f) {
                        f = 16.0f;
                    }
                    atom.madAtom = (short)(f * 2000.0f);
                    break;
                }
                case 1114638350: {
                    this.viewer.setSelectedAtom(atom.index, f != 0.0f);
                    break;
                }
                case 1112541199: {
                    if (!this.setBFactor(n4, f)) break;
                    this.taintAtom(n4, (byte)9);
                    break;
                }
                case 1095763988: {
                    atom.setValence(n2);
                    this.taintAtom(n4, (byte)10);
                    break;
                }
                case 1649412112: {
                    if (atom.setRadius(f)) {
                        this.taintAtom(n4, (byte)11);
                        break;
                    }
                    this.untaint(n4, (byte)11);
                    break;
                }
                default: {
                    Logger.error("unsettable atom property: " + T.nameOf(n));
                }
            }
            n4 = bS.nextSetBit(n4 + 1);
        }
        if (n == 1114638350) {
            this.viewer.setSelectedAtom(-1, false);
        }
    }

    protected void setElement(Atom atom, int n) {
        this.taintAtom(atom.index, (byte)3);
        atom.setAtomicAndIsotopeNumber(n);
        atom.setPaletteID(EnumPalette.CPK.id);
        atom.setColixAtom(this.viewer.getColixAtomPalette(atom, EnumPalette.CPK.id));
    }

    public float getVibrationCoord(int n, char c) {
        if (this.vibrationVectors == null || this.vibrationVectors[n] == null) {
            return 0.0f;
        }
        switch (c) {
            case 'X': {
                return this.vibrationVectors[n].x;
            }
            case 'Y': {
                return this.vibrationVectors[n].y;
            }
        }
        return this.vibrationVectors[n].z;
    }

    public V3 getVibrationVector(int n, boolean bl) {
        V3 v3 = this.vibrationVectors == null ? null : this.vibrationVectors[n];
        return v3 == null && bl ? new V3() : v3;
    }

    protected void setVibrationVector(int n, float f, float f2, float f3) {
        if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) {
            return;
        }
        if (this.vibrationVectors == null || this.vibrationVectors.length < n) {
            this.vibrationVectors = new V3[this.atoms.length];
        }
        if (this.vibrationVectors[n] == null) {
            this.vibrationVectors[n] = V3.new3(f, f2, f3);
        } else {
            this.vibrationVectors[n].set(f, f2, f3);
        }
        this.atoms[n].setVibrationVector();
    }

    private void setVibrationVector2(int n, int n2, float f) {
        V3 v3 = this.getVibrationVector(n, true);
        if (v3 == null) {
            v3 = new V3();
        }
        switch (n2) {
            case 1112541202: {
                v3.x = f;
                break;
            }
            case 1112541203: {
                v3.y = f;
                break;
            }
            case 1112541204: {
                v3.z = f;
            }
        }
        this.setAtomVibrationVector(n, v3.x, v3.y, v3.z);
    }

    public void setAtomName(int n, String string) {
        byte by;
        this.atoms[n].atomID = by = JC.lookupSpecialAtomID(string);
        if (by > 0 && ((ModelCollection)this).models[this.atoms[n].modelIndex].isBioModel) {
            return;
        }
        if (this.atomNames == null) {
            this.atomNames = new String[this.atoms.length];
        }
        this.atomNames[n] = string;
    }

    protected void setAtomType(int n, String string) {
        if (this.atomTypes == null) {
            this.atomTypes = new String[this.atoms.length];
        }
        this.atomTypes[n] = string;
    }

    public boolean setAtomNumber(int n, int n2) {
        if (this.atomSerials == null) {
            this.atomSerials = new int[this.atoms.length];
        }
        this.atomSerials[n] = n2;
        return true;
    }

    protected boolean setOccupancy(int n, int n2) {
        if (this.occupancies == null) {
            if (n2 == 100) {
                return false;
            }
            this.occupancies = new byte[this.atoms.length];
            int n3 = this.atoms.length;
            while (--n3 >= 0) {
                this.occupancies[n3] = 100;
            }
        }
        this.occupancies[n] = (byte)(n2 > 255 ? 255 : (n2 < 0 ? 0 : n2));
        return true;
    }

    protected boolean setPartialCharge(int n, float f) {
        if (Float.isNaN(f)) {
            return false;
        }
        if (this.partialCharges == null) {
            if (f == 0.0f && !Float.valueOf(f).equals(MINUSZERO)) {
                return false;
            }
            this.partialCharges = new float[this.atoms.length];
        }
        this.partialCharges[n] = f;
        return true;
    }

    protected boolean setIonicRadius(int n, float f) {
        if (Float.isNaN(f)) {
            return false;
        }
        if (this.ionicRadii == null) {
            this.ionicRadii = new float[this.atoms.length];
        }
        this.ionicRadii[n] = f;
        return true;
    }

    protected boolean setBFactor(int n, float f) {
        if (Float.isNaN(f)) {
            return false;
        }
        if (this.bfactor100s == null) {
            if (f == 0.0f && this.bfactor100s == null) {
                return false;
            }
            this.bfactor100s = new short[this.atoms.length];
        }
        this.bfactor100s[n] = (short)((f < -327.68f ? (double)-327.68f : ((double)f > 327.67 ? 327.67 : (double)f)) * 100.0 + (f < 0.0f ? -0.5 : 0.5));
        return true;
    }

    protected boolean setHydrophobicity(int n, float f) {
        if (Float.isNaN(f)) {
            return false;
        }
        if (this.hydrophobicities == null) {
            this.hydrophobicities = new float[this.atoms.length];
            for (int i = 0; i < this.atoms.length; ++i) {
                this.hydrophobicities[i] = Elements.getHydrophobicity(this.atoms[i].getGroupID());
            }
        }
        this.hydrophobicities[n] = f;
        return true;
    }

    protected void setEllipsoid(int n, Quadric[] quadricArray) {
        if (quadricArray == null) {
            return;
        }
        if (this.ellipsoids == null) {
            this.ellipsoids = new Quadric[this.atoms.length][];
        }
        this.ellipsoids[n] = quadricArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAtomData(int n, String string, String string2, boolean bl) {
        float[] fArray = null;
        BS bS = null;
        switch (n) {
            case 2: {
                this.loadCoordinates(string2, false, !bl);
                return;
            }
            case 12: {
                this.loadCoordinates(string2, true, true);
                return;
            }
            case 14: {
                fArray = new float[this.atomCount];
                bS = BSUtil.newBitSet(this.atomCount);
                break;
            }
        }
        int[] nArray = Parser.markLines(string2, ';');
        int n2 = 0;
        try {
            int n3 = Parser.parseInt(string2.substring(0, nArray[0] - 1));
            int n4 = 1;
            while (true) {
                block24: {
                    if (n4 > n3) {
                        if (n != 14) return;
                        if (n2 <= 0) return;
                        this.viewer.setData(string, new Object[]{string, fArray, bS, 1}, 0, 0, 0, 0, 0);
                        return;
                    }
                    String[] stringArray = Parser.getTokens(Parser.parseTrimmed(string2.substring(nArray[n4], nArray[n4 + 1] - 1)));
                    int n5 = Parser.parseInt(stringArray[0]) - 1;
                    if (n5 >= 0 && n5 < this.atomCount) {
                        Atom atom = this.atoms[n5];
                        ++n2;
                        int n6 = stringArray.length - 1;
                        float f = Parser.parseFloatStr(stringArray[n6]);
                        switch (n) {
                            case 14: {
                                fArray[n5] = f;
                                bS.set(n5);
                                break block24;
                            }
                            case 13: {
                                this.setAtomNumber(n5, (int)f);
                                break;
                            }
                            case 0: {
                                this.setAtomName(n5, stringArray[n6]);
                                break;
                            }
                            case 1: {
                                this.setAtomType(n5, stringArray[n6]);
                                break;
                            }
                            case 3: {
                                atom.setAtomicAndIsotopeNumber((int)f);
                                atom.setPaletteID(EnumPalette.CPK.id);
                                atom.setColixAtom(this.viewer.getColixAtomPalette(atom, EnumPalette.CPK.id));
                                break;
                            }
                            case 4: {
                                atom.setFormalCharge((int)f);
                                break;
                            }
                            case 5: {
                                this.setHydrophobicity(n5, f);
                                break;
                            }
                            case 6: {
                                this.setIonicRadius(n5, f);
                                break;
                            }
                            case 8: {
                                this.setPartialCharge(n5, f);
                                break;
                            }
                            case 9: {
                                this.setBFactor(n5, f);
                                break;
                            }
                            case 10: {
                                atom.setValence((int)f);
                                break;
                            }
                            case 11: {
                                atom.setRadius(f);
                            }
                        }
                        this.taintAtom(n5, (byte)n);
                    }
                }
                ++n4;
            }
        }
        catch (Exception exception) {
            Logger.error("AtomCollection.loadData error: " + exception);
        }
    }

    private void loadCoordinates(String string, boolean bl, boolean bl2) {
        int[] nArray = Parser.markLines(string, ';');
        try {
            int n = Parser.parseInt(string.substring(0, nArray[0] - 1));
            for (int i = 1; i <= n; ++i) {
                String[] stringArray = Parser.getTokens(Parser.parseTrimmed(string.substring(nArray[i], nArray[i + 1])));
                int n2 = Parser.parseInt(stringArray[0]) - 1;
                float f = Parser.parseFloatStr(stringArray[3]);
                float f2 = Parser.parseFloatStr(stringArray[4]);
                float f3 = Parser.parseFloatStr(stringArray[5]);
                if (bl) {
                    this.setAtomVibrationVector(n2, f, f2, f3);
                    continue;
                }
                this.setAtomCoord(n2, f, f2, f3);
                if (bl2) continue;
                this.untaint(n2, (byte)2);
            }
        }
        catch (Exception exception) {
            Logger.error("Frame.loadCoordinate error: " + exception);
        }
    }

    void validateBspf(boolean bl) {
        if (this.bspf != null) {
            this.bspf.validate(bl);
        }
    }

    void validateBspfForModel(int n, boolean bl) {
        if (this.bspf != null) {
            this.bspf.validateModel(n, bl);
        }
    }

    public void setPreserveState(boolean bl) {
        this.preserveState = bl;
    }

    public static int getUserSettableType(String string) {
        boolean bl = string.indexOf("property_") == 0;
        String string2 = bl ? string.substring(9) : string;
        for (int i = 0; i < 14; ++i) {
            if (!userSettableValues[i].equalsIgnoreCase(string2)) continue;
            return i;
        }
        return bl ? 14 : -1;
    }

    public BS getTaintedAtoms(byte by) {
        return this.tainted == null ? null : this.tainted[by];
    }

    public void taintAtoms(BS bS, byte by) {
        this.canSkipLoad = false;
        if (!this.preserveState) {
            return;
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.taintAtom(n, by);
            n = bS.nextSetBit(n + 1);
        }
    }

    protected void taintAtom(int n, byte by) {
        if (!this.preserveState) {
            return;
        }
        if (this.tainted == null) {
            this.tainted = new BS[14];
        }
        if (this.tainted[by] == null) {
            this.tainted[by] = BSUtil.newBitSet(this.atomCount);
        }
        this.tainted[by].set(n);
        if (by == 2) {
            this.validateBspfForModel(this.atoms[n].modelIndex, false);
        }
    }

    private void untaint(int n, byte by) {
        if (!this.preserveState) {
            return;
        }
        if (this.tainted == null || this.tainted[by] == null) {
            return;
        }
        this.tainted[by].clear(n);
    }

    public void setTaintedAtoms(BS bS, byte by) {
        if (!this.preserveState) {
            return;
        }
        if (bS == null) {
            if (this.tainted == null) {
                return;
            }
            this.tainted[by] = null;
            return;
        }
        if (this.tainted == null) {
            this.tainted = new BS[14];
        }
        if (this.tainted[by] == null) {
            this.tainted[by] = BSUtil.newBitSet(this.atomCount);
        }
        BSUtil.copy2(bS, this.tainted[by]);
    }

    public void unTaintAtoms(BS bS, byte by) {
        if (this.tainted == null || this.tainted[by] == null) {
            return;
        }
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            this.tainted[by].clear(n);
            n = bS.nextSetBit(n + 1);
        }
        if (this.tainted[by].nextSetBit(0) < 0) {
            this.tainted[by] = null;
        }
    }

    protected void findNearest2(int n, int n2, Atom[] atomArray, BS bS, int n3) {
        Atom atom = null;
        int n4 = this.atomCount;
        while (--n4 >= 0) {
            Atom atom2;
            if (bS != null && bS.get(n4) || !(atom2 = this.atoms[n4]).isClickable() || !this.isCursorOnTopOf(atom2, n, n2, n3, atom)) continue;
            atom = atom2;
        }
        atomArray[0] = atom;
    }

    boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return atom.screenZ > 1 && !this.g3d.isClippedZ(atom.screenZ) && this.g3d.isInDisplayRange(atom.screenX, atom.screenY) && atom.isCursorOnTopOf(n, n2, n3, atom2);
    }

    public BS findAtomsInRectangle(Rectangle rectangle, BS bS) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if (!bS.get(atom.modelIndex) || !atom.isVisible(0) || !rectangle.contains(atom.screenX, atom.screenY)) continue;
            this.bsFoundRectangle.set(n);
        }
        return this.bsFoundRectangle;
    }

    protected void fillADa(AtomData atomData, int n) {
        boolean bl;
        atomData.atomXyz = this.atoms;
        atomData.atomCount = this.atomCount;
        atomData.atomicNumber = new int[this.atomCount];
        boolean bl2 = bl = (n & 2) != 0;
        if (bl) {
            atomData.atomRadius = new float[this.atomCount];
        }
        boolean bl3 = (n & 0x10) != 0;
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atom = this.atoms[i];
            if (atom.isDeleted() || !bl3 && atomData.modelIndex >= 0 && atom.modelIndex != atomData.firstModelIndex) {
                if (atomData.bsIgnored == null) {
                    atomData.bsIgnored = new BS();
                }
                atomData.bsIgnored.set(i);
                continue;
            }
            atomData.atomicNumber[i] = atom.getElementNumber();
            atomData.lastModelIndex = atom.modelIndex;
            if (!bl) continue;
            atomData.atomRadius[i] = this.getWorkingRadius(atom, atomData);
        }
    }

    private float getWorkingRadius(Atom atom, AtomData atomData) {
        float f = 0.0f;
        RadiusData radiusData = atomData.radiusData;
        switch (radiusData.factorType) {
            case ABSOLUTE: {
                f = radiusData.value;
                break;
            }
            case FACTOR: 
            case OFFSET: {
                switch (radiusData.vdwType) {
                    case IONIC: {
                        f = atom.getBondingRadiusFloat();
                        break;
                    }
                    case ADPMAX: {
                        f = atom.getADPMinMax(true);
                        break;
                    }
                    case ADPMIN: {
                        f = atom.getADPMinMax(false);
                        break;
                    }
                    default: {
                        f = atom.getVanderwaalsRadiusFloat(this.viewer, atomData.radiusData.vdwType);
                    }
                }
                if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
                    f *= radiusData.value;
                    break;
                }
                f += radiusData.value;
            }
        }
        return f + radiusData.valueExtended;
    }

    /*
     * Enabled aggressive block sorting
     */
    public P3[][] calculateHydrogens(BS bS, int[] nArray, boolean bl, boolean bl2, JmolList<Atom> jmolList) {
        int n;
        P3[][] p3Array;
        block31: {
            V3 v3 = new V3();
            V3 v32 = new V3();
            p3Array = new P3[this.atomCount][];
            BS bS2 = this.viewer.getDeletedAtoms();
            n = 0;
            if (bS == null) break block31;
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                block30: {
                    int n3;
                    block33: {
                        P3 p3;
                        int n4;
                        int n5;
                        int n6;
                        int n7;
                        float f;
                        short s;
                        Atom atom;
                        block32: {
                            if (bS2 != null && bS2.get(n2)) break block30;
                            atom = this.atoms[n2];
                            s = atom.getElementNumber();
                            if (bl2 && s != 6) break block30;
                            f = s <= 6 ? 1.1f : (s <= 10 ? 1.0f : 1.3f);
                            switch (s) {
                                case 7: 
                                case 8: {
                                    f = 1.0f;
                                    break;
                                }
                            }
                            if (bl && atom.getCovalentHydrogenCount() > 0 || (n7 = this.getImplicitHydrogenCount(atom)) == 0) break block30;
                            n6 = this.aaRet[0];
                            n5 = this.aaRet[2];
                            n4 = this.aaRet[3];
                            p3Array[n2] = new P3[n7];
                            n3 = 0;
                            if (n4 != 0) break block32;
                            switch (n7) {
                                case 4: {
                                    v3.set(0.635f, 0.635f, 0.635f);
                                    p3 = P3.newP(v3);
                                    p3.add(atom);
                                    p3Array[n2][n3++] = p3;
                                    if (jmolList != null) {
                                        jmolList.addLast(atom);
                                    }
                                }
                                case 3: {
                                    v3.set(-0.635f, -0.635f, 0.635f);
                                    p3 = P3.newP(v3);
                                    p3.add(atom);
                                    p3Array[n2][n3++] = p3;
                                    if (jmolList != null) {
                                        jmolList.addLast(atom);
                                    }
                                }
                                case 2: {
                                    v3.set(-0.635f, 0.635f, -0.635f);
                                    p3 = P3.newP(v3);
                                    p3.add(atom);
                                    p3Array[n2][n3++] = p3;
                                    if (jmolList != null) {
                                        jmolList.addLast(atom);
                                    }
                                }
                                case 1: {
                                    v3.set(0.635f, -0.635f, -0.635f);
                                    p3 = P3.newP(v3);
                                    p3.add(atom);
                                    p3Array[n2][n3++] = p3;
                                    if (jmolList != null) {
                                        jmolList.addLast(atom);
                                        break;
                                    } else {
                                        break;
                                    }
                                }
                            }
                            break block33;
                        }
                        block9 : switch (n7) {
                            default: {
                                break;
                            }
                            case 3: {
                                this.getHybridizationAndAxes(n2, s, v3, v32, "sp3b", false, true);
                                p3 = new P3();
                                p3.scaleAdd2(f, v3, atom);
                                p3Array[n2][n3++] = p3;
                                if (jmolList != null) {
                                    jmolList.addLast(atom);
                                }
                                this.getHybridizationAndAxes(n2, s, v3, v32, "sp3c", false, true);
                                p3 = new P3();
                                p3.scaleAdd2(f, v3, atom);
                                p3Array[n2][n3++] = p3;
                                if (jmolList != null) {
                                    jmolList.addLast(atom);
                                }
                                this.getHybridizationAndAxes(n2, s, v3, v32, "sp3d", false, true);
                                p3 = new P3();
                                p3.scaleAdd2(f, v3, atom);
                                p3Array[n2][n3++] = p3;
                                if (jmolList == null) break;
                                jmolList.addLast(atom);
                                break;
                            }
                            case 2: {
                                boolean bl3;
                                boolean bl4 = bl3 = n5 == 2 || s == 5 || n4 == 1 && n6 == 4 || s == 7 && this.isAdjacentSp2(atom);
                                this.getHybridizationAndAxes(n2, s, v3, v32, bl3 ? "sp2b" : (n6 == 3 ? "sp3c" : "lpa"), false, true);
                                p3 = P3.newP(v3);
                                p3.scaleAdd2(f, v3, atom);
                                p3Array[n2][n3++] = p3;
                                if (jmolList != null) {
                                    jmolList.addLast(atom);
                                }
                                this.getHybridizationAndAxes(n2, s, v3, v32, bl3 ? "sp2c" : (n6 == 3 ? "sp3d" : "lpb"), false, true);
                                p3 = P3.newP(v3);
                                p3.scaleAdd2(f, v3, atom);
                                p3Array[n2][n3++] = p3;
                                if (jmolList == null) break;
                                jmolList.addLast(atom);
                                break;
                            }
                            case 1: {
                                switch (n6 - n4) {
                                    case 1: {
                                        if (s == 8 && atom == atom.getGroup().getCarbonylOxygenAtom()) {
                                            p3Array[n2] = null;
                                            break block30;
                                        } else {
                                            if (this.getHybridizationAndAxes(n2, s, v3, v32, n5 == 2 || s == 5 || s == 7 && this.isAdjacentSp2(atom) ? "sp2c" : "sp3d", true, false) != null) {
                                                p3 = P3.newP(v3);
                                                p3.scaleAdd2(f, v3, atom);
                                                p3Array[n2][n3++] = p3;
                                                if (jmolList == null) break block9;
                                                jmolList.addLast(atom);
                                                break block9;
                                            }
                                            p3Array[n2] = new P3[0];
                                            break block9;
                                        }
                                    }
                                    case 2: {
                                        this.getHybridizationAndAxes(n2, s, v3, v32, n6 == 4 ? "sp2c" : "sp2b", false, false);
                                        p3 = P3.newP(v3);
                                        p3.scaleAdd2(f, v3, atom);
                                        p3Array[n2][n3++] = p3;
                                        if (jmolList == null) break block9;
                                        jmolList.addLast(atom);
                                        break block9;
                                    }
                                    case 3: {
                                        this.getHybridizationAndAxes(n2, s, v3, v32, "spb", false, true);
                                        p3 = P3.newP(v3);
                                        p3.scaleAdd2(f, v3, atom);
                                        p3Array[n2][n3++] = p3;
                                        if (jmolList == null) break block9;
                                        jmolList.addLast(atom);
                                    }
                                }
                            }
                        }
                    }
                    n += n3;
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        nArray[0] = n;
        return p3Array;
    }

    private boolean isAdjacentSp2(Atom atom) {
        Bond[] bondArray = atom.bonds;
        for (int i = 0; i < bondArray.length; ++i) {
            Bond[] bondArray2 = bondArray[i].getOtherAtom((Atom)atom).bonds;
            for (int j = 0; j < bondArray2.length; ++j) {
                switch (bondArray2[j].order) {
                    case 2: 
                    case 3: 
                    case 514: 
                    case 515: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    int getImplicitHydrogenCount(Atom atom) {
        int n;
        String string;
        int n2 = atom.getTargetValence();
        int n3 = atom.getFormalCharge();
        if (this.aaRet == null) {
            this.aaRet = new int[4];
        }
        this.aaRet[0] = n2;
        this.aaRet[1] = n3;
        this.aaRet[2] = 0;
        this.aaRet[3] = atom.getCovalentBondCount();
        Model model = ((ModelCollection)this).models[atom.modelIndex];
        String string2 = string = model.isBioModel && !model.isPdbWithMultipleBonds ? atom.group.getGroup3() : null;
        if (string != null && n3 == 0 && JC.getAminoAcidValenceAndCharge(string, atom.getAtomName(), this.aaRet)) {
            n2 = this.aaRet[0];
            n3 = this.aaRet[1];
        }
        if (n3 != 0) {
            this.aaRet[0] = n2 += n2 == 4 ? -Math.abs(n3) : n3;
        }
        return (n = n2 - atom.getValence()) < 0 ? 0 : n;
    }

    public String getHybridizationAndAxes(int n, int n2, V3 v3, V3 v32, String string, boolean bl, boolean bl2) {
        int n3;
        String string2;
        String string3 = string2 = string.length() > 0 && string.charAt(0) == '-' ? string.substring(1) : string;
        if (string.indexOf("d") >= 0 && !string.endsWith("sp3d")) {
            return this.getHybridizationAndAxesD(n, v3, v32, string2);
        }
        Atom atom = this.atoms[n];
        if (n2 == 0) {
            n2 = atom.getElementNumber();
        }
        Atom[] atomArray = this.getAttached(atom, 4, bl);
        int n4 = atomArray.length;
        int n5 = string2.charAt(string2.length() - 1) - 97;
        if (n5 < 0 || n5 > 6) {
            n5 = 0;
        }
        V3 v33 = new V3();
        v3.set(0.0f, 0.0f, 0.0f);
        v32.set(0.0f, 0.0f, 0.0f);
        V3[] v3Array = new V3[4];
        for (n3 = 0; n3 < n4; ++n3) {
            v3Array[n3] = V3.newV(atom);
            v3Array[n3].sub(atomArray[n3]);
            v3Array[n3].normalize();
            v3.add(v3Array[n3]);
        }
        if (n4 > 0) {
            v32.setT(v3Array[0]);
        }
        n3 = 0;
        if (n4 >= 3) {
            if (v32.angle(v3Array[1]) < 2.984513f) {
                v33.cross(v32, v3Array[1]);
            } else {
                v33.cross(v32, v3Array[2]);
            }
            v33.normalize();
            V3 v34 = new V3();
            if (v3Array[1].angle(v3Array[2]) < 2.984513f) {
                v34.cross(v3Array[1], v3Array[2]);
            } else {
                v34.cross(v32, v3Array[2]);
            }
            v34.normalize();
            n3 = Math.abs(v34.dot(v33)) >= 0.95f ? 1 : 0;
        }
        boolean bl3 = string2.indexOf("sp3") == 0;
        boolean bl4 = !bl3 && string2.indexOf("sp2") == 0;
        boolean bl5 = !bl3 && !bl4 && string2.indexOf("sp") == 0;
        boolean bl6 = string2.indexOf("p") == 0;
        boolean bl7 = string2.indexOf("lp") == 0;
        String string4 = null;
        if (bl) {
            if (n4 == 0) {
                return null;
            }
            if (bl3 ? n5 > 3 || n4 > 4 : (bl4 ? n5 > 2 || n4 > 3 : bl5 && (n5 > 1 || n4 > 2))) {
                return null;
            }
            switch (n4) {
                case 1: {
                    if (n2 == 1 && !bl3) {
                        return null;
                    }
                    if (bl3) {
                        string4 = "sp3";
                        break;
                    }
                    switch (atomArray[0].getCovalentBondCount()) {
                        case 1: {
                            if (atomArray[0].getValence() != 2) {
                                string4 = "sp";
                                break;
                            }
                        }
                        case 2: {
                            string4 = bl5 ? "sp" : "sp2";
                            break;
                        }
                        case 3: {
                            if (!bl4 && !bl6) {
                                return null;
                            }
                            string4 = "sp2";
                        }
                    }
                    break;
                }
                case 2: {
                    if (v3.length() < 0.1f) {
                        if (string2.indexOf("2") >= 0 || string2.indexOf("3") >= 0) {
                            return null;
                        }
                        string4 = "sp";
                        break;
                    }
                    String string5 = string4 = bl3 ? "sp3" : "sp2";
                    if (string2.indexOf("sp") == 0) break;
                    if (bl7) {
                        string4 = "lp";
                        break;
                    }
                    string4 = string2;
                    break;
                }
                default: {
                    string4 = n3 != 0 ? "sp2" : (bl7 && n4 == 3 ? "lp" : "sp3");
                }
            }
            if (string4 == null) {
                return null;
            }
            if (string2.indexOf("p") == 0 ? string4 == "sp3" : string2.indexOf(string4) < 0) {
                return null;
            }
        }
        if (n5 < n4 && !string2.startsWith("p") && !string2.startsWith("l")) {
            v3.sub2(atomArray[n5], atom);
            v3.normalize();
            return string4;
        }
        switch (n4) {
            case 0: {
                if (string2.equals("sp3c") || string2.equals("sp2d") || string2.equals("lpa")) {
                    v3.set(-0.5f, -0.7f, 1.0f);
                    v32.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                if (string2.equals("sp3b") || string2.equals("lpb")) {
                    v3.set(0.5f, -0.7f, -1.0f);
                    v32.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                if (string2.equals("sp3a")) {
                    v3.set(0.0f, 1.0f, 0.0f);
                    v32.set(1.0f, 0.0f, 0.0f);
                    break;
                }
                v3.set(0.0f, 0.0f, 1.0f);
                v32.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                v33.setT(vRef);
                v32.cross(v33, v3);
                if (bl3) {
                    for (int i = 0; i < atomArray[0].bonds.length; ++i) {
                        if (!atomArray[0].bonds[i].isCovalent() || atomArray[0].getBondedAtomIndex(i) == atom.index) continue;
                        v32.sub2(atomArray[0], atomArray[0].bonds[i].getOtherAtom(atomArray[0]));
                        v32.cross(v3, v32);
                        if (v32.length() == 0.0f) continue;
                        v32.cross(v32, v3);
                        break;
                    }
                    v32.normalize();
                    if (Float.isNaN(v32.x)) {
                        v32.setT(vRef);
                        v32.cross(v32, v3);
                    }
                    v33.cross(v3, v32);
                    v33.normalize();
                    v3.normalize();
                    v32.scaleAdd2(2.828f, v32, v3);
                    if (n5 != 3) {
                        v32.normalize();
                        AxisAngle4f axisAngle4f = AxisAngle4f.new4(v3.x, v3.y, v3.z, (float)(n5 == 2 ? 1 : -1) * 2.0943952f);
                        Matrix3f matrix3f = new Matrix3f();
                        matrix3f.setIdentity();
                        matrix3f.setAA(axisAngle4f);
                        matrix3f.transform(v32);
                    }
                    v3.setT(v32);
                    v32.cross(v33, v3);
                    break;
                }
                v33.cross(v32, v3);
                switch (atomArray[0].getCovalentBondCount()) {
                    case 1: {
                        if (atomArray[0].getValence() != 2) break;
                    }
                    case 2: {
                        boolean bl8 = false;
                        Atom atom2 = atomArray[0];
                        v32.setT(v3);
                        v33.setT(vRef);
                        while (atom2 != null && atom2.getCovalentBondCount() == 2) {
                            Bond[] bondArray = atom2.bonds;
                            Atom atom3 = null;
                            bl8 = !bl8;
                            for (int i = 0; i < bondArray.length; ++i) {
                                if (!bondArray[i].isCovalent() || (atom3 = bondArray[i].getOtherAtom(atom2)) == atom) continue;
                                v33.sub2(atom3, atom2);
                                break;
                            }
                            v33.cross(v33, v32);
                            if (v33.length() > 0.1f || atom3.getCovalentBondCount() != 2) break;
                            atom = atom2;
                            atom2 = atom3;
                        }
                        if (v33.length() > 0.1f) {
                            v3.cross(v33, v32);
                            v3.normalize();
                            if (n5 == 1) {
                                v3.scale(-1.0f);
                            }
                            v3.scale(sqrt3_2);
                            v3.scaleAdd2(0.5f, v32, v3);
                            if (bl6) {
                                v33.cross(v3, v32);
                                v3.setT(v33);
                                v33.setT(v32);
                            }
                            v32.cross(v33, v3);
                            break;
                        }
                        v3.setT(v32);
                        v32.cross(vRef, v32);
                        break;
                    }
                    case 3: {
                        this.getHybridizationAndAxes(atomArray[0].index, 0, v32, v33, "pz", false, bl2);
                        v33.setT(v32);
                        if (bl4) {
                            v32.cross(v32, v3);
                            if (n5 == 1) {
                                v32.scale(-1.0f);
                            }
                            v32.scale(sqrt3_2);
                            v3.scaleAdd2(0.5f, v3, v32);
                        } else {
                            v33.setT(v3);
                            v3.setT(v32);
                        }
                        v32.cross(v33, v3);
                    }
                }
                break;
            }
            case 2: {
                if (v3.length() < 0.1f) {
                    if (!string2.equals("pz")) {
                        boolean bl9;
                        Atom atom4 = atomArray[0];
                        boolean bl10 = bl9 = atom4.getCovalentBondCount() == 3;
                        if (!bl9) {
                            atom4 = atomArray[1];
                            boolean bl11 = bl9 = atom4.getCovalentBondCount() == 3;
                        }
                        if (bl9) {
                            this.getHybridizationAndAxes(atom4.index, 0, v32, v3, "pz", false, bl2);
                            if (string2.equals("px")) {
                                v32.scale(-1.0f);
                            }
                            v3.setT(v3Array[0]);
                            break;
                        }
                        v33.setT(vRef);
                        v3.cross(v33, v32);
                        v33.cross(v3, v32);
                    }
                    v3.setT(v32);
                    v32.cross(v33, v3);
                    break;
                }
                v33.cross(v3, v32);
                if (bl4) {
                    v32.cross(v3, v33);
                    break;
                }
                if (bl3 || bl7) {
                    v33.normalize();
                    v3.normalize();
                    if (!string2.equals("lp")) {
                        if (n5 == 0 || n5 == 2) {
                            v3.scaleAdd2(-1.2f, v33, v3);
                        } else {
                            v3.scaleAdd2(1.2f, v33, v3);
                        }
                    }
                    v32.cross(v3, v33);
                    break;
                }
                v32.cross(v3, v33);
                v3.setT(v33);
                if (!(v3.z < 0.0f)) break;
                v3.scale(-1.0f);
                v32.scale(-1.0f);
                break;
            }
            default: {
                if (bl3) break;
                if (n3 == 0) {
                    v32.cross(v3, v32);
                    break;
                }
                v3.setT(v33);
                if (!(v3.z < 0.0f) || !bl2) break;
                v3.scale(-1.0f);
                v32.scale(-1.0f);
            }
        }
        v32.normalize();
        v3.normalize();
        return string4;
    }

    private String getHybridizationAndAxesD(int n, V3 v3, V3 v32, String string) {
        int n2;
        if (string.startsWith("sp3d2")) {
            string = "d2sp3" + (string.length() == 5 ? "a" : string.substring(5));
        }
        if (string.startsWith("sp3d")) {
            string = "dsp3" + (string.length() == 4 ? "a" : string.substring(4));
        }
        if (string.equals("d2sp3") || string.equals("dsp3")) {
            string = string + "a";
        }
        boolean bl = string.startsWith("dsp3");
        int n3 = string.charAt(string.length() - 1) - 97;
        if (v3 != null && (!bl && (n3 > 5 || !string.startsWith("d2sp3")) || bl && n3 > 4)) {
            return null;
        }
        Atom atom = this.atoms[n];
        Atom[] atomArray = this.getAttached(atom, 6, true);
        if (atomArray == null) {
            return v3 == null ? null : "?";
        }
        int n4 = atomArray.length;
        if (n4 < 3 && v3 != null) {
            return null;
        }
        boolean bl2 = n3 >= n4;
        int n5 = n4 * (n4 - 1) / 2;
        int[][] nArray = ArrayUtil.newInt2(n5);
        int[] nArray2 = new int[3];
        int[][] nArray3 = new int[3][n5];
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        int n9 = 2;
        int n10 = 0;
        for (int i = 0; i < n4 - 1; ++i) {
            for (int j = i + 1; j < n4; ++j) {
                float f = Measure.computeAngleABC(atomArray[i], atom, atomArray[j], true);
                n2 = f < 105.0f ? n7 : (f >= 150.0f ? n9 : n8);
                nArray3[n2][nArray2[n2]] = n6;
                int n11 = n2;
                nArray2[n11] = nArray2[n11] + 1;
                nArray[n6++] = new int[]{i, j};
                if (i != 0 || n2 != n8) continue;
                ++n10;
            }
        }
        n6 = nArray2[n7] * 100 + nArray2[n8] * 10 + nArray2[n9];
        if (v3 == null) {
            switch (n6) {
                default: {
                    return "";
                }
                case 0: {
                    return "";
                }
                case 1: {
                    return "linear";
                }
                case 10: 
                case 100: {
                    return "bent";
                }
                case 111: 
                case 201: {
                    return "T-shaped";
                }
                case 30: 
                case 120: 
                case 210: 
                case 300: {
                    if (Math.abs(Measure.computeTorsion(atomArray[0], atom, atomArray[1], atomArray[2], true)) > 162.0f) {
                        return "trigonal planar";
                    }
                    return "trigonal pyramidal";
                }
                case 330: {
                    return n10 % 2 == 1 ? "tetrahedral" : "uncapped trigonal pyramid";
                }
                case 60: 
                case 150: 
                case 240: {
                    return "tetrahedral";
                }
                case 402: {
                    return "square planar";
                }
                case 411: 
                case 501: {
                    return "see-saw";
                }
                case 631: {
                    return "trigonal bipyramidal";
                }
                case 802: {
                    return "uncapped square pyramid";
                }
                case 1203: 
            }
            return "octahedral";
        }
        switch (n6) {
            default: {
                return null;
            }
            case 201: {
                break;
            }
            case 210: 
            case 330: 
            case 411: 
            case 631: {
                if (bl) break;
                return null;
            }
            case 300: 
            case 402: 
            case 501: 
            case 802: 
            case 1203: {
                if (!bl) break;
                return null;
            }
        }
        if (bl2) {
            if (bl) {
                switch (nArray2[n8]) {
                    case 0: {
                        v3.sub2(atomArray[nArray[nArray3[n7][0]][0]], atom);
                        v32.sub2(atomArray[nArray[nArray3[n7][0]][1]], atom);
                        v3.cross(v3, v32);
                        v3.normalize();
                        if (n3 == 4) {
                            v3.scale(-1.0f);
                        }
                        BS bS = this.findNotAttached(n4, nArray, nArray3[n9], nArray2[n9]);
                        int n12 = bS.nextSetBit(0);
                        v32.sub2(atomArray[n12], atom);
                        v32.normalize();
                        v32.scale(0.5f);
                        v3.scaleAdd2(sqrt3_2, v3, v32);
                        n3 = -1;
                        break;
                    }
                    case 1: {
                        if (n3 == 4) {
                            int[] nArray4 = nArray[nArray3[n8][0]];
                            v3.add2(atomArray[nArray4[0]], atomArray[nArray4[1]]);
                            v3.scaleAdd2(-2.0f, atom, v3);
                            n3 = -1;
                            break;
                        }
                        BS bS = this.findNotAttached(n4, nArray, nArray3[n8], nArray2[n8]);
                        n3 = bS.nextSetBit(0);
                        break;
                    }
                    default: {
                        BS bS = this.findNotAttached(n4, nArray, nArray3[n8], nArray2[n8]);
                        n3 = bS.nextSetBit(0);
                        break;
                    }
                }
            } else {
                boolean bl3 = false;
                if (n4 == 4) {
                    switch (nArray2[n9]) {
                        case 1: {
                            BS bS = this.findNotAttached(n4, nArray, nArray3[n9], nArray2[n9]);
                            n2 = bS.nextSetBit(0);
                            if (n3 == 4) {
                                n3 = n2;
                                break;
                            }
                            n3 = bS.nextSetBit(n2 + 1);
                            break;
                        }
                        default: {
                            bl3 = true;
                            break;
                        }
                    }
                } else {
                    BS bS = this.findNotAttached(n4, nArray, nArray3[n9], nArray2[n9]);
                    n2 = bS.nextSetBit(0);
                    for (int i = n4; i < n3 && n2 >= 0; ++i) {
                        n2 = bS.nextSetBit(n2 + 1);
                    }
                    if (n2 == -1) {
                        bl3 = true;
                    } else {
                        n3 = n2;
                    }
                }
                if (bl3) {
                    v3.sub2(atomArray[nArray[nArray3[n7][0]][0]], atom);
                    v32.sub2(atomArray[nArray[nArray3[n7][0]][1]], atom);
                    v3.cross(v3, v32);
                    if (n3 == 4) {
                        v3.scale(-1.0f);
                    }
                    n3 = -1;
                }
            }
        }
        if (n3 >= 0) {
            v3.sub2(atomArray[n3], atom);
        }
        if (bl2) {
            v3.scale(-1.0f);
        }
        v3.normalize();
        return bl ? "dsp3" : "d2sp3";
    }

    private Atom[] getAttached(Atom atom, int n, boolean bl) {
        int n2 = atom.getCovalentBondCount();
        if (n2 > n) {
            return null;
        }
        Atom[] atomArray = new Atom[n2];
        if (n2 > 0) {
            Bond[] bondArray = atom.bonds;
            int n3 = 0;
            for (int i = 0; i < bondArray.length; ++i) {
                if (!bondArray[i].isCovalent()) continue;
                atomArray[n3++] = bondArray[i].getOtherAtom(atom);
            }
            if (bl) {
                Arrays.sort(atomArray, new AtomSorter());
            }
        }
        return atomArray;
    }

    private BS findNotAttached(int n, int[][] nArray, int[] nArray2, int n2) {
        BS bS = BSUtil.newBitSet(n);
        bS.setBits(0, n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int[] nArray3 = nArray[nArray2[j]];
                if (nArray3[0] != i && nArray3[1] != i) continue;
                bS.clear(i);
            }
        }
        return bS;
    }

    protected BS getAtomBitsMDa(int n, Object object) {
        Object object2;
        BS bS;
        BS bS2 = new BS();
        int n2 = 0;
        switch (n) {
            case 1095763969: {
                int n3 = (Integer)object;
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (this.atoms[n2].getAtomNumber() != n3) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 1087375362: {
                String string;
                String string2 = "," + object + ",";
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    string = this.atoms[n2].getAtomName();
                    if (string2.indexOf(string) < 0 || string2.indexOf("," + string + ",") < 0) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 1087375361: {
                Object object3;
                String string = "," + object + ",";
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    object3 = this.atoms[n2].getAtomType();
                    if (string.indexOf((String)object3) < 0 || string.indexOf("," + (String)object3 + ",") < 0) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 1048613: {
                int n3 = (Integer)object;
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (this.atoms[n2].getGroupID() != n3) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 0x100021: {
                return BSUtil.copy(this.getChainBits((char)((Integer)object).intValue()));
            }
            case 1048614: {
                return BSUtil.copy(this.getSeqcodeBits((Integer)object, true));
            }
            case 0x60300006: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isHetero()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 1613758476: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (this.atoms[n2].getElementNumber() != 1) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 0x300010: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isProtein()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 3145764: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isCarbohydrate()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 0x300020: 
            case 137363468: {
                Object object3 = n == 137363468 ? EnumStructure.HELIX : EnumStructure.SHEET;
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isWithinStructure((EnumStructure)((Object)object3))) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 0x30000E: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isNucleic()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 0x300004: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isDna()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 3145750: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isRna()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 3145746: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isPurine()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 3145748: {
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isPyrimidine()) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 1087375365: {
                bS = (BS)object;
                BS bS3 = new BS();
                n2 = bS.nextSetBit(0);
                while (n2 >= 0) {
                    bS3.set(this.getElementNumber(n2));
                    n2 = bS.nextSetBit(n2 + 1);
                }
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!bS3.get(this.getElementNumber(n2))) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 1095761938: {
                bS = (BS)object;
                BS bS3 = new BS();
                n2 = bS.nextSetBit(0);
                while (n2 >= 0) {
                    bS3.set(this.atoms[n2].atomSite);
                    n2 = bS.nextSetBit(n2 + 1);
                }
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!bS3.get(this.atoms[n2].atomSite)) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 0x40000000: {
                return this.getIdentifierOrNull((String)object);
            }
            case 0x100020: {
                object2 = ((String)object).toUpperCase();
                if (((String)object2).indexOf("\\?") >= 0) {
                    object2 = TextFormat.simpleReplace((String)object2, "\\?", "\u0001");
                }
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.isAtomNameMatch(this.atoms[n2], (String)object2, false)) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 0x10001F: {
                String string = (String)object;
                n2 = this.atomCount;
                while (--n2 >= 0) {
                    if (!this.atoms[n2].isAlternateLocationMatch(string)) continue;
                    bS2.set(n2);
                }
                break;
            }
            case 1048612: {
                return this.getSpecName((String)object);
            }
        }
        if (n2 < 0) {
            return bS2;
        }
        bS = (BS)object;
        int n4 = bS.nextSetBit(0);
        if (n4 < 0) {
            return bS2;
        }
        n2 = 0;
        switch (n) {
            case 1087373318: {
                n2 = n4;
                while (n2 >= 0) {
                    int n5 = this.atoms[n2].getGroup().selectAtoms(bS2);
                    if (n5 > n2) {
                        n2 = n5;
                    }
                    n2 = bS.nextSetBit(n2 + 1);
                }
                break;
            }
            case 1095766028: {
                n2 = n4;
                while (n2 >= 0) {
                    if (!bS2.get(n2)) {
                        short s = this.atoms[n2].modelIndex;
                        bS2.set(n2);
                        int n6 = n2;
                        while (--n6 >= 0 && this.atoms[n6].modelIndex == s) {
                            bS2.set(n6);
                        }
                        while (++n2 < this.atomCount && this.atoms[n2].modelIndex == s) {
                            bS2.set(n2);
                        }
                    }
                    n2 = bS.nextSetBit(n2 + 1);
                }
                break;
            }
            case 0x40D00004: {
                bS = BSUtil.copy((BS)object);
                n2 = bS.nextSetBit(0);
                while (n2 >= 0) {
                    object2 = this.atoms[n2].getChain();
                    ((Chain)object2).setAtomBitSet(bS2);
                    bS.andNot(bS2);
                    n2 = bS.nextSetBit(n2 + 1);
                }
                break;
            }
            case 1095761935: {
                n2 = n4;
                while (n2 >= 0) {
                    if (!bS2.get(n2)) {
                        int n7 = this.atoms[n2].getPolymerIndexInModel();
                        bS2.set(n2);
                        int n8 = n2;
                        while (--n8 >= 0 && this.atoms[n8].getPolymerIndexInModel() == n7) {
                            bS2.set(n8);
                        }
                        while (++n2 < this.atomCount && this.atoms[n2].getPolymerIndexInModel() == n7) {
                            bS2.set(n2);
                        }
                    }
                    n2 = bS.nextSetBit(n2 + 1);
                }
                break;
            }
            case 1641025539: {
                n2 = n4;
                while (n2 >= 0) {
                    if (!bS2.get(n2)) {
                        object2 = this.atoms[n2].getGroup().getStructure();
                        bS2.set(n2);
                        int n9 = n2;
                        while (--n9 >= 0 && this.atoms[n9].getGroup().getStructure() == object2) {
                            bS2.set(n9);
                        }
                        while (++n2 < this.atomCount && this.atoms[n2].getGroup().getStructure() == object2) {
                            bS2.set(n2);
                        }
                    }
                    n2 = bS.nextSetBit(n2 + 1);
                }
                break;
            }
        }
        if (n2 == 0) {
            Logger.error("MISSING getAtomBits entry for " + T.nameOf(n));
        }
        return bS2;
    }

    private BS getIdentifierOrNull(String string) {
        int n;
        BS bS;
        int n2;
        BS bS2 = this.getSpecNameOrNull(string, false);
        if (string.indexOf("\\?") >= 0) {
            string = TextFormat.simpleReplace(string, "\\?", "\u0001");
        }
        if (bS2 != null || string.indexOf("?") > 0) {
            return bS2;
        }
        if (string.indexOf("*") > 0) {
            return this.getSpecNameOrNull(string, true);
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isLetter(string.charAt(n2)); ++n2) {
        }
        bS2 = this.getSpecNameOrNull(string.substring(0, n2), false);
        if (n2 == n3) {
            return bS2;
        }
        if (bS2 == null) {
            bS2 = new BS();
        }
        int n4 = n2;
        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
            ++n2;
        }
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string.substring(n4, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        char c = ' ';
        if (n2 < n3 && string.charAt(n2) == '^' && ++n2 < n3) {
            c = string.charAt(n2);
        }
        if ((bS = this.getSeqcodeBits(n = Group.getSeqcodeFor(n5, c), false)) == null) {
            if (c != ' ') {
                bS = this.getSeqcodeBits(Character.toUpperCase(string.charAt(n2)), false);
            }
            if (bS == null) {
                return null;
            }
            ++n2;
        }
        bS2.and(bS);
        if (n2 >= n3) {
            return bS2;
        }
        char c2 = string.charAt(n2++);
        bS2.and(this.getChainBits(c2));
        if (n2 == n3) {
            return bS2;
        }
        return null;
    }

    private BS getSpecName(String string) {
        BS bS = this.getSpecNameOrNull(string, false);
        if (bS != null) {
            return bS;
        }
        if (string.indexOf("*") > 0) {
            bS = this.getSpecNameOrNull(string, true);
        }
        return bS == null ? new BS() : bS;
    }

    private BS getSpecNameOrNull(String string, boolean bl) {
        BS bS = null;
        if ((string = string.toUpperCase()).indexOf("\\?") >= 0) {
            string = TextFormat.simpleReplace(string, "\\?", "\u0001");
        }
        int n = this.atomCount;
        while (--n >= 0) {
            String string2 = this.atoms[n].getGroup3(true);
            if (string2 != null && string2.length() > 0) {
                if (!TextFormat.isMatch(string2, string, bl, true)) continue;
                if (bS == null) {
                    bS = BSUtil.newBitSet(n + 1);
                }
                bS.set(n);
                while (--n >= 0 && this.atoms[n].getGroup3(true).equals(string2)) {
                    bS.set(n);
                }
                ++n;
                continue;
            }
            if (!this.isAtomNameMatch(this.atoms[n], string, bl)) continue;
            if (bS == null) {
                bS = BSUtil.newBitSet(n + 1);
            }
            bS.set(n);
        }
        return bS;
    }

    private boolean isAtomNameMatch(Atom atom, String string, boolean bl) {
        return TextFormat.isMatch(atom.getAtomName().toUpperCase(), string, bl, false);
    }

    protected BS getSeqcodeBits(int n, boolean bl) {
        BS bS = new BS();
        int n2 = Group.getSeqNumberFor(n);
        boolean bl2 = n2 != Integer.MAX_VALUE;
        boolean bl3 = true;
        char c = Group.getInsertionCodeChar(n);
        switch (c) {
            case '?': {
                int n3 = this.atomCount;
                while (--n3 >= 0) {
                    int n4 = this.atoms[n3].getSeqcode();
                    if (bl2 && (n2 != Group.getSeqNumberFor(n4) || Group.getInsertionCodeFor(n4) == 0)) continue;
                    bS.set(n3);
                    bl3 = false;
                }
                break;
            }
            default: {
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    int n6 = this.atoms[n5].getSeqcode();
                    if (n != n6 && (bl2 || n != Group.getInsertionCodeFor(n6)) && (c != '*' || n2 != Group.getSeqNumberFor(n6))) continue;
                    bS.set(n5);
                    bl3 = false;
                }
                break block0;
            }
        }
        return !bl3 || bl ? bS : null;
    }

    protected BS getChainBits(char c) {
        boolean bl = this.viewer.getBoolean(603979822);
        if (!bl) {
            c = Character.toUpperCase(c);
        }
        BS bS = new BS();
        BS bS2 = BSUtil.newBitSet(this.atomCount);
        int n = bS2.nextClearBit(0);
        while (n < this.atomCount) {
            Chain chain = this.atoms[n].getChain();
            if (c == (bl ? chain.chainID : Character.toUpperCase(chain.chainID))) {
                chain.setAtomBitSet(bS);
                bS2.or(bS);
            } else {
                chain.setAtomBitSet(bS2);
            }
            n = bS2.nextClearBit(n + 1);
        }
        return bS;
    }

    public int[] getAtomIndices(BS bS) {
        int n = 0;
        int[] nArray = new int[this.atomCount];
        int n2 = bS.nextSetBit(0);
        while (n2 >= 0 && n2 < this.atomCount) {
            nArray[n2] = ++n;
            n2 = bS.nextSetBit(n2 + 1);
        }
        return nArray;
    }

    public BS getAtomsWithin(float f, P4 p4) {
        BS bS = new BS();
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            float f2 = Measure.distanceToPlane(p4, atom);
            if (!(f > 0.0f && (double)f2 >= -0.1 && f2 <= f || f < 0.0f && (double)f2 <= 0.1 && f2 >= f) && (f != 0.0f || !((double)Math.abs(f2) < 0.01))) continue;
            bS.set(atom.index);
        }
        return bS;
    }

    public BS getAtomsWithinBs(float f, P3[] p3Array, BS bS) {
        BS bS2 = new BS();
        if (p3Array.length == 0 || bS != null && bS.cardinality() == 0) {
            return bS2;
        }
        if (bS == null) {
            bS = BSUtil.setAll(p3Array.length);
        }
        int n = this.atomCount;
        block0: while (--n >= 0) {
            Atom atom = this.atoms[n];
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                if (atom.distance(p3Array[n2]) < f) {
                    bS2.set(n);
                    continue block0;
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
        }
        return bS2;
    }

    public BS getVisibleSet() {
        BS bS = new BS();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isVisible(0)) continue;
            bS.set(n);
        }
        return bS;
    }

    public BS getClickableSet() {
        BS bS = new BS();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isClickable()) continue;
            bS.set(n);
        }
        return bS;
    }

    protected void deleteModelAtoms(int n, int n2, BS bS) {
        int n3;
        this.atoms = (Atom[])ArrayUtil.deleteElements(this.atoms, n, n2);
        this.atomCount = this.atoms.length;
        for (n3 = n; n3 < this.atomCount; ++n3) {
            this.atoms[n3].index = n3;
            this.atoms[n3].modelIndex = (short)(this.atoms[n3].modelIndex - 1);
        }
        this.atomNames = (String[])ArrayUtil.deleteElements(this.atomNames, n, n2);
        this.atomTypes = (String[])ArrayUtil.deleteElements(this.atomTypes, n, n2);
        this.atomSerials = (int[])ArrayUtil.deleteElements(this.atomSerials, n, n2);
        this.bfactor100s = (short[])ArrayUtil.deleteElements(this.bfactor100s, n, n2);
        this.hasBfactorRange = false;
        this.occupancies = (byte[])ArrayUtil.deleteElements(this.occupancies, n, n2);
        this.partialCharges = (float[])ArrayUtil.deleteElements(this.partialCharges, n, n2);
        this.ellipsoids = (Quadric[][])ArrayUtil.deleteElements(this.ellipsoids, n, n2);
        this.vibrationVectors = (V3[])ArrayUtil.deleteElements(this.vibrationVectors, n, n2);
        this.nSurfaceAtoms = 0;
        this.bsSurface = null;
        this.surfaceDistance100s = null;
        if (this.tainted != null) {
            for (n3 = 0; n3 < 14; ++n3) {
                BSUtil.deleteBits(this.tainted[n3], bS);
            }
        }
    }

    static {
        if (userSettableValues.length != 14) {
            Logger.error("AtomCollection.java userSettableValues is not length TAINT_MAX!");
        }
        sqrt3_2 = (float)(Math.sqrt(3.0) / 2.0);
        vRef = V3.new3(3.14159f, 2.71828f, 1.41421f);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AtomSorter
    implements Comparator<Atom> {
        AtomSorter() {
        }

        @Override
        public int compare(Atom atom, Atom atom2) {
            return atom.index > atom2.index ? 1 : (atom.index < atom2.index ? -1 : 0);
        }
    }
}

