/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.jmol.util.SB;

public class OutputStringBuilder {
    public String type;
    SB sb;
    BufferedWriter bw;
    long nBytes;

    public OutputStringBuilder(BufferedOutputStream bufferedOutputStream) {
        if (bufferedOutputStream == null) {
            this.sb = new SB();
        } else {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
            this.bw = new BufferedWriter(outputStreamWriter, 8192);
        }
    }

    public OutputStringBuilder append(String string) {
        if (this.bw == null) {
            this.sb.append(string);
        } else {
            this.nBytes += (long)string.length();
            try {
                this.bw.write(string);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this;
    }

    public long length() {
        return this.bw == null ? (long)this.sb.length() : this.nBytes;
    }

    public String toString() {
        if (this.bw != null) {
            try {
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.bw == null ? this.sb.toString() : this.nBytes + " bytes";
    }
}

