/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolZipUtility;
import org.jmol.api.ZInputStream;
import org.jmol.io.Base64;
import org.jmol.io.Encoding;
import org.jmol.io.LimitedLineReader;
import org.jmol.util.ArrayUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmolBinary {
    public static final String JPEG_CONTINUE_STRING = " #Jmol...\u0000";
    public static final String PMESH_BINARY_MAGIC_NUMBER = "PM\u0001\u0000";
    private static final String DELPHI_BINARY_MAGIC_NUMBER = "\u0014\u0000\u0000\u0000";
    static JmolZipUtility jzu;

    public static String determineSurfaceTypeIs(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = JmolBinary.getBufferedReader(new BufferedInputStream(inputStream), "ISO-8859-1");
        }
        catch (IOException iOException) {
            return null;
        }
        return JmolBinary.determineSurfaceFileType(bufferedReader);
    }

    public static String determineSurfaceFileType(BufferedReader bufferedReader) {
        String string = null;
        LimitedLineReader limitedLineReader = null;
        try {
            limitedLineReader = new LimitedLineReader(bufferedReader, 16000);
            string = limitedLineReader.getHeader(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (limitedLineReader == null || string == null || string.length() == 0) {
            return null;
        }
        switch (string.charAt(0)) {
            case '@': {
                if (string.indexOf("@text") != 0) break;
                return "Kinemage";
            }
            case '#': {
                if (string.indexOf(".obj") >= 0) {
                    return "Obj";
                }
                if (string.indexOf("MSMS") < 0) break;
                return "Msms";
            }
            case '&': {
                if (string.indexOf("&plot") != 0) break;
                return "Jaguar";
            }
            case '\n': 
            case '\r': {
                if (string.indexOf("ZYX") < 0) break;
                return "Xplor";
            }
        }
        if (string.indexOf("Here is your gzipped map") >= 0) {
            return "UPPSALA" + string;
        }
        if (string.indexOf("! nspins") >= 0) {
            return "CastepDensity";
        }
        if (string.indexOf("<jvxl") >= 0 && string.indexOf("<?xml") >= 0) {
            return "JvxlXml";
        }
        if (string.indexOf("#JVXL+") >= 0) {
            return "Jvxl+";
        }
        if (string.indexOf("#JVXL") >= 0) {
            return "Jvxl";
        }
        if (string.indexOf("<efvet ") >= 0) {
            return "Efvet";
        }
        if (string.indexOf("usemtl") >= 0) {
            return "Obj";
        }
        if (string.indexOf("# object with") == 0) {
            return "Nff";
        }
        if (string.indexOf("BEGIN_DATAGRID_3D") >= 0 || string.indexOf("BEGIN_BANDGRID_3D") >= 0) {
            return "Xsf";
        }
        int n = string.indexOf(0);
        if (n >= 0) {
            if (string.indexOf(PMESH_BINARY_MAGIC_NUMBER) == 0) {
                return "Pmesh";
            }
            if (string.indexOf(DELPHI_BINARY_MAGIC_NUMBER) == 0) {
                return "DelPhi";
            }
            if (string.indexOf("MAP ") == 208) {
                return "Mrc";
            }
            if (string.length() > 37 && (string.charAt(36) == '\u0000' && string.charAt(37) == 'd' || string.charAt(36) == '\u0000' && string.charAt(37) == 'd')) {
                return "Dsn6";
            }
        }
        if (string.indexOf(" 0.00000e+00 0.00000e+00      0      0\n") >= 0) {
            return "Uhbd";
        }
        string = limitedLineReader.readLineWithNewline();
        if (string.indexOf("object 1 class gridpositions counts") == 0) {
            return "Apbs";
        }
        String[] stringArray = Parser.getTokens(string);
        String string2 = limitedLineReader.readLineWithNewline();
        if (stringArray.length == 2 && Parser.parseInt(stringArray[0]) == 3 && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && (stringArray = Parser.getTokens(string2)).length == 3 && Parser.parseInt(stringArray[0]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[1]) != Integer.MIN_VALUE && Parser.parseInt(stringArray[2]) != Integer.MIN_VALUE) {
            return "PltFormatted";
        }
        String string3 = limitedLineReader.readLineWithNewline();
        if (string.startsWith("v ") && string2.startsWith("v ") && string3.startsWith("v ")) {
            return "Obj";
        }
        int n2 = Parser.parseInt(string3);
        if (n2 == Integer.MIN_VALUE) {
            return string3.indexOf("+") == 0 ? "Jvxl+" : null;
        }
        if (n2 >= 0) {
            return "Cube";
        }
        n2 = -n2;
        int n3 = 4 + n2;
        while (--n3 >= 0) {
            string = limitedLineReader.readLineWithNewline();
            if (string != null) continue;
            return null;
        }
        n3 = Parser.parseInt(string);
        if (n3 == Integer.MIN_VALUE) {
            return null;
        }
        return n3 < 0 ? "Jvxl" : "Cube";
    }

    private static Encoding getUTFEncodingForStream(BufferedInputStream bufferedInputStream) throws IOException {
        byte[] byArray = new byte[4];
        byArray[3] = 1;
        try {
            bufferedInputStream.mark(5);
        }
        catch (Exception exception) {
            return Encoding.NONE;
        }
        bufferedInputStream.read(byArray, 0, 4);
        bufferedInputStream.reset();
        return JmolBinary.getUTFEncoding(byArray);
    }

    public static String fixUTF(byte[] byArray) {
        Encoding encoding = JmolBinary.getUTFEncoding(byArray);
        if (encoding != Encoding.NONE) {
            try {
                String string = new String(byArray, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        string = string.substring(1);
                        break;
                    }
                }
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.out.println(unsupportedEncodingException);
            }
        }
        return new String(byArray);
    }

    private static Encoding getUTFEncoding(byte[] byArray) {
        if (byArray.length >= 3 && byArray[0] == -17 && byArray[1] == -69 && byArray[2] == -65) {
            return Encoding.UTF8;
        }
        if (byArray.length >= 4 && byArray[0] == 0 && byArray[1] == 0 && byArray[2] == -2 && byArray[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (byArray.length >= 4 && byArray[0] == -1 && byArray[1] == -2 && byArray[2] == 0 && byArray[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (byArray.length >= 2 && byArray[0] == -1 && byArray[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static boolean isCompoundDocumentStream(InputStream inputStream) throws Exception {
        byte[] byArray = new byte[8];
        inputStream.mark(9);
        int n = inputStream.read(byArray, 0, 8);
        inputStream.reset();
        return n == 8 && byArray[0] == -48 && byArray[1] == -49 && byArray[2] == 17 && byArray[3] == -32 && byArray[4] == -95 && byArray[5] == -79 && byArray[6] == 26 && byArray[7] == -31;
    }

    public static boolean isCompoundDocumentArray(byte[] byArray) {
        return byArray.length >= 8 && byArray[0] == -48 && byArray[1] == -49 && byArray[2] == 17 && byArray[3] == -32 && byArray[4] == -95 && byArray[5] == -79 && byArray[6] == 26 && byArray[7] == -31;
    }

    public static boolean isGzipB(byte[] byArray) {
        return byArray != null && byArray.length > 2 && byArray[0] == 31 && byArray[1] == -117;
    }

    public static boolean isGzipS(InputStream inputStream) {
        byte[] byArray = new byte[4];
        try {
            inputStream.mark(5);
            inputStream.read(byArray, 0, 4);
            inputStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return JmolBinary.isGzipB(byArray);
    }

    public static boolean isZipStream(InputStream inputStream) {
        byte[] byArray = new byte[4];
        try {
            inputStream.mark(5);
            inputStream.read(byArray, 0, 4);
            inputStream.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JmolBinary.isZipFile(byArray);
    }

    public static boolean isZipFile(byte[] byArray) {
        return byArray.length >= 4 && byArray[0] == 80 && byArray[1] == 75 && byArray[2] == 3 && byArray[3] == 4;
    }

    public static boolean isPngZipStream(InputStream inputStream) {
        if (JmolBinary.isZipStream(inputStream)) {
            return false;
        }
        try {
            inputStream.mark(56);
            byte[] byArray = JmolBinary.getStreamBytes(inputStream, 55L);
            inputStream.reset();
            return byArray[51] == 80 && byArray[52] == 78 && byArray[53] == 71 && byArray[54] == 74;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getZipRoot(String string) {
        int n = string.indexOf("|");
        return n < 0 ? string : string.substring(0, n);
    }

    public static byte[] getStreamBytes(InputStream inputStream, long l) throws IOException {
        int n = l > 0L && l < 1024L ? (int)l : 1024;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[l < 0L ? 4096 : (int)l];
        int n2 = 0;
        int n3 = 0;
        while ((l < 0L || (long)n3 < l) && (n2 = inputStream.read(byArray, 0, n)) > 0) {
            if ((n3 += n2) > byArray2.length) {
                byArray2 = ArrayUtil.ensureLengthByte(byArray2, n3 * 2);
            }
            System.arraycopy(byArray, 0, byArray2, n3 - n2, n2);
        }
        if (n3 == byArray2.length) {
            return byArray2;
        }
        byArray = new byte[n3];
        System.arraycopy(byArray2, 0, byArray, 0, n3);
        return byArray;
    }

    public static String getEmbeddedScript(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf("**** Jmol Embedded Script ****");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf("/*", n);
        int n3 = string.indexOf((string.charAt(n2 + 2) == '*' ? "*" : "") + "*/", n);
        if (n2 >= 0 && n3 >= n) {
            string = string.substring(n + "**** Jmol Embedded Script ****".length(), n3) + "\n";
        }
        while ((n2 = string.indexOf(JPEG_CONTINUE_STRING)) >= 0) {
            string = string.substring(0, n2) + string.substring(n2 + JPEG_CONTINUE_STRING.length() + 4);
        }
        if (Logger.debugging) {
            Logger.info(string);
        }
        return string;
    }

    private static JmolZipUtility getJzu() {
        return jzu == null ? (jzu = (JmolZipUtility)Interface.getOptionInterface("io2.ZipUtil")) : jzu;
    }

    public static String getZipDirectoryAsStringAndClose(BufferedInputStream bufferedInputStream) {
        return JmolBinary.getJzu().getZipDirectoryAsStringAndClose(bufferedInputStream);
    }

    public static InputStream newGZIPInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        return JmolBinary.getJzu().newGZIPInputStream(bufferedInputStream);
    }

    public static String getGzippedBytesAsString(byte[] byArray) {
        return JmolBinary.getJzu().getGzippedBytesAsString(byArray);
    }

    public static ZInputStream newZipInputStream(InputStream inputStream) {
        return JmolBinary.getJzu().newZipInputStream(inputStream);
    }

    public static Object getZipFileContents(BufferedInputStream bufferedInputStream, String[] stringArray, int n, boolean bl) {
        return JmolBinary.getJzu().getZipFileContents(bufferedInputStream, stringArray, n, bl);
    }

    public static String[] getZipDirectoryAndClose(BufferedInputStream bufferedInputStream, boolean bl) {
        return JmolBinary.getJzu().getZipDirectoryAndClose(bufferedInputStream, bl);
    }

    public static void getAllZipData(BufferedInputStream bufferedInputStream, String[] stringArray, String string, String string2, Map<String, String> map) {
        JmolBinary.getJzu().getAllZipData(bufferedInputStream, stringArray, string, string2, map);
    }

    public static Object getZipFileContentsAsBytes(BufferedInputStream bufferedInputStream, String[] stringArray, int n) {
        return JmolBinary.getJzu().getZipFileContentsAsBytes(bufferedInputStream, stringArray, n);
    }

    public static Object createZipSet(FileManager fileManager, Viewer viewer, String string, String string2, String[] stringArray, boolean bl) {
        return JmolBinary.getJzu().createZipSet(fileManager, viewer, string, string2, stringArray, bl);
    }

    public static Object getStreamAsBytes(BufferedInputStream bufferedInputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = outputStream == null ? new byte[4096] : null;
        int n = 0;
        int n2 = 0;
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) > 0) {
            n2 += n;
            if (outputStream == null) {
                if (n2 >= byArray2.length) {
                    byArray2 = ArrayUtil.ensureLengthByte(byArray2, n2 * 2);
                }
                System.arraycopy(byArray, 0, byArray2, n2 - n, n);
                continue;
            }
            outputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        if (outputStream == null) {
            return ArrayUtil.arrayCopyByte(byArray2, n2);
        }
        return n2 + " bytes";
    }

    public static Object writeZipFile(FileManager fileManager, Viewer viewer, String string, JmolList<Object> jmolList, String string2) {
        return JmolBinary.getJzu().writeZipFile(fileManager, viewer, string, jmolList, string2);
    }

    public static String postByteArray(FileManager fileManager, String string, byte[] byArray) {
        Object object = fileManager.getBufferedInputStreamOrErrorMessageFromName(string, null, false, false, byArray, false);
        if (object instanceof String) {
            return (String)object;
        }
        try {
            object = JmolBinary.getStreamAsBytes((BufferedInputStream)object, null);
        }
        catch (IOException iOException) {
            try {
                ((BufferedInputStream)object).close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        return JmolBinary.fixUTF((byte[])object);
    }

    public static boolean isBase64(SB sB) {
        return sB.indexOf(";base64,") == 0;
    }

    public static byte[] getBytesFromSB(SB sB) {
        return JmolBinary.isBase64(sB) ? Base64.decodeBase64(sB.substring(8)) : sB.toBytes(0, -1);
    }

    public static BufferedInputStream getBISForStringXBuilder(SB sB) {
        return new BufferedInputStream(new ByteArrayInputStream(JmolBinary.getBytesFromSB(sB)));
    }

    public static BufferedReader getBufferedReaderForString(String string) {
        return new BufferedReader(new StringReader(string));
    }

    public static String getSceneScript(String[] stringArray, Map<String, String> map, JmolList<Integer> jmolList) {
        return JmolBinary.getJzu().getSceneScript(stringArray, map, jmolList);
    }

    public static byte[] getCachedPngjBytes(FileManager fileManager, String string) {
        return string.indexOf(".png") < 0 ? null : JmolBinary.getJzu().getCachedPngjBytes(fileManager, string);
    }

    static boolean cachePngjFile(FileManager fileManager, String[] stringArray) {
        return JmolBinary.getJzu().cachePngjFile(fileManager, stringArray);
    }

    public static Object getAtomSetCollectionOrBufferedReaderFromZip(JmolAdapter jmolAdapter, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, boolean bl, boolean bl2) {
        return JmolBinary.getJzu().getAtomSetCollectionOrBufferedReaderFromZip(jmolAdapter, inputStream, string, stringArray, map, 1, bl, bl2);
    }

    public static String[] spartanFileList(String string, String string2) {
        return JmolBinary.getJzu().spartanFileList(string, string2);
    }

    public static void getFileReferences(String string, List<String> list) {
        for (int i = 0; i < FileManager.scriptFilePrefixes.length; ++i) {
            String string2 = FileManager.scriptFilePrefixes[i];
            int n = -1;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                String string3 = Parser.getQuotedStringAt(string, n);
                if (string3.indexOf("::") >= 0) {
                    string3 = TextFormat.splitChars(string3, "::")[1];
                }
                if (list instanceof JmolList) {
                    ((JmolList)list).addLast(string3);
                    continue;
                }
                list.add(string3);
            }
        }
    }

    public static BufferedInputStream checkPngZipStream(BufferedInputStream bufferedInputStream) {
        if (!JmolBinary.isPngZipStream(bufferedInputStream)) {
            return bufferedInputStream;
        }
        byte[] byArray = null;
        bufferedInputStream.mark(75);
        try {
            byArray = JmolBinary.getStreamBytes(bufferedInputStream, 74L);
            bufferedInputStream.reset();
            int n = 0;
            int n2 = 64;
            int n3 = 1;
            while (--n2 > 54) {
                n += (byArray[n2] - 48) * n3;
                n3 *= 10;
            }
            n2 = 0;
            n3 = 74;
            int n4 = 1;
            while (--n3 > 64) {
                n2 += (byArray[n3] - 48) * n4;
                n4 *= 10;
            }
            while (n > 0) {
                n = (int)((long)n - bufferedInputStream.skip(n));
            }
            byArray = JmolBinary.getStreamBytes(bufferedInputStream, n2);
            bufferedInputStream.close();
        }
        catch (Throwable throwable) {
            byArray = new byte[]{};
        }
        return new BufferedInputStream(new ByteArrayInputStream(byArray));
    }

    public static BufferedReader getBufferedReader(BufferedInputStream bufferedInputStream, String string) throws IOException {
        if (JmolBinary.getUTFEncodingForStream(bufferedInputStream) == Encoding.NONE) {
            return new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, string == null ? "UTF-8" : string));
        }
        byte[] byArray = JmolBinary.getStreamBytes(bufferedInputStream, -1L);
        bufferedInputStream.close();
        return JmolBinary.getBufferedReaderForString(string == null ? JmolBinary.fixUTF(byArray) : new String(byArray, string));
    }

    public static String getManifestScriptPath(String string) {
        char c;
        if (string.indexOf("$SCRIPT_PATH$") >= 0) {
            return "";
        }
        char c2 = c = string.indexOf(10) >= 0 ? (char)'\n' : '\r';
        if (string.indexOf(".spt") >= 0) {
            String[] stringArray = TextFormat.split(string, c);
            int n = stringArray.length;
            while (--n >= 0) {
                if (stringArray[n].indexOf(".spt") < 0) continue;
                return "|" + TextFormat.trim(stringArray[n], "\r\n \t");
            }
        }
        return null;
    }

    public static String getBinaryType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(".");
        if (n < 0 || (n = ";pse=PyMOL;".indexOf(";" + string.substring(n + 1) + "=")) < 0) {
            return null;
        }
        n = ";pse=PyMOL;".indexOf("=", n);
        string = ";pse=PyMOL;".substring(n + 1);
        return string.substring(0, string.indexOf(";"));
    }

    public static boolean checkBinaryType(String string) {
        return ";pse=PyMOL;".indexOf("=" + string + ";") >= 0;
    }
}

