/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;
import org.jmol.util.SB;

class Dsn6BinaryReader
extends MapFileReader {
    private float byteFactor;
    private int xyCount;
    private int nBrickX;
    private int nBrickY;
    private int brickLayerVoxelCount;
    private int brickLayerByteCount;
    private int brickRowByteCount;
    private byte[] brickLayer;
    private int pt;

    Dsn6BinaryReader() {
    }

    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        super.init2(surfaceGenerator, null);
        this.binarydoc = this.newBinaryDocument();
        Object[] objectArray = (Object[])surfaceGenerator.getReaderData();
        String string = (String)objectArray[0];
        String string2 = (String)objectArray[1];
        if (string2 == null) {
            this.binarydoc.setStream(surfaceGenerator.getAtomDataServer().getBufferedInputStream(string), true);
        } else {
            this.binarydoc.setStreamData(new DataInputStream(new ByteArrayInputStream(string2.getBytes())), true);
        }
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.nSurfaces = 1;
    }

    protected void readParameters() throws Exception {
        int n;
        short[] sArray = new short[19];
        for (n = 0; n < 19; ++n) {
            sArray[n] = this.binarydoc.readShort();
        }
        if (sArray[18] != 100) {
            this.binarydoc.setStream(null, false);
            for (n = 0; n < 19; ++n) {
                sArray[n] = this.binarydoc.swapBytesS(sArray[n]);
            }
        }
        this.nxyzStart[0] = sArray[0];
        this.nxyzStart[1] = sArray[1];
        this.nxyzStart[2] = sArray[2];
        this.nx = sArray[3];
        this.ny = sArray[4];
        this.nz = sArray[5];
        this.na = sArray[6];
        this.nb = sArray[7];
        this.nc = sArray[8];
        this.a = sArray[9];
        this.b = sArray[10];
        this.c = sArray[11];
        this.alpha = sArray[12];
        this.beta = sArray[13];
        this.gamma = sArray[14];
        float f = sArray[15];
        float f2 = sArray[16];
        float f3 = sArray[17];
        float f4 = sArray[18];
        this.maps = 3;
        this.mapr = 2;
        this.mapc = 1;
        this.dmin = (0.0f - f2) * f4 / f;
        this.dmax = (255.0f - f2) * f4 / f;
        this.drange = this.dmax - this.dmin;
        this.byteFactor = this.drange / 255.0f;
        float f5 = (0.0f - f2 - 0.5f) * f4 / (f - 0.5f);
        float f6 = (0.0f - f2 + 0.5f) * f4 / (f + 0.5f);
        float f7 = (255.0f - f2 - 0.5f) * f4 / (f - 0.5f);
        float f8 = (255.0f - f2 + 0.5f) * f4 / (f + 0.5f);
        float f9 = (float)Math.round((f6 - f5) / 0.002f) * 0.001f;
        float f10 = (float)Math.round((f8 - f7) / 0.002f) * 0.001f;
        Logger.info((String)("DNS6 dmin,dmax = " + this.dmin + "+/-" + f9 + "," + this.dmax + "+/-" + f10));
        this.a /= f3;
        this.b /= f3;
        this.c /= f3;
        this.alpha /= f3;
        this.beta /= f3;
        this.gamma /= f3;
        this.binarydoc.seek(512L);
        this.getVectorsAndOrigin();
        this.setCutoffAutomatic();
        this.xyCount = this.nx * this.ny;
        this.brickLayerVoxelCount = this.xyCount * 8;
        this.nBrickX = (this.nx + 7) / 8;
        this.nBrickY = (this.ny + 7) / 8;
        this.brickRowByteCount = this.nBrickX * 512;
        this.brickLayerByteCount = this.brickRowByteCount * this.nBrickY;
        this.brickLayer = new byte[this.brickLayerByteCount];
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("DNS6/O progressive brick data reader\n");
        this.jvxlFileHeaderBuffer.append("see http://www.uoxray.uoregon.edu/tnt/manual/node104.html\n");
    }

    private void readBrickLayer() throws Exception {
        this.binarydoc.readByteArray(this.brickLayer, 0, this.brickLayerByteCount);
        this.pt = 0;
        this.nBytes = this.binarydoc.getPosition();
    }

    private float getBrickValue(int n) {
        int n2 = n / this.nx % this.ny;
        int n3 = n2 / 8;
        int n4 = n % this.nx;
        int n5 = n4 / 8;
        int n6 = n / this.xyCount;
        int n7 = n6 % 8;
        int n8 = n2 % 8;
        int n9 = n4 % 8;
        int n10 = n3 * 512 * this.nBrickX + n5 * 512 + n7 * 64 + n8 * 8 + n9;
        n10 = n10 % 2 == 0 ? ++n10 : --n10;
        float f = (this.brickLayer[n10] + 256) % 256;
        return this.dmin + f * this.byteFactor;
    }

    protected float nextVoxel() throws Exception {
        if (this.pt % this.brickLayerVoxelCount == 0) {
            this.readBrickLayer();
        }
        return this.getBrickValue(this.pt++);
    }

    protected void skipData(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.binarydoc.readByte();
        }
    }
}

