/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.SmilesSearch;
import org.jmol.util.P3;
import org.jmol.util.Tuple3f;

public class SmilesMeasure {
    SmilesSearch search;
    int nPoints;
    int type;
    int index;
    boolean isNot;
    private int[] indices = new int[4];
    static final String TYPES = "__dat";
    private float min;
    private float max;
    private static final float radiansPerDegree = (float)Math.PI / 180;
    private final P3[] points = new P3[4];

    SmilesMeasure(SmilesSearch smilesSearch, int n, int n2, float f, float f2, boolean bl) {
        this.search = smilesSearch;
        this.type = Math.min(4, Math.max(n2, 2));
        this.index = n;
        this.min = Math.min(f, f2);
        this.max = Math.max(f, f2);
        this.isNot = bl;
    }

    public String toString() {
        String string = "(." + TYPES.charAt(this.type) + this.index + ":" + this.min + "," + this.max + ") for";
        for (int i = 0; i < this.type; ++i) {
            string = string + " " + (i >= this.nPoints ? "?" : "" + this.indices[i]);
        }
        return string;
    }

    boolean addPoint(int n) {
        if (this.nPoints == this.type) {
            return false;
        }
        if (this.nPoints == 0) {
            for (int i = 1; i < this.type; ++i) {
                this.indices[i] = n + i;
            }
        }
        this.indices[this.nPoints++] = n;
        return true;
    }

    boolean check() {
        for (int i = 0; i < this.type; ++i) {
            int n = this.search.patternAtoms[this.indices[i]].getMatchingAtom();
            this.points[i] = (P3)this.search.jmolAtoms[n];
        }
        float f = 0.0f;
        switch (this.type) {
            case 2: {
                f = this.points[0].distance(this.points[1]);
                break;
            }
            case 3: {
                this.search.v.vA.sub2((Tuple3f)this.points[0], (Tuple3f)this.points[1]);
                this.search.v.vB.sub2((Tuple3f)this.points[2], (Tuple3f)this.points[1]);
                f = this.search.v.vA.angle(this.search.v.vB) / ((float)Math.PI / 180);
                break;
            }
            case 4: {
                SmilesMeasure.setTorsionData(this.points[0], this.points[1], this.points[2], this.points[3], this.search.v, true);
                f = this.search.v.vTemp1.angle(this.search.v.vTemp2) / ((float)Math.PI / 180) * (float)(this.search.v.vNorm1.dot(this.search.v.vNorm2) < 0.0f ? 1 : -1);
            }
        }
        return (f < this.min || f > this.max) == this.isNot;
    }

    public static void setTorsionData(P3 p3, P3 p32, P3 p33, P3 p34, SmilesSearch.VTemp vTemp, boolean bl) {
        vTemp.vTemp1.setT((Tuple3f)p3);
        vTemp.vTemp1.sub((Tuple3f)p32);
        vTemp.vTemp2.setT((Tuple3f)p34);
        vTemp.vTemp2.sub((Tuple3f)p33);
        if (!bl) {
            return;
        }
        vTemp.vNorm1.setT((Tuple3f)p32);
        vTemp.vNorm1.sub((Tuple3f)p33);
        vTemp.vNorm1.normalize();
        vTemp.vTemp1.cross(vTemp.vTemp1, vTemp.vNorm1);
        vTemp.vTemp1.normalize();
        vTemp.vTemp2.cross(vTemp.vTemp2, vTemp.vNorm1);
        vTemp.vTemp2.normalize();
        vTemp.vNorm2.cross(vTemp.vTemp1, vTemp.vTemp2);
    }
}

